# [SheetJS](https://sheetjs.com)

> ## 🏠 New Home
> 
> The new home for SheetJS CE is <https://git.sheetjs.com/sheetjs/sheetjs>, a
> hosted Gitea instance sponsored by SheetJS LLC.  SheetJS CE remains a truly
> open source project under the Apache 2.0 License.
> 
> Issues should be raised at [the new issue tracker](https://git.sheetjs.com/sheetjs/sheetjs/issues).
> Users can register directly or sign in with a valid GitHub account.
> 
> [The documentation](https://docs.sheetjs.com/docs/getting-started/#installation)
> includes instructions for using the new distribution points.
> 
> Legacy distribution points (including the `SheetJS/sheetjs` Git repository on
> GitHub and the `xlsx` package on npmjs.com) will not be receiving updates.


The SheetJS Community Edition offers battle-tested open-source solutions for
extracting useful data from almost any complex spreadsheet and generating new
spreadsheets that will work with legacy and modern software alike.

[SheetJS Pro](https://sheetjs.com/pro) offers solutions beyond data processing:
Edit complex templates with ease; let out your inner Picasso with styling; make
custom sheets with images/graphs/PivotTables; evaluate formula expressions and
port calculations to web apps; automate common spreadsheet tasks, and much more!

> ## 💼 We're Hiring!
> 
> SheetJS is looking for US-based software developers to expand this project and
> related software libraries and tools. <https://sheetjs.com/careers> more info.

[![License](https://img.shields.io/github/license/SheetJS/sheetjs)](https://github.com/SheetJS/sheetjs/blob/master/LICENSE)
[![Build Status](https://img.shields.io/github/workflow/status/sheetjs/sheetjs/Tests:%20node.js)](https://github.com/SheetJS/sheetjs/actions)
[![Snyk Vulnerabilities](https://img.shields.io/snyk/vulnerabilities/github/SheetJS/sheetjs)](https://snyk.io/test/github/SheetJS/sheetjs)
[![npm Downloads](https://img.shields.io/npm/dm/xlsx.svg)](https://cdn.sheetjs.com/)
[![GitHub Repo stars](https://img.shields.io/github/stars/SheetJS/sheetjs?style=social)](https://github.com/SheetJS/sheetjs)

[![Analytics](https://ga-beacon.appspot.com/UA-36810333-1/SheetJS/sheetjs?pixel)](https://github.com/SheetJS/sheetjs)

[![Build Status](https://saucelabs.com/browser-matrix/sheetjs.svg)](https://saucelabs.com/u/sheetjs)

## Documentation

- [API and Usage Documentation](https://docs.sheetjs.com)

- [Downloadable Scripts and Modules](https://cdn.sheetjs.com)

## Related Projects

- <https://oss.sheetjs.com/notes/>: File Format Notes

- [`ssf`](packages/ssf): Format data using ECMA-376 spreadsheet format codes

- [`xlsx-cli`](packages/xlsx-cli/): NodeJS command-line tool for processing files

- [`test_files`](https://github.com/SheetJS/test_files): Sample spreadsheets

- [`cfb`](https://github.com/SheetJS/js-cfb): Container (OLE/ZIP) format library

- [`codepage`](https://github.com/SheetJS/js-codepage): Legacy text encodings

## License

Please consult the attached LICENSE file for details.  All rights not explicitly
granted by the Apache 2.0 License are reserved by the Original Author.

