$(function(e){
	'use strict'

	
	/* chartjs (#retention) */
	var proyecto_recaudado = document.getElementById("proyecto_recaudado");
	proyecto_recaudado.height = "110";
	
	var myCanvasContext = proyecto_recaudado.getContext("2d");
	var gradientStroke = myCanvasContext.createLinearGradient(0, 80, 0, 280);
	gradientStroke.addColorStop(0, 'rgba(229, 73, 58, .8)');
	gradientStroke.addColorStop(1, 'rgba(229, 73, 58, 0.01)');
	var myChart_proyecto_recaudado = new Chart( proyecto_recaudado, {
		type: 'line',
		data: {
			labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
			type: 'line',
			datasets: [ {
				label: 'Return-On-Assets',
				data: [24, 18, 28, 21, 32, 28,30],
				backgroundColor: gradientStroke,
				borderColor: '#e5493a',
				pointBackgroundColor:'#fff',
				pointHoverBackgroundColor:gradientStroke,
				pointBorderColor :'#e5493a',
				pointHoverBorderColor :gradientStroke,
				pointBorderWidth :0,
				pointRadius :0,
				pointHoverRadius :0,
				lineTension: 0.2,
				borderWidth: 2,
				fill: 'origin'
			}, ]
		},
		options: {
			responsive: true,
			maintainAspectRatio: true,
			tooltips: {
				mode: 'index',
				titleFontSize: 12,
				titleFontColor: '#000',
				bodyFontColor: '#000',
				backgroundColor: '#fff',
				cornerRadius: 3,
				intersect: false,
			},
			stepsize: 200,
			min: 0,
			max: 400,
			legend: {
				display: false,
				labels: {
					usePointStyle: false,
				},
			},
			scales: {
				xAxes: [ {
					gridLines: {
						color: 'transparent',
						zeroLineColor: 'transparent'
					},
					ticks: {
						fontSize: 2,
						fontColor: 'transparent'
					}
				} ],
				yAxes: [ {
					display:false,
					ticks: {
						display: false,
					}
				} ]
			},
			title: {
				display: false,
				text: 'Normal Legend'
			}
		}
	});
	/* chartjs (#retention) closed */



	/* chartjs (#proyecto_participantes) */
	var proyecto_participantes = document.getElementById("proyecto_participantes");
	proyecto_participantes.height = "110";
	
	var myCanvasContext = proyecto_participantes.getContext("2d");
	var gradientStroke = myCanvasContext.createLinearGradient(0, 80, 0, 280);
	gradientStroke.addColorStop(0, 'rgba(40, 151, 212, 1)');
	gradientStroke.addColorStop(1, 'rgba(40, 151, 212, 0.01)');
	var myChart_proyecto_participantes = new Chart( proyecto_participantes, {
		type: 'line',
		data: {
			labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
			type: 'line',
			datasets: [ {
				label: 'Return-On-Assets',
				data: [24, 18, 28, 21, 32, 28,30],
				backgroundColor: gradientStroke,
				borderColor: '#2897d4',
				pointBackgroundColor:'#fff',
				pointHoverBackgroundColor:gradientStroke,
				pointBorderColor :'#2897d4',
				pointHoverBorderColor :gradientStroke,
				pointBorderWidth :0,
				pointRadius :0,
				pointHoverRadius :0,
				lineTension: 0.2,
				borderWidth: 2,
				fill: 'origin'
			}, ]
		},
		options: {
			responsive: true,
			maintainAspectRatio: true,
			tooltips: {
				mode: 'index',
				titleFontSize: 12,
				titleFontColor: '#000',
				bodyFontColor: '#000',
				backgroundColor: '#fff',
				cornerRadius: 3,
				intersect: false,
			},
			stepsize: 200,
			min: 0,
			max: 400,
			legend: {
				display: false,
				labels: {
					usePointStyle: false,
				},
			},
			scales: {
				xAxes: [ {
					gridLines: {
						color: 'transparent',
						zeroLineColor: 'transparent'
					},
					ticks: {
						fontSize: 2,
						fontColor: 'transparent'
					}
				} ],
				yAxes: [ {
					display:false,
					ticks: {
						display: false,
					}
				} ]
			},
			title: {
				display: false,
				text: 'Normal Legend'
			}
		}
	});
	/* chartjs (#proyecto_participantes) closed */



	/*  echart_estimacion_tokens */
	var chartdata = [
	{
		name: 'sales',
		type: 'bar',
		data: [10, 15, 9, 18, 10, 15]
	},
	{
		name: 'profit',
		type: 'line',
		smooth:true,
		data: [8, 5, 25, 10, 10]
	},
	{
		name: 'growth',
		type: 'bar',
		data: [10, 14, 10, 15, 9, 25]
	}
	];

	var echart_estimacion_tokens = document.getElementById('echart_estimacion_tokens');
	var barChart = echarts.init(echart_estimacion_tokens);

	var option = {
		grid: {
			top: '6',
			right: '0',
			bottom: '17',
			left: '25',
		},
		xAxis: {
			data: [ '2014', '2015', '2016', '2017', '2018'],
			axisLine: {
				lineStyle: {
					color: 'rgba(67, 87, 133, .09)'
				}
			},
			axisLabel: {
				fontSize: 10,
				color: '#8e9cad'
			}
		},
		tooltip: {
			show: true,
			showContent: true,
			alwaysShowContent: true,
			triggerOn: 'mousemove',
			trigger: 'axis',
			axisPointer:
			{
				label: {
					show: false,
				}
			}

		},
		yAxis: {
			splitLine: {
				lineStyle: {
					color: 'rgba(67, 87, 133, .09)'
				}
			},
			axisLine: {
				lineStyle: {
					color: 'rgba(67, 87, 133, .09)'
				}
			},
			axisLabel: {
				fontSize: 10,
				color: '#8e9cad'
			}
		},
		series: chartdata,
		color:[ '#1873b7','#2897d4', '#95d3f5',]
	};

	barChart.setOption(option);
	/*  /echart_estimacion_tokens */


	/*  echart_estimacion_tokens */
	var chartdata_echart_prevision = [
	{
		name: 'sales',
		type: 'bar',
		data: [10, 15, 9, 18, 10, 15]
	},
	{
		name: 'profit',
		type: 'line',
		smooth:true,
		data: [8, 5, 25, 10, 10]
	},
	{
		name: 'growth',
		type: 'bar',
		data: [10, 14, 10, 15, 9, 25]
	}
	];

	var echart_prevision = document.getElementById('echart_prevision');
	var barChart_echart_prevision = echarts.init(echart_prevision);

	var option = {
		grid: {
			top: '6',
			right: '0',
			bottom: '17',
			left: '25',
		},
		xAxis: {
			data: [ '2014', '2015', '2016', '2017', '2018'],
			axisLine: {
				lineStyle: {
					color: 'rgba(67, 87, 133, .09)'
				}
			},
			axisLabel: {
				fontSize: 10,
				color: '#8e9cad'
			}
		},
		tooltip: {
			show: true,
			showContent: true,
			alwaysShowContent: true,
			triggerOn: 'mousemove',
			trigger: 'axis',
			axisPointer:
			{
				label: {
					show: false,
				}
			}

		},
		yAxis: {
			splitLine: {
				lineStyle: {
					color: 'rgba(67, 87, 133, .09)'
				}
			},
			axisLine: {
				lineStyle: {
					color: 'rgba(67, 87, 133, .09)'
				}
			},
			axisLabel: {
				fontSize: 10,
				color: '#8e9cad'
			}
		},
		series: chartdata_echart_prevision,
		color:[ '#fa5948','#df362e', '#d6181a',]
	};

	barChart_echart_prevision.setOption(option);
	/*  /echart_estimacion_tokens */


	
	//
	
	var chart2 = c3.generate({
		bindto: '#chart_fondos', // id of chart wrapper
		data: {
			columns: [
					// each columns data
					['data1', 61],
					['data2', 19],
					['data3', 12],
					['data4', 6],
				],
				type: 'donut', // default type of chart
				colors: {
					'data1': '#d93f20',
					'data2': '#df512e',
					'data3': '#e5643a',
					'data4': '#fa7548',
				},
				names: {
					// name of each serie
					'data1': 'Comercialización',
					'data2': 'Bonus',
					'data3': 'Equipo fundador',
					'data4': 'Equipo de trabajo',
				}
			},
			axis: {
			},

			legend: {
			  show: false, //hide legend
			},
			padding: {
				bottom: 0,
				top: 0
			},
		});
	


});