<?php

$personalizacion = json_decode(file_get_contents('personalizacion.json'), true);



// Simulación de datos de la factura (estos deberían obtenerse dinámicamente)

$factura = [

    "numero" => "2025-0001",

    "fecha" => "2025-01-08",

    "importe" => "150.00",

    "cif_emisor" => "B12345678",

    "nombre_emisor" => "Empresa Ejemplo SL"

];

?>



<!DOCTYPE html>

<html lang="en" dir="ltr">



<head>

    <!-- Meta data -->

    <meta charset="UTF-8">

    <meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>

    <meta content="" name="description">

    <meta content="Intranet" name="author">

    <meta name="keywords" content="" />

    <!-- Title -->

    <title>

        <?php echo APP_NAME; ?> - Verificación de factura

    </title>

    <!-- Favicon -->

    <link rel="shortcut icon" href="<?php echo htmlentities($personalizacion['url_fav_icon'], ENT_QUOTES); ?>" />

    <!-- Style css -->

    <link href="assets/css/style.css" rel="stylesheet" />

    <link href="assets/css/login.css" rel="stylesheet" />

    <!-- Icons css -->

    <link href="assets/plugins/iconfonts/icons.css" rel="stylesheet" />

    <link href="assets/plugins/iconfonts/plugin.css" rel="stylesheet" />

    <!-- Icons Fontawesome 5 css -->

    <link href="assets/css/all.css" rel="stylesheet" />

    <!-- Skin css -->

    <link id="theme" rel="stylesheet" type="text/css" media="all" href="assets/skins/hor-skin/combined-default.css" />

    <link rel="stylesheet" href="assets/skins/demo.css" />

    <!-- Toastr -->

    <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <script src="assets/js/vendors/jquery-3.4.0.min.js"></script>

    <!-- Bootstrap4 js -->

    <script src="assets/plugins/bootstrap/popper.min.js"></script>

    <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>

    <script src="//cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <!-- Custom Styles -->

    <style>
    body {

        background-color: #f8f9fa;

    }



    .success-container {

        display: flex;

        justify-content: center;

        align-items: center;

        background-color: #f8f9fa;

        text-align: center;

        padding: 20px;

    }



    .success-box {

        background: #ffffff;

        border-radius: 8px;

        box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);

        padding: 30px;

        width: 100%;

        max-width: 600px;

        text-align: left;

    }



    .success-icon {

        font-size: 80px;

        color: #28a745;

        text-align: center;

    }



    .success-message {

        font-size: 22px;

        font-weight: 600;

        color: #333;

        text-align: center;

        margin-top: 10px;

    }



    .factura-details {

        margin-top: 20px;

        font-size: 16px;

        line-height: 1.6;

        color: #555;

    }



    .factura-details strong {

        color: #333;

    }



    .back-button {

        margin-top: 30px;

        text-align: center;

    }



    .back-button a {

        text-decoration: none;

        padding: 10px 20px;

        font-size: 16px;

        color: white;

        background-color: #007bff;

        border-radius: 5px;

        transition: background-color 0.3s ease;

    }



    .back-button a:hover {

        background-color: #0056b3;

    }
    </style>

</head>



<body class="m-0">

    <div class="success-container">

        <div class="success-box">

            <div class="success-icon text-center">

                <i class="fas fa-check-circle"></i>

            </div>

            <div class="success-message">

                ¡Factura Verificada Correctamente!

            </div>

            <div class="factura-details">

                <p><strong>Número de Factura:</strong> <?php echo htmlentities($Factura['numero'], ENT_QUOTES); ?></p>

                <p><strong>Fecha de Emisión:</strong> <?php echo htmlentities($Factura['fecha'], ENT_QUOTES); ?></p>

                <p><strong>Importe Total:</strong>
                    €<?php echo htmlentities($Factura['importe_calculado'], ENT_QUOTES); ?></p>

                <p><strong>CIF del emisor:</strong> <?php echo htmlentities($personalizacion['cif'], ENT_QUOTES); ?></p>

                <p><strong>Nombre/Razón Social del emisor:</strong>
                    <?php echo htmlentities($personalizacion['nombre'], ENT_QUOTES); ?></p>

                <p><strong>CIF del Cliente:</strong> <?php echo htmlentities($Factura['cif'], ENT_QUOTES); ?></p>

                <p><strong>Nombre/Razón Social del Cliente:</strong>
                    <?php echo htmlentities($Factura['nombre'], ENT_QUOTES); ?></p>

            </div>





        </div>

    </div>



    <div style="margin-top: 10px;text-align: center;">

        <div class="row">

            <div class="col-12 text-center">

                <img src="/assets/images/tributaria.png" style="width: 150px;margin-right: 50px;">

                <img src="/assets/images/gobierno.png" style="width: 150px;">

            </div>



        </div>

    </div>

</body>



</html>