<!DOCTYPE html>
<html lang="en" dir="ltr">
	<head>
		<!-- Meta data -->
		<meta charset="UTF-8">
		<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
		<meta content="OneUP" name="description">
		<meta content="OneUP" name="author">
		<meta name="keywords" content="OneUP, Salvavidas portátil STO, Salvavidas Autoinflable STO"/>
		<meta name="description" content="Únete a la revolución OneUP."/>
		<!-- Title -->
		<title>OneUP - Únete a la revolución</title>
		<!--Favicon -->
		<link rel="icon" href="assets/images/brand/favicon.ico" type="image/x-icon"/>
		<!-- Style css -->
		<link href="assets/css/style.css" rel="stylesheet" />
		<!---Icons css-->
		<link href="assets/plugins/iconfonts/icons.css" rel="stylesheet" />
		<link href="assets/plugins/iconfonts/font-awesome/font-awesome.min.css" rel="stylesheet">
		<link href="assets/plugins/iconfonts/plugin.css" rel="stylesheet" />
		<!-- Skin css-->
		<link id="theme" rel="stylesheet" type="text/css" media="all" href="assets/skins/hor-skin/combined-default.css" />
		<link rel="stylesheet" href="assets/skins/demo.css"/>
	</head>
	<body class="bg-white">
		<div class="container-fluid text-center">
			<div class="row">
				<div class="col-12 col-lg-6 px-0 bg-mar">
					<!-- <img src="assets/img/bgs/bg-mar.jpg" class="img-login" alt="login"> -->
				</div>
				<div class="col-lg-6">
					<div class="w-md-66 form-login mx-auto">
						<img src="assets/img/logo.png" class="login-logo" alt="Aronox logo">
						<form action="#" method="POST" id="login" class="card-body row" tabindex="500">
							<input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
							<div class="col-12">
								<p class="mb-6 login-title">Bienvenido, actualiza tu cuenta y accede ahora.</p>
<?php
		if (isset($_GET['error']) && !empty($_GET['error'])) {
			//Invalid or Expired Update Code
			if ($_GET['error'] == -1) {
				echo '								<div class="alert alert-danger mb-4" id="alerta-login" role="alert">Error, el enlace está expirado o ya ha sido utilizado.</div>'.PHP_EOL;
			//Invalid Name
			} else if ($_GET['error'] == -2) {
				echo '								<div class="alert alert-danger mb-4" id="alerta-login" role="alert">Error, debe de introducir un nombre valido</div>'.PHP_EOL;
			//Invalid Surnames
			} else if ($_GET['error'] == -3) {
				echo '								<div class="alert alert-danger mb-4" id="alerta-login" role="alert">Error, debe de introducir unos apellidos validos.</div>'.PHP_EOL;
			//Invalid User Origin
			} else if ($_GET['error'] == -4) {
				echo '								<div class="alert alert-danger mb-4" id="alerta-login" role="alert">Error, al parecer su cuenta fue creada a través de Google o Facebook.</div>'.PHP_EOL;
			//The New Password is Invalid
			} else if ($_GET['error'] == -5) {
				echo '								<div class="alert alert-danger mb-4" id="alerta-login" role="alert">Error, la contraseña debe incluir letras y numeros, además de tener al menos 8 caracteres de longitud.</div>'.PHP_EOL;
			//The Two Passwords aren't the same
			} else if ($_GET['error'] == -6) {
				echo '								<div class="alert alert-danger mb-4" id="alerta-login" role="alert">Por favor, asegurese de que las dos contraseñas introducidas coincidan.</div>'.PHP_EOL;
			//Unknown Error
			} else if ($_GET['error'] == -7) {
				echo '								<div class="alert alert-danger mb-4" id="alerta-login" role="alert">Lo sentimos, ha ocurrido un error inesperado al intentar actualizar su cuenta.</div>'.PHP_EOL;
			}
		} else if (isset($_GET['success'])) {
			echo '								<div class="alert alert-info" id="alerta-login" role="alert">Su cuenta ha sido actualizada con éxito.</div>'.PHP_EOL;
		}
?>
							</div>
							<div class="alert alert-danger" id="alerta-caracteres" role="alert" style="display:none;margin:auto;margin-bottom:10px;width:95%;">La contraseña debe ser superior a 6 caracteres.</div>
							<div class="alert alert-danger" id="alerta-alfanumerico" role="alert" style="display:none;margin:auto;margin-bottom:10px;width:95%;">La contraseña debe contener caracteres alfanúmericos.</div>
							<div class="col-md-6 mb-3 pr-md-1">
								<input name="name" type="text" class="form-control" placeholder="Nombre"<?php if (isset($Name)) { echo ' value="'.htmlentities($Name, ENT_QUOTES).'"'; } ?>>
							</div>
							<div class="col-md-6 mb-3 pl-md-1">
								<input name="surnames" type="text" class="form-control" placeholder="Apellidos"<?php if (isset($Surnames)) { echo ' value="'.htmlentities($Surnames, ENT_QUOTES).'"'; } ?>>
							</div>
<?php
	if (isset($Email)) {
?>
							<div class="col-md-12 mb-3">
								<input name="email" type="text" class="form-control" placeholder="Email" value="<?php echo htmlentities($Email, ENT_QUOTES); ?>" disabled>

							</div>
<?php
	}
?>
							<div class="col-md-12 mb-3">
								<input name="password1" type="password" class="form-control" placeholder="Nueva contraseña">
							</div>
							<div class="col-md-12 mb-3">
								<input name="password2" type="password" class="form-control" placeholder="Repetir nueva contraseña">
							</div>
							<div class="col-12">
								<button type="submit" class="btn btn-block btn-g-red py-2">Actualizar cuenta</button>
							</div>
							<div class="col-12 mb-0 login-data-pass">
								<p class="mb-4">
								</p>
								<p class="register-politics">
									Al acceder, aceptas los <a href="">Términos del servicio</a>,<br> la <a href="">Política de privacidad</a> y el <a href="">uso de cookies</a> de OneUP
								</p>
							</div>
						</form>
					</div>
				</div>
			</div>
			<!-- row -->
		</div>
		<!-- Jquery js-->
		<script src="assets/js/vendors/jquery-3.4.0.min.js"></script>
		<!-- Bootstrap4 js-->
		<script src="assets/plugins/bootstrap/popper.min.js"></script>
		<script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
		<!--Othercharts js-->
		<script src="assets/plugins/othercharts/jquery.sparkline.min.js"></script>
		<!-- Circle-progress js-->
		<script src="assets/js/vendors/circle-progress.min.js"></script>
		<!-- Jquery-rating js-->
		<script src="assets/plugins/rating/jquery.rating-stars.js"></script>
	</body>
</html>