<div class="content-wrapper">

    <div class="row profile-page ">
        <div class="col-md-12 mb-8">
            <div class="card satmar-bottom">
                <div class="sato-border-blue">

                    <div class="text-center soli-ad">
                        <lord-icon src="https://cdn.lordicon.com/crkzfzni.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES);?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES);?>"
                            style="width:80px;height:80px">
                        </lord-icon>
                        <p class="mb-2">Subvenciones enviadas</p>
                        <span class="">1</span>
                    </div>
                </div>
            </div>
        </div>

    </div>


    <div class="row profile-page">
        <div class="col-12">
            <div class="card">

                <div class="" style="padding-bottom: 0px !important;">

                    <div class="pt-0 ">

                        <div class="row ">
                            <!-- Historial de Acceso -->
                            <div class="col-md-12">
                                <a href="./subvenciones?crear=1" class="m-3 m-sm-4 btn btn-sm btn-primary">Agregar</a>
                                <div class="card card-cuenta">

                                    <div class="card-body p-3 p-sm-4 card-table-body">
                                        <div class="table-responsive">
                                            <table id="order-listing" cellspacing="0" class="table display nowrap">
                                                <thead>
                                                    <tr>
                                                        <th>ID</th>
                                                        <th>Sociedad/Autónomo</th>
                                                        <th>Subvencion</th>
                                                        <th>Fecha de envío</th>

                                                        <th>Email</th>
                                                        <th>Estado</th>

                                                        <th style="text-align:center;">Acciones</th>
                                                    </tr>
                                                </thead>
                                                <tbody>

                                                    <?php
                                                foreach($Subvenciones_List as $Subvencion){
                                                    $datos = $this->Users->GetDatosCliente($Subvencion['id_cliente_subvencion']);
                                                    $sub = $this->Users->GetSubvencion($Subvencion['id_subvencion']);
                                                ?>
                                                    <tr>
                                                        <td><?php echo htmlentities($Subvencion['id_cliente_subvencion'], ENT_QUOTES); ?>
                                                        </td>
                                                        <td><?php echo htmlentities($datos['nombre_comercial'], ENT_QUOTES); ?>
                                                        </td>
                                                        <td><?php echo htmlentities($datos['titulo'], ENT_QUOTES); ?>
                                                        </td>
                                                        <td><?php 

                                                        if($Subvencion['fecha_envio'] != NULL){
                                                        echo htmlentities($Subvencion['fecha_envio'], ENT_QUOTES); 
                                                        }else{
                                                            echo "No enviado";
                                                        }
                                                        
                                                        ?>
                                                        </td>

                                                        <td><?php echo htmlentities($datos['email'], ENT_QUOTES); ?>
                                                        </td>
                                                        <td><?php echo htmlentities($Subvencion['estado'], ENT_QUOTES); ?>
                                                        </td>

                                                        <td class="table-dropdown" style="text-align:center">

                                                            <div class="dropdown d-inline-block user-dropdown">
                                                                <a class="dropdown-toggle d-flex align-items-center"
                                                                    id="UserDropdown" href="#" data-toggle="dropdown"
                                                                    aria-expanded="false">


                                                                    Acciones


                                                                </a>
                                                                <div class="dropdown-menu dropdown-menu-right navbar-dropdown p-0"
                                                                    aria-labelledby="UserDropdown">



                                                                    <button type="button"
                                                                        class="btn_enviar p-1 dropdown-item"
                                                                        data-idclientesubvencion=<?php echo htmlentities($Subvencion['id_cliente_subvencion'], ENT_QUOTES); ?>>
                                                                        <lord-icon
                                                                            src="https://cdn.lordicon.com/xlrvroxq.json"
                                                                            trigger="hover"
                                                                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES);?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES);?>"
                                                                            style="width:30px;height:30px">
                                                                        </lord-icon>
                                                                        <?php
                                                                        if($Subvencion['estado']=="Enviado" || $Subvencion['estado']=="Aceptado" || $Subvencion['estado']=="Rechazado"){
                                                                        ?>
                                                                        Reenviar
                                                                        <?php
                                                                        }else{

                                                                        
                                                                        
                                                                        ?>
                                                                        Enviar
                                                                        <?php
                                                                        }
                                                                        ?>
                                                                    </button>

                                                                    <?php
                                                                        if($Subvencion['estado']=="Enviado" || $Subvencion['estado']=="Rechazado"){
                                                                        ?>
                                                                    <button type="button"
                                                                        class="btn_aceptar p-1 dropdown-item"
                                                                        data-id=<?php echo htmlentities($Subvencion['id_cliente_subvencion'], ENT_QUOTES); ?>
                                                                        data-cliente=<?php echo htmlentities($Subvencion['id_cliente'], ENT_QUOTES); ?>>

                                                                        <lord-icon
                                                                            src="https://cdn.lordicon.com/sdtfrjpe.json"
                                                                            trigger="hover"
                                                                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES);?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES);?>"
                                                                            style="width:30px;height:30px">
                                                                        </lord-icon>
                                                                        Aceptado
                                                                    </button>
                                                                    <?php
                                                                        }
                                                                        ?>
                                                                    <?php
                                                                        if($Subvencion['estado']=="Enviado" || $Subvencion['estado']=="Aceptado"){
                                                                        ?>
                                                                    <button type="button"
                                                                        class="btn_rechazar p-1 dropdown-item"
                                                                        data-id=<?php echo htmlentities($Subvencion['id_cliente_subvencion'], ENT_QUOTES); ?>
                                                                        data-cliente=<?php echo htmlentities($Subvencion['id_cliente'], ENT_QUOTES); ?>>
                                                                        <lord-icon
                                                                            src="https://cdn.lordicon.com/sdtfrjpe.json"
                                                                            trigger="hover"
                                                                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES);?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES);?>"
                                                                            style="width:30px;height:30px">
                                                                        </lord-icon>
                                                                        Rechazado
                                                                    </button>

                                                                    <?php
                                                                        }
                                                                        ?>


                                                                    <button type="button"
                                                                        class="p-1 dropdown-item btn_editar"
                                                                        data-idclientesubvencion=<?php echo htmlentities($Subvencion['id_cliente_subvencion'], ENT_QUOTES); ?>
                                                                        data-subvencion=<?php echo htmlentities($Subvencion['id_subvencion'], ENT_QUOTES); ?>>
                                                                        <lord-icon
                                                                            src="https://cdn.lordicon.com/wloilxuq.json"
                                                                            trigger="hover"
                                                                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES);?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES);?>"
                                                                            style="width:30px;height:30px">
                                                                        </lord-icon>
                                                                        Editar
                                                                    </button>

                                                                    <button type="button"
                                                                        class="btn_eliminar p-1 dropdown-item"
                                                                        data-id=<?php echo htmlentities($Subvencion['id_cliente_subvencion'], ENT_QUOTES); ?>
                                                                        data-cliente=<?php echo htmlentities($Subvencion['id_cliente'], ENT_QUOTES); ?>>
                                                                        <lord-icon
                                                                            src="https://cdn.lordicon.com/ymoqjpau.json"
                                                                            trigger="hover"
                                                                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES);?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES);?>"
                                                                            style="width:30px;height:30px">
                                                                        </lord-icon>
                                                                        Eliminar
                                                                    </button>

                                                                </div>
                                                            </div>




                                                        </td>

                                                        <?php
                                                }
                                                ?>

                                                    </tr>

                                                </tbody>
                                            </table>

                                        </div>

                                    </div>
                                </div>
                            </div>
                            <!-- /Historial de Acceso -->
                            <!-- Eliminación de cuenta -->

                            <!-- /Eliminación de cuenta -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">

            <div class="col-12">
                <div class="d-none" id="pdf_subvencion" style="">
                    <div
                        style="background-color:white; padding:1rem;max-width: 500px; min-width:360px; width:100%;margin: 0 auto;">
                        <img id="img_portada_mail"
                            style="width:100%; margin-left: auto; margin-right: auto; margin-bottom:.5rem" src=""
                            alt="">

                        <div>
                            <p style="color:black;font-family: Poppins; margin-bottom:.5rem">Nombre
                                comercial: <span id="nombre_cliente_pdf"></span></p>
                            <p style="color:black;font-family: Poppins; margin-bottom:.5rem">CIF: <span
                                    id="cif_cliente_pdf"></span></p>
                            <p style="color:black;font-family: Poppins; margin-bottom:.5rem">Domicilio:
                                <span id="domicilio_cliente_pdf"></span>
                            </p>
                            <p style="color:black;font-family: Poppins; margin-bottom:.5rem">Tipo: <span
                                    id="tipo_cliente_pdf"></span>
                            </p>
                            <p style="color:black;font-family: Poppins; margin-bottom:.5rem">Número de
                                empleados: <span id="empleados_pdf"></span></p>
                            <p style="color:black;font-family: Poppins; margin-bottom:.5rem">CP: <span
                                    id="cp_cliente_pdf"></span></p>
                            <p id="fase_pdf" style="color:black;font-family: Poppins; margin-bottom:.5rem">
                                Fase: <span id="fase_cliente_pdf"></span></p>
                            <p id="sector_pdf" style="color:black;font-family: Poppins; margin-bottom:.5rem">Sector:
                                <span id="sector_cliente_pdf"></span>
                            </p>
                            <p id="zona_pdf" style="color:black;font-family: Poppins; margin-bottom:.5rem">
                                Zona: <span id="zona_cliente_pdf"></span></p>

                            <p style="color:black;font-family: Poppins; margin-bottom:.5rem">Importe: <span
                                    id="importe_pdf"></span>
                            </p>

                        </div>


                        <h2 style="color:black;font-family: Poppins; text-align: center; margin-bottom:.5rem"
                            id="titulo_subvencion_pdf">
                            Titulo</h2>

                        <div style="color:black;font-family: Poppins; margin-bottom:1.5rem"
                            id="descripcion_subvencion_pdf">
                            Descripcion
                        </div>
                        <ul style="list-style: none;margin: 0px;margin-bottom:1rem;padding: 1rem; text-align: center;">

                            <li style="padding: .5rem;display: inline;" class="redes-soci">
                                <a style="font-family: Poppins;"
                                    href="<?php echo htmlentities($personalizacion['url_facebook'], ENT_QUOTES);?>"
                                    target="_blank" class="imgiconos"><img
                                        src=<?php echo WEBSITE_URL ."/assets/mail/fb.png";?> alt=""
                                        class="imgiconos"><span class="capa-traslucida"></span></a>
                            </li>
                            <li style="padding: .5rem;display: inline;" class="redes-soci">
                                <a style="font-family: Poppins;"
                                    href="<?php echo htmlentities($personalizacion['url_linkedin'], ENT_QUOTES);?>"
                                    target="_blank" class="imgiconos"><img
                                        src=<?php echo WEBSITE_URL ."assets/mail/lin.png";?> alt=""
                                        class="imgiconos"><span class="capa-traslucida"></span></a>
                            </li>
                            <li style="padding: .5rem;display: inline;" class="redes-soci">
                                <a style="font-family: Poppins;"
                                    href="<?php echo htmlentities($personalizacion['url_twitter'], ENT_QUOTES);?>"
                                    target="_blank" class="imgiconos"><img
                                        src=<?php echo WEBSITE_URL ."assets/mail/tw.png";?> alt=""
                                        class="imgiconos"><span class="capa-traslucida"></span></a>
                            </li>
                            <li style="padding: .5rem;display: inline;" class="redes-soci">
                                <a style="font-family: Poppins;"
                                    href="<?php echo htmlentities($personalizacion['url_youtube'], ENT_QUOTES);?>"
                                    target="_blank" class="imgiconos"><img
                                        src=<?php echo WEBSITE_URL ."assets/mail/you.png";?> alt=""
                                        class="imgiconos"><span class="capa-traslucida"></span></a>
                            </li>
                        </ul>
                        <div style="color:black;font-family: Poppins; margin-bottom:1.5rem" id="condiciones_pdf">
                            Condiciones
                        </div>

                    </div>


                </div>
            </div>

        </div>
    </div>

</div>


<!-- MODALS -->
<div class="modal fade" id="modalEditarSubvencion" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="nb-0">Editar subvención a enviar</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">

                <div class="container-fluid p-0">


                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="titulo_subvencion_editar">Título</label>
                                <input id="titulo_subvencion_editar" class="form-control" type="text" name="">
                            </div>
                        </div>
                        <div class="col-12">
                            <label class="mb-4">Imágen de cabecera</label>
                        </div>

                        <div class="col-sm-4 mb-4 mb-sm-0">
                            <img id="img_logo_portada_editar" class="w-100"
                                src=<?php echo WEBSITE_URL . "image.php?id=BEzwaVhMLsEYFSpFeIjHpOoJ7";?> alt="">
                        </div>
                        <div class="col-sm-8">
                            <form id="form_editar" method="POST" enctype="multipart/form-data">
                                <div class="input-group mb-4">

                                    <input id="input_mostrar_logo_editar" type="text" class="form-control"
                                        placeholder="" aria-label=""
                                        value=<?php echo WEBSITE_URL . "image.php?id=BEzwaVhMLsEYFSpFeIjHpOoJ7";?>
                                        disabled="">
                                    <input type="file" class="d-none" id="logo_portada_editar"
                                        name="logo_portada_editar">
                                    <div class="input-group-append">
                                        <label class="mb-0" for="logo_portada_editar" class="btn btn-success"
                                            type="button">Seleccionar</label>
                                    </div>
                                </div>
                            </form>

                            <p class="mb-0">Medidas recomendadas: 512px x 68px</p>

                        </div>

                        <div class="col-12">
                            <div class="form-group">
                                <label>Condiciones Generales</label>
                                <textarea class="form-control" type="text" class="form-control m-0"
                                    name="condiciones_presupuesto_editar" id="condiciones_presupuesto_editar"
                                    placeholder="" required></textarea>
                            </div>
                        </div>

                        <div class="col-12 mt-4">
                            <div class="form-group">
                                <label for="mymce_editar">Email</label>
                                <textarea class="h-100 mb-4" id="mymce_editar"></textarea>
                            </div>
                        </div>

                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Nombre del cliente</label>

                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            id="btn_eliminar">-</button>
                                    </span>
                                    <select id="select_cliente_editar"
                                        class="form-control custom-select text-center select2">

                                        <?php                  

                                                    foreach ($Clientes_List as $Cliente) {                                               
                                                        
                                                    ?>
                                        <option type="text"
                                            value=<?php echo htmlentities($Cliente['client_id'], ENT_QUOTES); ?>>
                                            <?php echo htmlentities($Cliente['nombre'], ENT_QUOTES); ?>
                                        </option>

                                        <?php
                                                    } 
                                                        
                                                ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarClienteNuevo">+</button>
                                    </span>
                                </div>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>CIF</label>

                                <input type="text" class="form-control" id="input_cif_editar" placeholder="">



                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Domicilio</label>

                                <input type="dir" class="form-control" id="input_domicilio_editar" placeholder="">

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>C.P</label>

                                <input type="number" class="form-control" id="input_cp_editar" placeholder="">

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Teléfono</label>

                                <input type="tel" class="form-control" id="input_telefono_editar" placeholder="">



                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Email</label>

                                <input type="mail" class="form-control" id="input_email_editar" placeholder="">

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Nombre comercial (Autónomo/SL) </label>

                                <input type="mail" class="form-control" id="input_nombre_editar" placeholder="">

                            </div>

                        </div>




                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Sector</label>

                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            id="btn_eliminar_sector_editar">-</button>
                                    </span>
                                    <select id="input_sector_editar" name="nombre_sector"
                                        class="form-control custom-select text-center select2">
                                        <?php

                                            foreach($Sectores as $Sector){
                                            ?>
                                        <option type="text"
                                            value="<?php echo htmlentities($Sector['id_sector'], ENT_QUOTES); ?>">
                                            <?php echo htmlentities($Sector['nombre'], ENT_QUOTES); ?>
                                        </option>
                                        <?php

                                            }
                                            ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarSector">+</button>
                                    </span>
                                </div>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Tipo</label>

                                <select id="tipo_cliente_editar" name="tipo_cliente"
                                    class="form-control custom-select text-center">



                                    <option type="text" value="Particular" selected="selected">Particular</option>

                                    <option type="text" value="Empresa">Empresa</option>



                                </select>


                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Nº de empleados </label>

                                <input type="mail" class="form-control" id="input_empleados_editar" placeholder=""
                                    value=0>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Fase</label>

                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            id="btn_eliminar_fase_editar">-</button>
                                    </span>
                                    <select id="input_fase_editar" name="input_fase"
                                        class="form-control custom-select text-center select2">

                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarFase">+</button>
                                    </span>
                                </div>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Importe</label>

                                <input type="number" class="form-control" id="input_importe_editar" placeholder=""
                                    value=0>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Enlace a enviar</label>

                                <select id="tipo_enlace_editar" name="" class="form-control custom-select text-center">



                                    <option type="text" value="autonomo">Autónomo</option>

                                    <option type="text" value="sociedad">Sociedad</option>
                                    <option type="text" value="generico">Genérico</option>



                                </select>


                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Responsable</label>

                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            data-toggle="modal" data-target="#modalQuitarNombre">-</button>
                                    </span>
                                    <select name="input_usuario" id="input_usuario_editar"
                                        class="form-control custom-select text-center select2">
                                        <?php

                                                 foreach($User_List as $User){
                                                 ?>
                                        <option type="text"
                                            value="<?php echo htmlentities($User['user_id'], ENT_QUOTES); ?>">
                                            <?php echo htmlentities($User['user_full_name'], ENT_QUOTES); ?>
                                        </option>
                                        <?php

                                                  }
                                                    ?>
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarNombre">+</button>
                                    </span>
                                </div>

                            </div>

                        </div>
                        <div class="col-lg-4">

                            <div class="form-group">

                                <label>Zona</label>

                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="file-upload-browse btn btn-danger" type="button"
                                            id="btn_eliminar_zona_editar">-</button>
                                    </span>
                                    <select id="input_zona_editar"
                                        class="form-control custom-select text-center select2">

                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarZona">+</button>
                                    </span>
                                </div>


                            </div>

                        </div>
                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">
                <input type="hidden" id="id_subvencion_editar">
                <input id="input_id_cliente_subvencion" type="hidden" name="">
                <input id="input_id_datos_cliente" type="hidden" name="">
                <button class="btn btn-success btn-fw" id="btn_editar_datos">

                    Editar</button>







            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade" id="modalAgregarSector" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Agregar sector</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>


            <form id="form-agregar-sector" method="POST" action="">

                <div class="modal-body pb-0">

                    <div class="container p-0">

                        <div class="row">

                            <div class="col-12">
                                <input class="form-control w-100" name="nombre_sector" id="nombre_sector" required
                                    type="text">
                            </div>

                        </div>

                    </div>



                </div>

                <div class="modal-footer text-right">

                    <input type="hidden" id="cliente_sector_id" name="cliente_sector_id">

                    <button class="btn btn-danger btn-fw" type="submit">

                        Agregar</button>

                    <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                        Cancelar </button>





                </div>

            </form>

            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade" id="modalAgregarFase" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Agregar fase</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>


            <form id="form-agregar-fase" method="POST" action="">

                <div class="modal-body pb-0">

                    <div class="container p-0">

                        <div class="row">

                            <div class="col-12">
                                <input class="w-100 form-control" name="nombre_fase" id="nombre_fase" type="text"
                                    required>
                            </div>

                        </div>

                    </div>



                </div>

                <div class="modal-footer text-right">

                    <input type="hidden" id="cliente_fase_id" name="cliente_fase_id">

                    <button class="btn btn-danger btn-fw" type="submit">

                        Agregar</button>

                    <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                        Cancelar </button>





                </div>

            </form>

            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade modal-cambiar" id="modalEliminarZona" tabindex="-1" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar la zona definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">
                <form id="form_eliminar_zona" method="POST" action="">

                    <input type="hidden" id="id_zona_eliminar" name="id_zona_eliminar" data-name="">
                    <button class="btn btn-danger btn-fw" type="submit" name="">
                        Confirmar y eliminar </button>
                    <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                        Cancelar </button>

                </form>
            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarZona" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Agregar zona</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>


            <form id="form-agregar-zona" method="POST" action="">

                <div class="modal-body pb-0">

                    <div class="container p-0">

                        <div class="row">

                            <div class="col-12">
                                <input class="w-100 form-control" name="nombre_zona" id="nombre_zona" type="text"
                                    required>
                            </div>

                        </div>

                    </div>



                </div>

                <div class="modal-footer text-right">

                    <input type="hidden" id="cliente_zona_id" name="cliente_zona_id">

                    <button class="btn btn-danger btn-fw" type="submit">

                        Agregar</button>

                    <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                        Cancelar </button>





                </div>

            </form>

            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade modal-cambiar" id="modalEliminarFase" tabindex="-1" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar la fase definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">
                <form id="form_eliminar_fase" method="POST" action="">

                    <input type="hidden" id="id_fase_eliminar" data-name="" name="id_fase_eliminar">
                    <button class="btn btn-danger btn-fw" type="submit" name="">
                        Confirmar y eliminar </button>
                    <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                        Cancelar </button>

                </form>
            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade modal-cambiar" id="modalEliminarSector" tabindex="-1" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el sector definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">
                <form id="form_eliminar_sector" method="POST" action="">

                    <input data-name="" type="hidden" id="id_sector_eliminar" name="id_sector_eliminar">
                    <button class="btn btn-danger btn-fw" type="submit" name="">
                        Confirmar y eliminar </button>
                    <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                        Cancelar </button>

                </form>
            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>


<script>
(function($) {
    'use strict';
    $(function() {
        var Table = $('#order-listing').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "lengthMenu": [
                [5, 10, 15, -1],
                [5, 10, 15, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en subvenciones enviadas",
                infoEmpty: "Mostrando 0 a 0 de 0 en clientes",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",

                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [
                'colvis'
            ]

        });
        if ($("#mymce_editar").length > 0) {
            tinymce.init({
                selector: "#mymce_editar",
                theme: "modern",
                height: 300,
                plugins: [
                    "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
                    "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                    "save table contextmenu directionality emoticons template paste textcolor"
                ],
                toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            });
        }
        $('#order-listing2').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "lengthMenu": [
                [5, 10, 15, -1],
                [5, 10, 15, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_ en enviados",
                infoEmpty: "Mostrando 0 a 0 de 0 en enviados",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                loadingRecords: "Cargando...",
                processing: "Procesando...",

                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [
                'colvis'
            ]

        });


        $('.dataTables_filter input').attr('placeholder', 'Buscar');
        $('.dataTables_filter input').addClass('form-control');
        // LENGTH - Inline-Form control



        $('.dataTables_length select').addClass('form-control');

        $('.dt-button span:nth-child(1)').text("Ocultar columnas");

        if ($("#mymce").length > 0) {
            tinymce.init({
                selector: "textarea#mymce",
                theme: "modern",
                height: 300,
                plugins: [
                    "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
                    "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                    "save table contextmenu directionality emoticons template paste textcolor"
                ],
                toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",

            });
        }



        $(document).on("click", ".btn_aceptar", function() {
            var id_aceptar = $(this).data("id")
            var id_cliente_aceptar = $(this).data("cliente")
            $.ajax({
                type: 'POST',
                url: './subvenciones_enviadas',
                data: {
                    id_aceptar: id_aceptar,
                    id_cliente_aceptar: id_cliente_aceptar

                },
                success: function(result) {
                    console.log(result);

                    $.toast({
                        heading: 'Subvención aceptada',
                        text: 'Se ha aceptado la subvención correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    setTimeout(function() {
                        window.location.reload();

                    }, 2000);

                }
            });



        })
        $(document).on("click", ".btn_rechazar", function() {
            var id_rechazar = $(this).data("id")

            $.ajax({
                type: 'POST',
                url: './subvenciones_enviadas',
                data: {
                    id_rechazar: id_rechazar,


                },
                success: function(result) {
                    console.log(result);

                    $.toast({
                        heading: 'Subvención rechazada',
                        text: 'Se ha rechazado la subvención correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    setTimeout(function() {
                        window.location.reload();

                    }, 2000);

                }
            });



        })
        $(document).on("click", ".btn_eliminar", function() {
            var id_eliminar = $(this).data("id")

            $.ajax({
                type: 'POST',
                url: './subvenciones_enviadas',
                data: {
                    id_eliminar: id_eliminar,


                },
                success: function(result) {
                    console.log(result);

                    $.toast({
                        heading: 'Subvención eliminada',
                        text: 'Se ha eliminado la subvención correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    setTimeout(function() {
                        window.location.reload();

                    }, 2000);

                }
            });



        })


        $(document).on("click", ".btn_enviar", function() {
            $(this).attr("disabled", true);
            var id_cliente_subvencion = $(this).data("idclientesubvencion")
            $.ajax({
                type: "GET",
                url: "./api/cliente_subvencion.php?id_cliente_subvencion=" +
                    id_cliente_subvencion,
                cache: false,
                async: false,
                success: function(response) {

                    var res = JSON.parse(response)
                    console.log(res);
                    var condiciones = res.condiciones
                    var email = res.email
                    var email_marketing = res.email_marketing
                    var url_portada = res.url_portada
                    var email_marketing = res.email_marketing
                    var id_cliente = res.id_cliente

                    $("#img_portada_mail").attr("src", url_portada)
                    $('#descripcion_subvencion_pdf').html(
                        email_marketing)



                    $.ajax({
                        type: "GET",
                        url: "./api/datos_cliente.php?id_cliente_subvencion=" +
                            id_cliente_subvencion,
                        cache: false,
                        async: false,
                        success: function(response2) {

                            var res2 = JSON.parse(response2)
                            console.log(res2);
                            var nombre = res2.nombre_comercial
                            var cif = res2.cif
                            var domicilio = res2.domicilio
                            var tipo = res2.tipo
                            var empleados = res2.numero_empleados
                            var cp = res2.cp
                            var titulo = res2.titulo
                            var importe = res2.importe
                            var fase = res2.id_fase
                            var sector = res2.id_sector
                            var zona = res2.id_zona
                            if (fase == null) {
                                $("#fase_pdf").css("display", "none");

                            } else {
                                $("#fase_pdf").css("display", "block");
                                $.ajax({
                                    url: "./api/fases.php?id_fase=" +
                                        fase,
                                    type: 'GET',
                                    dataType: 'json', // added data type
                                    cache: false,
                                    async: false,
                                    success: function(res) {
                                        console.log(res);
                                        $("#fase_cliente_pdf")
                                            .text(res.nombre)
                                    }
                                })

                            }
                            if (sector == null) {
                                $("#sector_pdf").css("display", "none");

                            } else {
                                $("#sector_pdf").css("display", "block");
                                $.ajax({
                                    url: "./api/sectores.php?id_sector=" +
                                        sector,
                                    type: 'GET',
                                    dataType: 'json', // added data type
                                    cache: false,
                                    async: false,
                                    success: function(res) {
                                        console.log(res);
                                        $("#sector_cliente_pdf")
                                            .text(res.nombre)
                                    }
                                })
                            }
                            if (zona == null) {
                                $("#zona_pdf").css("display", "none");

                            } else {
                                $("#zona_pdf").css("display", "block");
                                $.ajax({
                                    url: "./api/zonas.php?id_zona=" +
                                        zona,
                                    type: 'GET',
                                    dataType: 'json', // added data type
                                    cache: false,
                                    async: false,
                                    success: function(res) {
                                        console.log(res);
                                        $("#zona_cliente_pdf")
                                            .text(res.nombre)
                                    }
                                })
                            }


                            $('#nombre_cliente_pdf').text(nombre)
                            $('#cif_cliente_pdf').text(cif)
                            $('#domicilio_cliente_pdf').text(domicilio)
                            $('#tipo_cliente_pdf').text(tipo)
                            $('#empleados_pdf').text(empleados)
                            $('#cp_cliente_pdf').text(cp)
                            $('#titulo_subvencion_pdf').text(titulo)
                            $('#importe_pdf').text(importe + "€")
                            $('#condiciones_pdf').text(condiciones)

                            var pdf = $('#pdf_subvencion')[0].outerHTML
                            var fecha_envio = moment().format(
                                'YYYY-MM-DD HH:mm:ss');
                            $.ajax({
                                type: 'POST',
                                url: './mailer',
                                cache: false,
                                async: false,
                                data: {


                                    email: email,
                                    subvencion: pdf,
                                    id_cliente: id_cliente,
                                    id_cliente_subvencion: id_cliente_subvencion,
                                    fecha_envio: fecha_envio

                                },

                                success: function(result2) {

                                    console.log(result2);
                                    $.toast({
                                        heading: 'Subvencion enviada',
                                        text: 'Se ha enviado la subvencion correctamente',
                                        position: 'top-right',
                                        loaderBg: '#32a852',
                                        icon: 'success',
                                        hideAfter: 2000,
                                        stack: 6
                                    });
                                    setTimeout(function() {
                                        $(this).attr(
                                            "disabled",
                                            false);
                                        window.location
                                            .href =
                                            "./cliente?id=" +
                                            id_cliente +
                                            "&tab_subvenciones_pendientes=1"

                                    }, 2000);

                                }
                            });


                        }

                    })



                }

            })







        })

        function updateDatosEditar() {
            var id_cliente = $('#select_cliente_editar').val();

            $("#input_fase_editar").empty()
            $("#input_sector_editar").empty()
            $("#input_zona_editar").empty()

            $.ajax({
                type: "GET",
                url: "./api/zonas.php",
                cache: false,
                async: false,
                success: function(response) {

                    var res = JSON.parse(response)
                    // console.log(res);
                    for (let r of res) {
                        //console.log(r)
                        if (r.id_cliente == $('#select_cliente_editar').find(':selected')
                            .val()) {

                            let newOption
                            newOption = new Option(r.nombre, r.id_zona, false, false);
                            $("#input_zona_editar").append(newOption).trigger('change');

                        }
                    }



                }

            })
            $.ajax({
                type: "GET",
                url: "./api/sectores.php",
                cache: false,
                async: false,
                success: function(response) {

                    var res = JSON.parse(response)
                    // console.log(res);
                    for (let r of res) {



                        let newOption
                        newOption = new Option(r.nombre, r.id_sector, false, false);
                        $("#input_sector_editar").append(newOption).trigger('change');


                    }



                }

            })
            $.ajax({
                type: "GET",
                url: "./api/fases.php",
                cache: false,
                async: false,
                success: function(response) {

                    var res = JSON.parse(response)
                    //   console.log(res);
                    for (let r of res) {

                        if (r.id_cliente == $('#select_cliente_editar').find(':selected')
                            .val()) {

                            let newOption
                            newOption = new Option(r.nombre, r.id_fase, false, false);
                            $("#input_fase_editar").append(newOption).trigger('change');

                        }
                    }



                }

            })
            $.ajax({
                type: "GET",
                url: "./api/clientes.php?client_id=" +
                    id_cliente,
                cache: false,
                async: false,
                success: function(response) {

                    var res = JSON.parse(response)
                    //   console.log(res);

                    $('#input_cif_editar').val(res.cif)
                    $('#input_domicilio_editar').val(res.direccion)
                    $('#input_cp_editar').val(res.cp)
                    $('#input_telefono_editar').val(res.telefono)
                    $('#input_email_editar').val(res.email)
                    $('#input_nombre_editar').val(res.nombre)




                }

            })


        }

        updateDatosEditar()

        $("#select_cliente_editar").on("change", function() {
            updateDatosEditar()
        })

        function updateSelectZona(selected = "none") {

            $("#input_zona_editar").empty()
            $.ajax({
                type: "GET",
                url: "./api/zonas.php",
                cache: false,
                success: function(response) {

                    var res = JSON.parse(response)

                    for (let r of res) {
                        //console.log(r)

                        if (r.id_cliente == $('#select_cliente_editar').find(':selected')
                            .val()) {


                            let newOption
                            newOption = new Option(r.nombre, r.id_zona, false, false);
                            $("#input_zona_editar").append(newOption).trigger('change');


                        }
                    }
                    if (selected != "none") {

                        $("#input_zona_editar").val(res[res.length - 1].id_zona).trigger(
                            'change');
                    }

                }

            })
        }

        function updateSelectSector(selected = "none") {


            $("#input_sector_editar").empty()
            $.ajax({
                type: "GET",
                url: "./api/sectores.php",
                cache: false,
                success: function(response) {

                    var res = JSON.parse(response)
                    console.log(res);
                    for (let r of res) {



                        let newOption

                        newOption = new Option(r.nombre, r.id_sector, false, false);

                        $("#input_sector_editar").append(newOption).trigger('change');

                    }

                    if (selected != "none") {

                        $("#input_sector_editar").val(res[res.length - 1].id_sector).trigger(
                            'change');
                    }
                }

            })

        }

        function updateSelectFase(selected = "none") {


            $("#input_fase_editar").empty()

            $.ajax({
                type: "GET",
                url: "./api/fases.php",
                cache: false,
                success: function(response) {

                    var res = JSON.parse(response)

                    for (let r of res) {


                        if (r.id_cliente == $('#select_cliente_editar').find(':selected')
                            .val()) {

                            let newOption
                            newOption = new Option(r.nombre, r.id_fase, false, false);
                            $("#input_fase_editar").append(newOption).trigger('change');

                        }
                    }
                    if (selected != "none") {

                        $("#input_fase_editar").val(res[res.length - 1].id_fase).trigger(
                            'change');
                    }

                }

            })
        }
        $('#form-agregar-zona').submit(function(event) {
            event.preventDefault();

            $('#cliente_zona_id').val($('#select_cliente_editar').find(':selected').val())

            $.ajax({
                type: 'POST',
                url: './crear_subvenciones',
                data: $(this).serialize(),
                cache: false,
                success: function(result) {
                    console.log(result);
                    $('#modalAgregarZona').modal('hide');
                    $.toast({
                        heading: 'Zona del cliente ' + $(
                                '#select_cliente')
                            .find(':selected').text() + ' agregada.',
                        text: 'Se ha agregado la zona correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    updateSelectZona(1)
                }
            });

            return false;
        });

        $('#form-agregar-sector').submit(function(event) {
            event.preventDefault();

            $('#cliente_sector_id').val($('#select_cliente_editar').find(':selected').val())

            $.ajax({
                type: 'POST',
                url: './crear_subvenciones',
                data: $(this).serialize(),
                cache: false,
                success: function(result) {
                    console.log(result);
                    $('#modalAgregarSector').modal('hide');
                    $.toast({
                        heading: 'Sector del cliente ' + $(
                                '#select_cliente_editar')
                            .find(':selected').text() + ' agregado.',
                        text: 'Se ha agregado el sector correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    updateSelectSector(1)
                }
            });

            return false;
        });

        $('#form-agregar-fase').submit(function(event) {
            event.preventDefault();

            $('#cliente_fase_id').val($('#select_cliente_editar').find(':selected').val())

            $.ajax({
                type: 'POST',
                url: './crear_subvenciones',
                data: $(this).serialize(),
                cache: false,
                success: function(result) {

                    $('#modalAgregarFase').modal('hide');
                    $.toast({
                        heading: 'Fase del cliente ' + $(
                                '#select_cliente_editar')
                            .find(':selected').text() + ' agregado.',
                        text: 'Se ha agregado la fase correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    updateSelectFase(1)

                }
            });

            return false;
        });
        $(document).on("click", "#btn_eliminar_zona", function(e) {



            $("#id_zona_eliminar").val($("#input_zona_editar").val())
            $("#id_zona_eliminar").data('name', $("#input_zona_editar").find(':selected').text())

            console.log();
            $("#modalEliminarZona").modal('show');

            return false;


        })
        $(document).on("click", "#btn_eliminar_sector", function(e) {



            $("#id_sector_eliminar").val($("#input_sector_editar").val())
            $("#id_sector_eliminar").data('name', $("#input_sector_editar").find(':selected')
                .text())
            $("#modalEliminarSector").modal('show');

            return false;


        })
        $(document).on("click", "#btn_eliminar_fase", function(e) {



            $("#id_fase_eliminar").val($("#input_fase_editar").val())
            $("#id_fase_eliminar").data('name', $("#input_fase_editar").find(':selected').text())
            $("#modalEliminarFase").modal('show');

            return false;


        })
        $('#form_eliminar_zona').submit(function(event) {
            event.preventDefault();
            console.log(event.target);


            $.ajax({
                type: 'POST',
                url: './crear_subvenciones',
                data: $(this).serialize(),
                cache: false,
                success: function(result) {
                    console.log(result);
                    $('#modalEliminarZona').modal('hide');
                    $.toast({
                        heading: 'Zona ' + $("#id_zona_eliminar").data('name') +
                            ' eliminada',
                        text: 'Se ha eliminado la zona ' + $(
                            "#id_zona_eliminar").data(
                            'name') + ' correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    updateSelectZona()

                }
            });

            return false;
        });
        $('#form_eliminar_sector').submit(function(event) {
            event.preventDefault();



            $.ajax({
                type: 'POST',
                url: './crear_subvenciones',
                data: $(this).serialize(),
                cache: false,
                success: function(result) {
                    console.log(result);
                    $('#modalEliminarSector').modal('hide');
                    $.toast({
                        heading: 'Sector ' + $("#id_sector_eliminar").data(
                                'name') +
                            ' eliminado',
                        text: 'Se ha eliminado el sector ' + $(
                            "#id_sector_eliminar").data(
                            'name') + ' correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    updateSelectSector()

                }
            });

            return false;
        });
        $('#form_eliminar_fase').submit(function(event) {
            event.preventDefault();



            $.ajax({
                type: 'POST',
                url: './crear_subvenciones',
                data: $(this).serialize(),
                cache: false,
                success: function(result) {
                    console.log(result);
                    $('#modalEliminarFase').modal('hide');
                    $.toast({
                        heading: 'Fase ' + $("#id_fase_eliminar").data('name') +
                            ' eliminada',
                        text: 'Se ha eliminado la fase ' + $(
                            "#id_fase_eliminar").data(
                            'name') + ' correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    updateSelectFase()

                }
            });

            return false;
        });

        $("#tipo_enlace_editar").change(function() {
            $.ajax({
                url: "./api/subvenciones.php?id_subvencion=" + $("#id_subvencion_editar")
                    .val(),
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                success: function(res) {

                    var nombre = $("#input_nombre_editar").val()
                    var url_generico_subvencion = res.url_generico
                    var url_autonomo_subvencion = res.url_autonomo
                    var url_sociedad_subvencion = res.url_sociedad
                    var cuerpo = $(tinymce.get('mymce_editar').getBody()).html()
                    var tipo_enlace = $("#tipo_enlace_editar").val()

                    cuerpo = cuerpo.replace(/%nombre%/g, nombre);
                    if (tipo_enlace == "generico") {
                        cuerpo = cuerpo.replace(/%url%/g,
                            url_generico_subvencion);
                        cuerpo = cuerpo.replace(url_autonomo_subvencion,
                            url_generico_subvencion);
                        cuerpo = cuerpo.replace(url_sociedad_subvencion,
                            url_generico_subvencion);
                    }
                    if (tipo_enlace == "autonomo") {
                        cuerpo = cuerpo.replace(/%url%/g,
                            url_autonomo_subvencion);
                        cuerpo = cuerpo.replace(url_generico_subvencion,
                            url_autonomo_subvencion);
                        cuerpo = cuerpo.replace(url_sociedad_subvencion,
                            url_autonomo_subvencion);
                    }
                    if (tipo_enlace == "sociedad") {
                        cuerpo = cuerpo.replace(/%url%/g,
                            url_sociedad_subvencion);
                        cuerpo = cuerpo.replace(url_autonomo_subvencion,
                            url_sociedad_subvencion);
                        cuerpo = cuerpo.replace(url_generico_subvencion,
                            url_sociedad_subvencion);
                    }


                    $(tinymce.get('mymce_editar').getBody()).html(cuerpo)

                }



            })




        })


        $(document).on("click", ".btn_editar", function(e) {
            var id_cliente_subvencion = $(this).data("idclientesubvencion")
            $("#id_subvencion_editar").val($(this).data("subvencion"))

            $.ajax({
                type: "GET",
                url: "./api/cliente_subvencion.php?id_cliente_subvencion=" +
                    id_cliente_subvencion,
                cache: false,
                async: false,
                success: function(response) {
                    var res = JSON.parse(response)
                    var condiciones = res.condiciones
                    var email = res.email
                    var email_marketing = res.email_marketing
                    var url_portada = res.url_portada
                    var email_marketing = res.email_marketing
                    var id_cliente = res.id_cliente
                    $.ajax({
                        type: "GET",
                        url: "./api/datos_cliente.php?id_cliente_subvencion=" +
                            id_cliente_subvencion,
                        cache: false,
                        async: false,
                        success: function(response2) {

                            var res2 = JSON.parse(response2)
                            var nombre = res2.nombre_comercial
                            var id_datos_cliente = res2.id_datos_cliente
                            var cif = res2.cif
                            var domicilio = res2.domicilio
                            var tipo = res2.tipo
                            var empleados = res2.numero_empleados
                            var cp = res2.cp
                            var titulo = res2.titulo
                            var importe = res2.importe
                            var fase = res2.id_fase
                            var sector = res2.id_sector
                            var zona = res2.id_zona
                            var telefono = res2.telefono
                            var tipo_enlace = res2.tipo_enlace
                            var user_id = res2.user_id
                            $("#titulo_subvencion_editar").val(titulo)
                            $(tinymce.get('mymce_editar').getBody()).html(
                                email_marketing)
                            $("#select_cliente_editar").val(id_cliente)
                            $('#select_cliente_editar').trigger('change');
                            $("#input_cif_editar").val(cif)
                            $("#input_domicilio_editar").val(domicilio)
                            $("#input_cp_editar").val(cp)
                            $("#condiciones_presupuesto_editar").val(
                                condiciones)
                            $("#input_telefono_editar").val(telefono)
                            $("#input_email_editar").val(email)
                            $("#input_nombre_editar").val(nombre)
                            $("#img_logo_portada_editar").attr("src",
                                url_portada)
                            $("#input_mostrar_logo_editar").val(url_portada)
                            $("#tipo_cliente_editar").val(tipo)
                            $("#input_empleados_editar").val(empleados)
                            $("#input_id_datos_cliente").val(
                                id_datos_cliente)
                            $("#input_id_cliente_subvencion").val(
                                id_cliente_subvencion)
                            $("#input_importe_editar").val(importe)
                            $("#tipo_enlace_editar").val(tipo_enlace)
                            $("#input_usuario_editar").val(user_id)
                            $('#input_usuario_editar').trigger('change');
                            if (fase == null) {


                            } else {
                                $("#input_fase_editar").val(fase)
                                $('#input_fase_editar').trigger('change');


                            }
                            if (sector == null) {


                            } else {

                                $("#input_sector_editar").val(sector)
                                $('#input_sector_editar').trigger('change');

                            }
                            if (zona == null) {


                            } else {
                                $("#input_zona_editar").val(zona)
                                $('#input_zona_editar').trigger('change');

                            }


                            $("#modalEditarSubvencion").modal("show")


                        }

                    })



                }

            })







        })



        $("#btn_editar_datos").click(function() {
            var cif = $("#input_cif_editar").val()
            var domicilio = $("#input_domicilio_editar").val()
            var cp = $("#input_cp_editar").val()
            var telefono = $("#input_telefono_editar").val()
            var email = $("#input_email_editar").val()
            var nombre = $("#input_nombre_editar").val()
            var sector = $("#input_sector_editar").val()
            var tipo = $("#tipo_cliente_editar").val()
            var empleados = $("#input_empleados_editar").val()
            var fase = $("#input_fase_editar").val()
            var importe = $("#input_importe_editar").val()
            var enlace = $("#tipo_enlace_editar").val()
            var usuario = $("#input_usuario_editar").val()
            var zona = $("#input_zona_editar").val()
            var id_cliente = $("#select_cliente_editar").val()
            var email_marketing = $(tinymce.get('mymce_editar').getBody()).html()
            var titulo = $("#titulo_subvencion_editar").val()
            var nombre = $("#input_nombre_editar").val()

            var id_datos_cliente = $("#input_id_datos_cliente").val()
            var condiciones = $("#condiciones_presupuesto_editar").val()
            var url_portada = $("#input_mostrar_logo_editar").val()

            var id_cliente_subvencion = $("#input_id_cliente_subvencion").val()

            if (isNaN(parseInt(fase))) {
                fase = "";
            }
            if (isNaN(parseInt(zona))) {
                zona = "";
            }
            if (isNaN(parseInt(sector))) {
                sector = "";
            }


            $.ajax({
                type: 'POST',
                url: './subvenciones_enviadas',
                cache: false,
                data: {

                    id_datos_cliente: id_datos_cliente,
                    cif: cif,
                    cp: cp,
                    telefono: telefono,
                    email: email,
                    nombre_comercial: nombre,
                    id_sector: sector,
                    id_fase: fase,
                    id_zona: zona,
                    tipo: tipo,
                    numero_empleados: empleados,
                    importe: importe,
                    tipo_enlace: enlace,
                    user_id: usuario,
                    domicilio: domicilio,
                    titulo: titulo,
                    id_cliente_subvencion: id_cliente_subvencion,
                    id_cliente: id_cliente,
                    email_marketing: email_marketing,
                    condiciones: condiciones,
                    url_portada: url_portada
                },
                success: function(result) {
                    console.log(result);
                    $('#modalEditarSubvencion').modal('hide');
                    $.toast({
                        heading: 'Subvención editada',
                        text: 'Se ha editado la subvención correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    setTimeout(function() {
                        window.location.reload();

                    }, 2000);


                }
            })

        })


        $("#logo_portada_editar").on("change", function() {

            var fd = new FormData();
            var imagen_portada = $('#logo_portada_editar')[0].files[0];

            fd.append('imagen_portada', imagen_portada);
            console.log(fd);
            $.ajax({
                url: './crear_subvenciones',
                type: 'POST',
                data: fd,
                processData: false, // tell jQuery not to process the data
                contentType: false, // tell jQuery not to set contentType
                success: function(result) {

                    var url = result
                    $("#img_logo_portada_editar").attr('src', url)
                    $("#input_mostrar_logo_editar").val(url)
                    $.toast({
                        heading: 'Nueva imágen subida',
                        text: 'Se subido la nueva imágen correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 4
                    })
                }
            });

        })









    });
})(jQuery);
</script>