<?php
	$TotalSales = 0;
	
	$MostSoldPacket = array(0, 0);

	$TokensTotal = 0;
	$TokensSolds = 0;

	$PacketsTotal = 0;
	$PacketsSolds = 0;

	foreach ($Packets as $Packet) {
		$TotalSales += ($Packet['packet_sales'] * $Packet['packet_price']);
		
		if ($Packet['packet_sales'] > $MostSoldPacket[1]) {
			$MostSoldPacket[0] = $Packet['packet_id'] - 1;
			$MostSoldPacket[1] = $Packet['packet_sales'];
		}
		
		$TokensTotal += ($Packet['packet_limit'] * $Packet['packet_tokens']);
		$TokensSolds += ($Packet['packet_sales'] * $Packet['packet_tokens']);
		
		$PacketsTotal += $Packet['packet_limit'];
		$PacketsSolds += $Packet['packet_sales'];
	}
?>
			<!-- app-content-->
			<div class="app-content page-body">
				<div class="side-app oneup-container">
					<div class="d-block" >
						<ul class="bread">
							<li><a href="./"><?php echo _("Inicio")?></a></li>
							<li>/ <?php echo _("Estado del proyecto")?></li>
						</ul>
					</div>
					<div class="row">
						<!-- Recaudación -->
						<div class="col-md-6" style="margin-bottom:24px">
							<card class="card state-project-main" style="height:100%;">
								<div class="card-header">
								<?php echo _("Recaudación")?>
								</div>
								<div class="card-body"  style="background-image:url('assets/img/estado/img-fondo.jpg');background-size:cover;">
									<div class="row">
										<div class="col-md-12">
											<p class="state-project-main-money">
												<?php echo htmlentities(number_format($TotalSales + '1126800',0, ',', '.'), ENT_QUOTES); ?>€

											</p>
											<p class="state-project-main-total">
											<?php echo _("Total recaudado")?>
											</p>
											<div class="progress h-1 mb-1">
												<div class="progress-bar" style="width: 20%" role="progressbar"></div> 
											</div>
											<!-- <p class="state-project-main-restante mb-5 mb-md-0">
											<?php /*echo _("Tiempo restante")?>: 20 <?php echo _("días")?> 12 <?php echo _("horas")?> 15 <?php echo _("minutos") */?>
											</p> -->
										</div>
									
									</div>

								</div>
							</card>
						</div>
                        	<div class="col-md-3" style="margin-bottom:24px">
								<canvas id="proyecto_recaudado" class="" style="display:none"></canvas>
                                <card class="card state-project-sm state-project-participantes" style="height:100%;min-height:0px;">
									<div class="card-header">
									<?php echo _("Participantes")?>	
									</div>
									<div class="card-body pb-0" >
										<p class="state-project-participantes-number" >
											<i class="fas fa-user"></i> <?php echo htmlentities(number_format($Users_Count, 0, '', '.'), ENT_QUOTES); ?>
										</p>
									</div>
									<div class="px-1">
										<canvas id="proyecto_participantes"></canvas>
									</div>
								</card>
							</div>
                        <div class="col-md-3 pr-md-1" style="margin-bottom:24px">
							<div class="card state-project-sm state-project-participantes" style="height:100%;min-height:0px;">
								<div class="card-header">
								<?php echo _("Packs más vendidos")?>
								</div>
								<div class="card-body pb-0 text-center" >
								<img src="assets/img/estado/<?php echo $MostSoldPacket[0]; ?>.jpg" class="img-fluid">
								</div>
								<div class="padding-bottom-none card-body pb-0 text-center" style="border:none">
									<a href="./" class="btn btn btn-secondary" style="padding:3px 0px;display:block;"><?php echo _("Compra este pack")?></a>
								</div>
                            </div>
										</div>
						<!-- Recaudación -->
					</div>
                    <!-- state-project-row-4 -->
					<div class="row state-project-row-4">
						<!-- OneUPs entregados -->
						<div class="col-lg-12">
							<card class="card state-project-md">
								<div class="card-header" style="border-bottom: 1px solid #dee2e6">
                                    <span><?php echo _("Dispositivos OneUP entregados")?></span>
								</div>
                                <div class="card-header" style="border:none;display:block;">
                                    <small><?php echo _("Unidades OneUP vendidas")?></small>
                                    <div class="state-project-participantes-number " style="display:flex;">
                                        <span>70.000</span> <span style="font-size:9pt;margin-left:6px;margin-top:8px;color:#0bab16;"> (+ 20 <?php echo _("Con respecto al trimestre anterior")?> %)</span>
                                    </div>
                                    <small style="color:#999;"><?php echo _("Última actualización")?>: 20/03/2019</small>
									</div>
								<div class="card-body row pb-0 pb-xl-3" id="contenedor-mapa">
									<div class="col-xl-8 col-lg-8 col-md-12">
										<div class="overflow-hidden">
											<div id="world-map-markers" class="worldh h-300" ></div>
										</div>
                                        <ul class="leyenda-mapa-status mt-6">
                                        <li>  <span class="contenedor-color-asignacion"><span class="color-asignacion" style="background:#eb8e8f"></span></span>
										<p style="color:#eb8e8f">0 - 5%</p></li>
                                            
                                            <li>  <span class="contenedor-color-asignacion"><span class="color-asignacion" style="background:#ba4647"></span></span>
										<p style="color:#ba4647">5 - 10%</p></li>        
                                            <li>  <span class="contenedor-color-asignacion"><span class="color-asignacion" style="background:#cc1719"></span></span>
										<p style="color:#cc1719">10%<?php echo _(" o más")?></p></li>        
                                            
                                        </ul>
									</div>
									<div class="col-xl-4 col-lg-4 col-md-12">
										<div class="table-responsive">
											<p class="state-project-entregados-ventas">
												<?php echo _("Países") ?>
											</p>
                                            <div class="scroll-auto state-project-timeline">
											<table class="table text-nowrap border-0 mb-0 text-center">
											<tbody>
													<tr class="border-bottom">
														<td>
															<img src="assets/images/flags/es.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("ESPAÑA")?></td>
														<td>56%</td>
													</tr>
													<tr class="border-bottom">
														<td>
															<img src="assets/images/flags/us.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("ESTADOS UNIDOS")?></td>
														<td>8%</td>
													</tr>
													<tr class="border-bottom">
														<td>
															<img src="assets/images/flags/fr.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("FRANCIA")?></td>
														<td>7%</td>
													</tr>
													<tr class="border-bottom">
														<td>
															<img src="assets/images/flags/no.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("NORUEGA")?></td>
														<td>4%</td>
													</tr>
													<tr class="border-bottom">
														<td>
															<img src="assets/images/flags/cn.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("CHINA")?></td>
														<td>4%</td>
													</tr>
                                                    <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/jp.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("JAPÓN")?></td>
														<td>4%</td>
													</tr>       
                                                    <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/gr.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("GRECIA")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                     <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/mv.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("MALDIVAS")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                     <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/cy.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("CHIPRE")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                     <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/kw.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("KUWAIT")?></td>
														<td>1%</td>
													</tr>
                                                    
                                                    <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/in.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("INDIA")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                    <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/sa.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("ARABIA SAUDITA")?></td>
														<td>1%</td>
													</tr>
                                                    
                                                     <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/ch.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("SUIZA")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                     <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/ca.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("CANADÁ")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                     <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/germany_flag.jpg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("ALEMANIA")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                     <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/fr.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("REINO UNIDO")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                    <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/it.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("ITALIA")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                    <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/kr.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("KOREA DEL SUR")?></td>
														<td>1%</td>
													</tr> 
                                                    <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/au.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("AUSTRALIA")?></td>
														<td>1%</td>
													</tr> 
                                                    <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/nz.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("NUEVA ZELANDA")?></td>
														<td>1%</td>
													</tr> 
                                                    <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/th.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("THAILANDIA")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                    <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/vn.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("VIETNAM")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                    <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/id.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("INDONESIA")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                     <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/mx.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("MÉXICO")?></td>
														<td>1%</td>
													</tr> 
                                                     <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/fr.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("CROACIA")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                     <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/gr.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("GRECIA")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                     <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/dk.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("DINAMARCA")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                     <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/at.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("AUSTRIA")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                    <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/cl.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("CHILE")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                    
                                                    <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/af.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("AFGANIA")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                    
                                                    <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/ma.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("MARRUECOS")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                    
                                                    <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/ar.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("ARGENTINA")?></td>
														<td>1%</td>
													</tr> 
                                                    
                                                     <tr class="border-bottom">
														<td>
															<img src="assets/images/flags/sn.svg" class="w-5 h-5 text-center mx-auto d-block" alt="">
														</td>
														<td class="text-left"><?php echo _("SENEGAL")?></td>
														<td>1%</td>
													</tr>
												</tbody>
											</table>
                                            </div>
										</div>
									</div>
								</div>
							</card>
						</div>
						<!-- /OneUPs entregados -->
					</div>
					<!-- state-project-row-3 -->
					<div class="row state-project-row-3">
						<!-- Estimación de rendimiento anual por Token OneUP -->
						<!-- /Estimación de rendimiento anual por Token OneUP -->
						<!-- Previsión de ventas anuales de OneUP -->
						<div class="col-lg-6">
							<card class="card state-project-md">
								<div class="card-header">
								<?php echo _("Previsión de ventas anuales de OneUP")?>	
								</div>
								<div class="card-body">
							 <div id="chart-combination" class="chartsh chart-dropshadow"></div>
								</div>
                              
							</card>
                            <script>

                                
                                 (function($) {
    "use strict";

	/*chart-employment*/
	var chart = c3.generate({
			bindto: '#chart-combination', // id of chart wrapper
			data: {
				columns: [
					// each columns data
					['data1', 2018, 2019, 2020, 2021, 2022, 2023, 2024],
					['data2', 0, 323000, 1221000, 5033000, 14660000, 30520000, 58510000],
				
				],
              
				type: 'bar', // default type of chart
				types: {
					'data1': "area-spline",
					'data2': "bar",
					
				},
		groups: [
				[ 'data3']
			],
				colors: {
					data1: '#f7be2d',
					data2: '#1873b7',
					
					
				},
				names: {
					// name of each serie
					'data1': 'Años',
					'data2': 'OneUP',
				
					
				}
			},
			axis: {
				x: {
					type: 'category',
					// name of each category
					categories: ['2018', '2019*', '2020*', '2021*', '2022*', '2023*', '2024*'],
				},
			},
			bar: {
				width: 50
			},
			legend: {
				  show: false, //hide legend
			},
			padding: {
				bottom: 0,
				top: 0
			},
		});
})(jQuery);
</script>
						</div>
                        <div class="col-lg-6">
							<card class="card state-project-md">
								<div class="card-header">
								<?php echo _("Reparto de diviendo por Token OneUP")?>	
								</div>
								<div class="card-body">
							 <div id="top_div" style="width: 100%; height: 100%;"></div>
								</div>
							</card>
						</div>
						<!-- /Previsión de ventas anuales de OneUP -->
					</div>
					<!-- /state-project-row-3 -->
					<!-- state-project-row-5 -->
					<div class="row mb-md-5 state-project-row-5">
						<!-- Asignación de fondos -->
						<!-- /Asignación de fondos -->
                        <div class="col-lg-6">
                            <div class="row">
                            <!-- Tokens disponibles -->
						<div class="col-md-6">
							<card class="card state-project-sm state-project-tokens-disponibles">
								<div class="card-header">
								<?php echo _("Tokens disponibles")?>		
								</div>
								<div class="card-body n-p">	
									<div class="chart-circle chart-circle-md  overflow-hiddene  mt-sm-0 mb-0 text-left" data-value="<?php echo str_replace(',', '.',round(((100 - $this->Status->_Percent($TokensSolds, $TokensTotal)) / 100), 2, PHP_ROUND_HALF_UP));?>" data-thickness="4" data-color="#1873b7" style="width:9rem;height:9rem;"> 
										<div class="chart-circle-value text-center">
											<h3 class="mb-1 font-weight-semibold"><?php echo htmlentities(number_format($TokensTotal - $TokensSolds, 0, '', '.'), ENT_QUOTES); ?></h3>
											<small><?php echo _("Tokens disponibles")?></small>
										</div>
									</div>	
								</div>		
                
							</card>
						</div>
						<!-- Tokens disponibles -->
						<!-- Paquetes disponibles -->
						<div class="col-md-6">
							<card class="card state-project-sm state-project-paquetes-disponibles">
								<div class="card-header">
								<?php echo _("Paquetes disponibles")?>
								</div>
								<div class="card-body n-p">
									<div class="chart-circle chart-circle-md  overflow-hiddene  mt-sm-0 mb-0 text-left" data-value="<?php echo str_replace(',', '.',round(((100 - $this->Status->_Percent($PacketsSolds, $PacketsTotal)) / 100), 2, PHP_ROUND_HALF_UP)); ?>" data-thickness="4" data-color="#0c60a9" style="width:9rem;height:9rem;"> 
										<div class="chart-circle-value text-center">
											<h3 class="mb-1 font-weight-semibold"><?php echo htmlentities(number_format($PacketsTotal - $PacketsSolds, 0, '', '.'), ENT_QUOTES); ?></h3>
											<small><?php echo _("Paquetes disponibles")?></small>
										</div>
									</div>	
								</div>
							</card>
						</div>
						<!-- Paquetes disponibles -->
                        </div>
                        <div class="row">
						<!-- Bonus disponibles -->
						<div class="col-md-12">
							<card class="card  state-project-bonus" style="min-height:133px;">
								<div class="card-header">
								<?php echo _("Bonus disponibles")?>
								</div>
								<div class="card-body pt-xl-2  d-flex justify-content-center pt-md-0 pb-md-0">
									<!-- activos -->
									<div class="row text-center">
										<div class="col-2 px-1">
											<img src="assets/img/estado/bonus05.png" alt="bonus"<?php if ($Packets[0]['packet_sales'] >= $Packets[0]['packet_limit']) { echo ' style="filter: grayscale(1); -moz-filter: grayscale(1); -webkit-filter: grayscale(1); -o-filter: grayscale(1); -ms-filter: grayscale(1);"'; } ?>>	
										</div>
										<div class="col-2 px-1">
											<img src="assets/img/estado/bonus10.png" alt="bonus"<?php if ($Packets[1]['packet_sales'] >= $Packets[1]['packet_limit']) { echo ' style="filter: grayscale(1); -moz-filter: grayscale(1); -webkit-filter: grayscale(1); -o-filter: grayscale(1); -ms-filter: grayscale(1);"'; } ?>>	
										</div>
										<div class="col-2 px-1">
											<img src="assets/img/estado/bonus15.png" alt="bonus"<?php if ($Packets[2]['packet_sales'] >= $Packets[2]['packet_limit']) { echo ' style="filter: grayscale(1); -moz-filter: grayscale(1); -webkit-filter: grayscale(1); -o-filter: grayscale(1); -ms-filter: grayscale(1);"'; } ?>>	
										</div>
										<div class="col-2 px-1">
											<img src="assets/img/estado/bonus20.png" alt="bonus"<?php if ($Packets[3]['packet_sales'] >= $Packets[3]['packet_limit']) { echo ' style="filter: grayscale(1); -moz-filter: grayscale(1); -webkit-filter: grayscale(1); -o-filter: grayscale(1); -ms-filter: grayscale(1);"'; } ?>>	
										</div>
										<div class="col-2 px-1">
											<img src="assets/img/estado/bonus30.png" alt="bonus"<?php if ($Packets[4]['packet_sales'] >= $Packets[4]['packet_limit']) { echo ' style="filter: grayscale(1); -moz-filter: grayscale(1); -webkit-filter: grayscale(1); -o-filter: grayscale(1); -ms-filter: grayscale(1);"'; } ?>>	
										</div>
										<div class="col-2 px-1">
											<img src="assets/img/estado/bonus60.png" alt="bonus"<?php if ($Packets[5]['packet_sales'] >= $Packets[5]['packet_limit']) { echo ' style="filter: grayscale(1); -moz-filter: grayscale(1); -webkit-filter: grayscale(1); -o-filter: grayscale(1); -ms-filter: grayscale(1);"'; } ?>>	
										</div>
									</div>
								</div>
								<!-- /Previsión de ventas anuales de OneUP -->
                            </card>
                        </div>
                    </div>
                </div>
						<!-- Previsión de ventas anuales de OneUP -->
						<div class="col-lg-6">
							<card class="card state-project-md">
								<div class="card-header">
								<?php echo _("Asignación de fondos")?>
								</div>
								<div class="card-body row pb-0 pb-xl-3 content-state-project-asignacion">
									<div class="col-md-6 n-p-l">
										<div id="chart_fondos" class="chartsh donutShadow" style="min-width:170px;z-index:1 !important;"></div>
									</div>
									<div class="col-md-6 text-left state-project-asignacion-text pt-2">
                                        <div class="contenedor-text-asignacion-fondos">
                                            <div id="apoyo-proyecto">
										<span class="contenedor-color-asignacion"><span class="color-asignacion" style="background:rgb(12, 96, 169);"></span></span><p>
											31% <?php echo _("Apoyo proyecto")?>
										</p>
                                            </div>
                                            <div id="desarrollo">
                                        <span class="contenedor-color-asignacion"><span class="color-asignacion" style="background:rgb(35, 133, 196);"></span></span>
										<p>
								            20% <?php echo _("Desarrollo")?>
										</p>
                                            </div>
                                            <div id="marketing">
                                        <span class="contenedor-color-asignacion"><span class="color-asignacion" style="background:rgb(83, 172, 221);"></span></span>
										<p>
											18% <?php echo _("Marketing")?>
										</p>
                                            </div>
                                            <div id="recursos-humanos">
                                         <span class="contenedor-color-asignacion"><span class="color-asignacion" style="background:rgb(204, 23, 25);"></span></span>
										<p>
											16% <?php echo _("Recursos humanos")?>
										</p>
                                            </div>
                                            <div id="reserva">
                                          <span class="contenedor-color-asignacion"><span class="color-asignacion" style="background:rgb(207, 33, 31);"></span></span>
                                        <p>
											5% <?php echo _("Reserva")?>
										</p>
                                            </div>
                                            <div id="humanitario">
                                         <span class="contenedor-color-asignacion"><span class="color-asignacion" style="background:rgb(214, 52, 44);"></span></span>
                                        <p>
											5% <?php echo _("Humanitario")?>
										</p> 
                                            </div>
                                            <div id="legal-juridico">
                                         <span class="contenedor-color-asignacion"><span class="color-asignacion" style="background:rgb(221, 71, 56);"></span></span>
                                        <p>
											5% <?php echo _("Legal jurídico")?>
										</p>
                                            </div>
									</div>
								</div>
                                </div>
							</card>
						</div>
					</div>
					<!-- /state-project-row-5 -->
				</div>
			</div>
			<!-- end app-content-->
			<style>
                .table td{
                padding: 0.7rem 0px !important;
                padding-bottom: 0.7rem !important;
                }
                ul.leyenda-mapa-status li{
                display: inline-block;
                margin-left: 10px;
                }
                ul.leyenda-mapa-status li span, ul.leyenda-mapa-status li p{
                float:left;
                }
                ul.leyenda-mapa-status li p{
                position: relative;
                top: 2px;
                font-size: 12px;

                }
                .contenedor-text-asignacion-fondos{
                width: 200px;
                margin: auto;
                }
                .contenedor-text-asignacion-fondos p{
                margin-bottom: 0px !important;
                padding-bottom: 1em;
                }
                .contenedor-text-asignacion-fondos div:hover > p{
                color:#889BA9;
                }
                .contenedor-color-asignacion{
                width: 16px;
                height: 16px;

                float: left;
                margin-right: 7px;
                margin-top: 3px;
                position: relative;
                }
                .color-asignacion{
                width: 10px;
                height: 10px;
                border-radius: 50%;
                position: absolute;
                left: 50%;
                margin-left: -5px;
                top: 50%;
                margin-top: -5px;
                }
                .state-project-main-money, .state-project-main-total, .state-project-main-restante{
                color:#fff;
                }
                .scroll-auto{
                height: 290px;

                }
                .card-header{
                border:none;
                }
                @media (min-width: 992px){
                .pt-lg-7{
                padding-top: 6rem !important;
                }
                }

                @media (max-width: 767px){

                .padding-bottom-none{
                padding-bottom: 10px !important;
                }
                }
                .chartsh{
                overflow: inherit;
                }

                @media (max-width:1280px){

                .table-responsive{
                padding-bottom:20px;
                }
                }
                .table-responsive table tr td img{
                min-width: 24px;
                }
                @media (max-width:1400px) and (min-width:992px){
                .c3-chart-arc text{
                font-size: 11px !important;
                }
                }
                @media (max-width:1300px) and (min-width:992px){
                .state-project-asignacion-text{
                margin-top: 20px;
                }
                .state-project-asignacion-text p{
                font-size: 12px;
                }
                .content-state-project-asignacion{
                padding: 1.5rem .5rem !important;
                }
                .n-p-l{
                padding-left: 0px !important;
                }
                }
                .n-p{
                padding-top:0.5rem;
                }
                @media (min-width:992px){
                .n-p{
                padding-right: 0px !important;
                padding-left: 0px !important;
                }

                }
                        </style>

<script>
    
    $(document).ready(function(){
     var height = $('#contenedor-mapa').height(); 
        var height = Number(height) - 84;
        $('.state-project-timeline').height(height);
        
    


    });
    
$(function(e){
	'use strict'

	
	/* chartjs (#retention) */
	var proyecto_recaudado = document.getElementById("proyecto_recaudado");
	proyecto_recaudado.height = "110";
	
	var myCanvasContext = proyecto_recaudado.getContext("2d");
	var gradientStroke = myCanvasContext.createLinearGradient(0, 80, 0, 280);
	gradientStroke.addColorStop(0, 'rgba(229, 73, 58, .8)');
	gradientStroke.addColorStop(1, 'rgba(229, 73, 58, 0.01)');
	var myChart_proyecto_recaudado = new Chart( proyecto_recaudado, {
		type: 'line',
		data: {
			labels: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
			type: 'line',
			datasets: [ {
				label: 'Return-On-Assets',
				data: [24, 18, 28, 21, 32, 28,30],
				backgroundColor: gradientStroke,
				borderColor: '#e5493a',
				pointBackgroundColor:'#fff',
				pointHoverBackgroundColor:gradientStroke,
				pointBorderColor :'#e5493a',
				pointHoverBorderColor :gradientStroke,
				pointBorderWidth :0,
				pointRadius :0,
				pointHoverRadius :0,
				lineTension: 0.2,
				borderWidth: 2,
				fill: 'origin'
			}, ]
		},
		options: {
			responsive: true,
			maintainAspectRatio: true,
			tooltips: {
				mode: 'index',
				titleFontSize: 12,
				titleFontColor: '#000',
				bodyFontColor: '#000',
				backgroundColor: '#fff',
				cornerRadius: 3,
				intersect: false,
			},
			stepsize: 200,
			min: 0,
			max: 400,
			legend: {
				display: false,
				labels: {
					usePointStyle: false,
				},
			},
			scales: {
				xAxes: [ {
					gridLines: {
						color: 'transparent',
						zeroLineColor: 'transparent'
					},
					ticks: {
						fontSize: 2,
						fontColor: 'transparent'
					}
				} ],
				yAxes: [ {
					display:false,
					ticks: {
						display: false,
					}
				} ]
			},
			title: {
				display: false,
				text: 'Normal Legend'
			}
		}
	});
	/* chartjs (#retention) closed */



	/* chartjs (#proyecto_participantes) */
	var proyecto_participantes = document.getElementById("proyecto_participantes");
	proyecto_participantes.height = "110";
	
	var myCanvasContext = proyecto_participantes.getContext("2d");
	var gradientStroke = myCanvasContext.createLinearGradient(0, 80, 0, 280);
	gradientStroke.addColorStop(0, 'rgba(40, 151, 212, 1)');
	gradientStroke.addColorStop(1, 'rgba(40, 151, 212, 0.01)');
	var myChart_proyecto_participantes = new Chart( proyecto_participantes, {
		type: 'line',
		data: {
			labels: [<?php foreach ($datas as $data) { echo '"'.$data['Day'].'/'.$data['Month'].'/'.$data['Year'].'", ';} ?>],
			type: 'line',
			datasets: [ {
				label: 'Numero de usuarios',
				data: [<?php foreach ($datas as $data) { echo $data['Total'].', ';} ?>],
				backgroundColor: gradientStroke,
				borderColor: '#2897d4',
				pointBackgroundColor:'#fff',
				pointHoverBackgroundColor:gradientStroke,
				pointBorderColor :'#2897d4',
				pointHoverBorderColor :gradientStroke,
				pointBorderWidth :0,
				pointRadius :0,
				pointHoverRadius :0,
				lineTension: 0.2,
				borderWidth: 2,
				fill: 'origin'
			}, ]
		},
		options: {
			responsive: true,
			maintainAspectRatio: true,
			tooltips: {
				mode: 'index',
				titleFontSize: 12,
				titleFontColor: '#000',
				bodyFontColor: '#000',
				backgroundColor: '#fff',
				cornerRadius: 3,
				intersect: false,
			},
			stepsize: 200,
			min: 0,
			max: 400,
			legend: {
				display: false,
				labels: {
					usePointStyle: false,
				},
			},
			scales: {
				xAxes: [ {
					gridLines: {
						color: 'transparent',
						zeroLineColor: 'transparent'
					},
					ticks: {
						fontSize: 2,
						fontColor: 'transparent'
					}
				} ],
				yAxes: [ {
					display:false,
					ticks: {
						display: false,
					}
				} ]
			},
			title: {
				display: false,
				text: 'Normal Legend'
			}
		}
	});
	/* chartjs (#proyecto_participantes) closed */


	/*  echart_estimacion_tokens */
	var chartdata = [
	{
		name: 'Dividento por token',
		type: 'bar',
		data: [0, 0, 30, 125, 350, 720, 1380]
	},
	{
		name: 'Año',
		type: 'line',
		smooth:true,
		data: [2018, 2019, 2020, 2021, 2022, 2023, 2024]
	},
	{
		/*name: 'growth',*/
		type: 'bar',
		data: [0, 0, 0, 0, 0, 0]
	}
	];

	
	var chart2 = c3.generate({
		bindto: '#chart_fondos', // id of chart wrapper
		data: {
			columns: [
					// each columns data
					['data1', 5],
					['data2', 31],
					['data3', 5],
					['data4', 16],
					['data5', 18],
					['data6', 20],
					['data7', 5],
				],
				type: 'donut', // default type of chart
				colors: {
					'data1': '#cf211f',
					'data2': '#0c60a9',
					'data3': '#d6342c',
					'data4': '#cc1719',
					'data5': '#53acdd',
					'data6': '#2385c4',
					'data7': '#dd4738',
				},
				names: {
					// name of each serie
					'data1': '<?php echo  _("Reserva")?>',
					'data2': '<?php echo  _("Apoyo proyecto")?>',
					'data3': '<?php echo  _("Humanitario")?>',
					'data4': '<?php echo  _("Recursos humanos")?>',
					'data5': '<?php echo  _("Marketing")?>',
					'data6': '<?php echo  _("Desarrollo")?>',
					'data7': '<?php echo  _("Legal/juridico")?>',
				}
			},
			axis: {
			},

			legend: {
			  show: false, //hide legend
			},
			padding: {
				bottom: 0,
				top: 0
			},
		});
	


});
      google.charts.load('current', {'packages':['bar']});
      google.charts.setOnLoadCallback(drawChart);

      function drawChart() {
      var data = google.visualization.arrayToDataTable([
        ['Años', 'OneUP'],
        ['2018', 0],
        ['2019*', 323000],
        ['2020*', 1221000],
        ['2021*', 5033000],
        ['2022*', 14660000],
        ['2023*', 30520000],
        ['2024*', 58510000],
        
      ]);

        var options = {
          width: '100%',
             colors:['#1873b7'],
          legend: { position: 'none' },
  
            
          bar: { groupWidth: "90%" }
        };

        var chart = new google.charts.Bar(document.getElementById('top_x_div'));
        // Convert the Classic options to Material options.
        chart.draw(data, google.charts.Bar.convertOptions(options));
      };  
   
</script>
<script>
 google.charts.load('current', {'packages':['bar']});
      google.charts.setOnLoadCallback(drawChart);

      function drawChart() {
      var data = google.visualization.arrayToDataTable([
        ['Años', 'Dividiendo por token'],
        ['2018', 0],
        ['2019*', 0],
        ['2020*', 30],
        ['2021*', 125],
        ['2022*', 350],
        ['2023*', 720],
        ['2024*', 1380],
        
      ]);

        var options = {
          width: '100%',
             colors:['#cd161c'],
          legend: { position: 'none' },
  
            
          bar: { groupWidth: "90%" }
        };

        var chart = new google.charts.Bar(document.getElementById('top_div'));
        // Convert the Classic options to Material options.
        chart.draw(data, google.charts.Bar.convertOptions(options));
      };


</script>
<script>

    $('#apoyo-proyecto').hover(function(){
      $("g").addClass('c3-defocused');
        $("g.c3-target-data2").removeClass('c3-defocused');
       
    }, function(){
        $("g").removeClass('c3-defocused');

    }); 
    
    $('#desarrollo').hover(function(){
      $("g").addClass('c3-defocused');
        $("g.c3-target-data6").removeClass('c3-defocused');
    }, function(){
        $("g").removeClass('c3-defocused');
    });  
    $('#marketing').hover(function(){
      $("g").addClass('c3-defocused');
        $("g.c3-target-data5").removeClass('c3-defocused');
    }, function(){
        $("g").removeClass('c3-defocused');
    });  
    $('#recursos-humanos').hover(function(){
      $("g").addClass('c3-defocused');
        $("g.c3-target-data4").removeClass('c3-defocused');
    }, function(){
        $("g").removeClass('c3-defocused');
    }); 
    $('#reserva').hover(function(){
      $("g").addClass('c3-defocused');
        $("g.c3-target-data1").removeClass('c3-defocused');
    }, function(){
        $("g").removeClass('c3-defocused');
    }); 
    $('#humanitario').hover(function(){
      $("g").addClass('c3-defocused');
        $("g.c3-target-data3").removeClass('c3-defocused');
    }, function(){
        $("g").removeClass('c3-defocused');
    });  
    $('#legal-juridico').hover(function(){
      $("g").addClass('c3-defocused');
        $("g.c3-target-data7").removeClass('c3-defocused');
    }, function(){
        $("g").removeClass('c3-defocused');
    });
    
    
</script>