<div class="modal fade" id="modalAgregarVenta" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Agregar venta</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="container p-0">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Fecha de venta</label>
                                <input class="form-control w-100" id="fecha_venta" type="date">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Método de pago</label>

                                <div class="form-group">
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_metodo file-upload-browse btn btn-danger"
                                                data-target="id_metodo_venta" type="button">-</button>
                                        </span>
                                        <select id="id_metodo_venta"
                                            class="select_metodos custom-select select2 form-control">

                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarMetodo">+</button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Cliente</label>
                                <div class="form-group">
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_cliente file-upload-browse btn btn-danger"
                                                data-target="client_id_venta" type="button">-</button>
                                        </span>
                                        <select id="client_id_venta"
                                            class="select_clientes custom-select select2 form-control">

                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarCliente">+</button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Vehículo</label>
                                <div class="form-group">
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_vehiculo file-upload-browse btn btn-danger"
                                                data-target="id_vehiculo_venta" type="button">-</button>
                                        </span>
                                        <select id="id_vehiculo_venta"
                                            class="select_vehiculos custom-select select2 form-control">

                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarVehiculo">+</button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Financiera</label>
                                <div class="form-group">
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_financiera file-upload-browse btn btn-danger"
                                                data-target="id_financiera_venta" type="button">-</button>
                                        </span>
                                        <select id="id_financiera_venta"
                                            class="select_financieras custom-select select2 form-control">

                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarFinanciera">+</button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Plazo en meses</label>
                                <input disabled type="number" class="form-control" id="plazo_venta">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer text-right">
                <button id="btn_add_venta" class="btn btn-success btn-fw" type="button">
                    Agregar</button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>
            </div>
            <!-- /modal-body -->
        </div>

    </div>

</div>
<div class="modal fade" id="modalEditarVenta" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Editar venta</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="container p-0">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Fecha de venta</label>
                                <input class="form-control w-100" id="fecha_venta_editar" type="date">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Método de pago</label>

                                <div class="form-group">
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_metodo file-upload-browse btn btn-danger"
                                                data-target="id_metodo_venta_editar" type="button">-</button>
                                        </span>
                                        <select id="id_metodo_venta_editar"
                                            class="select_metodos custom-select select2 form-control">

                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarMetodo">+</button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Cliente</label>
                                <div class="form-group">
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_cliente file-upload-browse btn btn-danger"
                                                data-target="client_id_venta_editar" type="button">-</button>
                                        </span>
                                        <select id="client_id_venta_editar"
                                            class="select_clientes custom-select select2 form-control">

                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarCliente">+</button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Vehículo</label>
                                <div class="form-group">
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_vehiculo file-upload-browse btn btn-danger"
                                                data-target="id_vehiculo_venta_editar" type="button">-</button>
                                        </span>
                                        <select id="id_vehiculo_venta_editar"
                                            class="select_vehiculos custom-select select2 form-control">

                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarVenta">+</button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Financiera</label>
                                <div class="form-group">
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_financiera file-upload-browse btn btn-danger"
                                                data-target="id_financiera_venta_editar" type="button">-</button>
                                        </span>
                                        <select id="id_financiera_venta_editar"
                                            class="select_financieras custom-select select2 form-control">

                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarFinanciera">+</button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Plazo en meses</label>
                                <input disabled type="number" class="form-control" id="plazo_venta_editar">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer text-right">
                <button id="btn_edit_venta" class="btn btn-success btn-fw" type="button">
                    Editar</button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>
            </div>
            <!-- /modal-body -->
        </div>

    </div>

</div>
<div class="modal fade modal-cambiar" id="modalEliminarVenta" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar venta</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar la venta definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_venta_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_venta">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<?php require_once __VIEWS__ . 'selects/clientes.template.php'; ?>

<?php require_once __VIEWS__ . 'selects/vehiculos.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/financieras.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/metodos_pago.template.php'; ?>
<script>
(function($) {

    'use strict';

    $(function() {

        function validarCampos() {
            var fecha_venta = $("#fecha_venta").val();
            var client_id_venta = $("#client_id_venta").val();
            var id_vehiculo_venta = $("#id_vehiculo_venta").val();
            var id_financiera_venta = $("#id_financiera_venta").val();
            var plazo_venta = $("#plazo_venta").val();
            var res = true
            if (fecha_venta == "") {
                $.toast({
                    heading: 'Campo vacío',
                    text: 'El campo Fecha no puede estar vacío.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                res = false
            }
            if (client_id_venta == "No") {
                $.toast({
                    heading: 'Campo vacío',
                    text: 'Debes seleccionar un cliente.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                res = false
            }
            if (id_vehiculo_venta == "No") {
                $.toast({
                    heading: 'Campo vacío',
                    text: 'Debes seleccionar un vehículo.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                res = false
            }
            if (id_financiera_venta != "No") {
                if (plazo_venta == "") {

                    $.toast({
                        heading: 'Campo vacío',
                        text: 'El campo Plazo no puede estar vacío cuando estas seleccionando una financiera.',
                        position: 'top-right',
                        loaderBg: '#ff5c6c',
                        icon: 'error',
                        hideAfter: 5000,
                        stack: 6
                    });
                    res = false
                }
            }

            return res

        }

        function validarCamposEditar() {
            var fecha_venta = $("#fecha_venta_editar").val();
            var client_id_venta = $("#client_id_venta_editar").val();
            var id_vehiculo_venta = $("#id_vehiculo_venta_editar").val();
            var id_financiera_venta = $("#id_financiera_venta_editar").val();
            var plazo_venta = $("#plazo_venta_editar").val();
            var res = true
            if (fecha_venta == "") {
                $.toast({
                    heading: 'Campo vacío',
                    text: 'El campo Fecha no puede estar vacío.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                res = false
            }
            if (client_id_venta == "No") {
                $.toast({
                    heading: 'Campo vacío',
                    text: 'Debes seleccionar un cliente.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                res = false
            }
            if (id_vehiculo_venta == "No") {
                $.toast({
                    heading: 'Campo vacío',
                    text: 'Debes seleccionar un vehículo.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                res = false
            }
            if (id_financiera_venta != "No") {
                if (plazo_venta == "") {

                    $.toast({
                        heading: 'Campo vacío',
                        text: 'El campo Plazo no puede estar vacío cuando estas seleccionando una financiera.',
                        position: 'top-right',
                        loaderBg: '#ff5c6c',
                        icon: 'error',
                        hideAfter: 5000,
                        stack: 6
                    });
                    res = false
                }
            }

            return res

        }
        $("#btn_add_venta").click(function() {

            $("#btn_add_venta").addClass('btn-loading');
            var fecha_venta = $('#fecha_venta').val()
            var id_metodo_venta = $("#id_metodo_venta").val()
            var client_id_venta = $("#client_id_venta").val()
            var id_vehiculo_venta = $("#id_vehiculo_venta").val()
            var id_financiera_venta = $("#id_financiera_venta").val()
            var plazo_venta = $("#plazo_venta").val()

            if (!validarCampos()) {
                $("#btn_add_venta").removeClass('btn-loading');
                return false
            }



            $.ajax({
                type: 'POST',
                url: './api/ventas.php',
                cache: false,
                data: {
                    fecha: fecha_venta,
                    id_metodo: id_metodo_venta,
                    client_id: client_id_venta,
                    id_vehiculo: id_vehiculo_venta,
                    id_financiera: id_financiera_venta,
                    plazo: plazo_venta

                },
                success: function(result) {
                    var r = JSON.parse(result)
                    $('#modalAgregarVenta').modal("hide")


                    $.toast({
                        heading: 'Vehículo agregado.',
                        text: 'Se ha agregado el vehículo correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    $('#tabla_ventas').DataTable().ajax.reload(null, false);
                    $("#btn_add_venta").removeClass('btn-loading');

                }
            });
        })


        $(document).on("click", ".btn_edit_venta", function(e) {
            $("#btn_edit_venta").data("id", $(this).data("id"))

            $.ajax({
                url: "./api/ventas.php?id_venta=" + $(this).data("id"),
                type: 'GET',

                cache: false,
                async: false,
                dataType: "json",
                success: function(res) {
                    console.log(res);
                    var fecha_venta = $('#fecha_venta_editar').val(res.fecha)
                    if (res.id_metodo != null) {
                        $("#id_metodo_venta_editar").val(res.id_metodo).trigger(
                            "change")

                    } else {
                        $("#id_metodo_venta_editar").val("No").trigger("change")
                    }
                    if (res.client_id != null) {
                        $("#client_id_venta_editar").val(res.client_id).trigger(
                            "change")

                    } else {
                        $("#client_id_venta_editar").val("No").trigger("change")
                    }
                    if (res.id_vehiculo != null) {
                        $("#id_vehiculo_venta_editar").val(res.id_vehiculo).trigger(
                            "change")

                    } else {
                        $("#id_vehiculo_venta_editar").val("No").trigger("change")
                    }
                    if (res.id_financiera != null) {

                        $("#plazo_venta_editar").val(res.plazo);
                        $("#id_financiera_venta_editar").val(res.id_financiera).trigger(
                            "change");

                    } else {
                        $("#id_financiera_venta_editar").val("No").trigger("change");
                        $('#plazo_venta_editar').val('');

                    }


                    $("#modalEditarVenta").modal('show');

                }
            });



        })

        $("#btn_edit_venta").click(function() {

            $("#btn_edit_venta").removeClass('btn-loading');
            var fecha_venta = $('#fecha_venta_editar').val()
            var id_metodo_venta = $("#id_metodo_venta_editar").val()
            var client_id_venta = $("#client_id_venta_editar").val()
            var id_vehiculo_venta = $("#id_vehiculo_venta_editar").val()
            var id_financiera_venta = $("#id_financiera_venta_editar").val()
            var plazo_venta = $("#plazo_venta_editar").val()
            var id_venta = $("#btn_edit_venta").data("id")

            if (!validarCamposEditar()) {
                $("#btn_edit_venta").removeClass('btn-loading');
                return false
            }

            $.ajax({
                type: 'POST',
                url: './api/ventas.php',
                cache: false,
                data: {
                    fecha: fecha_venta,
                    id_metodo: id_metodo_venta,
                    client_id: client_id_venta,
                    id_vehiculo: id_vehiculo_venta,
                    id_financiera: id_financiera_venta,
                    plazo: plazo_venta,
                    id_venta: id_venta

                },
                success: function(result) {
                    var r = JSON.parse(result)
                    $('#modalEditarVenta').modal("hide")


                    $.toast({
                        heading: 'Vehículo editado.',
                        text: 'Se ha editado el vehículo correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    $('#tabla_ventas').DataTable().ajax.reload(null, false);
                    $("#btn_edit_venta").removeClass('btn-loading');

                }
            });
        })

        $(document).on("click", ".btn_eliminar_venta", function() {

            var target = $(this).data("target");


            if (typeof target === 'undefined') {
                console.log($(this).data("id"));
                $("#id_venta_eliminar").val($(this).data("id"))
            } else {
                if ($("#" + target).val() == "No") {
                    return false;
                } else {
                    $("#id_venta_eliminar").val($("#" + target).val())
                }
            }

            $("#modalEliminarVenta").modal("show");
        })

        $('#btn_eliminar_venta').click(function(event) {
            var id_venta_eliminar = $("#id_venta_eliminar").val()
            console.log(id_venta_eliminar);
            $.ajax({
                type: 'DELETE',
                url: './api/ventas.php?id=' + id_venta_eliminar,
                cache: false,
                success: function(result) {

                    $('#modalEliminarVenta').modal("hide")
                    $.toast({
                        heading: 'Venta eliminada',
                        text: 'Se ha eliminado la venta correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })

                    $('#tabla_ventas').DataTable().ajax.reload(null, false);
                }
            });
            return false;
        });


        $('#id_financiera_venta').on('change', function() {
            console.log("hol");
            let value = $(this).val();
            console.log(value);
            if (value == "No") {
                $('#plazo_venta').prop('disabled', true);
            } else {
                $('#plazo_venta').prop('disabled', false);
            }
        });

        $('#id_financiera_venta_editar').on('change', function() {
            let value = $(this).val();
            console.log(value);
            if (value == "No") {
                $('#plazo_venta_editar').prop('disabled', true);
            } else {
                $('#plazo_venta_editar').prop('disabled', false);
            }
        });

    });
});
</script>