<div class="modal fade modal-cambiar" id="modalEliminarVehiculo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar vehiculo</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el vehiculo definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_vehiculo_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_vehiculo">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarVehiculo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Agregar vehiculo</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="container p-0">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Exposición</label>
                                <select id="exposicion_vehiculo" class="form-control custom-select text-center">
                                    <option type="text" value="Zona 1">Zona 1</option>
                                    <option type="text" value="Zona 2">Zona 2</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Modelo</label>

                                <div class="form-group">
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_modelo file-upload-browse btn btn-danger"
                                                data-target="id_modelo_vehiculo" type="button">-</button>
                                        </span>
                                        <select id="id_modelo_vehiculo"
                                            class="select_modelos custom-select select2 form-control">

                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarModelo">+</button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Marca</label>
                                <div class="form-group">
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_marca file-upload-browse btn btn-danger"
                                                data-target="id_marca_vehiculo" type="button">-</button>
                                        </span>
                                        <select id="id_marca_vehiculo"
                                            class="select_marcas custom-select select2 form-control">

                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarMarca">+</button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Fecha de matriculación</label>
                                <input class="form-control w-100" id="fecha_matriculacion_vehiculo" type="date">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Próxima ITV</label>
                                <input class="form-control w-100" id="proxima_itv_vehiculo" type="date">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Combustible</label>
                                <div class="form-group">
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_combustible file-upload-browse btn btn-danger"
                                                data-target="id_combustible_vehiculo" type="button">-</button>
                                        </span>
                                        <select id="id_combustible_vehiculo"
                                            class="select_combustibles custom-select select2 form-control">

                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarCombustible">+</button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Kilómetros</label>
                                <input type="number" class="form-control" id="kilometros_vehiculo" step="any">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Matrícula</label>
                                <input type="text" class="form-control" disabled id="matricula_vehiculo">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer text-right">
                <button id="btn_add_vehiculo" class="btn btn-success btn-fw" type="button">
                    Agregar</button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>
            </div>
            <!-- /modal-body -->
        </div>

    </div>

</div>
<div class="modal fade" id="modalEditarVehiculo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Editar vehiculo</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="container p-0">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Exposición</label>
                                <select id="exposicion_vehiculo_editar" class="form-control custom-select text-center">
                                    <option type="text" value="Zona 1">Zona 1</option>
                                    <option type="text" value="Zona 2">Zona 2</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Modelo</label>

                                <div class="form-group">
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_modelo file-upload-browse btn btn-danger"
                                                data-target="id_modelo_vehiculo" type="button">-</button>
                                        </span>
                                        <select id="id_modelo_vehiculo_editar"
                                            class="select_modelos custom-select select2 form-control">

                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarModelo">+</button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Marca</label>
                                <div class="form-group">
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_marca file-upload-browse btn btn-danger"
                                                data-target="id_marca_vehiculo" type="button">-</button>
                                        </span>
                                        <select id="id_marca_vehiculo_editar"
                                            class="select_marcas custom-select select2 form-control">

                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarMarca">+</button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Fecha de matriculación</label>
                                <input class="form-control w-100" id="fecha_matriculacion_vehiculo_editar" type="date">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Próxima ITV</label>
                                <input class="form-control w-100" id="proxima_itv_vehiculo_editar" type="date">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Combustible</label>
                                <div class="form-group">
                                    <div class="input-group">
                                        <span class="input-group-prepend">
                                            <button class="btn_eliminar_combustible file-upload-browse btn btn-danger"
                                                data-target="id_combustible_vehiculo" type="button">-</button>
                                        </span>
                                        <select id="id_combustible_vehiculo_editar"
                                            class="select_combustibles custom-select select2 form-control">

                                        </select>
                                        <span class="input-group-append">
                                            <button class="file-upload-browse btn btn-info" type="button"
                                                data-toggle="modal" data-target="#modalAgregarCombustible">+</button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Kilómetros</label>
                                <input type="number" class="form-control" id="kilometros_vehiculo_editar" step="any">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Matrícula</label>
                                <input type="text" class="form-control" disabled id="matricula_vehiculo_editar">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer text-right">
                <button id="btn_edit_vehiculo" class="btn btn-success btn-fw" type="button">
                    Editar</button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>
            </div>
            <!-- /modal-body -->
        </div>

    </div>

</div>
<?php require_once __VIEWS__ . 'selects/marcas.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/combustibles.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/modelos.template.php'; ?>
<script>
(function($) {
    'use strict';
    $(function() {

        function getData() {
            var r
            $.ajax({
                url: "./api/vehiculos.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                dataType: "json",
                success: function(data) {
                    console.log(data);
                    data = data.map(function(item) {
                        return {
                            id: item.id_vehiculo,
                            text: item.nombre_marca + " " + item.nombre_modelo,
                            selected: false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguno',
                        selected: true
                    });
                    r = data
                }
            });
            return r
        }

        $('.select_vehiculos').select2({
            data: getData()
        }).trigger("change");

        function validarCampos() {

            var fecha_matriculacion_vehiculo = $("#fecha_matriculacion_vehiculo").val();
            var matricula_vehiculo = $("#matricula_vehiculo").val();
            var kilometros_vehiculo = $("#kilometros_vehiculo").val();
            var proxima_itv_vehiculo = $("#proxima_itv_vehiculo").val();
            var res = true

            if (fecha_matriculacion_vehiculo != "") {
                if (matricula_vehiculo == "") {

                    $.toast({
                        heading: 'Campo vacío',
                        text: 'El campo Matrícula no puede estar vacío cuando la Fecha de Matriculación está completa.',
                        position: 'top-right',
                        loaderBg: '#ff5c6c',
                        icon: 'error',
                        hideAfter: 5000,
                        stack: 6
                    });
                    res = false
                }
            }
            if (kilometros_vehiculo == "") {
                $.toast({
                    heading: 'Campo vacío',
                    text: 'El campo Kilómetros no puede estar vacío.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                res = false
            }
            if (proxima_itv_vehiculo == "") {
                $.toast({
                    heading: 'Campo vacío',
                    text: 'El campo Próxima ITV no puede estar vacío.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                res = false
            }
            return res

        }

        function validarCamposEditar() {

            var fecha_matriculacion_vehiculo = $("#fecha_matriculacion_vehiculo_editar").val();
            var matricula_vehiculo = $("#matricula_vehiculo_editar").val();
            var kilometros_vehiculo = $("#kilometros_vehiculo_editar").val();
            var proxima_itv_vehiculo = $("#proxima_itv_vehiculo_editar").val();
            var res = true

            if (fecha_matriculacion_vehiculo != "") {
                if (matricula_vehiculo == "") {

                    $.toast({
                        heading: 'Campo vacío',
                        text: 'El campo Matrícula no puede estar vacío cuando la Fecha de Matriculación está completa.',
                        position: 'top-right',
                        loaderBg: '#ff5c6c',
                        icon: 'error',
                        hideAfter: 5000,
                        stack: 6
                    });
                    res = false
                }
            }
            if (kilometros_vehiculo == "") {
                $.toast({
                    heading: 'Campo vacío',
                    text: 'El campo Kilómetros no puede estar vacío.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                res = false
            }
            if (proxima_itv_vehiculo == "") {
                $.toast({
                    heading: 'Campo vacío',
                    text: 'El campo Próxima ITV no puede estar vacío.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                res = false
            }
            return res

        }
        $("#btn_add_vehiculo").click(function() {
            $("#btn_add_vehiculo").addClass('btn-loading');
            var exposicion_vehiculo = $('#exposicion_vehiculo').val()
            var id_modelo_vehiculo = $("#id_modelo_vehiculo").val()
            var id_marca_vehiculo = $("#id_marca_vehiculo").val()
            var fecha_matriculacion_vehiculo = $("#fecha_matriculacion_vehiculo").val()
            var matricula_vehiculo = ($("#fecha_matriculacion_vehiculo").val() != "") ? $(
                "#matricula_vehiculo").val() : ""
            var proxima_itv_vehiculo = $("#proxima_itv_vehiculo").val()
            var id_combustible_vehiculo = $("#id_combustible_vehiculo").val()
            var kilometros_vehiculo = $("#kilometros_vehiculo").val()

            if (!validarCampos()) {
                $("#btn_add_vehiculo").removeClass('btn-loading');
                return false
            }


            $.ajax({
                type: 'POST',
                url: './api/vehiculos.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    exposicion: exposicion_vehiculo,
                    id_modelo: id_modelo_vehiculo,
                    id_marca: id_marca_vehiculo,
                    fecha_matriculacion: fecha_matriculacion_vehiculo,
                    proxima_itv: proxima_itv_vehiculo,
                    id_combustible: id_combustible_vehiculo,
                    kilometros: kilometros_vehiculo,
                    matricula: matricula_vehiculo
                },
                success: function(r) {
                    console.log(r);
                    if (r.success) {
                        $('#modalAgregarVehiculo').modal("hide")
                        $('.select_vehiculos').empty()
                        $('.select_vehiculos').select2({
                            data: getData()
                        }).trigger("change");
                        $.toast({
                            heading: r.title,
                            text: r.message,
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });
                        $('#modalAgregarVehiculo input').each(function() {
                            $(this).val("")
                        })
                        $("#matricula_vehiculo").prop("disabled", true)
                    } else {

                        $.toast({
                            heading: r.title,
                            text: r.message,
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 5000,
                            stack: 6
                        });
                    }

                    $('#tabla_vehiculos').DataTable().ajax.reload(null, false);
                    $("#btn_add_vehiculo").removeClass('btn-loading');

                }
            });
        })

        $(document).on("click", ".btn_eliminar_vehiculo", function() {

            var target = $(this).data("target");


            if (typeof target === 'undefined') {
                console.log($(this).data("id"));
                $("#id_vehiculo_eliminar").val($(this).data("id"))
            } else {
                if ($("#" + target).val() == "No") {
                    return false;
                } else {
                    $("#id_vehiculo_eliminar").val($("#" + target).val())
                }
            }

            $("#modalEliminarVehiculo").modal("show");
        })

        $('#btn_eliminar_vehiculo').click(function(event) {
            var id_vehiculo_eliminar = $("#id_vehiculo_eliminar").val()
            console.log(id_vehiculo_eliminar);
            $.ajax({
                type: 'DELETE',
                url: './api/vehiculos.php?id=' + id_vehiculo_eliminar,
                cache: false,
                success: function(result) {

                    $('#modalEliminarVehiculo').modal("hide")
                    $.toast({
                        heading: 'Vehiculo eliminado',
                        text: 'Se ha eliminado el vehiculo correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                    $('.select_vehiculos').empty()
                    $('.select_vehiculos').select2({
                        data: getData()
                    }).trigger("change");
                    $('#tabla_vehiculos').DataTable().ajax.reload(null, false);
                }
            });
            return false;
        });
        $("#btn_edit_vehiculo").click(function() {
            $("#btn_edit_vehiculo").addClass('btn-loading');
            var id_vehiculo = $(this).data("id")
            var exposicion_vehiculo = $('#exposicion_vehiculo_editar').val()
            var id_modelo_vehiculo = $("#id_modelo_vehiculo_editar").val()
            var id_marca_vehiculo = $("#id_marca_vehiculo_editar").val()
            var fecha_matriculacion_vehiculo = $("#fecha_matriculacion_vehiculo_editar").val()
            var proxima_itv_vehiculo = $("#proxima_itv_vehiculo_editar").val()
            var id_combustible_vehiculo = $("#id_combustible_vehiculo_editar").val()
            var kilometros_vehiculo = $("#kilometros_vehiculo_editar").val()
            var matricula_vehiculo = ($("#fecha_matriculacion_vehiculo_editar").val() != "") ? $(
                "#matricula_vehiculo_editar").val() : ""
            if (!validarCamposEditar()) {
                $("#btn_edit_vehiculo").removeClass('btn-loading');
                return false
            }
            $.ajax({
                type: 'POST',
                url: './api/vehiculos.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    id_vehiculo: id_vehiculo,
                    exposicion: exposicion_vehiculo,
                    id_modelo: id_modelo_vehiculo,
                    id_marca: id_marca_vehiculo,
                    fecha_matriculacion: fecha_matriculacion_vehiculo,
                    proxima_itv: proxima_itv_vehiculo,
                    id_combustible: id_combustible_vehiculo,
                    kilometros: kilometros_vehiculo,
                    matricula: matricula_vehiculo
                },
                success: function(r) {

                    if (r.success) {
                        $('#modalEditarVehiculo').modal("hide")
                        $('.select_vehiculos').empty()
                        $('.select_vehiculos').select2({
                            data: getData()
                        }).trigger("change");
                        $.toast({
                            heading: "Vehículo editado",
                            text: "Se ha editado el vehículo correctamente.",
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });


                    } else {

                        $.toast({
                            heading: r.title,
                            text: r.message,
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 5000,
                            stack: 6
                        });
                    }

                    $('#tabla_vehiculos').DataTable().ajax.reload(null, false);
                    $("#btn_edit_vehiculo").removeClass('btn-loading');

                }
            });
        })
        $(document).on("click", ".btn_edit_vehiculo", function(e) {
            $("#btn_edit_vehiculo").data("id", $(this).data("id"))

            $.ajax({
                url: "./api/vehiculos.php?id_vehiculo=" + $(this).data("id"),
                type: 'GET',

                cache: false,
                async: false,
                dataType: "json",
                success: function(res) {
                    console.log(res);


                    $('#exposicion_vehiculo_editar').val(res.exposicion)


                    $('#fecha_matriculacion_vehiculo_editar').val(res
                        .fecha_matriculacion)
                    $('#proxima_itv_vehiculo_editar').val(res.proxima_itv)

                    $('#kilometros_vehiculo_editar').val(res.kilometros)
                    if (res.id_modelo != null) {
                        $('#id_modelo_vehiculo_editar').val(res.id_modelo).trigger(
                            "change")

                    } else {
                        $("#id_modelo_vehiculo_editar").val("No")
                    }
                    if (res.id_combustible != null) {
                        $('#id_combustible_vehiculo_editar').val(res.id_combustible)
                            .trigger(
                                "change")

                    } else {
                        $("#id_combustible_vehiculo_editar").val("No")
                    }
                    if (res.id_marca != null) {
                        $("#id_marca_vehiculo_editar").val(res.id_marca).trigger(
                            "change")

                    } else {
                        $("#id_marca_vehiculo_editar").val("No")
                    }

                    if (res.fecha_matriculacion != null) {
                        $("#matricula_vehiculo_editar").val(res.matricula)
                        $("#fecha_matriculacion_editar").val(res.fecha_matriculacion)
                        document.getElementById('matricula_vehiculo_editar').disabled =
                            false
                    } else {
                        document.getElementById('matricula_vehiculo_editar').disabled =
                            true
                        $("#fecha_matriculacion_editar").val("")
                    }


                    $("#modalEditarVehiculo").modal('show');

                }
            });



        })
        document.getElementById('fecha_matriculacion_vehiculo').addEventListener('change', function(e) {
            let input = e.target;
            let value = input.value

            if (value == "") {

                document.getElementById('matricula_vehiculo').disabled = true
            } else {
                document.getElementById('matricula_vehiculo').disabled = false
            }


        });
        document.getElementById('matricula_vehiculo').addEventListener('input', function(e) {
            let input = e.target;
            let value = input.value.toUpperCase().replace(/[^A-Z0-9]/g, '');

            if (value.length > 3 && value.length <= 7) {
                value = value.slice(0, 3) + '-' + value.slice(3);
            }

            input.value = value;
        });
        document.getElementById('fecha_matriculacion_vehiculo_editar').addEventListener('change', function(
            e) {
            let input = e.target;
            let value = input.value

            if (value == "") {

                document.getElementById('matricula_vehiculo_editar').disabled = true
            } else {
                document.getElementById('matricula_vehiculo_editar').disabled = false
            }


        });
        document.getElementById('matricula_vehiculo_editar').addEventListener('input', function(e) {
            let input = e.target;
            let value = input.value.toUpperCase().replace(/[^A-Z0-9]/g, '');

            if (value.length > 3 && value.length <= 7) {
                value = value.slice(0, 3) + '-' + value.slice(3);
            }

            input.value = value;
        });
    });
})(jQuery);
</script>