<div class="modal fade modal-cambiar" id="modalEliminarUbicacion" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar ubicacion</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar la ubicacion definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_ubicacion_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_ubicacion">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarUbicacion" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar ubicación</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">
                            <input class="form-control w-100" id="nombre_ubicacion" type="text">
                        </div>

                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_ubicacion" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
(function($) {
    'use strict';
    $(function() {
        function getData(id_ubicacion) {
            console.log(id_ubicacion);
            var r
            $.ajax({
                url: "./api/ubicaciones.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,

                success: function(data) {

                    data = data.map(function(item) {
                        return {
                            id: item.id_ubicacion,
                            text: item.nombre,
                            selected: (item.id_ubicacion == id_ubicacion) ? true : false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguna',
                        selected: (id_ubicacion == "No") ? true : false
                    });

                    r = data
                }
            });
            return r
        }
        $('.select_ubicaciones').select2({
            data: getData("No")
        }).trigger("change");
        $("#btn_add_ubicacion").click(function() {
            var nombre_ubicacion = $('#nombre_ubicacion').val()
            $.ajax({
                type: 'POST',
                url: './api/ubicaciones.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    nombre: nombre_ubicacion,
                },
                success: function(r) {


                    $('#modalAgregarUbicacion').modal("hide")
                    $('.select_ubicaciones').empty()
                    $('.select_ubicaciones').select2({
                        data: getData(r.id)
                    }).trigger("change");
                    $.toast({
                        heading: 'Ubicación agregada.',
                        text: 'Se ha agregado la ubicación correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });

                    $("#btn_add_ubicacion").removeClass('btn-loading');

                }
            });
        })
        $(document).on("click", ".btn_eliminar_ubicacion", function() {
            var target = $(this).data("target");
            if ($("#" + target).val() == "No") {
                return false;
            } else {

                $("#id_ubicacion_eliminar").val($("#" + target).val())
            }

            $("#modalEliminarUbicacion").modal("show");
        })
        $('#btn_eliminar_ubicacion').click(function(event) {
            var id_ubicacion_eliminar = $("#id_ubicacion_eliminar").val()
            $.ajax({
                type: 'DELETE',
                url: './api/ubicaciones.php?id=' + id_ubicacion_eliminar,
                cache: false,
                async: false,
                success: function(result) {
                    $('.select_ubicaciones').empty()
                    $('.select_ubicaciones').select2({
                        data: getData("No")
                    }).trigger("change");
                    $('#modalEliminarUbicacion').modal("hide")
                    $.toast({
                        heading: 'Ubicacion eliminada',
                        text: 'Se ha eliminado la ubicación correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                }
            });

        });
    });
})(jQuery);
</script>