<div class="modal fade modal-cambiar" id="modalEliminarTransportista" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar transportista</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el transportista definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_transportista_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_transportista">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarTransportista" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Transportista</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">


                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Nombre</label>
                                <input class="form-control w-100" id="nombre_transportista" type="text">
                            </div>

                        </div>

                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">DNI</label>
                                <input class="form-control w-100" id="dni_transportista" type="text">
                            </div>

                        </div>

                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_transportista" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade modal-cambiar" id="modalVisualizarPedidos" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Pedido</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="row">
                    <div class="col-md-4">
                        <div class="row">
                            <div class="col-12">
                                <p>ID: <span id="vista_id_transportista"></span></p>

                                <hr class="mb-0 mt-2">
                            </div>

                            <div class="col-12">
                                <img id="vista_imagen_transportista"
                                    style="border-radius: .3rem;aspect-ratio:2/1;object-fit:cover;" class="img-fluid"
                                    src="./assets/images/clientes/user-default.png" alt="">
                            </div>

                            <div class="col-12">
                                <hr class="mt-0 mb-2">
                            </div>


                            <div class="col-12">
                                <div id="accordion">
                                    <h5 class="" data-toggle="collapse" data-target="#info" aria-expanded="true"
                                        aria-controls="collapseOne"">Información General<i class=" ml-1 fas
                                        fa-arrow-down">
                                        </i></h5>
                                    <div id="info" class="collapse show" aria-labelledby="headingOne"
                                        data-parent="#accordion">


                                    </div>

                                </div>


                            </div>

                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="row">
                            <div class="col-12">
                                <ul class="nav nav-tabs" role="tablist">
                                    <li class="nav-item"> <a class="active show flex-column align-items-center nav-link"
                                            data-toggle="tab" href="#pedidos" role="tab"><span class="hidden-sm-up">
                                                <lord-icon class="sidebar-menu-icon"
                                                    src="https://cdn.lordicon.com/nocovwne.json" trigger="hover"
                                                    colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                                                    style="width:40px;height:40px">
                                                </lord-icon>
                                            </span> <span class="hidden-xs-down">Pedidos</span></a> </li>


                                    <li class="nav-item"> <a class="flex-column align-items-center nav-link"
                                            data-toggle="tab" href="#observaciones" role="tab"><span
                                                class="hidden-sm-up">
                                                <lord-icon class="sidebar-menu-icon"
                                                    src="https://cdn.lordicon.com/oilwhjud.json" trigger="hover"
                                                    colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                                                    style="width:40px;height:40px">
                                                </lord-icon>
                                            </span> <span class="hidden-xs-down">Observaciones</span></a> </li>
                                </ul>
                                <div class="tab-content tabcontent-border p-3">
                                    <div class="tab-pane active show" id="pedidos" role="tabpanel">
                                        <div class="row">
                                            <div class="col-12">
                                                <table id="tabla_pedidos_transportista" cellspacing="0"
                                                    class="tabla_pedidos_transportista table display nowrap">

                                                    <thead>

                                                        <tr>

                                                            <th
                                                                style="padding-left: 32px !important;padding-right: 50px !important;">
                                                                ID</th>

                                                            <th>Imágen</th>

                                                            <th>Número</th>



                                                            <th style="text-align:center;">Acciones</th>

                                                        </tr>

                                                    </thead>

                                                    <tbody>



                                                    </tbody>

                                                </table>


                                            </div>
                                        </div>
                                    </div>

                                    <div class="tab-pane" id="observaciones" role="tabpanel">
                                        <div class="row">
                                            <div class="col-12">
                                                <table id="tabla_observaciones_transportista" cellspacing="0"
                                                    class="tabla_observaciones_transportista table display nowrap">

                                                    <thead>

                                                        <tr>

                                                            <th
                                                                style="padding-left: 32px !important;padding-right: 50px !important;">
                                                                ID</th>

                                                            <th>Imágen</th>

                                                            <th>Observación</th>



                                                            <th style="text-align:center;">Acciones</th>

                                                        </tr>

                                                    </thead>

                                                    <tbody>



                                                    </tbody>

                                                </table>



                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>


                </div>
            </div>


            <div class="modal-footer text-right">


                <button class="btn btn-danger" data-dismiss="modal" aria-label="Close">Cerrar</button>

            </div>

        </div>

    </div>

</div>
<script>
(function($) {
    'use strict';
    $(function() {

        function getData() {
            var r
            $.ajax({
                url: "./api/transportistas.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                dataType: "json",
                success: function(data) {
                    data = data.map(function(item) {
                        return {
                            id: item.id_transportista,
                            text: item.nombre,
                            selected: false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguno',
                        selected: true
                    });
                    r = data
                }
            });
            return r
        }

        $('.select_transportistas').select2({
            data: getData()
        }).trigger("change");
        $("#btn_add_transportista").click(function() {
            var nombre_transportista = $('#nombre_transportista').val()

            var dni_transportista = $('#dni_transportista').val()

            $.ajax({
                type: 'POST',
                url: './api/transportistas.php',
                cache: false,
                data: {
                    nombre: nombre_transportista,
                    dni: dni_transportista

                },
                success: function(result) {
                    var r = JSON.parse(result)
                    $('#modalAgregarTransportista').modal("hide")
                    $('.select_transportistas').empty()
                    $('.select_transportistas').select2({
                        data: getData()
                    }).trigger("change");
                    $.toast({
                        heading: 'Transportista agregado.',
                        text: 'Se ha agregado el transportista correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    $('#tabla_transportistas').DataTable().ajax.reload(null, false);
                    $("#btn_add_transportista").removeClass('btn-loading');

                }
            });
        })

        $(document).on("click", ".btn_eliminar_transportista", function() {

            var target = $(this).data("target");


            if (typeof target === 'undefined') {
                console.log($(this).data("id"));
                $("#id_transportista_eliminar").val($(this).data("id"))
            } else {
                if ($("#" + target).val() == "No") {
                    return false;
                } else {
                    $("#id_transportista_eliminar").val($("#" + target).val())
                }
            }

            $("#modalEliminarTransportista").modal("show");
        })

        $('#btn_eliminar_transportista').click(function(event) {
            var id_transportista_eliminar = $("#id_transportista_eliminar").val()
            console.log(id_transportista_eliminar);
            $.ajax({
                type: 'DELETE',
                url: './api/transportistas.php?id=' + id_transportista_eliminar,
                cache: false,
                success: function(result) {

                    $('#modalEliminarTransportista').modal("hide")
                    $.toast({
                        heading: 'Transportista eliminado',
                        text: 'Se ha eliminado el transportista correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                    $('.select_transportistas').empty()
                    $('.select_transportistas').select2({
                        data: getData()
                    }).trigger("change");
                    $('#tabla_transportistas').DataTable().ajax.reload(null, false);
                }
            });
            return false;
        });
        $("#btn_edit_transportista").click(function() {
            var nombre_transportista = $('#nombre_transportista_editar').val()
            var id_transportista = $(this).data("id")
            var swift_transportista = $("#swift_transportista_editar").val()
            var direccion_transportista = $("#direccion_transportista_editar").val()
            var iban_transportista = $("#iban_transportista_editar").val()
            var beneficiario_transportista = $("#beneficiario_transportista_editar").val()
            var divisa_transportista = $("#divisa_transportista_editar").val()

            $.ajax({
                type: 'POST',
                url: './api/transportistas.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    id_transportista: id_transportista,
                    nombre: nombre_transportista,
                    swift: swift_transportista,
                    direccion: direccion_transportista,
                    iban: iban_transportista,
                    beneficiario: beneficiario_transportista,
                    divisa: divisa_transportista
                },
                success: function(r) {

                    $('#modalEditarTransportista').modal("hide")
                    $('.select_transportistas').empty()
                    $('.select_transportistas').select2({
                        data: getData()
                    }).trigger("change");
                    $.toast({
                        heading: 'Transportista editado.',
                        text: 'Se ha editado el transportista correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    $('#tabla_transportistas').DataTable().ajax.reload(null, false);
                    $("#btn_edit_transportista").removeClass('btn-loading');

                }
            });
        })

        $('.tabla_observaciones_transportista').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "aLengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_",
                infoEmpty: "Mostrando 0 a 0 de 0",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                // loadingRecords: "Cargando...",

                processing: "Cargando...",
                loadingRecords: "",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "stateSave": true,
            "stateSaveCallback": function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(
                    data))
            },
            "stateLoadCallback": function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [


            ],
            "searching": true,
            "ajax": {
                url: '/api/transportistas.php?id_transportista_observacion=No', // Ruta que devuelve los datos de los transportistas
                method: 'GET',
                dataSrc: function(data) {
                    console.log(data);

                    return data

                } // La propiedad que contiene los datos en la respuesta del servidor
            },

            "initComplete": function() {
                // Renderizar la tabla una vez que los datos se hayan cargado

                //$('#tabla_transportistas_aceptados').show();
            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": false,
            "columns": [{
                    "data": "id_observacion",
                    "render": function(data, type, row, meta) {
                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +
                            data + '</span>';
                    }
                },
                {
                    "data": "id_observacion",
                    "render": function(data, type, row, meta) {
                        return '<img src="./observaciones/' + data +
                            '.png" alt="Imagen del cliente">';
                    }
                },
                {
                    "data": "observacion"
                },
                {
                    "data": null,
                    "render": function(data, type, row) {
                        var td = document.createElement('td');
                        td.className = 'table-dropdown';
                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');
                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');
                        link.className = 'dropdown-toggle d-flex align-items-center';
                        link.id = 'UserDropdown';
                        link.href = '#';
                        link.setAttribute('data-toggle', 'dropdown');
                        link.setAttribute('aria-expanded', 'false');
                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');
                        dropdownMenu.className =
                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';
                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');


                        var buttonEliminar = document.createElement('button');
                        buttonEliminar.className =
                            'btn_eliminar_observacion p-1 dropdown-item';
                        buttonEliminar.setAttribute('type', 'button');
                        buttonEliminar.setAttribute('data-id', data.id_observacion)
                        buttonEliminar.innerHTML = `
                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Eliminar
                `;
                        var buttonVerFoto = document.createElement('button');
                        buttonVerFoto.className =
                            'btn_seleccionar_archivo p-1 dropdown-item';
                        buttonVerFoto.setAttribute('type', 'button');
                        buttonVerFoto.setAttribute('data-id', data.id_observacion)
                        buttonVerFoto.innerHTML = `
                    <lord-icon src="./assets/lordicons/photo.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Ver imágen
                `;
                        dropdownMenu.appendChild(buttonVerFoto);
                        dropdownMenu.appendChild(buttonEliminar);
                        divDropdown.appendChild(link);
                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;
                    }
                }
            ]


        });
        $('.tabla_pedidos_transportista').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "aLengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_",
                infoEmpty: "Mostrando 0 a 0 de 0",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                // loadingRecords: "Cargando...",

                processing: "Cargando...",
                loadingRecords: "",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "stateSave": true,
            "stateSaveCallback": function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(
                    data))
            },
            "stateLoadCallback": function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [


            ],
            "searching": true,
            "ajax": {
                url: '/api/transportistas.php?id_transportista_pedido=No', // Ruta que devuelve los datos de los transportistas
                method: 'GET',
                dataSrc: function(data) {
                    console.log(data);

                    return data

                } // La propiedad que contiene los datos en la respuesta del servidor
            },

            "initComplete": function() {
                // Renderizar la tabla una vez que los datos se hayan cargado

                //$('#tabla_transportistas_aceptados').show();
            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": false,
            "columns": [{
                    "data": "id_pedido",
                    "render": function(data, type, row, meta) {
                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +
                            data + '</span>';
                    }
                },
                {
                    "data": "id_pedido",
                    "render": function(data, type, row, meta) {
                        return '<img src="./imagenes/pedidos/' + data +
                            '/perfil.png' + "?timestamp=" + new Date().getTime() +
                            '" alt="Imágen del pedido">';
                    }
                },
                {
                    "data": "numero"
                },
                {
                    "data": null,
                    "render": function(data, type, row) {
                        var td = document.createElement('td');
                        td.className = 'table-dropdown';
                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');
                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');
                        link.className = 'dropdown-toggle d-flex align-items-center';
                        link.id = 'UserDropdown';
                        link.href = '#';
                        link.setAttribute('data-toggle', 'dropdown');
                        link.setAttribute('aria-expanded', 'false');
                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');
                        dropdownMenu.className =
                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';
                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');


                        var buttonEliminar = document.createElement('button');
                        buttonEliminar.className =
                            'btn_eliminar_pedido p-1 dropdown-item';
                        buttonEliminar.setAttribute('type', 'button');
                        buttonEliminar.setAttribute('data-id', data.id_pedido)
                        buttonEliminar.innerHTML = `
                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Eliminar
                `;
                        var buttonFirmar = document.createElement('button');
                        buttonFirmar.className =
                            'btn_firmar p-1 dropdown-item';
                        buttonFirmar.setAttribute('type', 'button');
                        buttonFirmar.setAttribute('data-id', data.id_pedido)
                        buttonFirmar.setAttribute('data-firma', data.id_firma)
                        var texto = (data.id_firma != null) ? "Ver firma" : "Firmar"
                        buttonFirmar.innerHTML = `
                    <lord-icon src="./assets/lordicons/sign.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    ${texto}`;
                        dropdownMenu.appendChild(buttonFirmar);
                        dropdownMenu.appendChild(buttonEliminar);
                        divDropdown.appendChild(link);
                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;
                    }
                }
            ]


        });

        $(document).on("click", ".btn_ver_pedidos", function(event) {
            var id = $(this).data("id")
            VerInfo(id)


        })

        function VerInfo(id) {
            $.ajax({
                url: './api/transportistas.php?id_transportista=' + id,
                type: 'GET',
                cache: false,
                dataType: 'json', // added data type
                success: function(r) {
                    console.log(r);
                    var result = r
                    /*  if (result.telefono != null) {

                          var telefono = result.telefono.split(" ")[1]
                          var completo = result.telefono.replace(' ', '');



                          $("#vista_telefono").text(telefono)

                      }*/

                    //$("#vista_id_pedido").text(result.numero)
                    /*  $("#vista_imagen_pedido").attr("src", './imagenes/pedidos/' +
                          result.id_pedido +
                          '/perfil.png' + '?timestamp=' + new Date().getTime());*/
                    // $("#vista_numero").text(result.numero)
                    //$("#vista_nombre").text(result.nombre)
                    // $("#vista_domicilio").text(result.domicilio)
                    // $("#vista_dni").text(result.dni)
                    //  $("#vista_bultos").text(result.bultos)
                    // $("#vista_palets").text(result.palets)





                    $('.tabla_observaciones_transportista').DataTable().settings()[0].ajax
                        .data =
                        function(data) {
                            data.id_transportista_observacion =
                                result.id_transportista; // Establece el valor de fecha_i

                        };

                    $('.tabla_observaciones_transportista').DataTable().ajax.reload();
                    $('.tabla_pedidos_transportista').DataTable().settings()[0].ajax
                        .data =
                        function(data) {
                            data.id_transportista_pedido =
                                result.id_transportista; // Establece el valor de fecha_i

                        };

                    $('.tabla_pedidos_transportista').DataTable().ajax.reload();
                    $("#modalVisualizarPedidos").modal("show")
                }
            });

        }
    });
})(jQuery);
</script>