<div class="modal fade modal-cambiar" id="modalEliminarSubcategoria" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar subcategoria</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar la subcategoria definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_subcategoria_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_subcategoria">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarSubcategoria" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Subcategoria</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">
                            <input class="form-control w-100" id="nombre_subcategoria" type="text">
                        </div>

                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_subcategoria" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
(function($) {
    'use strict';
    $(function() {
        function getData(id_subcategoria) {
            console.log(id_subcategoria);
            var r
            $.ajax({
                url: "./api/subcategorias.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,

                success: function(data) {

                    data = data.map(function(item) {
                        return {
                            id: item.id_subcategoria,
                            text: item.nombre,
                            selected: (item.id_subcategoria == id_subcategoria) ? true :
                                false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguna',
                        selected: (id_subcategoria == "No") ? true : false
                    });

                    r = data
                }
            });
            return r
        }
        $('.select_subcategorias').select2({
            data: getData("No")
        }).trigger("change");
        $("#btn_add_subcategoria").click(function() {
            var nombre_subcategoria = $('#nombre_subcategoria').val()
            $.ajax({
                type: 'POST',
                url: './api/subcategorias.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    nombre: nombre_subcategoria,
                },
                success: function(r) {


                    $('#modalAgregarSubcategoria').modal("hide")
                    $('.select_subcategorias').empty()
                    $('.select_subcategorias').select2({
                        data: getData(r.id)
                    }).trigger("change");
                    $.toast({
                        heading: 'Subcategoria agregada.',
                        text: 'Se ha agregado la subcategoria correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    setTimeout(function() {
                        $("#btn_add_subcategoria").removeClass('btn-loading');
                    }, 2000);
                }
            });
        })
        $(document).on("click", ".btn_eliminar_subcategoria", function() {
            var target = $(this).data("target");
            if ($("#" + target).val() == "No") {
                return false;
            } else {


                $("#id_subcategoria_eliminar").val($("#" + target).val())
            }
            $("#modalEliminarSubcategoria").modal("show");
        })
        $('#btn_eliminar_subcategoria').click(function(event) {
            var id_subcategoria_eliminar = $("#id_subcategoria_eliminar").val()
            $.ajax({
                type: 'DELETE',
                url: './api/subcategorias.php?id=' + id_subcategoria_eliminar,
                cache: false,
                async: false,
                success: function(result) {
                    $('.select_subcategorias').empty()
                    $('.select_subcategorias').select2({
                        data: getData("No")
                    }).trigger("change");
                    $('#modalEliminarSubcategoria').modal("hide")
                    $.toast({
                        heading: 'Subcategoria eliminada',
                        text: 'Se ha eliminado la subcategoria correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                }
            });

        });
    });
})(jQuery);
</script>