<div class="modal fade" id="modalAgregarServicio" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">



    <div class="modal-dialog modal-dialog-centered" role="document">



        <div class="modal-content">



            <div class="modal-header border-none">



                <h4 class="mb-0">Agregar Servicio</h4>



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">



                    <i class="ti-close"></i>



                </button>



            </div>







            <div class="modal-body pb-0">



                <div class="container p-0">



                    <div class="row">

                        <div class="col-12">



                            <div class="form-group">



                                <label>Nombre del servicio</label>



                                <input type="text" class="form-control validable" id="nombre_servicio" placeholder="">





                            </div>





                        </div>

                        <div class="col-12">

                            <label class="mb-3">Imágen de cabecera</label>

                        </div>



                        <div class="col-12">

                            <div class="form-group">

                                <label>Foto</label>

                                <div id="imagen_servicio" class="row">

                                    <div style="display: flex;justify-content: center;align-items: center;"
                                        class="col-sm-3 mb-3 mb-sm-0">

                                        <img class="w-100" style="aspect-ratio: 1/1; object-fit:cover"
                                            id="imagen_previa_servicio" src="./assets/images/clientes/user-default.png"
                                            alt="">

                                    </div>

                                    <div class="col-sm-8">

                                        <div class="input-group mb-3">

                                            <input type="text" disabled id="nombre_imagen_servicio" class="form-control"
                                                value="Ninguna">

                                            <input type="file" id="input_imagen_servicio" class="d-none"
                                                accept="image/png">

                                            <div class="input-group-append">

                                                <button id="btn_cargar_imagen_servicio" class=" btn btn-success"
                                                    type="button">+</button>

                                            </div>

                                        </div>

                                        <p class="mb-0">El ratio recomendado para la imagen es 1X1</p>

                                    </div>

                                </div>

                            </div>

                        </div>

                        <div class="col-12">



                            <div class="form-group">



                                <label>Precio</label>



                                <input type="number" class="form-control validable" id="precio_servicio" placeholder=""
                                    required>



                            </div>



                        </div>

                        <div class="col-12">



                            <div class="form-group">



                                <label>Número del servicio</label>



                                <input type="text" class="form-control validable" id="numero_servicio" placeholder=""
                                    required>



                            </div>



                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label for="">Descripción</label>

                                <textarea class="form-control validable" id="descripcion_servicio" cols="30" rows="60"
                                    required></textarea>

                            </div>

                        </div>



                        <div class="col-12">



                            <div class="form-group">



                                <label>Subcategoria</label>

                                <div class="input-group">

                                    <span class="input-group-prepend">

                                        <button class="btn_eliminar_subcategoria file-upload-browse btn btn-danger"
                                            type="button" data-target="subcategoria_servicio"
                                            data-tipo="servicio">-</button>

                                    </span>

                                    <select id="subcategoria_servicio"
                                        class="select_subcategorias form-control custom-select text-center select2"
                                        required>



                                    </select>

                                    <span class="input-group-append">

                                        <button id="" data-toggle="modal" data-target="#modalAgregarSubcategoria"
                                            class="file-upload-browse btn btn-info" type="button">+</button>

                                    </span>

                                </div>

                            </div>



                        </div>



                    </div>



                </div>







            </div>



            <div class="modal-footer pb-3 text-right">







                <button class="btn btn-success btn-fw" id="btn_add_servicio" type="button">



                    Guardar</button>



                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">



                    Cancelar </button>











            </div>





            <!-- /modal-body -->



        </div>



    </div>



</div>





<div class="modal fade" id="modalEditarServicio" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">



    <div class="modal-dialog modal-dialog-centered" role="document">



        <div class="modal-content">



            <div class="modal-header border-none">



                <h4 class="mb-0">Editar Servicio</h4>



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">



                    <i class="ti-close"></i>



                </button>



            </div>







            <div class="modal-body pb-0">



                <div class="container p-0">



                    <div class="row">

                        <div class="col-12">



                            <div class="form-group">



                                <label>Nombre del servicio</label>



                                <input type="text" class="form-control validable" id="nombre_servicio_editar"
                                    placeholder="">





                            </div>





                        </div>

                        <div class="col-12">

                            <label class="mb-3">Imágen de cabecera</label>

                        </div>



                        <div class="col-12">

                            <div class="form-group">

                                <label>Foto</label>

                                <div id="imagen_servicio_editar" class="row">

                                    <div style="display: flex;justify-content: center;align-items: center;"
                                        class="col-sm-3 mb-3 mb-sm-0">

                                        <img class="w-100" style="aspect-ratio: 1/1; object-fit:cover"
                                            id="imagen_previa_servicio_editar"
                                            src="./assets/images/clientes/user-default.png" alt="">

                                    </div>

                                    <div class="col-sm-8">

                                        <div class="input-group mb-3">

                                            <input type="text" disabled id="nombre_imagen_servicio_editar"
                                                class="form-control" value="Ninguna">

                                            <input type="file" id="input_imagen_servicio_editar" class="d-none"
                                                accept="image/png">

                                            <div class="input-group-append">

                                                <button id="btn_cargar_imagen_servicio_editar" class=" btn btn-success"
                                                    type="button">+</button>

                                            </div>

                                        </div>

                                        <p class="mb-0">El ratio recomendado para la imagen es 1X1</p>

                                    </div>

                                </div>

                            </div>

                        </div>

                        <div class="col-12">



                            <div class="form-group">



                                <label>Precio</label>



                                <input type="number" class="form-control validable" id="precio_servicio_editar"
                                    placeholder="" required>



                            </div>



                        </div>


                        <div class="col-12">



                            <div class="form-group">



                                <label>Número del servicio</label>



                                <input type="text" class="form-control validable" id="numero_servicio_editar"
                                    placeholder="" required>



                            </div>



                        </div>
                        <div class="col-12">

                            <div class="form-group">

                                <label for="">Descripción</label>

                                <textarea class="form-control validable" id="descripcion_servicio_editar" cols="30"
                                    rows="60" required></textarea>

                            </div>

                        </div>



                        <div class="col-12">



                            <div class="form-group">



                                <label>Subcategoria</label>

                                <div class="input-group">

                                    <span class="input-group-prepend">

                                        <button class="btn_eliminar_subcategoria file-upload-browse btn btn-danger"
                                            type="button" data-target="subcategoria_servicio_editar"
                                            data-tipo="servicio">-</button>

                                    </span>

                                    <select id="subcategoria_servicio_editar"
                                        class="select_subcategorias form-control custom-select text-center select2"
                                        required>



                                    </select>

                                    <span class="input-group-append">

                                        <button id="" data-toggle="modal" data-target="#modalAgregarSubcategoria"
                                            class="file-upload-browse btn btn-info" type="button">+</button>

                                    </span>

                                </div>

                            </div>



                        </div>



                    </div>



                </div>







            </div>



            <div class="modal-footer pb-3 text-right">







                <button class="btn btn-success btn-fw" id="btn_edit_servicio" type="button">



                    Guardar</button>



                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">



                    Cancelar </button>











            </div>





            <!-- /modal-body -->



        </div>



    </div>



</div>







<div class="modal fade modal-cambiar" id="modalEliminarServicio" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar servicio</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el servicio definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>



            </div>



            <!-- /btn -->



            <div class="modal-footer text-right">







                <button class="btn btn-success btn-fw" id="btn_eliminar_servicio" type="button">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<script>
(function($) {

    'use strict';

    $(function() {


        function getData(id_servicio) {

            console.log(id_servicio);

            var r

            $.ajax({

                url: "./api/productos_y_servicios.php",

                type: 'GET',

                dataType: 'json', // added data type

                cache: false,

                async: false,



                success: function(data) {

               


                    data = data.servicios.map(function(item) {

                        return {

                            id: item.id_servicio,

                            text: item.nombre,

                            selected: (item.id_servicio == id_servicio) ? true : false

                        };

                    })

                    data.push({

                        id: 'No',

                        text: 'Ninguno',

                        selected: (id_servicio == "No") ? true : false

                    });



                    r = data

                }

            });

            return r

        }

        $('.select_servicios').each(function() {

            var $select = $(this);

            if ($select.closest('.modal').length) {



                var $mod = $select.closest('.modal')

                $mod.on('shown.bs.modal', function() {

                    var pri = ($select.data("pri") === undefined)

                    var edit = ($select.data("edit") === undefined) ? "No" : $select.data(

                        "edit")

                    if (pri) {

                        reload($select, edit, $mod)

                    } else {

                        $mod.off('shown.bs.modal'); // Elimina el evento si no es pri

                        $select.data("pri", false)

                    }



                })





            } else {



                reload($select)

            }



        });



        function reload($select, $id = "No", $mod = "No") {

            $select.empty()



            if ($mod == "No") {



                $select.select2({

                    data: getData(($id != "No") ? $id : "No")

                }).trigger("change");



            } else {

                $select.select2({

                    data: getData(($id != "No") ? $id : "No"),

                    dropdownParent: $mod

                }).trigger("change");

            }

        }


        $(document).on("click", ".btn_eliminar_servicio", function() {

            var target = $(this).data("target");

            if ($("#" + target).val() == "No") {

                return false;

            } else {





                $("#btn_eliminar_servicio").data("id", $("#" + target).val())

            }

            $("#modalEliminarServicio").modal("show");

        })








        $("#input_imagen_servicio").change(function() {



            const selectedFile = this.files[0]





            if (selectedFile) {

                const reader = new FileReader();



                reader.onload = function(e) {



                    $("#imagen_previa_servicio").attr("src", e.target.result);

                };



                reader.readAsDataURL(selectedFile);

                $("#nombre_imagen_servicio").val(selectedFile.name)



            }







        })

        $("#input_imagen_servicio_editar").change(function() {



            const selectedFile = this.files[0]





            if (selectedFile) {

                const reader = new FileReader();



                reader.onload = function(e) {



                    $("#imagen_previa_servicio_editar").attr("src", e.target.result);

                };



                reader.readAsDataURL(selectedFile);

                $("#nombre_imagen_servicio_editar").val(selectedFile.name)

                $("#btn_edit_servicio").data("misma", "No")

            }







        })



        $(document).on("click", ".btn_edit_servicio", function(event) {



            $("#btn_edit_servicio").data("id", $(this).data("id"));



            $.ajax({

                url: './api/productos_y_servicios.php?id_servicio=' + $(this).data("id"),

                type: 'GET',

                cache: false,

                async: false,

                dataType: 'json', // added data type

                success: function(r) {

                    var result = r

                    console.log(r);

                    $("#imagen_previa_servicio_editar").attr("src",

                        './imagenes/servicios/' +

                        result.id_servicio +

                        '/perfil.png' + '?timestamp=' + new Date().getTime());

                    $("#btn_edit_servicio").data("misma", "Si")



                    $("#nombre_imagen_servicio_editar").val("Imágen")

                    $("#nombre_servicio_editar").val(result.nombre)

                    $("#precio_servicio_editar").val(result.precio)


                    $("#numero_servicio_editar").val(result.numero)
                    $("#descripcion_servicio_editar").val(result.descripcion)

                    $("#subcategoria_servicio_editar").val((result.id_subcategoria !=

                        null) ? result.id_subcategoria : "No").trigger("change")





                    $('#modalEditarServicio').modal('show')

                }

            });







        })



        $("#btn_edit_servicio").click(function(event) {





            var misma = $("#btn_edit_servicio").data("misma")



            var id_servicio = $(this).data("id")



            var numero = $('#numero_servicio_editar').val();

            var nombre = $('#nombre_servicio_editar').val();

            var imagen = ($('#input_imagen_servicio_editar')[0].files[0]) ? $(

                    '#input_imagen_servicio_editar')[0]

                .files[0] : null;



            var precio = $('#precio_servicio_editar').val()



            var descripcion = $('#descripcion_servicio_editar').val()



            var subcategoria = $('#subcategoria_servicio_editar').val()


            var repetido = false


            // Recorrer todos los inputs .verificable dentro del modal
            document.querySelectorAll('#modalEditarServicio .validable').forEach(
                input => {


                    const evento = new CustomEvent('validar', {
                        bubbles: true,
                        detail: {
                            mensaje: 'Campo requerido'
                        }
                    });

                    // Disparar el evento de validación para cada input
                    input.dispatchEvent(evento);

                    // Si alguno de los inputs no es válido, marcamos todosValidos como falso
                    if (!input.isValid) {
                        repetido = true;
                    }
                });




            if (repetido) {





                return false

            }




            $("#btn_edit_servicio").attr("disabled", true);

            $("#btn_edit_servicio").addClass('btn-loading');









            var fd = new FormData();



            fd.append('nombre_servicio', nombre);

            fd.append('imagen_servicio', imagen);


            fd.append('numero_servicio', numero);
            fd.append('precio_servicio', precio);



            fd.append('descripcion_servicio', descripcion);

            fd.append('id_subcategoria_servicio', subcategoria);

            fd.append('misma', misma);

            fd.append('id_servicio', id_servicio);

            $.ajax({

                type: 'POST',

                url: './api/productos_y_servicios.php',

                cache: false,

                data: fd,

                processData: false, // tell jQuery not to process the data

                contentType: false, // tell jQuery not to set contentType

                success: function(r) {



                    r = JSON.parse(r)
                    console.log(r);

                    if (r.success == false) {
                        $.toast({

                            heading: 'Error',

                            text: r.error,

                            position: 'top-right',

                            loaderBg: "#ff5c6c",

                            icon: "error",

                            hideAfter: 5000,

                            stack: 6

                        });

                    } else {



                        $.toast({

                            heading: 'Servicio editado',

                            text: 'Se ha editado el servicio correctamente',

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 6

                        });
                        $('.tabla_productos').DataTable().ajax.reload(null, false);

                        $('#modalEditarServicio').modal('hide')

                    }

                    $("#btn_edit_servicio").attr("disabled", false);

                    $("#btn_edit_servicio").removeClass('btn-loading');




                }



            });



            return false;



        });





        $("#btn_cargar_imagen_servicio_editar").click(function() {



            console.log("SFDQW");

            $("#input_imagen_servicio_editar").click()

        })

        $("#btn_cargar_imagen_servicio").click(function() {



            console.log("SFDQW");

            $("#input_imagen_servicio").click()

        })









        $("#btn_add_servicio").click(function(event) {





            var numero = $('#numero_servicio').val()

            var nombre = $('#nombre_servicio').val();

            var imagen = ($('#input_imagen_servicio')[0].files[0]) ? $('#input_imagen_servicio')[0]

                .files[0] : null;



            var precio = $('#precio_servicio').val()



            var descripcion = $('#descripcion_servicio').val()



            var subcategoria = $('#subcategoria_servicio').val()



            var repetido = false


            // Recorrer todos los inputs .verificable dentro del modal
            document.querySelectorAll('#modalAgregarServicio .validable').forEach(
                input => {


                    const evento = new CustomEvent('validar', {
                        bubbles: true,
                        detail: {
                            mensaje: 'Campo requerido'
                        }
                    });

                    // Disparar el evento de validación para cada input
                    input.dispatchEvent(evento);

                    // Si alguno de los inputs no es válido, marcamos todosValidos como falso
                    if (!input.isValid) {
                        repetido = true;
                    }
                });




            if (repetido) {





                return false

            }






            $("#btn_add_servicio").attr("disabled", true);

            $("#btn_add_servicio").addClass('btn-loading');









            var fd = new FormData();



            fd.append('nombre_servicio', nombre);
            fd.append('numero_servicio', numero);
            fd.append('imagen_servicio', imagen);



            fd.append('precio_servicio', precio);



            fd.append('descripcion_servicio', descripcion);

            fd.append('id_subcategoria_servicio', subcategoria);

            $.ajax({

                type: 'POST',

                url: './api/productos_y_servicios.php',

                cache: false,

                data: fd,

                processData: false, // tell jQuery not to process the data

                contentType: false, // tell jQuery not to set contentType

                success: function(r) {



                    r = JSON.parse(r)
                    console.log(r);

                    if (r.success == false) {
                        $.toast({

                            heading: 'Error',

                            text: r.error,

                            position: 'top-right',

                            loaderBg: "#ff5c6c",

                            icon: "error",

                            hideAfter: 5000,

                            stack: 6

                        });

                    } else {





                        $.toast({

                            heading: 'Servicio agregado',

                            text: 'Se ha agregado el servicio correctamente',

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 6

                        });

                        $('.tabla_productos').DataTable().ajax.reload(null, false);

                        $('#modalAgregarServicio').modal('hide')

                        $('#modalAgregarServicio input').each(function() {

                            if ($(this).attr("id") != "nombre_imagen") {

                                $(this).val("")

                            } else {

                                $(this).val("Ninguna")

                            }

                        })


                        $('.select_servicios').each(function(params) {

                            reload($(this), r.servicio.id, "No")

                        })

                    }

                    $("#btn_add_servicio").attr("disabled", false);

                    $("#btn_add_servicio").removeClass('btn-loading');









                    $("#imagen_previa").attr("src",

                        './assets/images/clientes/user-default.png');

                }



            });



            return false;

        });










        $('#btn_eliminar_servicio').click(function(event) {



            var id_servicio_eliminar = $("#btn_eliminar_servicio").data("id")





            $.ajax({

                type: 'DELETE',

                url: './api/productos_y_servicios.php?id_servicio=' + id_servicio_eliminar,

                cache: false,

                success: function(result) {



                    $('#modalEliminarServicio').modal('hide');

                    $.toast({

                        heading: 'Servicio eliminado',

                        text: 'Se ha eliminado el servicio correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })


                    $('.select_servicios').each(function(params) {

                        reload($(this))

                    })



                    $('#modalEliminarServicio').modal('hide');



                    $('.tabla_productos').DataTable().ajax.reload(null, false);







                }

            });



            return false;

        });


    });

})(jQuery);
</script>