<div class="modal fade modal-cambiar" id="modalEliminarSector" role="dialog" aria-labelledby="exampleModalCenterTitle">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar sector</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->

                <p class="">¿Estás seguro de que deseas eliminar el sector definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>

            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">

                <input type="hidden" id="id_sector_eliminar">

                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_sector">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade" id="modalAgregarSector" role="dialog" aria-labelledby="exampleModalCenterTitle">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar sector</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">

                            <input class="form-control w-100" id="nombre_sector" type="text">

                        </div>

                    </div>

                </div>

            </div>

            <div class="modal-footer text-right">

                <button id="btn_add_sector" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<script>
(function($) {

    'use strict';

    $(function() {

        function getData(id_sector) {

            console.log(id_sector);

            var r

            $.ajax({

                url: "./api/sectores.php",

                type: 'GET',

                dataType: 'json', // added data type

                cache: false,

                async: false,

                success: function(data) {

                    data = data.map(function(item) {

                        return {

                            id: item.id_sector,

                            text: item.nombre,

                            selected: (item.id_sector == id_sector) ? true : false

                        };

                    })

                    data.push({

                        id: 'No',

                        text: 'Ninguno',

                        selected: (id_sector == "No") ? true : false

                    });

                    r = data

                }

            });

            return r

        }

        $('.select_sectores').each(function() {

            var $select = $(this);

            if ($select.closest('.modal').length) {

                var $mod = $select.closest('.modal')

                $mod.on('shown.bs.modal', function() {

                    var pri = ($select.data("pri") === undefined)

                    var edit = ($select.data("edit") === undefined) ? "No" : $select.data(

                        "edit")

                    if (pri) {

                        reload($select, edit, $mod)

                    } else {

                        $mod.off('shown.bs.modal'); // Elimina el evento si no es pri

                        $select.data("pri", false)

                    }

                })

            } else {

                reload($select)

            }

        });

        function reload($select, $id = "No", $mod = "No") {

            $select.empty()

            if ($mod == "No") {

                $select.select2({

                    data: getData(($id != "No") ? $id : "No")

                }).trigger("change");

            } else {

                $select.select2({

                    data: getData(($id != "No") ? $id : "No"),

                    dropdownParent: $mod

                }).trigger("change");

            }

        }

        $("#btn_add_sector").click(function() {

            var nombre_sector = $('#nombre_sector').val()

            $.ajax({

                type: 'POST',

                url: './api/sectores.php',

                cache: false,

                async: false,

                dataType: "json",

                data: {

                    nombre: nombre_sector,

                },

                success: function(r) {

                    $('#modalAgregarSector').modal("hide")

                    $('.select_sectores').each(function(params) {

                        reload($(this), r.id, "No")

                    })

                    $.toast({

                        heading: 'Sector agregado.',

                        text: 'Se ha agregado el sector correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    });

                    setTimeout(function() {

                        $("#btn_add_sector").removeClass('btn-loading');

                    }, 2000);

                }

            });

        })

        $(document).on("click", ".btn_eliminar_sector", function() {

            var target = $(this).data("target");

            if ($("#" + target).val() == "No") {

                return false;

            } else {

                $("#id_sector_eliminar").val($("#" + target).val())

            }

            $("#modalEliminarSector").modal("show");

        })

        $('#btn_eliminar_sector').click(function(event) {

            var id_sector_eliminar = $("#id_sector_eliminar").val()

            $.ajax({

                type: 'DELETE',

                url: './api/sectores.php?id=' + id_sector_eliminar,

                cache: false,

                async: false,

                success: function(result) {

                    $('.select_sectores').each(function(params) {

                        reload($(this))

                    })

                    $('#modalEliminarSector').modal("hide")

                    $.toast({

                        heading: 'Sector eliminado',

                        text: 'Se ha eliminado el sector correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })

                }

            });

        });

    });

})(jQuery);
</script>