<div class="modal fade modal-cambiar" id="modalEliminarProyecto" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar proyecto</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el proyecto definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_proyecto_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_proyecto">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarProyecto" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Proyecto</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Nombre</label>
                                <input class="form-control w-100" id="nombre_proyecto" type="text">
                            </div>

                        </div>
                        <div class="col-12">

                            <div class="form-group">

                                <label>Color</label>


                                <input id="color_proyecto" type="text" class="colorpicker form-control"
                                    value="#7ab2fa" />
                            </div>



                        </div>

                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Gastos adicionales</label>
                                <input id="gastos_adicionales_proyecto" type="number" class="form-control" step="any">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label>Observaciones</label>
                                <textarea id="observaciones_proyecto" type="text" class="form-control m-0"
                                    style="height: 184px !important;"></textarea>
                            </div>
                        </div>

                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_proyecto" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>

<script>
(function($) {
    'use strict';
    $(function() {

        function getData(id_proyecto = "No") {

            var r;
            $.ajax({
                url: "./api/proyectos.php?proyectos",
                type: 'GET',
                dataType: 'json',
                cache: false,
                async: false,
                success: function(data) {
                    data = data.map(function(item) {
                        return {
                            id: item.id_proyecto,
                            text: item.nombre,
                            selected: false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: (window.location.pathname.split("/").pop() ==
                            "control_de_personal") ? "Todos" : 'Ninguno',
                        selected: true
                    });
                    r = data
                }
            });
            return r;
        }


        $('.select_proyectos').select2({
            data: getData()
        }).trigger("change");
        $("#btn_add_proyecto").click(function() {

            var color = $('#color_proyecto').val()
            var nombre = $("#nombre_proyecto").val()
            var gastos_adicionales = $("#gastos_adicionales_proyecto").val()
            var observaciones = $("#observaciones_proyecto").val()
            var nombre = $("#nombre_proyecto").val()


            $.ajax({
                type: 'POST',
                url: './api/proyectos.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {

                    color: color,
                    nombre: nombre,
                    gastos_adicionales: gastos_adicionales,
                    observaciones: observaciones
                },
                success: function(r) {
                    console.log(r);
                    $('#modalAgregarProyecto').modal("hide")
                    $('.select_proyectos').empty()
                    $('.select_proyectos').select2({
                        data: getData(r.id_proyecto)
                    }).trigger("change");
                    $.toast({
                        heading: 'Proyecto agregado.',
                        text: 'Se ha agregado el proyecto correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    //$('#tabla_proyectos').DataTable().ajax.reload(null, false);
                    $("#btn_add_proyecto").removeClass('btn-loading');

                }
            });
        })

        $(document).on("click", ".btn_eliminar_proyecto", function() {

            var target = $(this).data("target");


            if (typeof target === 'undefined') {
                console.log($(this).data("id"));
                $("#id_proyecto_eliminar").val($(this).data("id"))
            } else {
                if ($("#" + target).val() == "No") {
                    return false;
                } else {
                    $("#id_proyecto_eliminar").val($("#" + target).val())
                }
            }

            $("#modalEliminarProyecto").modal("show");
        })

        $('#btn_eliminar_proyecto').click(function(event) {
            var id_proyecto_eliminar = $("#id_proyecto_eliminar").val()
            console.log(id_proyecto_eliminar);
            $.ajax({
                type: 'DELETE',
                url: './api/proyectos.php?id=' + id_proyecto_eliminar,
                cache: false,
                async: false,
                success: function(result) {

                    $('#modalEliminarProyecto').modal("hide")
                    $.toast({
                        heading: 'Proyecto eliminado',
                        text: 'Se ha eliminado el proyecto correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                    $('.select_proyectos').empty()
                    $('.select_proyectos').select2({
                        data: getData()
                    }).trigger("change");
                    // $('#tabla_proyectos').DataTable().ajax.reload(null, false);
                }
            });
            return false;
        });
        $("#btn_edit_proyecto").click(function() {
            var nombre_proyecto = $('#nombre_proyecto_editar').val()
            var id_proyecto = $(this).data("id")
            var swift_proyecto = $("#swift_proyecto_editar").val()
            var direccion_proyecto = $("#direccion_proyecto_editar").val()
            var iban_proyecto = $("#iban_proyecto_editar").val()
            var beneficiario_proyecto = $("#beneficiario_proyecto_editar").val()
            var divisa_proyecto = $("#divisa_proyecto_editar").val()

            $.ajax({
                type: 'POST',
                url: './api/proyectos.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    id_proyecto: id_proyecto,
                    nombre: nombre_proyecto,
                    swift: swift_proyecto,
                    direccion: direccion_proyecto,
                    iban: iban_proyecto,
                    beneficiario: beneficiario_proyecto,
                    divisa: divisa_proyecto
                },
                success: function(r) {

                    $('#modalEditarProyecto').modal("hide")
                    $('.select_proyectos').empty()
                    $('.select_proyectos').select2({
                        data: getData()
                    }).trigger("change");
                    $.toast({
                        heading: 'Proyecto editado.',
                        text: 'Se ha editado el proyecto correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    //  $('#tabla_proyectos').DataTable().ajax.reload(null, false);
                    $("#btn_edit_proyecto").removeClass('btn-loading');

                }
            });
        })
    });
})(jQuery);
</script>