<div class="modal fade modal-cambiar" id="modalEliminarProveedor" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar proveedor</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el proveedor definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_proveedor_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_proveedor">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarProveedor" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Proveedor</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">


                        <div class="col-12">

                            <div class="form-group">

                                <label>Razón social</label>
                                <input type="text" class="form-control" id="nombre_proveedor" placeholder="" required>
                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Email</label>

                                <input type="text" class="form-control" id="email_proveedor">


                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Télefono</label>

                                <input type="text" class="form-control" id="telefono_proveedor">

                            </div>

                        </div>
                        <div class="col-12">

                            <div class="form-group">

                                <label>Dirección</label>

                                <input type="text" class="form-control" id="direccion_proveedor">


                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>C.P.</label>

                                <input type="text" class="form-control" id="cp_proveedor">


                            </div>

                        </div>
                        <div class="col-12">

                            <div class="form-group">

                                <label>CIF</label>

                                <input type="text" class="form-control" id="cif_proveedor">


                            </div>

                        </div>


                        <div class="col-12">

                            <div class="form-group">
                                <label for="my-input">Forma jurídica</label>
                                <select id="forma_juridica_cliente_editar"
                                    class="custom-select select2 form-control">

                                    <option type="text" value="Autónomo">Autónomo</option>
                                    <option type="text" value="Sociedad limitada">Sociedad limitada</option>
                                    <option type="text" value="Sociedad anónima">Sociedad anónima</option>
                                    <option type="text" value="Sociedad colectiva">Sociedad colectiva</option>
                                    <option type="text" value="Sociedad cooperativa">Sociedad cooperativa
                                    </option>
                                    <option type="text" value="Sociedad comanditaria simple">Sociedad
                                        comanditaria simple
                                    </option>
                                    <option type="text" value="Otro">Otro</option>
                                </select>
                            </div>

                        </div>


                    </div>

                </div>



            </div>
            <div class="modal-footer text-right">



                <button id="btn_add_proveedor" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>


<div class="modal fade" id="modalEditarProveedor" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Editar Proveedor</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">


                        <div class="col-12">
                        <input type="hidden" class="form-control" id="id_proveedor_editar">
                            <div class="form-group">

                                <label>Razón social</label>
                                <input type="text" class="form-control" id="nombre_proveedor_editar" placeholder="" required>
                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Email</label>

                                <input type="text" class="form-control" id="email_proveedor_editar">


                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>Télefono</label>

                                <input type="text" class="form-control" id="telefono_proveedor_editar">

                            </div>

                        </div>
                        <div class="col-12">

                            <div class="form-group">

                                <label>Dirección</label>

                                <input type="text" class="form-control" id="direccion_proveedor_editar">


                            </div>

                        </div>

                        <div class="col-12">

                            <div class="form-group">

                                <label>C.P.</label>

                                <input type="text" class="form-control" id="cp_proveedor_editar">


                            </div>

                        </div>
                        <div class="col-12">

                            <div class="form-group">

                                <label>CIF</label>

                                <input type="text" class="form-control" id="cif_proveedor_editar">


                            </div>

                        </div>


                        <div class="col-12">

                            <div class="form-group">
                                <label for="my-input">Forma jurídica</label>
                                <select id="forma_juridica_cliente_editar_ed"
                                    class="custom-select select2 form-control">

                                    <option type="text" value="Autónomo">Autónomo</option>
                                    <option type="text" value="Sociedad limitada">Sociedad limitada</option>
                                    <option type="text" value="Sociedad anónima">Sociedad anónima</option>
                                    <option type="text" value="Sociedad colectiva">Sociedad colectiva</option>
                                    <option type="text" value="Sociedad cooperativa">Sociedad cooperativa
                                    </option>
                                    <option type="text" value="Sociedad comanditaria simple">Sociedad
                                        comanditaria simple
                                    </option>
                                    <option type="text" value="Otro">Otro</option>
                                </select>
                            </div>

                        </div>


                    </div>

                </div>



            </div>
            <div class="modal-footer text-right">



                <button id="btn_edit_proveedor" class="btn btn-success btn-fw" type="button">

                    Editar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>

<script>
    var proveedores_arr;
    (function($) {
        'use strict';
        $(function() {




            function getData() {
                var r
                $.ajax({
                    url: "./api/proveedores.php",
                    type: 'GET',
                    dataType: 'json', // added data type
                    cache: false,
                    async: false,
                    dataType: "json",
                    success: function(data) {
                        data = data.map(function(item) {
                            return {
                                id: item.id_proveedor,
                                text: item.nombre,
                                tipo: item.tipo,
                                selected: false
                            };
                        })
                        data.push({
                            id: 'No',
                            text: 'Ninguno',
                            selected: true
                        });
                        r = data

                        proveedores_arr = data;
                    }
                });
                return r
            }

            $("#id_proveedor").change(function(){
                const val = $(this).val();
                const proveedor = proveedores_arr.find(item => item.id === val);
                if(proveedor['tipo'] == '' || proveedor['tipo'] == undefined){
                    $("#show-proveedor-type").html('Sin forma jurídica seleccionada');
                } else {
                    $("#show-proveedor-type").html('Forma jurídica: ' + proveedor['tipo']);
                }
                
                console.log(proveedor);
            });

            $('.select_proveedores').select2({
                data: getData()
            }).trigger("change");
            $("#btn_add_proveedor").click(function() {
                var nombre_proveedor = $('#nombre_proveedor').val()
                var cif_proveedor = $('#cif_proveedor').val()
                var direccion_proveedor = $('#direccion_proveedor').val()
                var cp_proveedor = $('#cp_proveedor').val()
                var email_proveedor = $('#email_proveedor').val()

                var tipo = $('#forma_juridica_cliente_editar').val()
                var telefono_proveedor = $('#telefono_proveedor').val()

                $.ajax({
                    type: 'POST',
                    url: './api/proveedores.php',
                    cache: false,
                    data: {
                        nombre: nombre_proveedor,
                        cif: cif_proveedor,
                        direccion: direccion_proveedor,
                        cp: cp_proveedor,
                        email: email_proveedor,
                        telefono: telefono_proveedor,
                        tipo: tipo
                    },
                    success: function(result) {
                        console.log(result);
                        var r = JSON.parse(result)
                        $('#modalAgregarProveedor').modal("hide")
                        $('.select_proveedores').empty()
                        $('.select_proveedores').select2({
                            data: getData()
                        }).trigger("change");
                        $.toast({
                            heading: 'Proveedor agregado.',
                            text: 'Se ha agregado el proveedor correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });
                        $(".tabla_pago_proveedores").DataTable().ajax.reload(null, false);
                        $("#btn_add_proveedor").removeClass('btn-loading');
                        $("#modalAgregarProveedor input").each(function() {
                            $(this).val("")
                        })

                    }
                });
            })


            $("#btn_edit_proveedor").click(function() {
                var nombre_proveedor_editar = $('#nombre_proveedor_editar').val()
                var cif_proveedor_editar = $('#cif_proveedor_editar').val()
                var direccion_proveedor_editar = $('#direccion_proveedor_editar').val()
                var cp_proveedor_editar = $('#cp_proveedor_editar').val()
                var email_proveedor_editar = $('#email_proveedor_editar').val()
                var id_proveedor_editar = $('#id_proveedor_editar').val()
                var tipo_editar = $('#forma_juridica_cliente_editar_ed').val()
                var telefono_proveedor_editar = $('#telefono_proveedor_editar').val()

                $.ajax({
                    type: 'POST',
                    url: './api/proveedores.php',
                    cache: false,
                    data: {
                        nombre: nombre_proveedor_editar,
                        cif: cif_proveedor_editar,
                        direccion: direccion_proveedor_editar,
                        cp: cp_proveedor_editar,
                        email: email_proveedor_editar,
                        telefono: telefono_proveedor_editar,
                        tipo: tipo_editar,
                        id_proveedor: id_proveedor_editar
                    },
                    success: function(result) {
                        console.log(result);
                        var r = JSON.parse(result)
                        $('#modalEditarProveedor').modal("hide")
                        $('.select_proveedores').empty()
                        $('.select_proveedores').select2({
                            data: getData()
                        }).trigger("change");
                        $.toast({
                            heading: 'Proveedor agregado.',
                            text: 'Se ha agregado el proveedor correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });
                        $(".tabla_pago_proveedores").DataTable().ajax.reload(null, false);
                        $("#btn_add_proveedor").removeClass('btn-loading');
                        $("#modalAgregarProveedor input").each(function() {
                            $(this).val("")
                        })

                    }
                });
            })

            $(document).on("click", ".btn_eliminar_proveedor", function() {

                var target = $(this).data("target");


                if (typeof target == 'undefined') {
                    $("#id_proveedor_eliminar").val($(this).data("id"))
                } else {
                    if ($("#" + target).val() == "No") {
                        return false;
                    } else {
                        $("#id_proveedor_eliminar").val($("#" + target).val())
                    }
                }


                $("#modalEliminarProveedor").modal("show");
            })
            $('#btn_eliminar_proveedor').click(function(event) {
                var id_proveedor_eliminar = $("#id_proveedor_eliminar").val()
                $.ajax({
                    type: 'DELETE',
                    url: './api/proveedores.php?id=' + id_proveedor_eliminar,
                    cache: false,
                    success: function(result) {
                        $('.select_proveedores').empty()
                        $('.select_proveedores').select2({
                            data: getData()
                        }).trigger("change");
                        $('#modalEliminarProveedor').modal("hide")
                        $.toast({
                            heading: 'Proveedor eliminado',
                            text: 'Se ha eliminado el proveedor correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        })
                        $(".tabla_pago_proveedores").DataTable().ajax.reload(null, false);
                    }
                });
                return false;
            });
        });
    })(jQuery);
</script>