<div class="modal fade modal-cambiar" id="modalEliminarPoblacion" role="dialog"
    aria-labelledby="exampleModalCenterTitle">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar poblacion</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el poblacion definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_poblacion">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarPoblacion" role="dialog" aria-labelledby="exampleModalCenterTitle">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar poblacion</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">
                            <input class="form-control w-100" id="nombre_poblacion" type="text">
                        </div>

                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_poblacion" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
(function($) {
    'use strict';
    $(function() {
        function getData(id) {
            console.log(id);
            var r
            $.ajax({
                url: "./api/poblaciones.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,

                success: function(data) {

                    data = data.map(function(item) {
                        return {
                            id: item.id,
                            text: item.nombre,
                            selected: (item.id == id) ? true : false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguno',
                        selected: (id == "No") ? true : false
                    });

                    r = data
                }
            });
            return r
        }
        $('.select_poblaciones').each(function() {
            var $select = $(this);
            if ($select.closest('.modal').length) {

                var $mod = $select.closest('.modal')


                $mod.on('shown.bs.modal', function() {

                    var pri = ($select.data("pri") === undefined)
                    var edit = ($select.data("edit") === undefined) ? "No" : $select.data(
                        "edit")
                    if (pri) {
                        reload($select, edit, $mod)
                    } else {
                        $mod.off('shown.bs.modal'); // Elimina el evento si no es pri
                        $select.data("pri", false)
                    }

                })


            } else {

                reload($select)
            }

        });

        function reload($select, $id = "No", $mod = "No") {
            $select.empty()

            if ($mod == "No") {

                $select.select2({
                    data: getData($id)
                }).trigger("change");

            } else {
                $select.select2({
                    data: getData($id),
                    dropdownParent: $mod
                }).trigger("change");
                console.log("aca");

            }
        }
        $("#btn_add_poblacion").click(function() {
            var nombre_poblacion = $('#nombre_poblacion').val()
            $.ajax({
                type: 'POST',
                url: './api/poblaciones.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    nombre: nombre_poblacion,
                },
                success: function(r) {


                    $('#modalAgregarPoblacion').modal("hide")

                    $('.select_poblaciones').each(function(params) {
                        reload($(this), r.id, "No")
                    })
                    $.toast({
                        heading: 'Poblacion agregado.',
                        text: 'Se ha agregado el poblacion correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    setTimeout(function() {
                        $("#btn_add_poblacion").removeClass('btn-loading');
                    }, 2000);
                }
            });
        })
        $(document).on("click", ".btn_eliminar_poblacion", function() {
            var target = $(this).data("target");
            if ($("#" + target).val() == "No") {
                return false;
            } else {


                $("#id_eliminar").val($("#" + target).val())
            }
            $("#modalEliminarPoblacion").modal("show");
        })
        $('#btn_eliminar_poblacion').click(function(event) {
            var id_eliminar = $("#id_eliminar").val()
            $.ajax({
                type: 'DELETE',
                url: './api/poblaciones.php?id=' + id_eliminar,
                cache: false,
                async: false,
                success: function(result) {
                    $('.select_poblaciones').each(function(params) {
                        reload($(this))
                    })
                    $('#modalEliminarPoblacion').modal("hide")
                    $.toast({
                        heading: 'Poblacion eliminado',
                        text: 'Se ha eliminado el poblacion correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                }
            });

        });
    });
})(jQuery);
</script>