<div class="modal fade" id="modalAgregarPack" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Crear pack</h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="container p-0">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="nombre_pack">Nombre</label>
                                <input class="form-control validable" id="nombre_pack" type="text">
                            </div>
                            <div class="form-group">
                                <label for="descripcion_pack">Descripción</label>
                                <textarea class="form-control validable" id="descripcion_pack"></textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">

                                <label>Material</label>

                                <div class="input-group">

                                    <span class="input-group-prepend">

                                        <button class="btn_eliminar_material file-upload-browse btn btn-danger"
                                            data-target="select_materiales" type="button">-</button>

                                    </span>

                                    <select id="select_materiales"
                                        class="select_materiales custom-select select2 form-control">

                                    </select>

                                    <span class="input-group-append">

                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarMaterial">+</button>

                                    </span>

                                </div>

                            </div>

                        </div>
                        <div class="col-md-6">

                            <div class="form-group">

                                <label>Cantidad</label>

                                <div class="input-group">

                                    <input class="form-control" id="cantidad_material" type="number">

                                    <span class="input-group-append">

                                        <button class="file-upload-browse btn btn-info" type="button"
                                            id="btn_add_material_pack">Añadir</button>

                                    </span>

                                </div>

                            </div>

                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label>Materiales del pack</label>
                                <ul id="lista_materiales" class="p-0 m-0" style="background-color: #fff;
    border-top: 1px solid #ced4da;
    border-radius: 2px;list-style: none;min-height: 33px;">

                                </ul>
                            </div>
                        </div>

                    </div>

                </div>
            </div>
            <div class="modal-footer text-right">
                <button id="btn_add_pack" class="btn btn-success btn-fw" type="button">Agregar</button>
                <button class="btn btn-confi" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal Editar Pack -->
<!-- Modal Editar Pack -->
<div class="modal fade" id="modalEditarPack" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Editar pack</h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="container p-0">
                    <input type="hidden" id="id_pack_editar">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="nombre_pack_editar">Nombre</label>
                                <input class="form-control validable" id="nombre_pack_editar" type="text">
                            </div>
                            <div class="form-group">
                                <label for="descripcion_pack_editar">Descripción</label>
                                <textarea class="form-control validable" id="descripcion_pack_editar"></textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Material</label>
                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="btn_eliminar_material file-upload-browse btn btn-danger"
                                            data-target="select_materiales_editar" type="button">-</button>
                                    </span>
                                    <select id="select_materiales_editar"
                                        class="select_materiales custom-select select2 form-control">
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarMaterial">+</button>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Cantidad</label>
                                <div class="input-group">
                                    <input class="form-control" id="cantidad_material_editar" type="number">
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            id="btn_add_material_pack_editar">Añadir</button>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label>Materiales del pack</label>
                                <ul id="lista_materiales_editar" class="p-0 m-0" style="background-color: #fff;
                                    border-top: 1px solid #ced4da;
                                    border-radius: 2px;list-style: none;min-height: 33px;">
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer text-right">
                <button id="btn_update_pack" class="btn btn-success btn-fw" type="button">Guardar cambios</button>
                <button class="btn btn-confi" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade modal-cambiar" id="modalEliminarPack" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar pack</h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <p class="">¿Estás seguro de que deseas eliminar el pack definitivamente?</p>
                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>
            </div>
            <div class="modal-footer text-right">
                <input type="hidden" id="id_pack_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_pack">Confirmar y
                    eliminar</button>
                <button class="btn btn-confi" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>
<style>
.li_material {
    display: flex;
    align-items: center;
    justify-content: space-between;
    border-bottom: 1px solid #ced4da;
    border-right: 1px solid #ced4da;
    border-left: 1px solid #ced4da;
}
</style>
<script>
(function($) {
    'use strict';

    $(function() {
        $('#select_materiales').change(function() {
            const id = $(this).val();

            if (id === "No") return false;
            $.getJSON('/api/materiales2.php?id_material=' + id + '&_=' + new Date().getTime(),
                function(material) {
                    $('#cantidad_material').val(material.stock);

                });
        });

        $('#btn_add_material_pack').click(function() {
            // Obtener el valor y el texto del extra seleccionado
            var id = $('#select_materiales').val();
            var cantidad = $('#cantidad_material').val();
            if (cantidad === "" || cantidad <= 0) {
                $.toast({
                    heading: 'Cantidad no válida.',
                    text: 'Ingresa una cantidad mayor que 0.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });
                return;
            }
            // Validar si el valor seleccionado es "No"
            if (id === "No") {
                $.toast({
                    heading: 'Seleccion no válida.',
                    text: 'No puedes seleccionar "Ninguno" como material.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });
                return;
            }

            // Verificar si el extra ya está en la lista
            var isDuplicate = false;
            $('#lista_materiales li').each(function() {

                if ($(this).data('id') == id) {
                    isDuplicate = true;

                    return false; // Salir del ciclo si se encuentra un duplicado
                }
            });
            if (isDuplicate) {
                $.toast({
                    heading: 'Material duplicado.',
                    text: 'Este material ya está en el pack.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });
                return;
            }
            // Si el extra es un duplicado, mostrar un mensaje
            $.getJSON('/api/materiales2.php?id_material=' + id + '&_=' + new Date().getTime(),
                function(material) {

                    if (cantidad > material.stock) {
                        $.toast({
                            heading: 'Stock insuficiente.',
                            text: 'La cantidad supera el stock disponible.',
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 2000,
                            stack: 6
                        });
                        return;
                    }
                    var newItem = $('<li>').addClass('p-1 li_material').attr('data-id',
                            material
                            .id_material)
                        .append(
                            $('<span>').addClass('mb-0 mr-2').text(material.nombre + ' (X' +
                                cantidad + ')'),
                            $('<button>').addClass('btn btn-sm btn-danger')
                            .text('x')
                            .on('click', function() {
                                // Eliminar el extra de la lista al hacer clic en el botón 'x'
                                $(this).parent().remove();

                            })
                        );

                    // Agregar el nuevo ítem a la lista
                    $('#lista_materiales').append(newItem);
                    $('#select_materiales').val("No").trigger('change');
                    $.toast({
                        heading: 'Material agregado.',
                        text: 'El material se ha agregado correctamente.',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                });

            // Crear el nuevo elemento <li> con el extra seleccionado

            // Limpiar la selección del select después de agregar

            // Mostrar mensaje de éxito al agregar el extra

        });

        $('#select_materiales_editar').change(function() {
            const id = $(this).val();

            if (id === "No") return false;
            $.getJSON('/api/materiales2.php?id_material=' + id + '&_=' + new Date().getTime(),
                function(material) {
                    $('#cantidad_material_editar').val(material.stock);

                });
        });

        $('#btn_add_material_pack_editar').click(function() {
            // Obtener el valor y el texto del extra seleccionado
            var id = $('#select_materiales_editar').val();
            var cantidad = $('#cantidad_material_editar').val();
            if (cantidad === "" || cantidad <= 0) {
                $.toast({
                    heading: 'Cantidad no válida.',
                    text: 'Ingresa una cantidad mayor que 0.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });
                return;
            }
            // Validar si el valor seleccionado es "No"
            if (id === "No") {
                $.toast({
                    heading: 'Seleccion no válida.',
                    text: 'No puedes seleccionar "Ninguno" como material.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });
                return;
            }

            // Verificar si el extra ya está en la lista
            var isDuplicate = false;
            $('#lista_materiales_editar li').each(function() {

                if ($(this).data('id') == id) {
                    isDuplicate = true;

                    return false; // Salir del ciclo si se encuentra un duplicado
                }
            });
            if (isDuplicate) {
                $.toast({
                    heading: 'Material duplicado.',
                    text: 'Este material ya está en el pack.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });
                return;
            }
            // Si el extra es un duplicado, mostrar un mensaje
            $.getJSON('/api/materiales2.php?id_material=' + id + '&_=' + new Date().getTime(),
                function(material) {

                    if (cantidad > material.stock) {
                        $.toast({
                            heading: 'Stock insuficiente.',
                            text: 'La cantidad supera el stock disponible.',
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 2000,
                            stack: 6
                        });
                        return;
                    }
                    var newItem = $('<li>').addClass('p-1 li_material').attr('data-id',
                        material
                        .id_material).attr('data-cantidad', cantidad).append(
                        $('<span>').addClass('mb-0 mr-2').text(material.nombre + ' (X' +
                            cantidad + ')'),
                        $('<button>').addClass('btn btn-sm btn-danger')
                        .text('x')
                        .on('click', function() {
                            // Eliminar el extra de la lista al hacer clic en el botón 'x'
                            $(this).parent().remove();

                        })
                    );

                    // Agregar el nuevo ítem a la lista
                    $('#lista_materiales_editar').append(newItem);
                    $('#select_materiales_editar').val("No").trigger('change');
                    $.toast({
                        heading: 'Material agregado.',
                        text: 'El material se ha agregado correctamente.',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                });

            // Crear el nuevo elemento <li> con el extra seleccionado

            // Limpiar la selección del select después de agregar

            // Mostrar mensaje de éxito al agregar el extra

        });
        $('#btn_add_pack').click(function() {
            const nombre = $('#nombre_pack').val().trim();
            const descripcion = $('#descripcion_pack').val();
            var repetido = false

            // Recorrer todos los inputs .verificable dentro del modal
            document.querySelectorAll('#modalAgregarPack input.validable').forEach(input => {

                const evento = new CustomEvent('validar', {
                    bubbles: true,
                    detail: {
                        mensaje: 'Campo requerido'
                    }
                });

                // Disparar el evento de validación para cada input
                input.dispatchEvent(evento);

                // Si alguno de los inputs no es válido, marcamos todosValidos como falso
                if (!input.isValid) {
                    repetido = true;
                }
            });

            if (repetido) {



                return false;

            }
            if ($('#lista_materiales li').length === 0) {
                $.toast({
                    heading: 'No hay materiales.',
                    text: 'Agrega al menos un material al pack.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });
                return false;
            }
            var fd = new FormData();

            const materiales = [];
            $('#lista_materiales li').each(function() {
                materiales.push({
                    id: $(this).data('id'),
                    cantidad: $(this).data('cantidad') ?? 1
                });
            });
            fd.append('extras', JSON.stringify(materiales));
            fd.append('nombre', nombre);
            fd.append('descripcion', descripcion);
            $.ajax({
                type: 'POST',
                url: './api/packs.php',
                cache: false,
                data: fd,
                processData: false, // No procesar datos
                contentType: false, // No establecer contentType
                success: function(r) {
                    $('#modalAgregarPack').modal("hide");

                    $('#tabla_packs').DataTable().ajax.reload(null, false);
                    $.toast({
                        heading: 'Pack agregado',
                        text: 'Se ha agregado el pack correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000
                    });
                }
            });
        });
        $(document).on('click', '.btn_edit_pack', function() {
            const id = $(this).data('id');

            $.getJSON('/api/packs.php?id_pack=' + id + '&_=' + new Date().getTime(), function(
                pack) {
                $('#id_pack_editar').val(id);
                $('#nombre_pack_editar').val(pack.nombre);
                $('#descripcion_pack_editar').val(pack.descripcion);

                $('#lista_materiales_editar').empty();
                pack.materiales.forEach(function(mat) {
                    var item = $('<li>').addClass('p-1 li_material')
                        .attr('data-id', mat.id_material)
                        .attr('data-cantidad', mat.cantidad)
                        .append(
                            $('<span>').addClass('mb-0 mr-2').text(mat.nombre +
                                ' (X' + mat.cantidad + ')'),
                            $('<button>').addClass('btn btn-sm btn-danger').text(
                                'x').on('click', function() {
                                $(this).parent().remove();
                            })
                        );
                    $('#lista_materiales_editar').append(item);
                });

                $('#modalEditarPack').modal('show');
            });
        });
        $('#btn_update_pack').click(function() {
            const id = $('#id_pack_editar').val();
            const nombre = $('#nombre_pack_editar').val().trim();
            const descripcion = $('#descripcion_pack_editar').val();
            var repetido = false

            // Recorrer todos los inputs .verificable dentro del modal
            document.querySelectorAll('#modalEditarPack input.validable').forEach(input => {

                const evento = new CustomEvent('validar', {
                    bubbles: true,
                    detail: {
                        mensaje: 'Campo requerido'
                    }
                });

                // Disparar el evento de validación para cada input
                input.dispatchEvent(evento);

                // Si alguno de los inputs no es válido, marcamos todosValidos como falso
                if (!input.isValid) {
                    repetido = true;
                }
            });

            if (repetido) {


                return false;

            }

            const materiales = [];
            $('#lista_materiales_editar li').each(function() {
                materiales.push({
                    id: $(this).data('id'),
                    cantidad: $(this).data('cantidad') ?? 1
                });
            });

            if (materiales.length === 0) {
                $.toast({
                    heading: 'Sin materiales',
                    text: 'El pack debe contener al menos un material',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000
                });
                return;
            }

            const fd = new FormData();
            fd.append('id_pack', id);
            fd.append('nombre', nombre);
            fd.append('descripcion', descripcion);
            fd.append('extras', JSON.stringify(materiales));

            $.ajax({
                type: 'POST',
                url: './api/packs.php',
                cache: false,
                data: fd,
                processData: false,
                contentType: false,
                success: function() {
                    $('#modalEditarPack').modal('hide');
                    $('#tabla_packs').DataTable().ajax.reload(null, false);
                    $.toast({
                        heading: 'Pack actualizado',
                        text: 'Se han guardado los cambios correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000
                    });
                }
            });
        });


        $(document).on("click", ".btn_eliminar_pack", function() {
            const target = $(this).data("target");
            const value = $("#" + target).val();
            if (value === "No") return false;
            const id = $(this).data("id");
            $('#id_pack_eliminar').val(id);
            $('#modalEliminarPack').modal("show");
        });

        $('#btn_eliminar_pack').click(function() {
            const id = $('#id_pack_eliminar').val();
            $.ajax({
                type: 'DELETE',
                url: '/api/packs.php?id=' + id,
                success: function() {
                    $('#modalEliminarPack').modal("hide");
                    $('#tabla_packs').DataTable().ajax.reload(null, false);
                    $('.select_packs').each(function() {
                        reloadSelect($(this));
                    });
                    $.toast({
                        heading: 'Pack eliminado',
                        text: 'Se ha eliminado el pack correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000
                    });
                }
            });
        });

    });

})(jQuery);
</script>