<div class="modal fade modal-cambiar" id="modalEliminarObra" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar obra</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el obra definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_obra_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_obra">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarObra" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Obra</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">
                            <input class="form-control w-100" id="nombre_obra" type="text">
                        </div>

                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_obra" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
(function($) {
    'use strict';
    $(function() {
        $("#btn_add_obra").click(function() {
            var nombre_obra = $('#nombre_obra').val()
            $.ajax({
                type: 'POST',
                url: './api/obras.php',
                cache: false,
                data: {
                    nombre: nombre_obra,
                },
                success: function(result) {
                    var r = JSON.parse(result)
                    $('#modalAgregarObra').modal("hide")
                    $(".select_obras").each(
                        function() {
                            $(this).append(
                                    '<option value="' +
                                    r.id + '">' +
                                    nombre_obra +
                                    '</option>'
                                ).val(r.id)
                                .trigger("change");
                        })
                    $.toast({
                        heading: 'Obra agregado.',
                        text: 'Se ha agregado la obra correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    setTimeout(function() {
                        $("#btn_add_obra").removeClass('btn-loading');
                    }, 2000);
                }
            });
        })
        $(document).on("click", ".btn_eliminar_obra", function() {

            var target = $(this).data("target");

            $("#id_obra_eliminar").val($("#" + target).val())
            if ($("#id_obra_eliminar").val() != "No") {
                $("#modalEliminarObra").modal("show");
            }

        })
        $('#btn_eliminar_obra').click(function(event) {
            var id_obra_eliminar = $("#id_obra_eliminar").val()
            $.ajax({
                type: 'DELETE',
                url: './api/obras.php?id=' + id_obra_eliminar,
                cache: false,
                success: function(result) {
                    $(".select_obras").each(function() {
                        $(this).find("option[value='" +
                                id_obra_eliminar + "']").remove()
                            .trigger(
                                "change");
                    })
                    $('#modalEliminarObra').modal("hide")
                    $.toast({
                        heading: 'Obra eliminada',
                        text: 'Se ha eliminado la obra correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                }
            });
            return false;
        });
    });
})(jQuery);
</script>
