<div class="modal fade modal-cambiar" id="modalEliminarNivelEstudios" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar nivel</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el nivel definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_nivel_estudios_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_nivel_estudios">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarNivelEstudios" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar nivel</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">
                            <input class="form-control w-100" id="nombre_nivel_estudios" type="text">
                        </div>

                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_nivel_estudios" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
(function($) {
    'use strict';
    $(function() {
        $("#btn_add_nivel_estudios").click(function() {
            var nombre_nivel_estudios = $('#nombre_nivel_estudios').val()
            $.ajax({
                type: 'POST',
                url: './api/nivel_estudios.php',
                cache: false,
                async: false,
                dataType: 'json',
                data: {
                    nombre: nombre_nivel_estudios,
                },
                success: function(result) {
                    var r = result
                    console.log(r);
                    if (r == 0) {
                        $.toast({
                            heading: 'Nombre repetido.',
                            text: 'Elije otro nombre.',
                            position: 'top-right',
                            loaderBg: '#c21011',
                            icon: 'error',
                            hideAfter: 2000,
                            stack: 6
                        });
                        return false;
                    }
                    $('#modalAgregarNivelEstudios').modal("hide")
                    $(".select_nivel_estudios").each(
                        function() {
                            $(this).append(
                                    '<option value="' +
                                    r.id + '">' +
                                    nombre_nivel_estudios +
                                    '</option>'
                                ).val(r.id)
                                .trigger("change");
                        })
                    $.toast({
                        heading: 'Nivel agregado.',
                        text: 'Se ha agregado el nivel correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    setTimeout(function() {
                        $("#btn_add_nivel_estudios").removeClass('btn-loading');
                    }, 2000);
                }
            });
        })
        $(document).on("click", ".btn_eliminar_nivel_estudios", function() {

            var target = $(this).data("target");
            if ($("#" + target).val() == "No") {
                return false;
            }
            $("#id_nivel_estudios_eliminar").val($("#" + target).val())
            $("#modalEliminarNivelEstudios").modal("show");
        })
        $('#btn_eliminar_nivel_estudios').click(function(event) {
            var id_nivel_estudios_eliminar = $("#id_nivel_estudios_eliminar").val()

            $.ajax({
                type: 'DELETE',
                url: './api/nivel_estudios.php?id=' + id_nivel_estudios_eliminar,
                cache: false,
                success: function(result) {
                    $(".select_nivel_estudios").each(function() {
                        $(this).find("option[value='" +
                                id_nivel_estudios_eliminar + "']").remove()
                            .trigger(
                                "change");
                    })
                    $('#modalEliminarNivelEstudios').modal("hide")
                    $.toast({
                        heading: 'Nivel eliminado',
                        text: 'Se ha eliminado el nivel correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                }
            });
            return false;
        });
    });
})(jQuery);
</script>