<div class="modal fade modal-cambiar" id="modalEliminarNavegador" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar navegador</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el navegador definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_navegador_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_navegador">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarNavegador" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Navegador</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">
                            <input class="form-control w-100" id="nombre_navegador" type="text">
                        </div>

                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_navegador" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
    (function ($) {
        'use strict';
        $(function () {
            $("#btn_add_navegador").click(function () {
                var nombre_navegador = $('#nombre_navegador').val()



                if (!ValidateAgent(nombre_navegador)) {
                    $.toast({
                        heading: 'Navegador incorrecto.',
                        text: 'Agrega un nombre válido para el navegador',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'error',
                        hideAfter: 2000,
                        stack: 6
                    });
                    return false;
                }



                $.ajax({
                    type: 'POST',
                    url: './api/navegadores.php',
                    cache: false,
                    data: {
                        nombre: nombre_navegador,
                    },
                    success: function (result) {
                        var r = JSON.parse(result)
                        $('#modalAgregarNavegador').modal("hide")
                        $(".select_navegadores").each(
                            function () {
                                $(this).append(
                                    '<option value="' +
                                    r.id + '">' +
                                    nombre_navegador +
                                    '</option>'
                                ).val(r.id)
                                    .trigger("change");
                            })
                        $.toast({
                            heading: 'Navegador agregado.',
                            text: 'Se ha agregado el navegador correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });
                        setTimeout(function () {
                            $("#btn_add_navegador").removeClass('btn-loading');
                        }, 2000);
                    }
                });
            })
            $(document).on("click", ".btn_eliminar_navegador", function () {

                var target = $(this).data("target");

                $("#id_navegador_eliminar").val($("#" + target).val())
                if ($("#id_navegador_eliminar").val() != "No") {
                    $("#modalEliminarNavegador").modal("show");
                }

            })

            function ValidateAgent(userAgentString) {
                var parser = new UAParser();


                var result = parser.setUA(userAgentString).getResult();
                var esNavegador = result.browser.name !== undefined;

                return esNavegador; // Devuelve true


            }
            $('#btn_eliminar_navegador').click(function (event) {
                var id_navegador_eliminar = $("#id_navegador_eliminar").val()
                $.ajax({
                    type: 'DELETE',
                    url: './api/navegadores.php?id=' + id_navegador_eliminar,
                    cache: false,
                    success: function (result) {
                        $(".select_navegadores").each(function () {
                            $(this).find("option[value='" +
                                id_navegador_eliminar + "']").remove()
                                .trigger(
                                    "change");
                        })
                        $('#modalEliminarNavegador').modal("hide")
                        $.toast({
                            heading: 'Navegador eliminado',
                            text: 'Se ha eliminado el navegador correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        })
                    }
                });
                return false;
            });
        });
    })(jQuery);
</script>