<div class="modal fade modal-cambiar" id="modalEliminarModelo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar modelo</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el modelo definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_modelo_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_modelo">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarModelo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Modelo</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">


                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Nombre</label>
                                <input class="form-control w-100" id="nombre_modelo" type="text">
                            </div>

                        </div>


                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_modelo" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
(function($) {
    'use strict';
    $(function() {

        function getData(id_modelo) {
            var r
            $.ajax({
                url: "./api/modelos.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                
                success: function(data) {
                    data = data.map(function(item) {
                        return {
                            id: item.id_modelo,
                            text: item.nombre,
                            selected: (item.id_modelo == id_modelo) ? true : false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguno',
                        selected: (id_modelo == "No") ? true : false
                    });

                    r = data
                }
            });
            return r
        }

        $('.select_modelos').select2({
            data: getData("No")
        }).trigger("change");
        $("#btn_add_modelo").click(function() {
            var nombre_modelo = $('#nombre_modelo').val()





            $.ajax({
                type: 'POST',
                url: './api/modelos.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    nombre: nombre_modelo

                },
                success: function(r) {

                    $('#modalAgregarModelo').modal("hide")
                    $('.select_modelos').empty()
                    $('.select_modelos').select2({
                        data: getData(r.id)
                    }).trigger("change");
                    $.toast({
                        heading: 'Modelo agregado.',
                        text: 'Se ha agregado el modelo correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });

                    $("#btn_add_modelo").removeClass('btn-loading');

                }
            });
        })

        $(document).on("click", ".btn_eliminar_modelo", function() {

            var target = $(this).data("target");


            if (typeof target === 'undefined') {
                console.log($(this).data("id"));
                $("#id_modelo_eliminar").val($(this).data("id"))
            } else {
                if ($("#" + target).val() == "No") {
                    return false;
                } else {
                    $("#id_modelo_eliminar").val($("#" + target).val())
                }
            }

            $("#modalEliminarModelo").modal("show");
        })

        $('#btn_eliminar_modelo').click(function(event) {
            var id_modelo_eliminar = $("#id_modelo_eliminar").val()
            console.log(id_modelo_eliminar);
            $.ajax({
                type: 'DELETE',
                url: './api/modelos.php?id=' + id_modelo_eliminar,
                cache: false,
                success: function(result) {

                    $('#modalEliminarModelo').modal("hide")
                    $.toast({
                        heading: 'Modelo eliminado',
                        text: 'Se ha eliminado el modelo correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                    $('.select_modelos').empty()
                    $('.select_modelos').select2({
                        data: getData("No")
                    }).trigger("change");

                }
            });
            return false;
        });

    });
})(jQuery);
</script>