<div class="modal fade modal-cambiar" id="modalEliminarMetodo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar metodo</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el metodo definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_metodo_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_metodo">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarMetodo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Metodo</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">


                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Nombre</label>
                                <input class="form-control w-100" id="nombre_metodo" type="text">
                            </div>

                        </div>


                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_metodo" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
(function($) {
    'use strict';
    $(function() {

        function getData(id_metodo) {
            var r
            $.ajax({
                url: "./api/metodos.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                dataType: "json",
                success: function(data) {
                    data = data.map(function(item) {
                        return {
                            id: item.id_metodo,
                            text: item.nombre,
                            selected: (item.id_metodo == id_metodo) ? true : false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguno',
                        selected: (id_metodo == "No") ? true : false
                    });

                    r = data
                }
            });
            return r
        }

        $('.select_metodos').select2({
            data: getData("No")
        }).trigger("change");
        $("#btn_add_metodo").click(function() {
            var nombre_metodo = $('#nombre_metodo').val()





            $.ajax({
                type: 'POST',
                url: './api/metodos.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    nombre: nombre_metodo

                },
                success: function(r) {

                    $('#modalAgregarMetodo').modal("hide")
                    $('.select_metodos').empty()
                    $('.select_metodos').select2({
                        data: getData(r.id)
                    }).trigger("change");
                    $.toast({
                        heading: 'Método agregado.',
                        text: 'Se ha agregado el método correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });

                    $("#btn_add_metodo").removeClass('btn-loading');

                }
            });
        })

        $(document).on("click", ".btn_eliminar_metodo", function() {

            var target = $(this).data("target");


            if (typeof target === 'undefined') {
                console.log($(this).data("id"));
                $("#id_metodo_eliminar").val($(this).data("id"))
            } else {
                if ($("#" + target).val() == "No") {
                    return false;
                } else {
                    $("#id_metodo_eliminar").val($("#" + target).val())
                }
            }

            $("#modalEliminarMetodo").modal("show");
        })

        $('#btn_eliminar_metodo').click(function(event) {
            var id_metodo_eliminar = $("#id_metodo_eliminar").val()
            console.log(id_metodo_eliminar);
            $.ajax({
                type: 'DELETE',
                url: './api/metodos.php?id=' + id_metodo_eliminar,
                cache: false,
                success: function(result) {

                    $('#modalEliminarMetodo').modal("hide")
                    $.toast({
                        heading: 'Metodo eliminado',
                        text: 'Se ha eliminado el metodo correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                    $('.select_metodos').empty()
                    $('.select_metodos').select2({
                        data: getData("No")
                    }).trigger("change");

                }
            });
            return false;
        });

    });
})(jQuery);
</script>