<div class="modal fade modal-cambiar" id="modalEliminarMedida" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar medida</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el medida definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_medida_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_medida">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarMedida" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Medida</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">
                            <input class="form-control w-100" id="nombre_medida" type="text">
                        </div>

                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_medida" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
(function($) {
    'use strict';
    $(function() {
        function getData(id_medida) {
            console.log(id_medida);
            var r
            $.ajax({
                url: "./api/medidas.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,

                success: function(data) {

                    data = data.map(function(item) {
                        return {
                            id: item.id_medida,
                            text: item.nombre,
                            selected: (item.id_medida == id_medida) ? true : false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguna',
                        selected: (id_medida == "No") ? true : false
                    });

                    r = data
                }
            });
            return r
        }
        $('.select_medidas').select2({
            data: getData("No")
        }).trigger("change");
        $("#btn_add_medida").click(function() {
            var nombre_medida = $('#nombre_medida').val()
            $.ajax({
                type: 'POST',
                url: './api/medidas.php',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                data: {
                    nombre: nombre_medida,
                },
                success: function(r) {

                    $('#modalAgregarMedida').modal("hide")
                    $('.select_medidas').empty()
                    $('.select_medidas').select2({
                        data: getData(r.id)
                    }).trigger("change");
                    $.toast({
                        heading: 'Medida agregada.',
                        text: 'Se ha agregado la medida correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });

                    $("#btn_add_medida").removeClass('btn-loading');

                }
            });
        })
        $(document).on("click", ".btn_eliminar_medida", function() {
            var target = $(this).data("target");
            if ($("#" + target).val() == "No") {
                return false;
            } else {


                $("#id_medida_eliminar").val($("#" + target).val())
            }
            $("#modalEliminarMedida").modal("show");
        })
        $('#btn_eliminar_medida').click(function(event) {
            var id_medida_eliminar = $("#id_medida_eliminar").val()
            $.ajax({
                type: 'DELETE',
                url: './api/medidas.php?id=' + id_medida_eliminar,
                cache: false,
                async: false,
                success: function(result) {
                    $('.select_medidas').empty()
                    $('.select_medidas').select2({
                        data: getData("No")
                    }).trigger("change");
                    $('#modalEliminarMedida').modal("hide")
                    $.toast({
                        heading: 'Medida eliminada',
                        text: 'Se ha eliminado la medida correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                }
            });

        });
    });
})(jQuery);
</script>