<div class="modal fade" id="confirmModal" role="dialog" aria-labelledby="confirmModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="confirmModalLabel">Cargar materiales</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>
            </div>
            <div class="modal-body">
                ¿Deseas agregar automáticamente los materiales e información asociados a este evento?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" id="cancelarCambios"
                    data-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" id="aceptarCambios">Aceptar</button>
            </div>
        </div>
    </div>
</div>
<script>
(function($) {

    'use strict';



    $(window).on('load', function() {


        function FillMaterial(id_material) {



            $.ajax({

                url: "./api/materiales2.php?id_material=" + id_material,

                type: 'GET',

                dataType: 'json', // added data type

                cache: false,

                async: false,

                success: function(res) {

                    $('#complementos_material').empty();
                    const contenedor2 = document.getElementById('complementos_material');
                    if (res.complementos.length == 0 || !res.complementos || !Array.isArray(
                            res.complementos)) {
                        $('#complementos_material').append(
                            '<div class="col-12 mb-0"><div class="px-2" style="display: flex; align-items: center; justify-content: space-between;   border-radius: 2px; list-style: none; min-height: 33px;">Sin complementos asociados</div></div>'


                        );


                        return;
                    }
                    res.complementos.forEach(complemento => {
                        const div = document.createElement('div');
                        div.className =
                            'col-6 col-sm-6 col-lg-4 d-flex flex-row mb-0 p-2 justify-content-start align-items-start';

                        div.innerHTML = `
                        <label class="custom-control custom-checkbox d-inline-block mb-0">
                            <input type="checkbox" checked class="custom-control-input apartado" name="complementos_material" data-descripcion="${complemento.nombre} X${complemento.cantidad} ${(complemento.cantidad > 1) ? "Unidades" :"Unidad"}" value="${complemento.id_complemento}">
                            <span class="custom-control-label">${complemento.nombre} X${complemento.cantidad}</span>
                        </label>
                    `;

                        contenedor2.appendChild(div);
                    });

                    $("#titulo_edit").val(res.nombre)
                    $("#cantidad_edit").val(res.stock)

                    if (window.location.pathname.split("/").pop() ==

                        "crear_factura_manual_materiales") {
                        $("#dias_edit").val($("#id_evento_factura").select2('data')[0]
                            .dias)
                        var id = $("#id_evento_factura").val()
                    } else {

                        $("#dias_edit").val($("#id_evento_presupuesto").select2('data')[0]
                            .dias)
                        var id = $("#id_evento_presupuesto").val()
                    }

                    $("#descuento_edit").val(0.00)
                    var id_igic = "No"

                    if (!document.getElementById("impuestos_check").checked) {

                        $("#igic_edit").val(id_igic).trigger("change")

                    }





                    $("#precio_unitario_edit").val(res.precio_dia).trigger("change")

                    $("#precio_unitario_edit").trigger("input");
                    $('#dias_material_crear').empty();
                    const contenedor = document.getElementById('dias_material_crear');
                    if (id != "No") {
                        $.getJSON(`./api/eventos2.php?id_evento=${id}` + '&_=' + new Date()
                            .getTime(),
                            function(
                                data) {
                                console.log(data);

                                JSON.parse(data.dias).forEach(dia => {
                                    const div = document.createElement('div');
                                    div.className =
                                        'col-6 col-sm-4 col-lg-3 col-xl-2 d-flex flex-row mb-3 px-3 justify-content-start align-items-center';

                                    div.innerHTML = `
                                    <label class="custom-control custom-checkbox d-inline-block mb-0">
                                        <input type="checkbox" checked class="custom-control-input apartado" name="dias_material_crear" value="${dia}">
                                        <span class="custom-control-label">${dia}</span>
                                    </label>
                                `;

                                    contenedor.appendChild(div);


                                });
                            });
                    } else {
                        contenedor.innerHTML = `<div class="col-12">
                                                        <div class="px-2"
                                                            style="display: flex; align-items: center; justify-content: space-between;    ;   background-color: #fff;   border-radius: 2px; list-style: none; min-height: 33px;">
                                                            Sin días asociados</div>
                                                    </div>`
                    }




                    $("#btn_agregar_d").data("id", res.id_material)



                    $("#btn_agregar_detallado").data("id", res.id_material)

                    $("#btn_agregar_detallado").data("stock", res.stock)

                    $("#btn_agregar_detallado").removeAttr("disabled")

                }

            });



        }

        $("#cant_materiales").change(function() {

            UpdateMateriales()



        });

        $('#search_materiales').keyup(function(event) {



            UpdateMateriales()

        })



        function UpdateMateriales() {

            var cant = $("#cant_materiales").val()

            var search = $('#search_materiales').val().toLowerCase()

            $("#materiales").html("")

            $.ajax({

                type: 'GET',

                url: './api/materiales2.php',

                cache: false,

                async: false,

                dataType: "json",

                success: function(data) {





                    data = data.filter(objeto => {

                        var titulo = objeto.nombre



                        var pp = titulo

                        return pp.toLowerCase().includes(

                            search)

                    });





                    if (cant == "todos" ||

                        data.length < parseInt(cant)) {



                        cant = data.length

                    }







                    for (var h = 0; h < cant; h++) {

                        var r = data[h]



                        var titulo2 = r.nombre



                        var pp2 = titulo2





                        var div1 = document.createElement("div");

                        div1.classList.add("custom-control")

                        div1.classList.add("custom-radio")

                        div1.classList.add("mb-2")

                        var input = document.createElement("input");

                        input.type = "radio"

                        input.classList.add("custom-control-input")

                        input.classList.add("checkbox_apartado")

                        input.name = "customRadio"

                        input.setAttribute('data-id', r.id_material)

                        input.setAttribute('data-nombre', r.nombre)



                        input.id = "material" + r.id_material




                        input.addEventListener('focus', function(event) {

                            var elementoCambiado = event.target;

                            elementoCambiado.blur();
                            if (elementoCambiado.checked) {
                                // Esto previene que quede marcado (efecto "toggle")
                                setTimeout(() => {
                                    elementoCambiado.checked = false;
                                    $("#btn_agregar_detallado").data("id",
                                        "No")
                                }, 0);

                                // No continúes con la función si lo desmarcaste (opcional)
                                return;
                            }
                        });


                        input.addEventListener('change', function(event) {

                            var elementoCambiado = event.target;
                            console.log(elementoCambiado.checked);
                            var dataIdValue = elementoCambiado.getAttribute(
                                "data-id");





                            FillMaterial(dataIdValue)

                        });



                        var label = document.createElement("label");

                        label.classList.add("custom-control-label")

                        label.classList.add("materiales")

                        label.innerText = pp2

                        label.htmlFor = "material" + r.id_material



                        var materiales = document.getElementById("materiales");



                        const badge = document.createElement('div');

                        var state = (r.stock != 0) ? "success" : "danger"

                        // Agregar clases al elemento

                        badge.classList.add('badge', 'badge-' + state);



                        // Establecer el estilo del elemento

                        badge.style.fontSize = '14px';



                        // Establecer el texto del elemento

                        badge.textContent = r.stock;



                        const div2 = document.createElement('div');

                        div1.classList.add("d-flex")

                        div1.classList.add("justify-content-between")

                        div2.append(input)

                        div2.append(label)

                        div1.append(div2)

                        div1.append(badge)

                        materiales.append(div1)



                    }







                }

            });



        }
        UpdateMateriales()

        function calcularDias() {
            const inicioStr = $('#fecha_i_mat').val();
            const finStr = $('#fecha_f_mat').val();

            if (!inicioStr || !finStr) {
                $('#resultado_dias').text('');
                return;
            }

            const inicio = new Date(inicioStr);
            const fin = new Date(finStr);

            if (fin < inicio) {
                $('#resultado_dias').text('Fecha fin debe ser mayor o igual a fecha inicio.');
                $.toast({
                    heading: 'Fechas inválidas',
                    text: 'Fecha fin debe ser mayor o igual a fecha inicio.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                $('#fecha_i_mat').val("");
                $('#fecha_f_mat').val("");

                return;
            }

            // calcular diferencia en milisegundos
            const diferenciaMs = fin - inicio;

            // calcular diferencia en días (redondeando hacia abajo)
            const diferenciaDias = Math.floor(diferenciaMs / (1000 * 60 * 60 * 24)) +
                1; // +1 para incluir ambos días

            $('#cantidad_edit').val(diferenciaDias);
        }


        $('#fecha_i_mat, #fecha_f_mat').on('input change', calcularDias);


    });

})(jQuery);
</script>











<script>
(function($) {

    'use strict';



    $(window).on('load', function() {
        function FillPacks(id_material) {



            $.ajax({

                url: "./api/packs.php?id_pack=" + id_material,

                type: 'GET',

                dataType: 'json', // added data type

                cache: false,

                async: false,

                success: function(res) {

                    console.log(res);
                    var rowCount = $('#order-listing').DataTable().data().count();
                    res.materiales.forEach(function(m) {
                        var descripcion = "Alquiler de " + m.nombre;
                        var complementosDescripciones = [];

                        m.complementos.forEach(c => {
                            let texto =
                                `${c.nombre} (${c.cantidad} ${c.cantidad > 1 ? "Unidades" : "Unidad"})`;
                            complementosDescripciones.push(texto);
                        });

                        if (complementosDescripciones.length > 0) {
                            descripcion += ", el material cuenta con: <br>" +
                                complementosDescripciones.join(' <br> ');
                        }
                        var days = 0
                        if (window.location.pathname.split("/").pop() ==

                            "crear_factura_manual_materiales") {
                            days = $("#id_evento_factura").select2('data')[
                                    0]
                                .dias
                        } else {

                            days = $("#id_evento_presupuesto").select2(
                                    'data')[0]
                                .dias
                        }
                        if (window.datosEvento != null) {} else {}
                        var newRowData = {

                            "index": rowCount + 1,
                            "fechas": (window.datosEvento != null) ? JSON.parse(
                                window.datosEvento.dias) : [],

                            "id": m.id_material,
                            "cantidad": m.cantidad,
                            "dias": (window.datosEvento != null) ? JSON.parse(window
                                .datosEvento.dias).length : days,

                            "descripcion": descripcion,
                            "precio_unitario": m.precio_dia,

                            "nombre": m.nombre,

                            "descuento": 0.00,

                            "igic": parseFloat($("#igic_edit").find(':selected')
                                .data('porcentaje')),

                            "id_igic": "No",

                        };



                        rowCount++

                        $('#order-listing').DataTable().row.add(newRowData).draw();


                    })


                }

            });



        }
        var modal = new bootstrap.Modal(document.getElementById(
            'confirmModal'));
        $("#id_evento_presupuesto, #id_evento_factura").change(function() {
            var boo = false
            if ($(this).data("wait") == 1) {
                boo = true
            }
            const id = $(this).val();
            if (id === "No") {
                $("#dias_edit").prop("disabled", true)
                window.datosEvento = null
                return;
            } else {
                $("#dias_edit").prop("disabled", false)
            }
            $.getJSON('/api/eventos2.php?id_evento=' + id + '&_=' + new Date().getTime(),
                function(
                    evento) {
                    window.datosEvento = evento;
                    if (!boo) {
                        modal.show();
                    }
                });


        });
        $('#aceptarCambios').on('click', function() {
            var res = window.datosEvento; // Obtener los datos guardados
            var rowCount = $('#order-listing').DataTable().data().count();
            console.log(res);
            if (window.location.pathname.split("/").pop() ==
                "crear_factura_manual_materiales") {
                $("#cliente_factura").val(res.client_id).trigger("change")

            } else {
                $("#cliente_presupuesto").val(res.client_id).trigger("change")
            }
            res.materiales.forEach(m => {

                var descripcion = "Alquiler de " + m.nombre;
                var complementosDescripciones = [];

                m.complementos.forEach(c => {
                    let texto =
                        `${c.nombre} (${c.cantidad} ${c.cantidad > 1 ? "Unidades" : "Unidad"})`;
                    complementosDescripciones.push(texto);
                });

                if (complementosDescripciones.length > 0) {
                    descripcion += ", el material cuenta con: <br>" +
                        complementosDescripciones.join(' <br> ');
                }

                var newRowData = {

                    "index": rowCount,

                    "fechas": JSON.parse(m.dias),
                    "id": m.id_material,
                    "cantidad": m.cantidad,
                    "dias": JSON.parse(m.dias).length,
                    "descuento": 0.00,


                    "descripcion": descripcion,

                    "precio_unitario": m.precio_dia,

                    "nombre": m.nombre,



                    "igic": parseFloat($("#igic_edit").find(':selected')
                        .data('porcentaje') / 100),

                    "id_igic": "No",

                };



                rowCount++

                $('#order-listing').DataTable().row.add(newRowData).draw();

            });


            // Cerrar el modal después de aceptar
            modal.hide();
        });
        $("#cant_packs").change(function() {

            UpdatePacks()



        });

        $('#search_packs').keyup(function(event) {



            UpdatePacks()

        })



        function UpdatePacks() {

            var cant = $("#cant_packs").val()

            var search = $('#search_packs').val().toLowerCase()

            $("#packs").html("")

            $.ajax({

                type: 'GET',

                url: './api/packs.php',

                cache: false,

                async: false,

                dataType: "json",

                success: function(data) {





                    data = data.filter(objeto => {

                        var titulo = objeto.nombre



                        var pp = titulo

                        return pp.toLowerCase().includes(

                            search)

                    });





                    if (cant == "todos" ||

                        data.length < parseInt(cant)) {



                        cant = data.length

                    }







                    for (var h = 0; h < cant; h++) {

                        var r = data[h]



                        var titulo2 = r.nombre



                        var pp2 = titulo2





                        var div1 = document.createElement("div");

                        div1.classList.add("custom-control")

                        div1.classList.add("custom-radio")

                        div1.classList.add("mb-2")

                        var input = document.createElement("input");

                        input.type = "radio"

                        input.classList.add("custom-control-input")

                        input.classList.add("checkbox_apartado")

                        input.name = "customRadio"

                        input.setAttribute('data-id', r.id_pack)

                        input.setAttribute('data-nombre', r.nombre)



                        input.id = "pack" + r.id_pack




                        input.addEventListener('focus', function(event) {

                            var elementoCambiado = event.target;

                            elementoCambiado.blur();
                            if (elementoCambiado.checked) {
                                // Esto previene que quede marcado (efecto "toggle")
                                setTimeout(() => {
                                    elementoCambiado.checked = false;
                                    $("#btn_agregar_detallado").data("id",
                                        "No")
                                }, 0);

                                // No continúes con la función si lo desmarcaste (opcional)
                                return;
                            }
                        });


                        input.addEventListener('change', function(event) {

                            var elementoCambiado = event.target;
                            console.log(elementoCambiado.checked);
                            var dataIdValue = elementoCambiado.getAttribute(
                                "data-id");





                            FillPacks(dataIdValue)

                        });



                        var label = document.createElement("label");

                        label.classList.add("custom-control-label")

                        label.classList.add("packs")

                        label.innerText = pp2

                        label.htmlFor = "pack" + r.id_pack



                        var packs = document.getElementById("packs");




                        const div2 = document.createElement('div');

                        div1.classList.add("d-flex")

                        div1.classList.add("justify-content-between")

                        div2.append(input)

                        div2.append(label)

                        div1.append(div2)



                        packs.append(div1)



                    }







                }

            });



        }
        UpdatePacks()


    });

})(jQuery);
</script>