<!-- Modal Eliminar Material -->
<div class="modal fade modal-cambiar" id="modalEliminarMaterial" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar material</h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <p class="">¿Estás seguro de que deseas eliminar el material definitivamente?</p>
                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>
            </div>
            <div class="modal-footer text-right">
                <input type="hidden" id="id_material_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_material">Confirmar y
                    eliminar</button>
                <button class="btn btn-confi" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Agregar Material -->
<div class="modal fade" id="modalAgregarMaterial" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Agregar material</h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="container p-0">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="nombre_material">Nombre</label>
                                <input class="form-control validable" id="nombre_material" type="text">
                            </div>
                            <div class="form-group">
                                <label for="estado_material">Estado</label>
                                <select class="form-control" id="estado_material">
                                    <option value="Disponible" selected>Disponible</option>
                                    <option value="Bloqueado">Bloqueado</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label>Familia</label>
                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="btn_eliminar_familia file-upload-browse btn btn-danger"
                                            data-target="select_familias" type="button">-</button>
                                    </span>
                                    <select id="select_familias"
                                        class="select_familias custom-select select2 form-control"
                                        data-target="select_subfamilias">
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarFamilia">+</button>
                                    </span>
                                </div>
                            </div>

                            <div class="form-group">
                                <label>Subfamilia</label>
                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="btn_eliminar_subfamilia file-upload-browse btn btn-danger"
                                            data-target="select_subfamilias" type="button">-</button>
                                    </span>
                                    <select id="select_subfamilias"
                                        class="select_subfamilias custom-select select2 form-control">
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarSubfamilia">+</button>
                                    </span>

                                </div>
                            </div>
                            <div class="form-group">
                                <label for="precio_dia_material">Precio por día</label>
                                <input class="form-control validable" id="precio_dia_material" type="number"
                                    step="0.01">
                            </div>

                            <div class="form-group">
                                <label for="stock_material">Stock</label>
                                <input class="form-control validable" id="stock_material" type="number">
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer text-right">
                <button id="btn_add_material" class="btn btn-success btn-fw" type="button">Agregar</button>
                <button class="btn btn-confi" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Editar Material -->
<div class="modal fade" id="modalEditarMaterial" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Editar material</h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="container p-0">
                    <div class="row mb-2">
                        <div class="col-12">
                            <label for="nombre_material_editar">Nombre</label>
                            <input class="form-control validable" id="nombre_material_editar" type="text">
                        </div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-12">
                            <label for="estado_material_editar">Estado</label>
                            <select class="form-control" id="estado_material_editar">
                                <option value="Disponible">Disponible</option>
                                <option value="Bloqueado">Bloqueado</option>
                            </select>
                        </div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-12">
                            <label for="precio_dia_material_editar">Precio por día</label>
                            <input class="form-control validable" id="precio_dia_material_editar" type="number"
                                step="0.01">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label>Familia</label>
                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="btn_eliminar_familia file-upload-browse btn btn-danger"
                                            data-target="select_familias_editar" type="button">-</button>
                                    </span>
                                    <select id="select_familias_editar"
                                        class="select_familias custom-select select2 form-control"
                                        data-target="select_subfamilias_editar">
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarFamilia">+</button>
                                    </span>
                                </div>
                            </div>

                            <div class="form-group">
                                <label>Subfamilia</label>
                                <div class="input-group">
                                    <span class="input-group-prepend">
                                        <button class="btn_eliminar_subfamilia file-upload-browse btn btn-danger"
                                            data-target="select_subfamilias_editar" type="button">-</button>
                                    </span>
                                    <select id="select_subfamilias_editar"
                                        class="select_subfamilias custom-select select2 form-control">
                                    </select>
                                    <span class="input-group-append">
                                        <button class="file-upload-browse btn btn-info" type="button"
                                            data-toggle="modal" data-target="#modalAgregarSubfamilia">+</button>
                                    </span>

                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <label for="stock_material_editar">Stock</label>
                            <input class="form-control validable" id="stock_material_editar" type="number">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer text-right">
                <button id="btn_edit_material" class="btn btn-success btn-fw" type="button">Guardar cambios</button>
                <button class="btn btn-confi" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modalComplementosMaterial" role="dialog">
    <div class="modal-dialog   modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Editar complementos</h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">

                            <label>Nombre</label>

                            <input class="form-control validable" type="text" name="" id="nombre_complemento_material">
                        </div>
                        <div class="form-group">

                            <label>Cantidad</label>

                            <input class="form-control validable" type="number" name=""
                                id="cantidad_complemento_material">
                        </div>

                        <button id="btn_add_complemento_material" class="btn btn-success btn-sm mb-3"
                            type="button">Agregar</button>
                    </div>

                    <div class="col-12">
                        <div class="form-group">
                            <h5>Complementos del material</h5>
                            <ul id="lista_complementos_material" class="p-0 m-0" style="background-color: #fff;
    border-top: 1px solid #ced4da;
    border-radius: 2px;list-style: none;min-height: 33px;">

                            </ul>
                        </div>
                    </div>

                </div>

            </div>
            <div class="modal-footer text-right">
                <button id="btn_add_complementos_material" data-dismiss="modal" class="btn btn-success btn-fw"
                    type="button">Editar</button>
                <button class="btn btn-confi" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade modal-cambiar" id="modalEliminarComplemento" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar complemento</h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <p>¿Estás seguro de que deseas eliminar el complemento definitivamente?</p>
                <lottie-player autoplay src="assets/lottiefiles/warning.json" style="width: 250px;margin: auto;">
                </lottie-player>
            </div>
            <div class="modal-footer text-right">
                <input type="hidden" id="id_complemento_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_complemento">Confirmar y
                    eliminar</button>
                <button class="btn btn-confi" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>
<?php require_once __VIEWS__ . 'selects/familias.template.php'; ?>
<script>
(function($) {
    'use strict';

    $(function() {

        function reloadMaterialTable() {
            $('#tabla_materiales').DataTable().ajax.reload(null, false);
        }

        function getMateriales(id_material) {
            var result;
            $.ajax({
                url: "./api/materiales2.php",
                type: 'GET',
                dataType: 'json',
                cache: false,
                async: false,
                success: function(data) {
                    data = data.map(function(item) {
                        return {
                            id: item.id_material,
                            text: item.nombre,
                            selected: (item.id_material == id_material)
                        };
                    });
                    data.push({
                        id: 'No',
                        text: 'Ninguno',
                        selected: (id_material == "No")
                    });
                    result = data;
                }
            });
            return result;
        }

        $('.select_materiales').each(function() {
            const $select = $(this);
            const $modal = $select.closest('.modal');

            if ($modal.length) {
                $modal.on('shown.bs.modal', function() {
                    const isPrimary = ($select.data("pri") === undefined);
                    const id = $select.data("edit") ?? "No";

                    if (isPrimary) {
                        reloadSelect($select, id, $modal);
                    } else {
                        $modal.off('shown.bs.modal');
                        $select.data("pri", false);
                    }
                });
            } else {
                reloadSelect($select);
            }
        });

        function reloadSelect($select, id = "No", $modal = "No") {
            $select.empty();
            const config = {
                data: getMateriales(id)
            };
            if ($modal !== "No") config.dropdownParent = $modal;
            $select.select2(config).trigger("change");
        }
        $('#btn_add_material').click(function() {
            const nombre = $('#nombre_material').val().trim();
            const estado = $('#estado_material').val().trim();
            const precio_dia = parseFloat($('#precio_dia_material').val());
            const stock = parseInt($('#stock_material').val());
            const id_familia = ($('#select_familias').val() != "No") ? $('#select_familias').val() :
                ""
            const id_subfamilia = ($('#select_subfamilias').val() != "No") ? $(
                '#select_subfamilias').val() : ""
            var repetido = false

            // Recorrer todos los inputs .verificable dentro del modal
            document.querySelectorAll('#modalAgregarMaterial input.validable').forEach(input => {

                const evento = new CustomEvent('validar', {
                    bubbles: true,
                    detail: {
                        mensaje: 'Campo requerido'
                    }
                });

                // Disparar el evento de validación para cada input
                input.dispatchEvent(evento);

                // Si alguno de los inputs no es válido, marcamos todosValidos como falso
                if (!input.isValid) {
                    repetido = true;
                }
            });

            if (repetido) {

                return false;

            }

            $.post('/api/materiales2.php', {
                nombre,
                estado,
                precio_dia,
                stock,
                id_familia,
                id_subfamilia
            }, function(r) {
                $('#modalAgregarMaterial').modal("hide");
                reloadMaterialTable();
                $('.select_materiales').each(function() {
                    reloadSelect($(this), r.id_material, "No");
                });
                $.toast({
                    heading: 'Material agregado',
                    text: 'Se ha agregado el material correctamente',
                    position: 'top-right',
                    loaderBg: '#32a852',
                    icon: 'success',
                    hideAfter: 2000
                });
            }, 'json');
        });

        $(document).on("click", ".btn_edit_material", function() {
            const id = $(this).data("id");

            $("#btn_edit_material").data("id", id);
            $.ajax({

                url: "./api/materiales2.php?id_material=" + id,

                type: 'GET',

                dataType: 'json', // added data type

                cache: false,

                async: false,

                success: function(material) {
                    $('#select_familias_editar').val((material.id_familia != null) ?
                        material.id_familia : "No").trigger(
                        "change");
                    $('#select_subfamilias_editar').val((material.id_subfamilia !=
                        null) ? material.id_subfamilia : "No").trigger(
                        "change");
                    $('#nombre_material_editar').val(material.nombre);
                    $('#estado_material_editar').val(material.estado);
                    $('#precio_dia_material_editar').val(material.precio_dia);
                    $('#stock_material_editar').val(material.stock);
                    $('#modalEditarMaterial').modal("show");
                }
            });

        });

        $('#btn_edit_material').click(function() {
            const id = $(this).data("id");
            const nombre = $('#nombre_material_editar').val().trim();
            const estado = $('#estado_material_editar').val().trim();
            const precio_dia = parseFloat($('#precio_dia_material_editar').val());
            const stock = parseInt($('#stock_material_editar').val());

            const id_familia = ($('#select_familias_editar').val() != "No") ? $(
                    '#select_familias_editar').val() :
                ""
            const id_subfamilia = ($('#select_subfamilias_editar').val() != "No") ? $(
                '#select_subfamilias_editar').val() : ""
            var repetido = false

            // Recorrer todos los inputs .verificable dentro del modal
            document.querySelectorAll('#modalEditarMaterial input.validable').forEach(input => {

                const evento = new CustomEvent('validar', {
                    bubbles: true,
                    detail: {
                        mensaje: 'Campo requerido'
                    }
                });

                // Disparar el evento de validación para cada input
                input.dispatchEvent(evento);

                // Si alguno de los inputs no es válido, marcamos todosValidos como falso
                if (!input.isValid) {
                    repetido = true;
                }
            });

            if (repetido) {

                return false;

            }

            $.ajax({
                type: 'POST',
                url: '/api/materiales2.php',
                data: {
                    id_material: id,
                    nombre,
                    estado,
                    precio_dia,
                    stock,
                    id_familia,
                    id_subfamilia
                },
                dataType: 'json',
                success: function() {
                    $('#modalEditarMaterial').modal("hide");
                    reloadMaterialTable();
                    $('.select_materiales').each(function() {
                        reloadSelect($(this), id, "No");
                    });
                    $.toast({
                        heading: 'Material actualizado',
                        text: 'Se han guardado los cambios correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000
                    });
                }
            });
        });

        $(document).on("click", ".btn_eliminar_material", function() {
            const target = $(this).data("target");
            const value = $("#" + target).val();
            if (value === "No") return false;
            const id = $(this).data("id");
            $('#id_material_eliminar').val(id);
            $('#modalEliminarMaterial').modal("show");
        });

        $('#btn_eliminar_material').click(function() {
            const id = $('#id_material_eliminar').val();
            $.ajax({
                type: 'DELETE',
                url: '/api/materiales2.php?id=' + id,
                success: function() {
                    $('#modalEliminarMaterial').modal("hide");
                    reloadMaterialTable();
                    $('.select_materiales').each(function() {
                        reloadSelect($(this));
                    });
                    $.toast({
                        heading: 'Material eliminado',
                        text: 'Se ha eliminado el material correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000
                    });
                }
            });
        });

    });

})(jQuery);
</script>

<script>
(function($) {

    'use strict';

    $(function() {
        $(document).on("click", ".btn_complementos_material", function() {
            const id = $(this).data("id");
            reloadComplementosMaterial(id)
            $("#btn_add_complementos_material").data("id", id);
            $('#modalComplementosMaterial').modal("show");

        });
        $('#btn_add_complemento_material').click(function() {
            // Obtener el valor y el texto del extra seleccionado
            var nombre_complemento = $('#nombre_complemento_material').val();
            var cantidad_complemento = $('#cantidad_complemento_material').val();
            var id_material_complemento = $('#btn_add_complementos_material').data("id");


            // Verificar si el extra ya está en la lista
            if (!nombre_complemento || !cantidad_complemento) {
                $.toast({
                    heading: 'Error',
                    text: 'Por favor, completa todos los campos.',
                    position: 'top-right',
                    loaderBg: '#ff6849',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });
                return;
            }
            // Si el extra es un duplicado, mostrar un mensaje
            $.post('/api/materiales2.php', {
                id_material_complemento: id_material_complemento,
                nombre_complemento: nombre_complemento,
                cantidad_complemento: cantidad_complemento
            }, function() {

                reloadComplementosMaterial(id_material_complemento)
                $.toast({
                    heading: 'Complemento agregado.',
                    text: 'El complemento se ha agregado correctamente.',
                    position: 'top-right',
                    loaderBg: '#32a852',
                    icon: 'success',
                    hideAfter: 2000,
                    stack: 6
                });
            });



        });

        function reloadComplementosMaterial(id) {
            $.getJSON('/api/materiales2.php?id_material=' + id + '&_=' + new Date()
                .getTime(),
                function(u) {
                    console.log(u);


                    $('#lista_complementos_material').empty();
                    if (!u.complementos || !Array.isArray(u.complementos)) {
                        $('#lista_complementos_material').append(
                            '<li class="list-group-item">Sin complementos asociados</li>');


                    } else {

                        u.complementos.forEach(function(complemento) {



                            var newItem = $('<li>').addClass(
                                    'p-1 li_complemento d-flex justify-content-between').attr(
                                    'data-id',
                                    complemento
                                    .id_complemento)
                                .append($('<div>').addClass('d-flex align-items-center')
                                    .append(
                                        $('<span>').addClass('mb-0 mr-2').text(complemento
                                            .nombre + ' (X' +
                                            complemento.cantidad + ') ')),
                                    $('<button>').addClass('btn btn-sm btn-danger')
                                    .text('x')
                                    .on('click', function() {
                                        $('#id_complemento_eliminar').val(complemento
                                            .id_complemento);
                                        $('#modalEliminarComplemento').modal("show");

                                    })
                                );




                            $('#lista_complementos_material').append(newItem);

                        });

                    }

                });
        }
        $('#btn_eliminar_complemento').click(function() {
            const id = $('#id_complemento_eliminar').val();
            $.ajax({
                type: 'DELETE',
                url: '/api/materiales2.php?id_complemento=' + id,
                success: function() {
                    var id_evento = $('#btn_add_complementos_material').data("id");
                    reloadComplementosMaterial(id_evento)
                    $('#modalEliminarComplemento').modal("hide");
                    $.toast({
                        heading: 'Complemento eliminado',
                        text: 'Se ha eliminado el complemento correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000
                    });
                }
            });
        });
    });

})(jQuery);
</script>