<div class="modal fade modal-cambiar" id="modalEliminarMarca" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar marca</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar la marca definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_marca_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_marca">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarMarca" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Marca</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">
                            <input class="form-control w-100" id="nombre_marca" type="text">
                        </div>

                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_marca" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
(function($) {
    'use strict';
    $(function() {
        function getData(id_marca) {
            console.log(id_marca);
            var r
            $.ajax({
                url: "./api/marcas.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,

                success: function(data) {

                    data = data.map(function(item) {
                        return {
                            id: item.id_marca,
                            text: item.nombre,
                            selected: (item.id_marca == id_marca) ? true : false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguna',
                        selected: (id_marca == "No") ? true : false
                    });

                    r = data
                }
            });
            return r
        }
        $('.select_marcas').select2({
            data: getData("No")
        }).trigger("change");
        $("#btn_add_marca").click(function() {
            var nombre_marca = $('#nombre_marca').val()
            $.ajax({
                type: 'POST',
                url: './api/marcas.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    nombre: nombre_marca,
                },
                success: function(r) {


                    $('#modalAgregarMarca').modal("hide")
                    $('.select_marcas').empty()
                    $('.select_marcas').select2({
                        data: getData(r.id)
                    }).trigger("change");
                    $.toast({
                        heading: 'Marca agregada.',
                        text: 'Se ha agregado la marca correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    setTimeout(function() {
                        $("#btn_add_marca").removeClass('btn-loading');
                    }, 2000);
                }
            });
        })
        $(document).on("click", ".btn_eliminar_marca", function() {
            var target = $(this).data("target");
            if ($("#" + target).val() == "No") {
                return false;
            } else {


                $("#id_marca_eliminar").val($("#" + target).val())
            }
            $("#modalEliminarMarca").modal("show");
        })
        $('#btn_eliminar_marca').click(function(event) {
            var id_marca_eliminar = $("#id_marca_eliminar").val()
            $.ajax({
                type: 'DELETE',
                url: './api/marcas.php?id=' + id_marca_eliminar,
                cache: false,
                async: false,
                success: function(result) {
                    $('.select_marcas').empty()
                    $('.select_marcas').select2({
                        data: getData("No")
                    }).trigger("change");
                    $('#modalEliminarMarca').modal("hide")
                    $.toast({
                        heading: 'Marca eliminada',
                        text: 'Se ha eliminado la marca correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                }
            });

        });
    });
})(jQuery);
</script>