<div class="modal fade"  id="modalSubirImagen" role="dialog"
    aria-labelledby="exampleModalCenterTitle3">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Cambiar imagen</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">

                <div class="container-lg p-0">
                    <div id="lista_imagenes" class="row">
                        <?php
                        foreach ($Uploads as $Upload) {
                            ?>
                            <div id="imagen_<?php echo $Upload["upload_id"]; ?>"
                                class="col-sm-3 p-2 d-flex justify-content-center align-items-center">
                                <div class="img_lista d-flex justify-content-center align-items-center">
                                    <img class="img-fluid" src="./image.php?id=<?php echo $Upload["upload_name"]; ?>"
                                        alt="">
                                    <button data-url="<?php echo $Upload["upload_name"]; ?>"
                                        data-id="<?php echo $Upload["upload_id"]; ?>" class="p-1 btn_eliminar_imagen btn"
                                        type="button"><i class="m-0 fas fa-trash"></i></button>
                                    <button data-url="<?php echo $Upload["upload_name"]; ?>"
                                        data-id="<?php echo $Upload["upload_id"]; ?>" class="p-1 btn_seleccionar_imagen btn"
                                        type="button"><i class="m-0 fa fa-check"></i></i></button>
                                </div>

                            </div>
                            <?php
                        }

                        ?>
                    </div>





                </div>



            </div>

            <div class="modal-footer text-right">



                <div class="input-group">
                    <input type="file" class="d-none" id="imagen_file">
                    <div class="input-group-append">
                        <label for="imagen_file" class="mb-0 btn btn-success btn-fw" id="btn_subir_imagen"
                            type="button">

                            Subir imagen</label>
                    </div>
                </div>









            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<style>
    .img_lista {
        cursor: pointer;
        transition: all .3s ease;
        position: relative;
        height: 100%;
        width: 100%;
        background: #0000001a;
        box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);
        -webkit-box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);
        -moz-box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);
        aspect-ratio: 1/1;
    }

    .img_lista img {
        object-fit: cover;
        max-height: 200px;
    }

    .img_lista:hover {
        opacity: .5;
        background: #000000;
    }

    .btn_eliminar_imagen {
        cursor: pointer;
        transition: all .3s ease;
        opacity: 0;
        position: absolute;
        right: 0;
        top: 0;
        border-radius: 0px;
    }

    .img_lista:hover .btn_eliminar_imagen {
        opacity: 1;
    }

    .btn_eliminar_imagen i:before {
        transition: all .3s ease;
        font-size: 1.1rem;
        color: #F1635F;
    }

    .btn_eliminar_imagen:hover i:before {
        color: #F1635F;
    }

    .btn_seleccionar_imagen {
        cursor: pointer;
        transition: all .3s ease;
        opacity: 0;
        position: absolute;
        left: 0;
        top: 0;
        border-radius: 0px;
    }

    .img_lista:hover .btn_seleccionar_imagen {
        opacity: 1;
    }

    .btn_seleccionar_imagen i:before {
        transition: all .3s ease;
        font-size: 1.1rem;
        color: #0cca8e;
    }

    .btn_seleccionar_imagen:hover i:before {
        color: #0cca8e;
    }
</style>

<script>
    (function ($) {
        'use strict';

        $(window).on('load', function () {


            $(document).on("click", ".btn_modal_imagenes", function () {
                var target = $(this).data("target");

                $("#imagen_file").data("target", target);


                $("#modalSubirImagen").modal("show");
            });

            $(document).on("click", ".btn_seleccionar_imagen", function () {
                var url = $(this).data("url");
                var target = $("#imagen_file").data("target");

                var baseUrl = window.location.protocol + "//" + window.location.hostname;


                $("#" + target + " img").first().attr("src", baseUrl + "/image.php?id=" + url).trigger(
                    "change");
                $("#" + target + " input").val(baseUrl + "/image.php?id=" + url).trigger("change");
                console.log("#" + target + " input");
                //console.log(baseUrl + "/image.php?id=" + url);
                $("#modalSubirImagen").modal("hide");
            });

            $("#imagen_file").change(function (e) {
                var target = $(this).data("target");
                const imagen = $('#imagen_file')[0].files[0];
                if (imagen.size > 1000000) {
                    $.toast({
                        heading: 'Imágen demasiado pesada.',
                        text: 'La imágen debe pesar menos 1 MB.',
                        position: 'top-right',
                        loaderBg: '#ff5c6c',
                        icon: 'error',
                        hideAfter: 5000,
                        stack: 6
                    });
                    return false
                }
                var fd = new FormData();
                fd.append('imagen', imagen);
                const contenedor = document.getElementById('lista_imagenes');

                // Crear el elemento contenedor de la imagen
                const imagenDiv = document.createElement('div');

                imagenDiv.className =
                    'col-sm-3 p-2 d-flex justify-content-center align-items-center';

                // Crear el elemento contenedor de la imagen y botones
                const imgListaDiv = document.createElement('div');
                imgListaDiv.className =
                    'img_lista d-flex justify-content-center align-items-center';

                // Crear el elemento imagen y agregar atributos
                const imagen_file = document.createElement('img');
                imagen_file.className = 'img-fluid';
                imagen_file.src = './assets/images/oval.svg';
                imagen_file.alt = '';

                // Crear el botón de eliminar imagen y agregar atributos
                const btnEliminar = document.createElement('button');
                btnEliminar.className = 'p-1 btn_eliminar_imagen btn';
                btnEliminar.type = 'button';
                btnEliminar.style.cursor = 'pointer'
                btnEliminar.innerHTML = '<i class="m-0 fas fa-trash"></i>';
                btnEliminar.style.cursor = 'none'
                // Crear el botón de seleccionar imagen y agregar atributos
                const btnSeleccionar = document.createElement('button');
                btnSeleccionar.className = 'p-1 btn_seleccionar_imagen btn';
                btnSeleccionar.type = 'button';

                btnSeleccionar.innerHTML = '<i class="m-0 fa fa-check"></i>';
                btnSeleccionar.style.cursor = 'none'
                // Agregar los elementos hijos al contenedor principal
                imgListaDiv.appendChild(imagen_file);
                imgListaDiv.appendChild(btnEliminar);
                imgListaDiv.appendChild(btnSeleccionar);
                imagenDiv.appendChild(imgListaDiv);
                contenedor.appendChild(imagenDiv);

                $.ajax({
                    url: './api/recursos.php',
                    type: 'POST',
                    data: fd,
                    processData: false, // tell jQuery not to process the data
                    contentType: false, // tell jQuery not to set contentType
                    success: function (result) {

                        var r = JSON.parse(result)
                        imagenDiv.id = 'imagen_' + r.id;
                        imagen_file.src = './image.php?id=' + r.url;
                        btnEliminar.dataset.id = r.id;
                        btnEliminar.dataset.url = r.url;
                        btnSeleccionar.dataset.id = r.id;
                        btnSeleccionar.dataset.url = r.url;
                        btnEliminar.style.cursor = 'pointer'
                        btnSeleccionar.style.cursor = 'pointer'


                        $.toast({
                            heading: 'Nueva imagen subida.',
                            text: 'Se subido la nueva imagen correctamente.',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 4
                        })
                    }
                });

            });
            $(document).on("click", ".btn_eliminar_imagen", function () {
                var id = $(this).data("id");
                var url = $(this).data("url");
                $.ajax({
                    url: "./api/recursos.php?personalizacion=1",
                    type: 'GET',
                    dataType: 'json', // added data type
                    cache: false,
                    async: false,
                    success: function (res) {

                        var nombre_1 = res.imagen_email.split('=')[1];
                        var nombre_2 = res.imagen_email_usuario.split('=')[1];
                        var nombre_3 = res.imagen_admision.split('=')[1];
                        var nombre_4 = res.url_logo_portada.split('=')[1];
                        var nombre_5 = res.url_imagen_portada.split('=')[1];
                        var nombre_6 = res.url_fav_icon.split('=')[1];
                        var nombre_7 = res.url_logo_superior.split('=')[1];
                        var nombre_8 = res.imagen_portada_configuracion.split('=')[1];

                        if (nombre_1 == url || nombre_2 == url || nombre_3 == url ||
                            nombre_4 == url || nombre_5 == url || nombre_6 == url ||
                            nombre_7 == url || nombre_8 == url) {
                            $.toast({
                                heading: 'Imagen en uso.',
                                text: 'La imagen que ha seleccionado esta siendo usada en la plataforma.',
                                position: 'top-right',
                                loaderBg: '#ff5c6c',
                                icon: 'error',
                                hideAfter: 5000,
                                stack: 6
                            });

                        } else {

                            $.ajax({
                                type: "DELETE",
                                url: "./api/recursos.php?id=" + id,
                                cache: false,
                                async: false,
                                success: function (response) {
                                    $("#imagen_" + id).remove()
                                    $.toast({
                                        heading: 'Imagen eliminada.',
                                        text: 'Se eliminado la imagen correctamente.',
                                        position: 'top-right',
                                        loaderBg: '#32a852',
                                        icon: 'success',
                                        hideAfter: 2000,
                                        stack: 4
                                    })
                                }

                            })
                        }



                    }
                });

            });

        });
    })(jQuery);
</script>