<div class="modal fade modal-cambiar" id="modalEliminarIGIC" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar impuesto</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar el impuesto definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>



            <!-- /btn -->



            <div class="modal-footer text-right">





                <input type="hidden" id="id_igic_eliminar">

                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_igic">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade" id="modalAgregarIGIC" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">



    <div class="modal-dialog modal-dialog-centered" role="document">



        <div class="modal-content">



            <div class="modal-header border-none">



                <h4 class="mb-0">Agregar impuesto</h4>



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">



                    <i class="ti-close"></i>



                </button>



            </div>









            <div class="modal-body pb-0">



                <div class="container p-0">



                    <div class="row">



                        <div class="col-12">

                            <div class="input-group">

                                <input class="form-control w-100" id="porcentaje_igic" type="number" step="0.01" min="0"
                                    placeholder="0.00" required>

                                <div class="input-group-append">

                                    <span class="input-group-text">%</span>

                                </div>

                            </div>

                        </div>



                        <div class="col-12 mt-3">

                            <div class="input-group">

                                <div class="input-group-prepend">

                                    <span class="input-group-text">Nombre</span>

                                </div>

                                <input class="form-control w-100" id="nombre_igic" type="text" required>



                            </div>

                        </div>



                    </div>



                </div>







            </div>



            <div class="modal-footer text-right">







                <button id="btn_add_igic" class="btn btn-success btn-fw" type="button">



                    Agregar</button>



                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">



                    Cancelar </button>











            </div>







            <!-- /modal-body -->



        </div>



    </div>



</div>

<script>
(function($) {

    'use strict';

    $(function() {

        function getData(id_igic) {



            var r

            $.ajax({

                url: "./api/igic.php",

                type: 'GET',

                dataType: 'json', // added data type

                cache: false,

                async: false,



                success: function(data) {



                    data = data.map(function(item) {

                        return {

                            id: item.id_igic,

                            text: item.porcentaje + '% (' + item.nombre + ')',

                            porcentaje: item.porcentaje,

                            selected: (item.id_igic == id_igic) ? true : false

                        };

                    })

                    data.push({

                        id: 'No',

                        text: '0.00%',

                        porcentaje: 0.00,

                        selected: (id_igic == "No") ? true : false

                    });



                    r = data

                }

            });

            console.log(r);

            return r

        }

        /*   $('.select_igic').select2({

            data: getData("No")

        }).on("select2:open", function() {

            // Set data-porcentaje attribute for all options

            $(".select_igic option").each(function() {

                var data = $(this).data();

                $(this).data('porcentaje', data.data.porcentaje);



            });

        }).trigger("change");

*/

        function initializeSelect2(callback, id = "No") {

            var data = getData(id);



            $('.select_igic').select2({

                data: data

            }).on('select2:open', function() {



                data.forEach(item => {

                    $(`.select_igic option[value='${item.id}']`).data('porcentaje',

                        item.porcentaje);

                    console.log($(`.select_igic option[value='${item.id}']`).data(

                        'porcentaje'))

                });

                if (typeof callback === 'function') {

                    callback();

                }

            });



            // Trigger the event manually to set the data attributes initially

            $('.select_igic').trigger('select2:open');

            $('.select_igic').trigger('change');

        }

        initializeSelect2(function() {

            console.log("Select2 options have been loaded and data attributes are set.");

            // Your callback logic here

        });

        $("#btn_add_igic").click(function() {

            var porcentaje_igic = $('#porcentaje_igic').val();

            var nombre_igic = $('#nombre_igic').val();



            if (parseFloat(porcentaje_igic).toFixed(2) == "0.00") {

                $.toast({

                    heading: 'El porcentaje no puede ser 0.00%',

                    text: 'Por favor ingresa un porcentaje mayor que 0.00%.',

                    position: 'top-right',

                    loaderBg: '#ff5e5e',

                    icon: 'error',

                    hideAfter: 2000,

                    stack: 6

                });

                return false

            }

            $.ajax({

                type: 'POST',

                url: './api/igic.php',

                cache: false,

                async: false,

                dataType: "json",

                data: {

                    porcentaje: porcentaje_igic,

                    nombre: nombre_igic,

                },

                success: function(r) {

                    $('#modalAgregarIGIC').modal("hide");

                    $('.select_igic').empty();

                    initializeSelect2(function() {

                        console.log(

                            "Select2 options have been loaded and data attributes are set."

                        );

                        // Your callback logic here

                    }, r.id);

                    $.toast({

                        heading: 'Impuesto agregado.',

                        text: 'Se ha agregado el impuesto correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    });

                    $('#porcentaje_igic').val("")

                },

                error: function(xhr, status, error) {

                    if (xhr.status === 409) {

                        $.toast({

                            heading: 'El porcentaje ya existe',

                            text: 'Por favor ingresa un porcentaje único.',

                            position: 'top-right',

                            loaderBg: '#ff5e5e',

                            icon: 'error',

                            hideAfter: 2000,

                            stack: 6

                        });

                    } else {

                        $.toast({

                            heading: 'Error',

                            text: 'Ha ocurrido un error. Por favor intente de nuevo.',

                            position: 'top-right',

                            loaderBg: '#ff5e5e',

                            icon: 'error',

                            hideAfter: 2000,

                            stack: 6

                        });

                    }

                    $('#porcentaje_igic').val("")

                }

            });

        });



        $(document).on("click", ".btn_eliminar_igic", function() {

            var target = $(this).data("target");

            if ($("#" + target).val() == "No") {

                return false;

            } else {





                $("#id_igic_eliminar").val($("#" + target).val())

            }

            $("#modalEliminarIGIC").modal("show");

        })

        $('#btn_eliminar_igic').click(function(event) {

            var id_igic_eliminar = $("#id_igic_eliminar").val()

            $.ajax({

                type: 'DELETE',

                url: './api/igic.php?id=' + id_igic_eliminar,

                cache: false,

                async: false,

                success: function(result) {

                    $('.select_igic').empty()

                    initializeSelect2(function() {

                        console.log(

                            "Select2 options have been loaded and data attributes are set."

                        );

                        // Your callback logic here

                    });

                    $('#modalEliminarIGIC').modal("hide")

                    $.toast({

                        heading: 'Impuesto eliminado',

                        text: 'Se ha eliminado el impuesto correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })

                }

            });



        });

    });

})(jQuery);
</script>