<div class="modal fade modal-cambiar" id="modalEliminarGrupo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar grupo</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el grupo definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_grupo_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_grupo">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarGrupo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Grupo</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">
                            <input class="form-control w-100" id="nombre_grupo" type="text">
                        </div>

                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_grupo" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
(function($) {
    'use strict';
    $(function() {
        $("#btn_add_grupo").click(function() {
            var nombre_grupo = $('#nombre_grupo').val()
            $.ajax({
                type: 'POST',
                url: './api/grupos2.php',
                cache: false,
                async: false,
                dataType: 'json',
                data: {
                    nombre: nombre_grupo,
                },
                success: function(result) {
                    var r = result
                    console.log(r);
                    if (r == 0) {
                        $.toast({
                            heading: 'Nombre repetido.',
                            text: 'Elije otro nombre.',
                            position: 'top-right',
                            loaderBg: '#c21011',
                            icon: 'error',
                            hideAfter: 2000,
                            stack: 6
                        });
                        return false;
                    }
                    $('#modalAgregarGrupo').modal("hide")
                    $(".select_grupos").each(
                        function() {
                            $(this).append(
                                    '<option value="' +
                                    r.id + '">' +
                                    nombre_grupo +
                                    '</option>'
                                ).val(r.id)
                                .trigger("change");
                        })
                    $.toast({
                        heading: 'Grupo agregado.',
                        text: 'Se ha agregado el grupo correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    setTimeout(function() {
                        $("#btn_add_grupo").removeClass('btn-loading');
                    }, 2000);
                }
            });
        })
        $(document).on("click", ".btn_eliminar_grupo", function() {

            var target = $(this).data("target");

            $("#id_grupo_eliminar").val($("#" + target).val())
            $("#modalEliminarGrupo").modal("show");
        })
        $('#btn_eliminar_grupo').click(function(event) {
            var id_grupo_eliminar = $("#id_grupo_eliminar").val()
            $.ajax({
                type: 'DELETE',
                url: './api/grupos.php?id=' + id_grupo_eliminar,
                cache: false,
                success: function(result) {
                    $(".select_grupos").each(function() {
                        $(this).find("option[value='" +
                                id_grupo_eliminar + "']").remove()
                            .trigger(
                                "change");
                    })
                    $('#modalEliminarGrupo').modal("hide")
                    $.toast({
                        heading: 'Grupo eliminado',
                        text: 'Se ha eliminado el grupo correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                }
            });
            return false;
        });
    });
})(jQuery);
</script>