<div class="modal fade modal-cambiar" id="modalEditarGrupos" role="dialog" aria-labelledby="exampleModalCenterTitle">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Editar grupos</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->

                <div class="row">

                    <div class="col-12">
                        <div class="form-group">
                            <label for="my-input">Grupos</label>
                            <div class="input-group">
                                <span class="input-group-prepend">
                                    <button class="btn_eliminar_grupo file-upload-browse btn btn-danger"
                                        data-target="select_grupos" type="button">-</button>
                                </span>
                                <select id="select_grupos" class="select_grupos custom-select select2 form-control">


                                </select>
                                <span class="input-group-append">
                                    <button class="file-upload-browse btn btn-info" type="button" data-toggle="modal"
                                        data-target="#modalAgregarGrupo">+</button>
                                </span>

                            </div>
                        </div>
                    </div>


                    <div class="col-6">

                        <h5 class="mb-3">Selecciona los clientes para añadirlos al grupo</h5>
                        <div class="row">
                            <div class="col-12 mb-3">
                                <button type="button" class="mr-1 btn btn-success"
                                    id="btn_marcar_todos_grupo_si">Seleccionar
                                    todos</button>
                                <button type="button" class="btn btn-danger"
                                    id="btn_desmarcar_todos_grupo_si">Deseleccionar
                                    todos</button>


                            </div>
                        </div>
                        <div class="table-responsive mb-3">
                            <table style="min-height:120px;" id="tabla_clientes_agregar" cellspacing="0"
                                class="tabla_clientes table display nowrap">

                                <thead>

                                    <tr>
                                        <th style="padding-left: 32px !important;padding-right: 50px !important;">
                                            Código</th>

                                        <th>Nombre</th>



                                        <th style="text-align:center;">Acciones</th>


                                    </tr>

                                </thead>

                                <tbody>



                                </tbody>

                            </table>
                        </div>




                        <a id="select-all" class="float-right btn btn-success" href="#">Agregar seleccionados</a>



                    </div>
                    <div class="col-6">
                        <h5 class="mb-3">Selecciona los clientes para eliminarlos del grupo</h5>
                        <div class="row">
                            <div class="col-12 mb-3">
                                <button type="button" class="mr-1 btn btn-success"
                                    id="btn_marcar_todos_grupo_no">Seleccionar
                                    todos</button>
                                <button type="button" class="btn btn-danger"
                                    id="btn_desmarcar_todos_grupo_no">Deseleccionar
                                    todos</button>


                            </div>
                        </div>
                        <div class="table-responsive mbno">
                            <table style="min-height:120px;" id="tabla_clientes_eliminar" cellspacing="0"
                                class="tabla_clientes table display nowrap">

                                <thead>

                                    <tr>
                                        <th style="padding-left: 32px !important;padding-right: 50px !important;">
                                            Código</th>

                                        <th>Nombre</th>



                                        <th style="text-align:center;">Acciones</th>


                                    </tr>

                                </thead>

                                <tbody>



                                </tbody>

                            </table>
                        </div>

                        <a id="deselect-all" class="btn btn-danger" href="#">Eliminar seleccionados</a>
                    </div>

                </div>








            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">




                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>


<div class="modal fade modal-cambiar" id="modalEliminarGrupo" role="dialog" aria-labelledby="exampleModalCenterTitle">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar grupo</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar el grupo definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>



            <!-- /btn -->



            <div class="modal-footer text-right">





                <input type="hidden" id="id_eliminar">

                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_grupo">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade modal-cambiar" id="modalAgregarGrupo" role="dialog" aria-labelledby="exampleModalCenterTitle">



    <div class="modal-dialog modal-dialog-centered" role="document">



        <div class="modal-content">



            <div class="modal-header border-none">



                <h4 class="mb-0">Agregar grupo</h4>



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">



                    <i class="ti-close"></i>



                </button>



            </div>









            <div class="modal-body pb-0">



                <div class="container p-0">



                    <div class="row">



                        <div class="col-12">

                            <input class="form-control w-100" id="nombre_grupo" type="text">

                        </div>



                    </div>



                </div>







            </div>



            <div class="modal-footer text-right">







                <button id="btn_add_grupo" class="btn btn-success btn-fw" type="button">



                    Agregar</button>



                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">



                    Cancelar </button>











            </div>







            <!-- /modal-body -->



        </div>



    </div>



</div>


<script>
(function($) {

    'use strict';

    $(function() {

        function getData(id) {

            console.log(id);

            var r

            $.ajax({

                url: "./api/grupos.php",

                type: 'GET',

                dataType: 'json', // added data type

                cache: false,

                async: false,



                success: function(data) {



                    data = data.map(function(item) {

                        return {

                            id: item.id_grupo,

                            text: item.nombre,

                            selected: (item.id_grupo == id) ? true : false

                        };

                    })

                    data.push({

                        id: 'No',

                        text: 'Ninguno',

                        selected: (id == "No") ? true : false

                    });



                    r = data

                }

            });

            return r

        }

        $('.select_grupos').each(function() {

            var $select = $(this);

            if ($select.closest('.modal').length) {



                var $mod = $select.closest('.modal')





                $mod.on('shown.bs.modal', function() {



                    var pri = ($select.data("pri") === undefined)

                    var edit = ($select.data("edit") === undefined) ? "No" : $select.data(

                        "edit")

                    if (pri) {

                        reload($select, edit, $mod)

                    } else {

                        $mod.off('shown.bs.modal'); // Elimina el evento si no es pri

                        $select.data("pri", false)

                    }



                })





            } else {



                reload($select)

            }



        });



        function reload($select, $id = "No", $mod = "No") {

            $select.empty()



            if ($mod == "No") {



                $select.select2({

                    data: getData($id)

                }).trigger("change");



            } else {

                $select.select2({

                    data: getData($id),

                    dropdownParent: $mod

                }).trigger("change");

                console.log("aca");



            }

        }

        $("#btn_add_grupo").click(function() {

            var nombre_grupo = $('#nombre_grupo').val()

            $.ajax({

                type: 'POST',

                url: './api/grupos.php',

                cache: false,

                async: false,

                dataType: "json",

                data: {

                    nombre: nombre_grupo,

                },

                success: function(r) {





                    $('#modalAgregarGrupo').modal("hide")



                    $('.select_grupos').each(function(params) {

                        reload($(this), r.id, "No")

                    })

                    $.toast({

                        heading: 'Grupo agregado.',

                        text: 'Se ha agregado el grupo correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    });

                    setTimeout(function() {

                        $("#btn_add_grupo").removeClass('btn-loading');

                    }, 2000);

                }

            });

        })

        $(document).on("click", ".btn_eliminar_grupo", function() {

            var target = $(this).data("target");

            if ($("#" + target).val() == "No") {

                return false;

            } else {





                $("#id_eliminar").val($("#" + target).val())

            }

            $("#modalEliminarGrupo").modal("show");

        })

        $('#btn_eliminar_grupo').click(function(event) {

            var id_eliminar = $("#id_eliminar").val()

            $.ajax({

                type: 'DELETE',

                url: './api/grupos.php?id=' + id_eliminar,

                cache: false,

                async: false,

                success: function(result) {

                    $('.select_grupos').each(function(params) {

                        reload($(this))

                    })

                    $('#modalEliminarGrupo').modal("hide")

                    $.toast({

                        heading: 'Grupo eliminado',

                        text: 'Se ha eliminado el grupo correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })

                }

            });



        });

    });

})(jQuery);
</script>


<script>
(function($) {

    'use strict';

    $(function() {

        $('#tabla_clientes_agregar').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "aLengthMenu": [
                [5, 10, 25, 50, 100],
                [5, 10, 25, 50, 100]
            ],
            "iDisplayLength": 5,
            "language": {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_",
                infoEmpty: "Mostrando 0 a 0 de 0",
                infoFiltered: "(Filtrado de _MAX_)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                // loadingRecords: "Cargando...",
                zeroRecords: "Ningún resultado.",

                processing: "Cargando...",
                loadingRecords: "",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: ">",
                    previous: "<"
                }
            },
            "stateSave": true,
            "stateSaveCallback": function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
            },
            "stateLoadCallback": function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [

                {
                    extend: 'colvis',
                    text: 'Ocultar Columnas',
                    collectionLayout: 'fixed two-column',
                    className: "form-control"
                }
            ],
            "searching": true,

            "initComplete": function() {

            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": true,
            "ajax": {
                "url": "./ServerSide/serversideClientes.php",
                "data": function(d) {
                    // Agregar parámetros adicionales a la solicitud aquí
                    d.id_grupo_no = $("#select_grupos").val();
                    d.estado_cliente = $("#btn_editar_grupos").data("tipo");

                },
                dataSrc: function(json) {

                    console.log(json);
                    return json.data;
                },
                "error": function(xhr, error, thrown) {
                    // Manejo de errores
                    alert('Error en la carga de datos: ' + thrown);
                }
            },


            "columns": [{
                    "data": "codigo",
                    "render": function(data, type, row, meta) {
                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +
                            data + '</span>';
                    }
                },
                {
                    "data": "nombre"
                },
                {
                    "data": "client_id",
                    "render": function(data, type, row, meta) {

                        const checkboxContainer = document.createElement("label");
                        checkboxContainer.classList.add("custom-control", "custom-checkbox",
                            "d-inline-block");

                        // Crear el elemento checkbox
                        const checkbox = document.createElement("input");
                        checkbox.type = "checkbox";
                        checkbox.setAttribute("data-id", data);
                        checkbox.classList.add("custom-control-input");
                        checkbox.classList.add("agregar_cliente");
                        checkbox.style.fontSize = "18px"
                        // Opción 1: Usar el atributo "checked"




                        // Crear el elemento span para la etiqueta
                        const labelSpan = document.createElement("span");

                        labelSpan.classList.add("custom-control-label");
                        labelSpan.textContent = "Agregar";

                        // Agregar el checkbox y el span al contenedor
                        checkboxContainer.appendChild(checkbox);
                        checkboxContainer.appendChild(labelSpan);

                        return checkboxContainer.outerHTML;
                    }
                }
            ]
        });
        $('#tabla_clientes_eliminar').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            "aLengthMenu": [
                [5, 10, 25, 50, 100],
                [5, 10, 25, 50, 100]
            ],
            "iDisplayLength": 5,
            "language": {
                search: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_",
                infoEmpty: "Mostrando 0 a 0 de 0",
                infoFiltered: "(Filtrado de _MAX_)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Mostrar _MENU_ Entradas",
                // loadingRecords: "Cargando...",
                zeroRecords: "Ningún resultado.",

                processing: "Cargando...",
                loadingRecords: "",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: ">",
                    previous: "<"
                }
            },
            "stateSave": true,
            "stateSaveCallback": function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data))
            },
            "stateLoadCallback": function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance))
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [

                {
                    extend: 'colvis',
                    text: 'Ocultar Columnas',
                    collectionLayout: 'fixed two-column',
                    className: "form-control"
                }
            ],
            "searching": true,

            "initComplete": function() {

            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": true,
            "ajax": {
                "url": "./ServerSide/serversideClientes.php",
                "data": function(d) {
                    // Agregar parámetros adicionales a la solicitud aquí
                    d.id_grupo = $("#select_grupos").val();
                    d.estado_cliente = $("#btn_editar_grupos").data("tipo");
                },
                dataSrc: function(json) {

                    console.log(json);
                    return json.data;
                },
                "error": function(xhr, error, thrown) {
                    // Manejo de errores
                    alert('Error en la carga de datos: ' + thrown);
                }
            },


            "columns": [{
                    "data": "codigo",
                    "render": function(data, type, row, meta) {
                        return '<span style="padding-left: 32px !important;padding-right: 50px !important;">' +
                            data + '</span>';
                    }
                },
                {
                    "data": "nombre"
                },
                {
                    "data": "client_id",
                    "render": function(data, type, row, meta) {

                        const checkboxContainer = document.createElement("label");
                        checkboxContainer.classList.add("custom-control", "custom-checkbox",
                            "d-inline-block");

                        // Crear el elemento checkbox
                        const checkbox = document.createElement("input");
                        checkbox.type = "checkbox";
                        checkbox.setAttribute("data-id", data);
                        checkbox.classList.add("custom-control-input");
                        checkbox.classList.add("eliminar_cliente");
                        checkbox.style.fontSize = "18px"
                        // Opción 1: Usar el atributo "checked"




                        // Crear el elemento span para la etiqueta
                        const labelSpan = document.createElement("span");

                        labelSpan.classList.add("custom-control-label");
                        labelSpan.textContent = "Eliminar";

                        // Agregar el checkbox y el span al contenedor
                        checkboxContainer.appendChild(checkbox);
                        checkboxContainer.appendChild(labelSpan);

                        return checkboxContainer.outerHTML;
                    }
                }
            ]
        });



        function AgregarAGrupo(client_ids, id_grupo) {
            $.ajax({
                url: "./api/grupos.php",
                type: 'POST',
                dataType: 'json',
                cache: false,
                async: false,
                data: {
                    id_grupo_agregar: id_grupo,
                    client_ids_agregar: JSON.stringify(client_ids) // Convertimos el array a JSON
                },
                success: function(res) {
                    console.log(res);
                    if (res != 0) {
                        $.toast({
                            heading: 'Clientes agregados al grupo',
                            text: 'Se han agregado los clientes correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });
                        $('.tabla_clientes').DataTable().ajax.reload(null, false);
                    }
                }
            });
        }

        $('#select-all').on('click', function() {
            var clients_id = []
            var id_grupo = $("#select_grupos").val()
            var values = $('#public-methods').val();

            $('.agregar_cliente').each(function() {
                console.log($(this).is(":checked"));
                if ($(this).is(":checked")) {
                    clients_id.push($(this).data("id"))
                }

            })
            console.log(clients_id);
            AgregarAGrupo(clients_id, id_grupo)

        })

        function SacarDeGrupo(client_ids, id_grupo) {
            $.ajax({
                url: "./api/grupos.php",
                type: 'POST',
                dataType: 'json',
                cache: false,
                async: false,
                data: {

                    id_grupo_remover: id_grupo,
                    client_ids_remover: JSON.stringify(client_ids)
                },
                success: function(res) {
                    console.log(res);
                    if (res != 0) {
                        $.toast({
                            heading: 'Clientes eliminados del grupo',
                            text: 'Se han eliminado los clientes correctamente',
                            position: 'top-right',
                            loaderBg: '#dc3545',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });
                        $('.tabla_clientes').DataTable().ajax.reload(null, false);
                    } else {
                        $.toast({
                            heading: 'Error',
                            text: res.error ||
                                'Error al eliminar los clientes del grupo',
                            position: 'top-right',
                            loaderBg: '#dc3545',
                            icon: 'error',
                            hideAfter: 2000,
                            stack: 6
                        });
                    }
                }
            });
        }

        $('#deselect-all').on('click', function() {
            var clients_id = []
            var id_grupo = $("#select_grupos").val()
            var values = $('#public-methods').val();

            $('.eliminar_cliente').each(function() {

                if ($(this).is(":checked")) {
                    clients_id.push($(this).data("id"))
                }

            })
            console.log(clients_id);
            SacarDeGrupo(clients_id, id_grupo)

        })
        $("#select_grupos").change(function(e) {
            //$('.tabla_clientes').DataTable().ajax.reload(null, false);
            $('#tabla_clientes_eliminar').DataTable().ajax.reload(null, false);
            $('#tabla_clientes_agregar').DataTable().ajax.reload(null, false);
        });
        $("#btn_marcar_todos_grupo_si").click(function(e) {

            $('.agregar_cliente').prop("checked", true);
        });
        $("#btn_desmarcar_todos_grupo_si").click(function(e) {

            $('.agregar_cliente').prop("checked", false);
        });

        $("#btn_marcar_todos_grupo_no").click(function(e) {

            $('.eliminar_cliente').prop("checked", true);
        });
        $("#btn_desmarcar_todos_grupo_no").click(function(e) {

            $('.eliminar_cliente').prop("checked", false);
        });
    });

})(jQuery);
</script>