<div class="modal fade" id="modalAgregarFinanciera" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Agregar financiera</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="container p-0">
                    <div class="row">




                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Nombre</label>
                                <input type="text" class="form-control" id="nombre_financiera">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Teléfono</label>
                                <input type="text" class="form-control" id="telefono_financiera">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Email</label>
                                <input type="text" class="form-control" id="email_financiera">
                            </div>
                        </div>
                        <div class="col-12 text-right mb-3">
                            <button id="btn_add_financiera" class="btn btn-success btn-fw" type="button">
                                Agregar</button>
                        </div>
                    </div>
                    <div class="row ">
                        <div class="col-12">
                            <div class="table-responsive">

                                <table id="tabla_financieras" class="table">

                                    <thead>

                                        <tr>

                                            <th style="padding-left: 32px !important;padding-right: 50px !important;">
                                                ID</th>

                                            <th>Nombre</th>

                                            <th>Teléfono</th>

                                            <th>Email</th>



                                            <th style="text-align:center;">Acciones</th>

                                        </tr>

                                    </thead>

                                    <tbody>



                                    </tbody>

                                </table>

                            </div>
                        </div>

                    </div>
                </div>


            </div>
            <div class="modal-footer text-right">

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>
            </div>
            <!-- /modal-body -->
        </div>

    </div>

</div>
<div class="modal fade" id="modalEditarFinanciera" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Editar financiera</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="container p-0">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Nombre</label>
                                <input type="text" class="form-control" id="nombre_financiera_editar">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Teléfono</label>
                                <input type="text" class="form-control" id="telefono_financiera_editar">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Email</label>
                                <input type="text" class="form-control" id="email_financiera_editar">
                            </div>
                        </div>

                    </div>

                </div>


            </div>
            <div class="modal-footer text-right">
                <button id="btn_edit_financiera" class="btn btn-success btn-fw" type="button">
                    Editar</button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>
            </div>
            <!-- /modal-body -->
        </div>

    </div>

</div>
<div class="modal fade modal-cambiar" id="modalEliminarFinanciera" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar financiera</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el financiera definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_financiera_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_financiera">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade modal-cambiar" id="modalConfigurar" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Configurar</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->
                <div class="row">
                    <div class="col-12">
                        <h4 class="mb-2">Envío de notificaciones</h4>
                    </div>
                    <div class="col-lg-6">
                        <h5 class="mb-2">Método de envío</h5>
                        <div class="d-flex flex-row justify-content-between align-items-center mb-3">

                            <div class="form-check form-check-inline d-flex m-0">
                                <input value="sms" class="form-check-input valor_personalizacion" type="radio"
                                    name="envio" <?php
    if (htmlentities($personalizacion['metodo_envio_financiacion'], ENT_QUOTES) == "sms") {
        echo "checked";
    }
    ?> data-nombre="metodo_envio_financiacion">
                                <label class="p-0 form-check-label" for="inlineCheckbox1">SMS</label>

                            </div>
                            <div class="form-check form-check-inline d-flex m-0">
                                <input value="email" class="form-check-input valor_personalizacion" type="radio"
                                    name="envio" <?php
    if (htmlentities($personalizacion['metodo_envio_financiacion'], ENT_QUOTES) == "email") {
        echo "checked";
    }
    ?> data-nombre="metodo_envio_financiacion">
                                <label class="p-0 form-check-label" for="inlineCheckbox1">Email</label>

                            </div>
                            <div class="form-check form-check-inline d-flex m-0">
                                <input value="emailsinosms" class="form-check-input valor_personalizacion" type="radio"
                                    name="envio" <?php
        if (htmlentities($personalizacion['metodo_envio_financiacion'], ENT_QUOTES) == "emailsinosms") {
            echo "checked";
        }
        ?> data-nombre="metodo_envio_financiacion">
                                <label class="p-0 form-check-label" for="inlineCheckbox2">Email y si no se puede
                                    SMS</label>
                            </div>


                        </div>
                    </div>
                    <div class="col-lg-6">
                        <h5 class="mb-2">Plazo de antelación</h5>
                        <div class="mb-3 d-flex flex-row justify content start align-items-center">
                            <p class="mb-0 mr-2">Notificar el vencimiento de la financiación previo a:</p>
                            <input style="width: 100px" class="form-control valor_personalizacion" type="text"
                                data-nombre="dias_envio_financiacion"
                                value="<?php echo htmlentities($personalizacion['dias_envio_financiacion'], ENT_QUOTES); ?>">
                            <p class="ml-2 mb-0">días.</p>
                        </div>
                    </div>
                </div>





                <div class="row">
                    <div class="col-12">
                        <h4 class="mb-2">Email</h4>
                    </div>
                    <div class="col-lg-6">

                        <div class="form-group">
                            <h5>Asunto</h5>
                            <input id="asunto" class="form-control valor_personalizacion" type="text"
                                data-nombre="asunto_email_financiacion"
                                value="<?php echo htmlentities($personalizacion['asunto_email_financiacion'], ENT_QUOTES); ?>">
                        </div>
                        <h5 class="mb-2">Tags</h5>
                        <div style="flex-wrap: wrap;"
                            class="mb-1 d-flex flex-row justify content start align-items-end">
                            <button class="btn btn-success btn-fw mb-2 mr-2 tag_button" type="button" data-tag="nombre">
                                %nombre%</button>
                            <button class="btn btn-success btn-fw mb-2 mr-2 tag_button" type="button" data-tag="marca">
                                %marca%</button>
                            <button class="btn btn-success btn-fw mb-2 mr-2 tag_button" type="button" data-tag="modelo">
                                %modelo%</button>
                            <button class="btn btn-success btn-fw mb-2 mr-2 tag_button" type="button"
                                data-tag="matricula">
                                %matricula%</button>
                            <button class="btn btn-success btn-fw mb-2 mr-2 tag_button" type="button"
                                data-tag="nombreyapellido">
                                %nombreyapellido%</button>
                            <button class="btn btn-success btn-fw mb-2 mr-2 tag_button" type="button"
                                data-tag="fechadevencimiento">
                                %fechadevencimiento%</button>
                            <button class="btn btn-success btn-fw mb-2 mr-2 tag_button" type="button"
                                data-tag="fechadehoy">
                                %fechadehoy%</button>
                        </div>


                    </div>
                    <div class="col-lg-6">
                        <div class="form-group">
                            <h5>Cuerpo</h5>
                            <textarea id="cuerpo" class="form-control valor_personalizacion"
                                data-nombre="cuerpo_email_financiacion"><?php echo htmlentities($personalizacion['cuerpo_email_financiacion'], ENT_QUOTES); ?></textarea>

                        </div>

                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <h4 class="mb-2">SMS</h4>
                    </div>
                    <div class="col-lg-6 mb-1 mb-lg-0">
                        <h5 class="mb-2">Tags</h5>
                        <div style="flex-wrap: wrap;"
                            class="mb-0 d-flex flex-row justify content start align-items-end">
                            <button class="btn btn-success btn-fw mb-2 mr-2 tag_button_sms" type="button"
                                data-tag="nombre">
                                %nombre%</button>
                            <button class="btn btn-success btn-fw mb-2 mr-2 tag_button_sms" type="button"
                                data-tag="marca">
                                %marca%</button>
                            <button class="btn btn-success btn-fw mb-2 mr-2 tag_button_sms" type="button"
                                data-tag="modelo">
                                %modelo%</button>
                            <button class="btn btn-success btn-fw mb-2 mr-2 tag_button_sms" type="button"
                                data-tag="matricula">
                                %matricula%</button>
                            <button class="btn btn-success btn-fw mb-2 mr-2 tag_button_sms" type="button"
                                data-tag="nombreyapellido">
                                %nombreyapellido%</button>
                            <button class="btn btn-success btn-fw mb-2 mr-2 tag_button_sms" type="button"
                                data-tag="fechadevencimiento">
                                %fechadevencimiento%</button>
                            <button class="btn btn-success btn-fw mb-2 mr-2 tag_button_sms" type="button"
                                data-tag="fechadehoy">
                                %fechadehoy%</button>
                        </div>
                    </div>
                    <div class="col-lg-6 mb-0">
                        <div class="form-group mb-0">
                            <h5>Cuerpo</h5>
                            <textarea id="cuerpo_sms" class="form-control valor_personalizacion"
                                data-nombre="cuerpo_sms_financiacion"><?php echo html_entity_decode($personalizacion['cuerpo_sms_financiacion']); ?></textarea>
                        </div>
                    </div>

                </div>










            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>

<style>
/* Estilo del botón */
textarea#cuerpo_sms {
    height: 100% !important;
    min-height: 110px !important;
}

.btn_guardar_mce,
#btn_guardar_mce {

    /* Restablece todos los estilos heredados */
    background-color: #0cca8e !important;
    color: white;
    border: none;
    padding: .56rem 1.375rem !important;
    cursor: pointer;
    margin-top: 10px;
    /* Para dar espacio encima del botón */
}

.btn_guardar_mce:hover,
#btn_guardar_mce:hover {
    background-color: #0aa675 !important;
}

#mceu_41.mce-statusbar.mce-container {
    text-align: right !important;
}
</style>

<style>
#tabla_financieras {
    visibility: hidden;
}
</style>
<script>
(function($) {
    'use strict';
    $(function() {

        var Table = $('#tabla_financieras').DataTable({
            "responsive": true,
            "dom": 'Blfrtip',
            'autoWidth': true,
            "lengthMenu": [
                [5, 10, 15, -1],
                [5, 10, 15, "Todos"]
            ],
            "iDisplayLength": 10,
            "language": {
                search: "",
                searchPlaceholder: "Buscar",
                emptyTable: "No hay información",
                info: "Mostrando _START_ a _END_ de _TOTAL_",
                infoEmpty: "Mostrando 0 a 0 de 0",
                infoFiltered: "(Filtrado de _MAX_ total)",
                infoPostFix: "",
                thousands: ",",
                lengthMenu: "Ver _MENU_",
                loadingRecords: "Cargando...",
                processing: "Procesando...",

                zeroRecords: "Sin resultados encontrados",
                paginate: {
                    first: "Primero",
                    last: "Ultimo",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            "order": [
                [0, "desc"]
            ],
            "buttons": [

                {
                    extend: 'colvis',
                    text: 'Ocultar Columnas',
                    collectionLayout: 'fixed two-column',
                    className: "form-control"
                }
            ],
            "searching": true,
            "ajax": {
                url: '/api/financieras.php', // Ruta que devuelve los datos de los apartados
                method: 'GET',
                dataSrc: function(data) {
                    console.log(data);


                    return data;
                } // La propiedad que contiene los datos en la respuesta del servidor
            },

            "initComplete": function() {
                // Renderizar la tabla una vez que los datos se hayan cargado

                //$('#tabla_financieras').show();
            },
            "processing": true, // Mostrar el indicador de procesamiento
            "serverSide": false,
            "columns": [{
                    "data": "id_financiera"

                },
                {
                    "data": "nombre"
                },
                {
                    "data": "telefono"
                },
                {
                    "data": "email"
                },


                {
                    "data": "id_financiera",
                    "render": function(data, type, row) {
                        var td = document.createElement('td');
                        td.className = 'table-dropdown';
                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');
                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');
                        link.className = 'dropdown-toggle d-flex align-items-center';
                        link.id = 'UserDropdown';
                        link.href = '#';
                        link.setAttribute('data-toggle', 'dropdown');
                        link.setAttribute('aria-expanded', 'false');
                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');
                        dropdownMenu.className =
                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';
                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');



                        var buttonEditar = document.createElement('button');
                        buttonEditar.className = 'btn_edit_financiera p-1 dropdown-item';
                        buttonEditar.setAttribute('type', 'button');
                        buttonEditar.setAttribute('data-id', data);
                        buttonEditar.innerHTML = `
                    <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Editar
                    
                `;

                        var buttonEliminar = document.createElement('button');
                        buttonEliminar.className =
                            'btn_eliminar_financiera p-1 dropdown-item';
                        buttonEliminar.setAttribute('type', 'button');
                        buttonEliminar.setAttribute('data-id', data);
                        buttonEliminar.innerHTML = `
                    <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>
                    Eliminar
                `;


                        dropdownMenu.appendChild(buttonEditar);
                        dropdownMenu.appendChild(buttonEliminar);

                        divDropdown.appendChild(link);
                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;
                    }
                }
            ]

        });
        $(document).on("click", ".tag_button", function() {
            var tag = $(this).data("tag")
            $("#btn_edit_financiera").data("id", $(this).data("id"))
            var d = tinymce.get('cuerpo').getContent({
                format: 'html'
            }) + "%" + tag + "%"

            tinymce.get('cuerpo').setContent(d);
        });
        $('#modalAgregarFinanciera').on('shown.bs.modal', function(e) {
            $('#tabla_financieras').css('visibility', 'visible');
            $("#tabla_financieras").DataTable()
                .columns.adjust()

        });

        function getData() {
            var r
            $.ajax({
                url: "./api/financieras.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                dataType: "json",
                success: function(data) {
                    data = data.map(function(item) {
                        return {
                            id: item.id_financiera,
                            text: item.nombre,
                            selected: false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguna',
                        selected: true
                    });
                    r = data
                }
            });
            return r
        }

        $('.select_financieras').select2({
            data: getData()
        }).trigger("change");
        $("#btn_add_financiera").click(function() {
            var nombre_financiera = $('#nombre_financiera').val()
            var telefono_financiera = $("#telefono_financiera").val()
            var email_financiera = $("#email_financiera").val()

            if (nombre_financiera == "") {

                $.toast({
                    heading: 'Por favor selecciona un nombre.',
                    text: 'No se ha asignado un nombre a la financiera.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false;
            }
            if (telefono_financiera == "") {

                $.toast({
                    heading: 'Por favor selecciona un teléfono.',
                    text: 'No se ha asignado un teléfono a la financiera.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false;
            }
            if (email_financiera == "") {

                $.toast({
                    heading: 'Por favor selecciona un email.',
                    text: 'No se ha asignado un email a la financiera.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false;
            }

            $.ajax({
                type: 'POST',
                url: './api/financieras.php',
                cache: false,
                data: {
                    nombre: nombre_financiera,
                    telefono: telefono_financiera,
                    email: email_financiera

                },
                success: function(result) {
                    var r = JSON.parse(result)

                    $('.select_financieras').empty()
                    $('.select_financieras').select2({
                        data: getData()
                    }).trigger("change");
                    $.toast({
                        heading: 'Financiera agregada.',
                        text: 'Se ha agregado la financiera correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    $('#modalAgregarFinanciera input').each(function() {
                        $(this).val("")

                    })
                    $('#tabla_financieras').DataTable().ajax.reload(null, false);
                    $("#btn_add_financiera").removeClass('btn-loading');

                }
            });
        })

        $(document).on("click", ".btn_eliminar_financiera", function() {

            var target = $(this).data("target");


            if (typeof target === 'undefined') {
                console.log($(this).data("id"));
                $("#id_financiera_eliminar").val($(this).data("id"))
            } else {
                if ($("#" + target).val() == "No") {
                    return false;
                } else {
                    $("#id_financiera_eliminar").val($("#" + target).val())
                }
            }

            $("#modalEliminarFinanciera").modal("show");
        })

        $('#btn_eliminar_financiera').click(function(event) {
            var id_financiera_eliminar = $("#id_financiera_eliminar").val()
            console.log(id_financiera_eliminar);
            $.ajax({
                type: 'DELETE',
                url: './api/financieras.php?id=' + id_financiera_eliminar,
                cache: false,
                success: function(result) {

                    $('#modalEliminarFinanciera').modal("hide")
                    $.toast({
                        heading: 'Financiera eliminada',
                        text: 'Se ha eliminado la financiera correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                    $('.select_financieras').empty()
                    $('.select_financieras').select2({
                        data: getData()
                    }).trigger("change");
                    $('#tabla_financieras').DataTable().ajax.reload(null, false);
                }
            });
            return false;
        });
        $(document).on("click", ".btn_edit_financiera", function() {
            $("#btn_edit_financiera").data("id", $(this).data("id"))
            $.ajax({
                url: "./api/financieras.php?id_financiera=" + $(this).data("id"),
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                success: function(res) {
                    $('#nombre_financiera_editar').val(res.nombre)
                    $("#telefono_financiera_editar").val(res.telefono)

                    $("#email_financiera_editar").val(res.email)

                    $('#modalEditarFinanciera').modal("show")


                }
            });


        });
        $("#btn_edit_financiera").click(function() {

            var id_financiera = $(this).data("id")
            var nombre_financiera = $('#nombre_financiera_editar').val()
            var telefono_financiera = $("#telefono_financiera_editar").val()
            var email_financiera = $("#email_financiera_editar").val()

            if (nombre_financiera == "") {

                $.toast({
                    heading: 'Por favor selecciona un nombre.',
                    text: 'No se ha asignado un nombre a la financiera.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false;
            }
            if (telefono_financiera == "") {

                $.toast({
                    heading: 'Por favor selecciona un teléfono.',
                    text: 'No se ha asignado un teléfono a la financiera.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false;
            }
            if (email_financiera == "") {

                $.toast({
                    heading: 'Por favor selecciona un email.',
                    text: 'No se ha asignado un email a la financiera.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return false;
            }

            $.ajax({
                type: 'POST',
                url: './api/financieras.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    id_financiera: id_financiera,
                    nombre: nombre_financiera,
                    telefono: telefono_financiera,
                    email: email_financiera

                },
                success: function(r) {

                    $('#modalEditarFinanciera').modal("hide")
                    $('.select_financieras').empty()
                    $('.select_financieras').select2({
                        data: getData()
                    }).trigger("change");
                    $.toast({
                        heading: 'Financiera editada.',
                        text: 'Se ha editado la financiera correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    $('#modalEditarFinanciera input').each(function() {
                        $(this).val("")

                    })
                    $('#tabla_financieras').DataTable().ajax.reload(null, false);
                    $("#btn_edit_financiera").removeClass('btn-loading');

                }
            });
        })
    });
})(jQuery);
</script>
<script>
(function($) {

    'use strict';

    $(function() {
        var changeEnabled = false;
        if ($("#cuerpo").length > 0) {
            tinymce.init({
                selector: "textarea#cuerpo",
                theme: "modern",
                height: 150,
                plugins: [
                    "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
                    "searchreplace visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                    "save table directionality emoticons template paste textcolor"
                ],
                toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",
                language: "es",
                branding: false,

                setup: function(editor) {

                    editor.on('change', function() {
                        if (!changeEnabled) {
                            return;
                        }
                        var nombre = "cuerpo_email_financiacion"
                        var valor = editor.getContent();

                        $.ajax({
                            type: 'POST',
                            url: './api/personalizacion.php',
                            cache: false,
                            async: false,
                            data: {
                                nombre: nombre,
                                valor: valor
                            },
                            success: function(result2) {
                                console.log(result2);
                                $.toast({
                                    heading: 'Valor cambiado.',
                                    text: 'Se ha cambiado la configuración correctamente',
                                    position: 'top-right',
                                    loaderBg: '#32a852',
                                    icon: 'success',
                                    hideAfter: 2000,
                                    stack: 6
                                })

                            }

                        });
                        changeEnabled = false;
                    });
                    editor.on('init', function() {

                        // Crear el botón personalizado
                        var button = document.createElement('button');
                        button.type = 'button';
                        button.innerHTML = 'Guardar';
                        button.className =
                            'btn_guardar_mce m-2 btn btn-success';
                        button.id = 'btn_guardar_mce'
                        // Definir la acción del botón
                        button.onclick = function() {
                            changeEnabled = true;
                            editor.fire('change');
                            changeEnabled = false;
                        };

                        // Agregar el botón al footer del editor
                        var container = editor.getContainer();
                        var footer = container.querySelector(
                            '.mce-statusbar .mce-container-body'
                        );
                        console.log(footer);
                        if (footer) {
                            footer.appendChild(button);
                        }
                    });
                }
            });
        }

        function insertCustomText(tag) {
            changeEnabled = true;
            var editor = tinymce.get('cuerpo');

            // Obtener el contenido actual del editor
            var content = editor.getContent({
                format: 'html'
            });

            // Obtener la posición del cursor de texto
            var cursorPosition = editor.selection.getBookmark();

            // Insertar el tag en la posición del cursor de texto
            editor.selection.moveToBookmark(cursorPosition);
            editor.selection.setContent('%' + tag + '%');
            changeEnabled = false;
        }

        function insertTextAtCursor(textareaId, text) {
            var textarea = document.getElementById(textareaId);
            var scrollPos = textarea.scrollTop;
            var strPos = 0;
            var br = ((textarea.selectionStart || textarea.selectionStart == '0') ?
                "ff" : (document.selection ? "ie" : false));

            if (br == "ie") {
                textarea.focus();
                var range = document.selection.createRange();
                range.moveStart('character', -textarea.value.length);
                strPos = range.text.length;
            } else if (br == "ff") {
                strPos = textarea.selectionStart;
            }

            var front = (textarea.value).substring(0, strPos);
            var back = (textarea.value).substring(strPos, textarea.value.length);
            textarea.value = front + "%" + text + "%" + back;
            strPos = strPos + text.length;

            if (br == "ie") {
                textarea.focus();
                var ieRange = document.selection.createRange();
                ieRange.moveStart('character', -textarea.value.length);
                ieRange.moveStart('character', strPos);
                ieRange.moveEnd('character', 0);
                ieRange.select();
            } else if (br == "ff") {
                textarea.selectionStart = strPos;
                textarea.selectionEnd = strPos;
                textarea.focus();
            }

            textarea.scrollTop = scrollPos;
        }
        $(document).on("click", ".tag_button", function() {
            var tag = $(this).data("tag")
            insertCustomText(tag)
        });
        $(document).on("click", ".tag_button_sms", function() {
            var tag = $(this).data("tag")
            insertTextAtCursor("cuerpo_sms", tag)
        });
        $(document).on("change", ".valor_personalizacion", function() {
            var nombre = $(this).data("nombre")
            var valor = $(this).val()

            $.ajax({
                type: 'POST',
                url: './api/personalizacion.php',
                cache: false,
                async: false,
                data: {
                    nombre: nombre,
                    valor: valor
                },
                success: function(result2) {
                    console.log(result2);
                    $.toast({
                        heading: 'Valor cambiado.',
                        text: 'Se ha cambiado la configuración correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })

                }
            });


        });
    });

})(jQuery);
</script>