<div class="modal fade modal-cambiar" id="modalEliminarFase" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar fase</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar el fase definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>



            <!-- /btn -->



            <div class="modal-footer text-right">





                <input type="hidden" id="id_fase_eliminar">

                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_fase">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade" id="modalAgregarFase" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">



    <div class="modal-dialog modal-dialog-centered" role="document">



        <div class="modal-content">



            <div class="modal-header border-none">



                <h4 class="mb-0">Agregar Fase</h4>



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">



                    <i class="ti-close"></i>



                </button>



            </div>









            <div class="modal-body pb-0">



                <div class="container p-0">



                    <div class="row">



                        <div class="col-12">

                            <input class="form-control w-100" id="nombre_fase" type="text">

                        </div>



                    </div>



                </div>







            </div>



            <div class="modal-footer text-right">







                <button id="btn_add_fase" class="btn btn-success btn-fw" type="button">



                    Agregar</button>



                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">



                    Cancelar </button>











            </div>







            <!-- /modal-body -->



        </div>



    </div>



</div>

<script>
(function($) {

    'use strict';

    $(function() {

        $("#btn_add_fase").click(function() {

            var nombre_fase = $('#nombre_fase').val()

            $.ajax({

                type: 'POST',

                url: './api/fases.php',

                cache: false,

                data: {

                    nombre: nombre_fase,

                },

                success: function(result) {

                    var r = JSON.parse(result)

                    $('#modalAgregarFase').modal("hide")

                    $(".select_fases").each(

                        function() {

                            $(this).append(

                                    '<option value="' +

                                    r.id + '">' +

                                    nombre_fase +

                                    '</option>'

                                ).val(r.id)

                                .trigger("change");

                        })

                    $.toast({

                        heading: 'Fase agregado.',

                        text: 'Se ha agregado la fase correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    });

                    setTimeout(function() {

                        $("#btn_add_fase").removeClass('btn-loading');

                    }, 2000);

                }

            });

        })

        $(document).on("click", ".btn_eliminar_fase", function() {



            var target = $(this).data("target");



            $("#id_fase_eliminar").val($("#" + target).val())

            if ($("#id_fase_eliminar").val() != "No") {

                $("#modalEliminarFase").modal("show");

            }



        })

        $('#btn_eliminar_fase').click(function(event) {

            var id_fase_eliminar = $("#id_fase_eliminar").val()

            $.ajax({

                type: 'DELETE',

                url: './api/fases.php?id=' + id_fase_eliminar,

                cache: false,

                success: function(result) {

                    $(".select_fases").each(function() {

                        $(this).find("option[value='" +

                                id_fase_eliminar + "']").remove()

                            .trigger(

                                "change");

                    })

                    $('#modalEliminarFase').modal("hide")

                    $.toast({

                        heading: 'Fase eliminada',

                        text: 'Se ha eliminado la fase correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })

                }

            });

            return false;

        });

    });

})(jQuery);
</script>