<div class="modal fade modal-cambiar" id="modalEliminarFamilia" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar familia</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar la familia definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>



            <!-- /btn -->



            <div class="modal-footer text-right">





                <input type="hidden" id="id_familia_eliminar">

                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_familia">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade" id="modalAgregarFamilia" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">



    <div class="modal-dialog modal-dialog-centered" role="document">



        <div class="modal-content">



            <div class="modal-header border-none">



                <h4 class="mb-0">Agregar Familia</h4>



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">



                    <i class="ti-close"></i>



                </button>



            </div>









            <div class="modal-body pb-0">



                <div class="container p-0">



                    <div class="row">



                        <div class="col-12">

                            <input class="form-control w-100" id="nombre_familia" type="text">

                        </div>



                    </div>



                </div>







            </div>



            <div class="modal-footer text-right">







                <button id="btn_add_familia" class="btn btn-success btn-fw" type="button">



                    Agregar</button>



                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">



                    Cancelar </button>











            </div>







            <!-- /modal-body -->



        </div>



    </div>



</div>

<div class="modal fade modal-cambiar" id="modalEliminarSubfamilia" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar subfamilia</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar la subfamilia definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>



            <!-- /btn -->



            <div class="modal-footer text-right">





                <input type="hidden" id="id_subfamilia_eliminar">

                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_subfamilia">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade" id="modalAgregarSubfamilia" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">



    <div class="modal-dialog modal-dialog-centered" role="document">



        <div class="modal-content">



            <div class="modal-header border-none">



                <h4 class="mb-0">Agregar subfamilia</h4>



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">



                    <i class="ti-close"></i>



                </button>



            </div>









            <div class="modal-body pb-0">



                <div class="container p-0">



                    <div class="row">



                        <div class="col-12">

                            <input class="form-control w-100" id="nombre_subfamilia" type="text">

                        </div>



                    </div>



                </div>







            </div>



            <div class="modal-footer text-right">







                <button id="btn_add_subfamilia" class="btn btn-success btn-fw" type="button">



                    Agregar</button>



                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">



                    Cancelar </button>











            </div>







            <!-- /modal-body -->



        </div>



    </div>



</div>

<script>
(function($) {

    'use strict';

    $(function() {

        function getData(id_familia) {

            console.log(id_familia);

            var r

            $.ajax({

                url: "./api/familias.php",

                type: 'GET',

                dataType: 'json', // added data type

                cache: false,

                async: false,



                success: function(data) {



                    data = data.map(function(item) {

                        return {

                            id: item.id_familia,

                            text: item.nombre,

                            selected: (item.id_familia == id_familia) ? true : false

                        };

                    })

                    data.push({

                        id: 'No',

                        text: 'Ninguna',

                        selected: (id_familia == "No") ? true : false

                    });



                    r = data

                }

            });

            return r

        }





        $(".select_familias").change(function() {



            var id_familia = $(this).val()

            var target = $(this).data("target")

            // $(this).empty()



            $("#btn_add_subfamilia").data("id", id_familia)

            //$(".select_subfamilias").data("id", id_familia)

            $('#' + target).empty()

            $('#' + target).select2({

                data: getData2(id_familia, "No")

            }).trigger("change");

        })

        $('.select_familias').select2({

            data: getData("No")

        }).trigger("change");



        $("#btn_add_familia").click(function() {

            var nombre_familia = $('#nombre_familia').val()





            $.ajax({

                type: 'POST',

                url: './api/familias.php',

                cache: false,

                async: false,

                dataType: "json",

                data: {

                    nombre: nombre_familia,

                },

                success: function(r) {



                    console.log(r);

                    $('#modalAgregarFamilia').modal("hide")

                    $('.select_familias').empty()

                    $('.select_familias').select2({

                        data: getData(r.id)

                    }).trigger("change");



                    $.toast({

                        heading: 'Familia agregada.',

                        text: 'Se ha agregado la familia correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    });



                    $("#btn_add_familia").removeClass('btn-loading');



                }

            });

        })

        $(document).on("click", ".btn_eliminar_familia", function() {







            var target = $(this).data("target");

            if ($("#" + target).val() == "No") {

                return false;

            } else {

                $("#id_familia_eliminar").val($("#" + target).val())

            }

            $("#modalEliminarFamilia").modal("show");



        })

        $('#btn_eliminar_familia').click(function(event) {

            var id_familia_eliminar = $("#id_familia_eliminar").val()

            $.ajax({

                type: 'DELETE',

                url: './api/familias.php?id=' + id_familia_eliminar,

                cache: false,

                async: false,

                success: function(result) {

                    $('.select_familias').empty()

                    $('.select_familias').select2({

                        data: getData("No")

                    }).trigger("change");

                    $('#modalEliminarFamilia').modal("hide")

                    $.toast({

                        heading: 'Familia eliminada',

                        text: 'Se ha eliminado la familia correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })

                }

            });



        });





        function getData2(id_familia, id_subfamilia) {

            console.log(id_subfamilia);

            var r

            if (id_familia != "No") {

                $.ajax({

                    url: "./api/subfamilias.php?id_familia=" + id_familia,

                    type: 'GET',

                    dataType: 'json', // added data type

                    cache: false,

                    async: false,



                    success: function(data) {

                        data = data.map(function(item) {

                            return {

                                id: item.id_subfamilia,

                                text: item.nombre,

                                selected: (item.id_subfamilia == id_subfamilia) ? true :

                                    false

                            };

                        })

                        data.push({

                            id: 'No',

                            text: 'Ninguna',

                            selected: (id_subfamilia == "No") ? true : false

                        });



                        r = data

                    }

                });



            } else {

                var data = []

                data.push({

                    id: 'No',

                    text: 'Ninguna',

                    selected: true

                });

                r = data

            }

            return r

        }





        $("#btn_add_subfamilia").click(function() {

            var nombre_subfamilia = $('#nombre_subfamilia').val()



            var id_familia = $(this).data("id")



            if (id_familia != "No") {

                $.ajax({

                    type: 'POST',

                    url: './api/subfamilias.php',

                    cache: false,

                    async: false,

                    dataType: "json",

                    data: {

                        nombre: nombre_subfamilia,

                        id_familia: id_familia

                    },

                    success: function(r) {



                        $('#modalAgregarSubfamilia').modal("hide")

                        $('.select_subfamilias').empty()

                        $('.select_subfamilias').select2({

                            data: getData2(id_familia, r.id)

                        }).trigger("change");

                        $.toast({

                            heading: 'Subfamilia agregada.',

                            text: 'Se ha agregado la subfamilia correctamente',

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 6

                        });



                        $("#btn_add_subfamilia").removeClass('btn-loading');



                    }

                });

            } else {

                $.toast({

                    heading: 'Por favor selecciona una familia.',

                    text: 'No se ha añadido ninguna familia para la subfamilia.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

            }

        })

        $(document).on("click", ".btn_eliminar_subfamilia", function() {



            var target = $(this).data("target");

            if ($("#" + target).val() == "No") {

                return false;

            } else {

                $("#id_subfamilia_eliminar").val($("#" + target).val())

            }

            $("#modalEliminarSubfamilia").modal("show");

        })

        $('#btn_eliminar_subfamilia').click(function(event) {

            var id_subfamilia_eliminar = $("#id_subfamilia_eliminar").val()

            var id_familia = $(".select_familias").eq(0).data("id")

            $.ajax({

                type: 'DELETE',

                url: './api/subfamilias.php?id=' + id_subfamilia_eliminar,

                cache: false,

                async: false,

                success: function(result) {

                    $('.select_subfamilias').empty()

                    $('.select_subfamilias').select2({

                        data: getData2(id_familia, "No")

                    }).trigger("change");

                    $('#modalEliminarSubfamilia').modal("hide")

                    $.toast({

                        heading: 'Subfamilia eliminada',

                        text: 'Se ha eliminado la subfamilia correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })

                }

            });



        });

    });

})(jQuery);
</script>