<!-- Modal Eliminar Evento -->
<div class="modal fade modal-cambiar" id="modalEliminarEvento" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar evento</h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <p>¿Estás seguro de que deseas eliminar el evento definitivamente?</p>
                <lottie-player autoplay src="assets/lottiefiles/warning.json" style="width: 250px;margin: auto;">
                </lottie-player>
            </div>
            <div class="modal-footer text-right">
                <input type="hidden" id="id_evento_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_evento">Confirmar y
                    eliminar</button>
                <button class="btn btn-confi" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Agregar Evento -->
<div class="modal fade" id="modalAgregarEvento" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Agregar evento</h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="form-group">
                    <label>Nombre del evento</label>
                    <input class="form-control validable" id="nombre_evento" type="text">
                </div>
                <div class="form-group">

                    <label>Comercial</label>

                    <div class="input-group">

                        <span class="input-group-prepend">

                            <button class="btn_eliminar_comercial file-upload-browse btn btn-danger" type="button"
                                data-target="id_comercial_evento">-</button>

                        </span>

                        <select name="id_comercial_evento" id="id_comercial_evento"
                            class="select_comerciales validable form-control custom-select text-center select2">





                        </select>

                        <span class="input-group-append">
                            <button class="btn btn-info" type="button" data-toggle="modal"
                                data-target="#modalAgregarComercial">+</button>

                        </span>

                    </div>

                </div>
                <div class="form-group">

                    <label>Cliente</label>

                    <div class="input-group">

                        <span class="input-group-prepend">

                            <button class="btn_eliminar_cliente file-upload-browse btn btn-danger"
                                data-target="id_cliente_evento" type="button">-</button>

                        </span>

                        <select id="id_cliente_evento" class="select_clientes custom-select select2 form-control">

                        </select>

                        <span class="input-group-append">

                            <button class="file-upload-browse btn btn-info" type="button" data-toggle="modal"
                                data-target="#modalAgregarCliente">+</button>

                        </span>

                    </div>

                </div>
                <div class="form-group">

                    <label>Camión</label>

                    <div class="input-group">

                        <span class="input-group-prepend">

                            <button class="btn_eliminar_camion file-upload-browse btn btn-danger"
                                data-target="id_camion_evento" type="button">-</button>

                        </span>

                        <select id="id_camion_evento" class="select_camiones custom-select select2 form-control">

                        </select>

                        <span class="input-group-append">

                            <button class="file-upload-browse btn btn-info" type="button" data-toggle="modal"
                                data-target="#modalAgregarCamion">+</button>

                        </span>

                    </div>

                </div>
                <div class="form-group">
                    <label>Agregar días (rango)</label>
                    <div class="d-flex align-items-center gap-2">
                        <input class="form-control mr-2" id="dia_evento_inicio" type="date">
                        <input class="form-control mr-2" id="dia_evento_fin" type="date">
                        <button class="btn btn-primary" type="button" id="btn_agregar_rango">Agregar</button>
                    </div>
                    <ul id="lista_dias" class="mt-2 mb-0 list-unstyled"></ul>
                </div>
                <div class="form-group">
                    <label>Localización</label>
                    <input class="form-control validable" id="localizacion_evento" type="text">
                </div>
            </div>
            <div class="modal-footer text-right">
                <button id="btn_add_evento" class="btn btn-success btn-fw" type="button">Agregar</button>
                <button class="btn btn-confi" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Editar Evento -->
<div class="modal fade" id="modalEditarEvento" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Editar evento</h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <input type="hidden" id="id_evento_editar">
                <div class="form-group">
                    <label>Nombre del evento</label>
                    <input class="form-control validable" id="nombre_evento_editar" type="text">
                </div>
                <div class="form-group">

                    <label>Comercial</label>

                    <div class="input-group">

                        <span class="input-group-prepend">

                            <button class="btn_eliminar_comercial file-upload-browse btn btn-danger" type="button"
                                data-target="id_comercial_evento_editar">-</button>

                        </span>

                        <select name="id_comercial_evento_editar" id="id_comercial_evento_editar"
                            class="select_comerciales validable form-control custom-select text-center select2">





                        </select>

                        <span class="input-group-append">
                            <button class="btn btn-info" type="button" data-toggle="modal"
                                data-target="#modalAgregarComercial">+</button>

                        </span>

                    </div>

                </div>
                <div class="form-group">

                    <label>Cliente</label>

                    <div class="input-group">

                        <span class="input-group-prepend">

                            <button class="btn_eliminar_cliente file-upload-browse btn btn-danger"
                                data-target="id_cliente_evento_editar" type="button">-</button>

                        </span>

                        <select id="id_cliente_evento_editar"
                            class="select_clientes custom-select select2 form-control">

                        </select>

                        <span class="input-group-append">

                            <button class="file-upload-browse btn btn-info" type="button" data-toggle="modal"
                                data-target="#modalAgregarCliente">+</button>

                        </span>

                    </div>

                </div>
                <div class="form-group">

                    <label>Camión</label>

                    <div class="input-group">

                        <span class="input-group-prepend">

                            <button class="btn_eliminar_camion file-upload-browse btn btn-danger"
                                data-target="id_camion_evento_editar" type="button">-</button>

                        </span>

                        <select id="id_camion_evento_editar" class="select_camiones custom-select select2 form-control">

                        </select>

                        <span class="input-group-append">

                            <button class="file-upload-browse btn btn-info" type="button" data-toggle="modal"
                                data-target="#modalAgregarCamion">+</button>

                        </span>

                    </div>

                </div>
                <div class="form-group">
                    <label>Agregar días (rango)</label>
                    <div class="d-flex align-items-center gap-2">
                        <input class="form-control mr-2" id="dia_evento_editar_inicio" type="date">
                        <input class="form-control mr-2" id="dia_evento_editar_fin" type="date">
                        <button class="btn btn-primary" type="button" id="btn_agregar_rango_editar">Agregar</button>
                    </div>
                    <ul id="lista_dias_editar" class="mt-2 list-unstyled"></ul>
                </div>
                <div class="form-group">
                    <label>Localización</label>
                    <input class="form-control validable" id="localizacion_evento_editar" type="text">
                </div>
            </div>
            <div class="modal-footer text-right">
                <button id="btn_edit_evento" class="btn btn-success btn-fw" type="button">Guardar cambios</button>
                <button class="btn btn-confi" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalMaterialesEvento" role="dialog">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Materiales del evento</h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">

                            <label>Material</label>

                            <div class="input-group">

                                <span class="input-group-prepend">

                                    <button class="btn_eliminar_material file-upload-browse btn btn-danger"
                                        data-target="select_materiales_evento" type="button">-</button>

                                </span>

                                <select id="select_materiales_evento"
                                    class="select_materiales custom-select select2 form-control">

                                </select>

                                <span class="input-group-append">

                                    <button class="file-upload-browse btn btn-info" type="button" data-toggle="modal"
                                        data-target="#modalAgregarMaterial">+</button>

                                </span>

                            </div>

                        </div>

                    </div>
                    <div class="col-md-6">

                        <div class="form-group">

                            <label>Cantidad</label>



                            <input class="form-control" id="cantidad_material_evento" type="number">



                        </div>

                    </div>
                    <div class="col-12">
                        <h5>Días de alquiler</h5>
                        <div id="dias_material" class="row gx-3 ">


                        </div>
                    </div>
                    <div class="col-12">
                        <button id="btn_seleccionar_todos" class="mb-2 mr-1 btn btn-success btn-sm btn-fw"
                            type="button">Seleccionar todos</button>
                        <button id="btn_desseleccionar_todos" class="mb-2 btn btn-info btn-sm btn-fw"
                            type="button">Deseleccionar todos</button>
                    </div>
                    <div class="col-12">
                        <h5>Complementos</h5>
                        <div id="complementos_material" class="row gx-3 ">


                        </div>
                    </div>
                    <div class="col-12">
                        <button id="btn_seleccionar_todos_complementos" class="mb-3 mr-1 btn btn-success btn-sm btn-fw"
                            type="button">Seleccionar todos</button>
                        <button id="btn_desseleccionar_todos_complementos" class="mb-3 btn btn-info btn-sm btn-fw"
                            type="button">Deseleccionar todos</button>
                    </div>
                    <div class="col-12">
                        <button id="btn_add_material_evento" class="btn btn-primary btn-sm mb-2" type="button">Agregar
                            material</button>
                    </div>
                    <div class="col-12">
                        <div class="form-group">
                            <h5>Materiales del evento</h5>
                            <ul id="lista_materiales_evento" class="p-0 m-0" style="background-color: #fff;
    border-top: 1px solid #ced4da;
    border-radius: 2px;list-style: none;min-height: 33px;">

                            </ul>
                        </div>
                    </div>

                </div>

            </div>
            <div class="modal-footer text-right">
                <button id="btn_add_materiales_evento" data-dismiss="modal" class="btn btn-success btn-fw"
                    type="button">Guardar</button>
                <button class="btn btn-confi" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>


<style>
body .tooltip.fade.show {
    opacity: 1 !important;
    z-index: 99999 !important;
}
</style>
<style>
.archivo_lista_eventos {

    cursor: pointer;

    transition: all .3s ease;

    position: relative;

    height: 100%;

    width: 100%;

    background: #0000001a;

    box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);

    -webkit-box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);

    -moz-box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);

    aspect-ratio: 1/1;

    border-radius: 2% !important;

}

.archivo_lista_eventos img {

    object-fit: cover;

    max-height: 200px;

}

.archivo_lista_eventos:hover {

    opacity: .5;

    background: #000000;

}

.btn_eliminar_archivo_eventos {

    cursor: pointer;

    transition: all .3s ease;

    opacity: 0;

    position: absolute;

    right: 0;

    top: 0;

    border-radius: 10% !important;

}

.archivo_lista_eventos:hover .btn_eliminar_archivo_eventos {

    opacity: 1;

}

.btn_eliminar_archivo_eventos i:before {

    transition: all .3s ease;

    font-size: 1.1rem;

    color: #F1635F;

}

.btn_eliminar_archivo_eventos:hover i:before {

    color: #F1635F;

}

.btn_seleccionar_archivo_eventos {

    cursor: pointer;

    transition: all .3s ease;

    opacity: 0;

    position: absolute;

    left: 0;

    top: 0;

    border-radius: 10% !important;

}

.archivo_lista_eventos:hover .btn_seleccionar_archivo_eventos {

    opacity: 1;

}

.btn_seleccionar_archivo_eventos i:before {

    transition: all .3s ease;

    font-size: 1.1rem;

    color: #0cca8e;

}

.btn_seleccionar_archivo_eventos:hover i:before {

    color: #0cca8e;

}

.nombre_archivo_div_eventos {

    position: absolute;

    font-size: 18px;

    border-radius: 4px;

    transition: all .3s ease;

    opacity: 0;

    color: white;

    background-color: black;

    padding: .5rem;

    cursor: pointer;

}

.col-sm-3:hover .nombre_archivo_div_eventos {

    opacity: 1;

}

#lista_archivos_eventos {

    max-height: 723px;

    overflow-y: scroll;

}

table.dataTable thead>tr>th.sorting {

    padding: 10px !important;

}
</style>

<div class="modal fade" id="modalSubirArchivoEventos" role="dialog">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Archivos</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-4">

                <div class="row">

                    <div class="col-12 col-md-6">

                        <div class="form-group">

                            <label for="my-input">Nombre</label>

                            <input id="nombre_archivo_eventos" type="text" class="form-control">

                        </div>

                    </div>

                    <div class="col-12 col-md-6">

                        <div class="form-group">

                            <label for="my-input">Archivo</label>

                            <div class="input-group">

                                <input type="file" class="d-none" id="archivo_file_eventos" accept=".png, .jpg, .pdf">

                                <input disabled id="archivo_archivo_eventos" type="text" class="form-control"
                                    value="Ningún archivo seleccionado.">

                                <div class="input-group-append">

                                    <label for="archivo_file_eventos" class="mb-0 btn btn-success btn-fw"
                                        id="btn_subir_archivo_eventos" type="button">

                                        Seleccionar archivo</label>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="col-12 text-left mb-2">

                        <button class="btn btn-success btn-fw" id="btn_add_archivo_eventos" type="button">Subir</button>

                    </div>

                </div>

                <div class=" container-lg p-0">

                    <div id="lista_archivos_eventos" class="row">

                    </div>

                </div>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>



<div class="modal fade modal-cambiar" id="modalVerArchivoEventos" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div id="contenedor_archivo_eventos" class="modal-body">

                <!-- btn -->

            </div>

            <!-- /btn -->

            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade" id="modalPersonalEvento" role="dialog">
    <div class="modal-dialog   modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Personal asignado al evento</h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">

                            <label>Miembro</label>

                            <select id="id_miembro_evento" class="form-control custom-select text-center select2">



                            </select>

                        </div>
                        <button id="btn_add_miembro_evento" class="btn btn-success btn-sm mb-3"
                            type="button">Agregar</button>
                    </div>

                    <div class="col-12">
                        <div class="form-group">
                            <h5>Miembros del evento</h5>
                            <ul id="lista_miembros_evento" class="p-0 m-0" style="background-color: #fff;
    border-top: 1px solid #ced4da;
    border-radius: 2px;list-style: none;min-height: 33px;">

                            </ul>
                        </div>
                    </div>

                </div>

            </div>
            <div class="modal-footer text-right">
                <button id="btn_add_miembros_evento" data-dismiss="modal" class="btn btn-success btn-fw"
                    type="button">Editar</button>
                <button class="btn btn-confi" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade modal-cambiar" id="modalEliminarMiembroEvento" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar miembro</h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <p>¿Estás seguro de que deseas eliminar el miembro definitivamente?</p>
                <lottie-player autoplay src="assets/lottiefiles/warning.json" style="width: 250px;margin: auto;">
                </lottie-player>
            </div>
            <div class="modal-footer text-right">
                <input type="hidden" id="id_evento_miembro_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_evento_miembro">Confirmar y
                    eliminar</button>
                <button class="btn btn-confi" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade modal-cambiar" id="modalVerPresupuesto" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div id="contenedor_presupuesto" class="modal-body pb-0">

                <!-- btn -->











            </div>
            <div class="modal-footer text-right">
                <button class="btn btn-primary btn-fw mr-1" type="button"
                    id="btn_aceptar_presupuesto_evento2">Aceptar</button>
                <a class="btn btn-info btn-fw mr-1" id="btn_editar_presupuesto_evento"
                    href="./crear_presupuesto_materiales?id_presupuesto=">Editar</a>
                <button class="btn btn-danger btn-fw mr-1" type="button"
                    id="btn_eliminar_presupuesto_evento2">Eliminar</button>
                <button class="btn btn-confi" data-dismiss="modal">Cancelar</button>
            </div>


            <!-- /btn -->





            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade modal-cambiar" id="modalVerFactura" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">



                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div id="contenedor_factura" class="modal-body pb-0">

                <!-- btn -->











            </div>
            <div class="modal-footer text-right">
                <button class="btn btn-success btn-fw mr-1" type="button"
                    id="btn_aceptar_factura_evento2">Aceptar</button>
                <a class="btn btn-info btn-fw mr-1" id="btn_editar_factura_evento"
                    href="./crear_factura_materiales?id_factura=">Editar</a> <button class="btn btn-primary btn-fw mr-1"
                    type="button" id="btn_facturae_factura_evento2">Factura-E</button>
                <button class="btn btn-danger btn-fw mr-1" type="button"
                    id="btn_eliminar_factura_evento2">Eliminar</button>
                <button class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
            </div>


            <!-- /btn -->





            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade modal-cambiar" id="modalEliminarPresupuestoEvento" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar presupuesto</h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <p>¿Estás seguro de que deseas eliminar el presupuesto definitivamente?</p>
                <lottie-player autoplay src="assets/lottiefiles/warning.json" style="width: 250px;margin: auto;">
                </lottie-player>
            </div>
            <div class="modal-footer text-right">
                <input type="hidden" id="id_presupuesto_evento_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_presupuesto_evento">Confirmar y
                    eliminar</button>
                <button class="btn btn-confi" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>
<?php require_once __VIEWS__ . 'selects/camiones.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/materiales.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/packs.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/clientes.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/comerciales.template.php'; ?>
<div class="modal fade modal-cambiar" id="modalDescargarFacturaeMateriales" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Generar factura electrónica</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="form-group">

                    <label for="my-input">Nombre de la factura</label>

                    <input id="nombre_facturae" class="sin_espacios form-control" type="text" name="">

                </div>

                <h4>Opciones de descarga</h4>





                <div style="margin-left: 25px;">

                    <div class="form-check form-check-inline d-flex">

                        <input id="inlineCheckbox1" value="1" class="form-check-input" type="radio" name="firmado" <?php $folderPath = 'assets/firma';

                                                                                                $files = glob($folderPath . '/*');

                                                                                                if (count($files) > 0) {

                                                                                                    echo "checked";

                                                                                                } else {

                                                                                                    echo 'disabled';

                                                                                                } ?>>

                        <label class="p-0 form-check-label" for="inlineCheckbox1" style="margin-left: 15px;">Firmar la

                            factura-e con el certificado

                            de

                            firma digital</label>



                    </div>

                    <div class="form-check form-check-inline d-flex">

                        <input id="inlineCheckbox2" value="0" class="form-check-input" type="radio" name="firmado" <?php $folderPath = 'assets/firma';

                                                                                                $files = glob($folderPath . '/*');

                                                                                                if (count($files) == 0) {

                                                                                                    echo "checked";

                                                                                                } ?>>

                        <label class="p-0 form-check-label" for="inlineCheckbox2">Descargar la factura-e sin la firma

                            digital</label>

                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">

                <button class="btn btn-success btn-fw" type="button" id="btn_facturae">

                    Descargar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>
<style>
.li_material_evento {
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: space-between;
    border-bottom: 1px solid #ced4da;
    border-right: 1px solid #ced4da;
    border-left: 1px solid #ced4da;
}
</style>
<script async
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCWWOfka8SjiT9Duq-FEYJON1zYftnN7LI&libraries=places&callback=AutoComplete">

</script>

<script>
function AutoComplete() {

    var autocomplete;

    var autocomplete_editar;

    var input = document.getElementById('localizacion_evento')

    var input_editar = document.getElementById('localizacion_evento_editar')



    var options = {};

    autocomplete = new google.maps.places.Autocomplete(input, options);

    autocomplete_editar = new google.maps.places.Autocomplete(input_editar, options);


}
</script>

<style>
.pac-container {

    background-color: #FFF;

    z-index: 10000;

    position: fixed;

    display: inline-block;

    float: left;

}
</style>
<script>
(function($) {
    'use strict';

    $(function() {


        function getEventos(id_evento) {
            var result;
            $.ajax({
                url: "./api/eventos2.php",
                type: 'GET',
                dataType: 'json',
                cache: false,
                async: false,
                success: function(data) {
                    data = data.map(function(item) {
                        return {
                            id: item.id_evento,
                            text: item.nombre,
                            selected: (item.id_evento == id_evento),
                            dias: item.dias.length
                        };
                    });
                    data.push({
                        id: 'No',
                        text: 'Ninguno',
                        selected: (id_evento == "No"),
                        dias: 1
                    });
                    result = data;
                }
            });
            return result;
        }

        $('.select_eventos').each(function() {
            const $select = $(this);
            const $modal = $select.closest('.modal');

            if ($modal.length) {
                $modal.on('shown.bs.modal', function() {
                    const isPrimary = ($select.data("pri") === undefined);
                    const id = $select.data("edit") ?? "No";

                    if (isPrimary) {
                        reloadSelect($select, id, $modal);
                    } else {
                        $modal.off('shown.bs.modal');
                        $select.data("pri", false);
                    }
                });
            } else {
                reloadSelect($select);
            }
        });

        function reloadSelect($select, id = "No", $modal = "No") {
            $select.empty();
            const config = {
                data: getEventos(id)
            };
            if ($modal !== "No") config.dropdownParent = $modal;
            $select.select2(config).trigger("change");
        }



        function reloadEventosTable() {
            $('#tabla_eventos').DataTable().ajax.reload(null, false);
        }
        /*  $('#btn_add_materiales_evento').click(function() {
              var fd = new FormData();

              var extras = [];
              var comp = [];
              $('#lista_materiales_evento li').each(function() {
                  const diasStr = $(this).data('dias') ||
                      ''; // obtiene el string "Lunes,Martes"
                  const complementos = $(this).data('complementos') ||
                      '';
                  console.log(complementos);

                  const dias = diasStr.split(',').map(d => d.trim()).filter(
                      Boolean); // convierte a array y limpia espacios

                  const complementosArray = complementos.split(',').map(d => d.trim()).filter(
                      Boolean); // convierte a array y limpia espacios
                  extras.push({
                      id: $(this).data('id'),
                      cantidad: $(this).data('cantidad') ?? 1,
                      complementos: complementosArray,
                      dias: dias // arreglo de strings
                  });

              });


              fd.append('materiales', JSON.stringify(extras));

              fd.append('id_evento', $(this).data("id"));
              $.ajax({
                  type: 'POST',
                  url: './api/eventos2.php',
                  cache: false,
                  data: fd,
                  processData: false, // No procesar datos
                  contentType: false, // No establecer contentType
                  success: function(r) {
                      $('#modalMaterialesEvento').modal("hide");

                      $('#tabla_eventos').DataTable().ajax.reload(null, false);
                      $.toast({
                          heading: 'Materiales agregado',
                          text: 'Se ha agregado los materiales correctamente',
                          position: 'top-right',
                          loaderBg: '#32a852',
                          icon: 'success',
                          hideAfter: 2000
                      });
                  }
              });
          });*/
        const dias = [];
        const diasEditar = [];

        function agregarRangoFechas(inicio, fin, lista, diasArray) {
            const start = new Date(inicio);
            const end = new Date(fin);

            if (start > end) {

                $.toast({
                    heading: 'Fechas inválidas',
                    text: 'La fecha de inicio no puede ser posterior a la de fin.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                return;
            }

            const nuevasFechas = [];
            for (let d = new Date(start); d <= end; d.setDate(d.getDate() + 1)) {
                const fecha = d.toISOString().split('T')[0];
                if (diasArray.includes(fecha)) {

                    $.toast({
                        heading: 'Fechas inválidas',
                        text: `El día ${fecha} ya está en otro rango.`,
                        position: 'top-right',
                        loaderBg: '#ff5c6c',
                        icon: 'error',
                        hideAfter: 5000,
                        stack: 6
                    });
                    return;
                }
                nuevasFechas.push(fecha);
            }

            diasArray.push(...nuevasFechas);

            const li = $('<li>')
                .text(`${inicio} - ${fin} (${nuevasFechas.length} días) `)
                .append(
                    $('<button>')
                    .addClass('btn btn-sm btn-danger ml-2')
                    .text('x')
                    .on('click', function() {
                        nuevasFechas.forEach(f => {
                            const index = diasArray.indexOf(f);
                            if (index !== -1) diasArray.splice(index, 1);
                        });
                        li.remove();
                    })
                );
            lista.append(li);
        }

        $('#btn_agregar_rango').click(function() {
            const inicio = $('#dia_evento_inicio').val();
            const fin = $('#dia_evento_fin').val();
            if (inicio && fin && inicio <= fin) {
                agregarRangoFechas(inicio, fin, $('#lista_dias'), dias);
                $('#dia_evento_inicio').val('');
                $('#dia_evento_fin').val('');
            }
        });

        $('#btn_agregar_rango_editar').click(function() {
            const inicio = $('#dia_evento_editar_inicio').val();
            const fin = $('#dia_evento_editar_fin').val();
            if (inicio && fin && inicio <= fin) {
                agregarRangoFechas(inicio, fin, $('#lista_dias_editar'), diasEditar);
                $('#dia_evento_editar_inicio').val('');
                $('#dia_evento_editar_fin').val('');
            }
        });

        $('#btn_add_evento').click(function() {
            const nombre = $('#nombre_evento').val().trim();
            const id_camion = ($('#id_camion_evento').val() != "No") ? $('#id_camion_evento')
                .val() : "";
            const id_comercial = ($('#id_comercial_evento').val() != "No") ? $(
                    '#id_comercial_evento')
                .val() : "";


            const localizacion = $('#localizacion_evento').val().trim();
            const id_cliente = ($('#id_cliente_evento').val() != "No") ? $(
                '#id_cliente_evento').val() : "";
            if (!nombre || !localizacion || dias.length === 0) {
                $.toast({
                    heading: 'Datos inválidos.',
                    text: 'Ingresa todos los datos.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });
                return;
            }


            $.post('/api/eventos2.php', {
                nombre,
                id_camion,
                id_comercial,
                id_cliente,
                dias: JSON.stringify(dias),
                localizacion
            }, function(r) {
                console.log(r);

                $('#modalAgregarEvento').modal("hide");
                reloadEventosTable();
                $('.select_eventos').each(function() {
                    reloadSelect($(this), r.id_evento, "No");
                });
                if (window.calendar != undefined) {
                    window.calendar.refetchEvents();
                }
                dias.length = 0;
                $('#lista_dias').empty();
            }, 'json');
        });

        function agruparFechasConsecutivas(fechas) {
            if (!fechas.length) return [];
            // Primero ordenamos las fechas por si no vienen ordenadas
            fechas.sort();

            const grupos = [];
            let grupoActual = [fechas[0]];

            for (let i = 1; i < fechas.length; i++) {
                const fechaPrev = new Date(fechas[i - 1]);
                const fechaActual = new Date(fechas[i]);

                // Si la fechaActual es el día siguiente de fechaPrev, la agregamos al grupo
                if ((fechaActual - fechaPrev) === 86400000) { // 86400000 ms = 1 día
                    grupoActual.push(fechas[i]);
                } else {
                    // Si no es consecutiva, iniciamos un nuevo grupo
                    grupos.push(grupoActual);
                    grupoActual = [fechas[i]];
                }
            }
            grupos.push(grupoActual);
            return grupos;
        }


        $(document).on("click", "#btn_eliminar_presupuesto_evento2", function() {
            const id = $(this).data("id");
            $('#id_presupuesto_evento_eliminar').val(id);
            $('#modalEliminarPresupuestoEvento').modal("show");
        });

        $('#btn_eliminar_presupuesto_evento').click(function() {
            const id = $('#id_presupuesto_evento_eliminar').val();
            $.ajax({
                type: 'DELETE',
                url: '/api/presupuestos_material.php?id=' + id,
                success: function() {
                    $('#modalEliminarPresupuestoEvento').modal("hide");
                    $('#modalVerPresupuesto').modal("hide");
                    $('#tabla_eventos').DataTable().ajax.reload(null, false);

                }
            });
        });
        $(document).on("click", ".btn_edit_evento", function() {
            const id = $(this).data("id");
            $.getJSON('/api/eventos2.php?id_evento=' + id + '&_=' + new Date().getTime(), function(
                evento) {
                diasEditar.length = 0;
                $('#lista_dias_editar').empty();

                $('#id_evento_editar').val(evento.id_evento);
                $('#nombre_evento_editar').val(evento.nombre);


                if (evento.id_camion != null) {

                    $("#id_camion_evento_editar").data("edit", evento.id_camion)

                        .trigger("change")

                } else {

                    $("#id_camion_evento_editar").data("edit", "No").trigger(

                        "change")

                }
                if (evento.client_id != null) {

                    $("#id_cliente_evento_editar").data("edit", evento.client_id)

                        .trigger("change")

                } else {

                    $("#id_cliente_evento_editar").data("edit", "No").trigger(

                        "change")

                }
                if (evento.id_comercial != null) {

                    $("#id_comercial_evento_editar").data("edit", evento.id_comercial)

                        .trigger("change")

                } else {

                    $("#id_comercial_evento_editar").data("edit", "No").trigger(

                        "change")

                }
                var d = JSON.parse(evento.dias);

                diasEditar.push(...d);

                // Limpiar lista antes de agregar
                $('#lista_dias_editar').empty();

                if (d.length > 0) {
                    const grupos = agruparFechasConsecutivas(d);

                    grupos.forEach(grupo => {
                        const desde = grupo[0];
                        const hasta = grupo[grupo.length - 1];
                        const li = $('<li>')
                            .text(`${desde} - ${hasta} (${grupo.length} días) `)
                            .append(
                                $('<button>')
                                .addClass('btn btn-sm btn-danger ml-2')
                                .text('x')
                                .on('click', function() {
                                    grupo.forEach(f => {
                                        const index = diasEditar
                                            .indexOf(f);
                                        if (index !== -1) diasEditar
                                            .splice(index, 1);
                                    });
                                    li.remove();
                                })
                            );
                        $('#lista_dias_editar').append(li);
                    });
                }

                $('#localizacion_evento_editar').val(evento.localizacion);
                $('#modalEditarEvento').modal("show");
            });
        });

        $('#btn_seleccionar_todos').on('click', function() {
            $('input[name="dias_material"]').prop('checked', true);
        });
        $('#btn_desseleccionar_todos').on('click', function() {
            $('input[name="dias_material"]').prop('checked', false);
        });
        $('#btn_seleccionar_todos_complementos').on('click', function() {
            $('input[name="complementos_material"]').prop('checked', true);
        });
        $('#btn_desseleccionar_todos_complementos').on('click', function() {
            $('input[name="complementos_material"]').prop('checked', false);
        });
        $(document).on("click", ".btn_materiales_evento", function() {
            const id = $(this).data("id");
            $('#btn_add_materiales_evento').data("id", id)
            reloadMaterialesEvento(id)


        });

        function reloadMaterialesEvento(id) {

            $('#lista_materiales_evento').empty();
            $('#dias_material').empty();
            const contenedor = document.getElementById('dias_material');
            // Llamar a la API para obtener los materiales del evento
            $.getJSON(`./api/eventos2.php?id_evento=${id}` + '&_=' + new Date().getTime(), function(
                data) {
                console.log(data);

                if (!data.materiales || !Array.isArray(data.materiales)) {
                    $('#lista_materiales_evento').append(
                        '<li class="list-group-item">Sin materiales asociados</li>');
                    return;
                }
                $('#modalMaterialesEvento').modal("show");
                // Agregar los materiales a la lista
                data.materiales.forEach(function(material) {
                    var estadoIcon = $('<i>')
                        .addClass('ml-0')
                        .css('cursor', 'pointer')
                        .css('font-size', '18px')
                        .attr('title', material.estado_material)
                        .attr('data-toggle', "tooltip")
                        .attr('id', 'estado_material_' + material.id_material)
                        .attr('data-original-title', material.estado_material)
                        .attr('data-placement', "top");

                    if (material.estado_m == true) {
                        estadoIcon.addClass('text-success fa fa-check-circle');
                    } else {
                        estadoIcon.addClass(
                            'text-danger fas fa-exclamation-circle');
                    }

                    var diasArray = JSON.parse(material.dias);
                    var diasTexto = diasArray.join(', ');
                    var diasAgrupados = agruparFechasConsecutivas(diasArray);

                    var ulDias = $('<ul>').addClass(
                        'mb-0 pl-3'); // Lista con padding izquierda
                    var ulComp = $('<ul>').addClass(
                        'mb-0 pl-3'); // Lista con padding izquierda
                    diasAgrupados.forEach(grupo => {
                        const desde = grupo[0];
                        const hasta = grupo[grupo.length - 1];
                        const texto = `${desde} al ${hasta} (${grupo.length} días)`;

                        ulDias.append(
                            $('<li>').html('<span>' + texto + '</span>')
                        );
                    });
                    material.complementos.forEach(g => {

                        const texto = `${g.nombre} X ${g.cantidad} Unidades`;

                        ulComp.append(
                            $('<li>').html('<span>' + texto + '</span>')
                        );
                    });


                    var complementosArray = material.complementos.map(c =>
                        parseInt(
                            c.id_complemento));

                    var complementosArray2 = material.complementos.map(c =>
                        c.nombre);
                    // Convierte array a texto con comas solo si hay elementos
                    var complementosTexto = complementosArray2.length > 0 ?
                        complementosArray2.join(', ') : "Ninguno";



                    var collapseId = 'collapse_material_' + material.id_material;
                    var chevronIcon = $('<i>')
                        .addClass('fa fa-chevron-down mr-2 text-muted toggle-icon')
                        .css('transition', 'transform 0.3s'); // rotación suave

                    var nombreToggle = $('<div>')
                        .addClass('d-flex align-items-center justify-content-between')
                        .append(chevronIcon,
                            $('<span>').addClass('mb-0 mr-2 font-weight-bold').text(
                                material.nombre),
                            estadoIcon

                        );


                    var botonEliminar = $('<button>')
                        .addClass('btn btn-sm btn-danger')
                        .text('x')
                        .on('click', function() {
                            $.ajax({
                                type: 'DELETE',
                                url: '/api/eventos2.php?id_evento_material=' +
                                    material.id_evento_material,
                                success: function() {
                                    reloadMaterialesEvento(id)
                                }
                            });
                        });

                    var contenidoCollapse = $('<div>')
                        .addClass('collapse w-100')
                        .attr('id', collapseId)
                        .append(
                            $('<div>').addClass('card card-body p-2')
                            .append(
                                $('<p>').addClass('mb-0 font-weight-bold').text(
                                    'Cantidad: ' + material.cantidad),
                                $('<p>').addClass('mb-0 font-weight-bold').text(
                                    'Días de alquiler: ' + diasArray.length),
                                $('<p>').addClass('mb-0 font-weight-bold').text(
                                    'Complementos:'),
                                ulComp,
                                $('<p>').addClass('mb-0 font-weight-bold').text('Fechas:'),
                                ulDias
                            )
                        );

                    var newItem = $('<li>')
                        .addClass('p-1 li_material_evento')
                        .attr('data-id', material.id_material)
                        .attr('data-cantidad', material.cantidad)
                        .attr('data-dias', diasArray)
                        .attr('data-complementos', complementosArray)
                        .append(
                            $('<div>').addClass(
                                'd-flex px-2 w-100 align-items-center justify-content-between'
                            ).attr('data-toggle', 'collapse')
                            .attr('data-target', '#' + collapseId)
                            .attr('aria-expanded', 'false')
                            .attr('aria-controls', collapseId)
                            .css('cursor', 'pointer')
                            .append(nombreToggle, botonEliminar),
                            contenidoCollapse
                        );

                    $('#lista_materiales_evento').append(newItem);

                    $('#' + collapseId).on('show.bs.collapse', function() {
                        $(this).prev().find('.toggle-icon').css('transform',
                            'rotate(180deg)');
                    });

                    $('#' + collapseId).on('hide.bs.collapse', function() {
                        $(this).prev().find('.toggle-icon').css('transform',
                            'rotate(0deg)');
                    });

                });


                JSON.parse(data.dias).forEach(dia => {
                    const div = document.createElement('div');
                    div.className =
                        'col-6 col-sm-4 col-lg-3 col-xl-2 d-flex flex-row mb-3 px-3 justify-content-start align-items-center';

                    div.innerHTML = `
                    <label class="custom-control custom-checkbox d-inline-block mb-0">
                        <input type="checkbox" checked class="custom-control-input apartado" name="dias_material" value="${dia}">
                        <span class="custom-control-label">${dia}</span>
                    </label>
                `;

                    contenedor.appendChild(div);


                });



            });
            $('#lista_materiales_evento [data-toggle="tooltip"]').tooltip();


        }


        $(document).on("click", ".btn_quitar_material", function() {
            $(this).parent().remove();
        });
        $('#btn_edit_evento').click(function() {
            const id = $('#id_evento_editar').val();
            const nombre = $('#nombre_evento_editar').val().trim();
            const id_cliente = ($('#id_cliente_evento_editar').val() != "No") ? $(
                '#id_cliente_evento_editar').val() : "";

            const id_comercial = ($('#id_comercial_evento_editar').val() != "No") ? $(
                    '#id_comercial_evento_editar')
                .val() : "";


            const id_camion = ($('#id_camion_evento_editar').val() != "No") ? $(
                '#id_camion_evento_editar').val() : "";
            const localizacion = $('#localizacion_evento_editar').val().trim();

            if (!nombre || !localizacion || diasEditar.length === 0) return;

            $.post('/api/eventos2.php', {
                id_evento: id,
                nombre,
                id_camion,
                id_cliente,
                id_comercial,
                dias: JSON.stringify(diasEditar),
                localizacion
            }, function() {
                $('#modalEditarEvento').modal("hide");
                reloadEventosTable();
                $('.select_eventos').each(function() {
                    reloadSelect($(this), id, "No");
                });

                if (window.calendar != undefined) {
                    window.calendar.refetchEvents();
                }
            });
        });

        $(document).on("click", ".btn_eliminar_evento", function() {
            const id = $(this).data("id");
            $('#id_evento_eliminar').val(id);
            $('#modalEliminarEvento').modal("show");
        });

        $('#btn_eliminar_evento').click(function() {
            const id = $('#id_evento_eliminar').val();
            $.ajax({
                type: 'DELETE',
                url: '/api/eventos2.php?id=' + id,
                success: function() {
                    $('#modalEliminarEvento').modal("hide");
                    reloadEventosTable();
                    $('.select_eventos').each(function() {
                        reloadSelect($(this));
                    });
                    if (window.calendar != undefined) {
                        window.calendar.refetchEvents();
                    }
                }
            });
        });

        $('#select_materiales_evento').change(function() {
            const id = $(this).val();

            if (id === "No") {

                $('#cantidad_material_evento').val(0);
                $('#complementos_material').empty();
                $('#complementos_material').append(
                    '<div class="col-12 mb-3"><div class="px-2" style="display: flex; align-items: center; justify-content: space-between; border-bottom: 1px solid #ced4da; border-right: 1px solid #ced4da; border-left: 1px solid #ced4da; background-color: #fff; border-top: 1px solid #ced4da; border-radius: 2px; list-style: none; min-height: 33px;">Sin complementos asociados</div></div>'
                );

                return false;

            }
            $.getJSON('/api/materiales2.php?id_material=' + id + '&_=' + new Date().getTime(),
                function(data) {
                    $('#cantidad_material_evento').val(data.stock);
                    $('#complementos_material').empty();
                    const contenedor2 = document.getElementById('complementos_material');
                    if (data.complementos.length == 0 || !data.complementos || !Array.isArray(
                            data.complementos)) {
                        $('#complementos_material').append(
                            '<div class="col-12 mb-3"><div class="px-2" style="display: flex; align-items: center; justify-content: space-between; border-bottom: 1px solid #ced4da; border-right: 1px solid #ced4da; border-left: 1px solid #ced4da; background-color: #fff; border-top: 1px solid #ced4da; border-radius: 2px; list-style: none; min-height: 33px;">Sin complementos asociados</div></div>'


                        );


                        return;
                    }
                    data.complementos.forEach(complemento => {
                        const div = document.createElement('div');
                        div.className =
                            'col-6 col-sm-4 col-lg-3 col-xl-2 d-flex flex-row mb-3 px-3 justify-content-start align-items-start';

                        div.innerHTML = `
                            <label class="custom-control custom-checkbox d-inline-block mb-0">
                                <input type="checkbox" checked class="custom-control-input apartado" name="complementos_material" value="${complemento.id_complemento}">
                                <span class="custom-control-label">${complemento.nombre}</span>
                            </label>
                        `;

                        contenedor2.appendChild(div);
                    });
                });
        });

        $('#btn_add_material_evento').click(function() {
            // Obtener el valor y el texto del extra seleccionado
            var id = $('#select_materiales_evento').val();
            var cantidad = $('#cantidad_material_evento').val();
            if (cantidad === "" || cantidad <= 0) {
                $.toast({
                    heading: 'Cantidad no válida.',
                    text: 'Ingresa una cantidad mayor que 0.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });
                return;
            }
            if ($('input[name="dias_material"]:checked').length == 0) {
                $.toast({
                    heading: 'Ningún día seleccionado.',
                    text: 'Debes seleccionar al menos un día de alquiler del material.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });
                return;
            }
            // Validar si el valor seleccionado es "No"
            if (id === "No") {
                $.toast({
                    heading: 'Seleccion no válida.',
                    text: 'No puedes seleccionar "Ninguno" como material.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });
                return;
            }

            // Verificar si el extra ya está en la lista
            var isDuplicate = false;
            $('#lista_materiales_evento li').each(function() {

                if ($(this).data('id') == id) {
                    isDuplicate = true;

                    return false; // Salir del ciclo si se encuentra un duplicado
                }
            });
            if (isDuplicate) {
                $.toast({
                    heading: 'Material duplicado.',
                    text: 'Este material ya está en el pack.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });
                return;
            }
            // Si el extra es un duplicado, mostrar un mensaje
            $.getJSON('/api/materiales2.php?id_material=' + id + '&_=' + new Date().getTime(),
                function(material) {

                    if (cantidad > material.stock) {
                        $.toast({
                            heading: 'Stock insuficiente.',
                            text: 'La cantidad supera el stock disponible.',
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 2000,
                            stack: 6
                        });
                        return;
                    }
                    let seleccionados = [];

                    $('input[name="dias_material"]:checked').each(function() {
                        seleccionados.push($(this).val());
                    });
                    let seleccionados2 = [];

                    $('input[name="complementos_material"]:checked').each(function() {
                        seleccionados2.push($(this).val());
                    });
                    console.log(seleccionados);
                    var fd = new FormData();

                    fd.append('dias_material_evento', JSON.stringify(seleccionados));
                    fd.append('complementos_material_evento', JSON.stringify(seleccionados2));
                    fd.append('id_evento_agregar_material', $('#btn_add_materiales_evento')
                        .data("id"));
                    fd.append('cantidad_material_evento', cantidad);
                    fd.append('id_material_agregar_evento', id);
                    $.ajax({
                        type: 'POST',
                        url: './api/eventos2.php',
                        cache: false,
                        data: fd,
                        processData: false, // No procesar datos
                        contentType: false, // No establecer contentType
                        success: function(r) {

                            reloadMaterialesEvento($('#btn_add_materiales_evento')
                                .data("id"))
                            $('#tabla_eventos').DataTable().ajax.reload(null,
                                false);
                            $.toast({
                                heading: 'Material agregado',
                                text: 'Se ha agregado el material correctamente',
                                position: 'top-right',
                                loaderBg: '#32a852',
                                icon: 'success',
                                hideAfter: 2000
                            });
                            $('#select_materiales_evento').val("No").trigger(
                                'change');
                        }
                    });



                });

            // Crear el nuevo elemento <li> con el extra seleccionado

            // Limpiar la selección del select después de agregar

            // Mostrar mensaje de éxito al agregar el extra

        });
    });
})(jQuery);
</script>






<script>
(function($) {
    'use strict';

    $(function() {

        $("#archivo_file_eventos").change(function(e) {

            var archivo = $('#archivo_file_eventos')[0].files[0];

            $("#archivo_archivo_eventos").val(archivo.name)

        });

        $("#btn_add_archivo_eventos").click(function() {

            var archivo = $('#archivo_file_eventos')[0].files[0];

            var id_factura_proveedor = $('#btn_subir_archivo_eventos').data("id")

            var nombre = $("#nombre_archivo_eventos").val();

            if (!archivo) {

                $.toast({

                    heading: 'Ningún archivo seleccionado.',

                    text: 'Por favor, selecciona un archivo para subir.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                return false

            }

            if (nombre == "") {

                $.toast({

                    heading: 'Ningún nombre seleccionado.',

                    text: 'Por favor, agrega un nombre al archivo para subir.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                return false

            }

            var extension = archivo.type.split('/').pop();

            if (extension == "jpeg") {

                extension = "jpg"

            }

            if (archivo.size > 3000000) {

                $.toast({

                    heading: 'Archivo demasiado pesado.',

                    text: 'El archivo debe pesar menos 3 MB.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                return false

            }

            var fd = new FormData();

            fd.append('archivo', archivo);

            fd.append('extension', extension);

            fd.append('nombre', nombre);

            fd.append('id_evento_archivos', id_factura_proveedor);

            var contenedor = document.getElementById('lista_archivos_eventos');

            var divElement = document.createElement('div');

            divElement.classList.add('col-sm-3', 'p-2', 'd-flex',

                'justify-content-center', 'align-items-center');

            // Crear un elemento div para la clase "archivo_lista"

            var archivoListaDiv = document.createElement('div');

            archivoListaDiv.classList.add('archivo_lista_eventos', 'd-flex',

                'justify-content-center', 'align-items-center');

            var imgElement = document.createElement('img');

            imgElement.classList.add('img-fluid');

            imgElement.setAttribute('alt', '');

            imgElement.setAttribute('src', './assets/images/oval.svg');

            // Agregar elementos al div "archivo_lista"

            archivoListaDiv.appendChild(imgElement);

            divElement.appendChild(archivoListaDiv);

            // Agregar el div "archivo_lista" al div principal

            contenedor.insertAdjacentElement('afterbegin', divElement);

            $.ajax({

                url: './api/eventos2.php',

                type: 'POST',

                data: fd,

                async: false,

                cache: false,

                processData: false, // tell jQuery not to process the data

                contentType: false, // tell jQuery not to set contentType

                success: function(result) {

                    console.log(result);

                    if (result == "0") {

                        $.toast({

                            heading: 'Nombre repetido.',

                            text: 'Selecciona otro nombre para el archivo.',

                            position: 'top-right',

                            loaderBg: '#ff5c6c',

                            icon: 'error',

                            hideAfter: 5000,

                            stack: 6

                        });

                        divElement.remove()

                        return false

                    } else {

                        CargarArchivos(id_factura_proveedor)

                        $.toast({

                            heading: 'Nuevo archivo subido.',

                            text: 'Se subido el nuevo archivo correctamente.',

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 4

                        })

                    }

                }

            });

        });

        function CargarArchivos(id_factura_proveedor) {

            var contenedor = document.getElementById('lista_archivos_eventos');

            contenedor.innerHTML = ""

            $.ajax({

                url: './api/eventos2.php?id_evento_archivos=' +

                    id_factura_proveedor,

                type: 'GET',

                cache: false,

                async: false,

                dataType: 'json', // added data type

                success: function(result) {

                    console.log(result);

                    for (let r of result) {

                        r.url = r.url.slice(1)

                        console.log(r);

                        var divElement = document.createElement('div');

                        divElement.classList.add('col-sm-3', 'p-2', 'd-flex',

                            'justify-content-center', 'align-items-center');

                        // Crear un elemento div para la clase "archivo_lista"

                        var archivoListaDiv = document.createElement('div');

                        archivoListaDiv.classList.add('archivo_lista_eventos', 'd-flex',

                            'justify-content-center', 'align-items-center');

                        if (r.extension != "pdf") {

                            // Crear un elemento img

                            var imgElement = document.createElement('img');

                            imgElement.classList.add('img-fluid');

                            imgElement.setAttribute('alt', '');

                            imgElement.setAttribute('src', r.url);

                        } else {

                            var iframe = document.createElement('iframe');

                            iframe.setAttribute('src', r.url);

                            iframe.style.width = "100%";

                            iframe.style.height = "100%";

                        }

                        // Crear un botón para eliminar

                        var btnEliminar = document.createElement('button');

                        btnEliminar.classList.add('p-1', 'btn_eliminar_archivo_eventos', 'btn');

                        btnEliminar.setAttribute('data-url', r.url);

                        btnEliminar.setAttribute('data-id', id_factura_proveedor);

                        btnEliminar.setAttribute('type', 'button');

                        btnEliminar.innerHTML = '<i class="m-0 fas fa-trash"></i>';

                        // Crear un botón para seleccionar

                        var btnSeleccionar = document.createElement('button');

                        btnSeleccionar.classList.add('p-1', 'btn_seleccionar_archivo_eventos',

                            'btn');

                        btnSeleccionar.setAttribute('data-url', r.url);

                        btnSeleccionar.setAttribute('data-extension', r.extension);

                        btnSeleccionar.setAttribute('type', 'button');

                        btnSeleccionar.innerHTML = '<i class="m-0 fa fa-eye"></i>';

                        var nombre = document.createElement('a');

                        nombre.textContent = r.nombre

                        nombre.setAttribute('data-nombre', r.nombre);

                        nombre.setAttribute('data-url', r.url);

                        nombre.setAttribute('data-extension', r.extension);

                        nombre.classList.add("nombre_archivo_div_eventos")

                        nombre.innerHTML += '<i class="ml-2 fa fa-download"></i>';

                        // Agregar elementos al div "archivo_lista"

                        if (r.extension != "pdf") {

                            // Crear un elemento img

                            archivoListaDiv.appendChild(imgElement);

                        } else {

                            archivoListaDiv.appendChild(iframe);

                        }

                        archivoListaDiv.appendChild(btnEliminar);

                        archivoListaDiv.appendChild(btnSeleccionar);

                        // Agregar el div "archivo_lista" al div principal

                        divElement.appendChild(archivoListaDiv);

                        divElement.appendChild(nombre);

                        contenedor.appendChild(divElement);

                    }

                }

            })

        }

        $(document).on("click", ".btn_modal_archivos_eventos", function() {

            $('#btn_subir_archivo_eventos').data("id", $(this).data("id"))

            CargarArchivos($(this).data("id"))

            $("#modalSubirArchivoEventos").modal("show");

        });

        $(document).on("click", ".btn_seleccionar_archivo_eventos", function() {

            var url = $(this).data("url");

            var extension = $(this).data("extension");

            var div = document.getElementById("contenedor_archivo_eventos")

            div.innerHTML = ""

            if (extension !== "pdf") {

                // Crear un elemento <img>

                var imgElement = document.createElement("img");

                // Establecer los atributos del elemento <img>

                imgElement.id = "archivo_modal_eventos";

                imgElement.className = "w-100 img-fluid";

                imgElement.src = url; // Aquí establece la fuente de la imagen que desees

                imgElement.alt = "";

                // Agregar el elemento <img> al documento

                div.appendChild(imgElement);

            } else {

                var iframe = document.createElement('iframe');

                iframe.setAttribute('id', 'archivo_modal_eventos');

                iframe.setAttribute('src', url);

                iframe.style.width = "100%"

                iframe.style.height = "400px"

                div.appendChild(iframe);

            }

            $("#modalVerArchivoEventos").modal("show");

        });

        $(document).on("click", ".nombre_archivo_div_eventos", function() {

            var nombre = $(this).data("nombre");

            var url = $(this).data("url");

            var extension = $(this).data("extension");

            $(this).attr("download", nombre + "." + extension)

            $(this).attr("href", url)

        });

        $(document).on("click", ".btn_eliminar_archivo_eventos", function() {

            var id = $(this).data("id");

            var url = $(this).data("url");

            $.ajax({

                type: "DELETE",

                url: "./api/eventos2.php?url=" + url,

                cache: false,

                async: false,

                success: function(response) {

                    console.log(response);

                    CargarArchivos(id)

                    $.toast({

                        heading: 'Archivo eliminado.',

                        text: 'Se eliminado el archivo correctamente.',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 4

                    })

                }

            })

        });
    });

})(jQuery);
</script>


<script>
(function($) {

    'use strict';

    $(function() {
        function reloadMiembrosSelect(id) {
            var result

            $.ajax({
                url: "./api/eventos2.php?id_evento_miembros_no=" + id,
                type: 'GET',
                dataType: 'json',
                cache: false,
                async: false,
                success: function(data) {
                    data = data.map(function(item) {
                        return {
                            id: item.id_miembro,
                            text: item.user_full_name,
                            selected: (item.id_miembro == id)
                        };
                    });

                    result = data;
                }
            });
            return result;
        }

        function reloadMiembros(id) {
            $.getJSON('/api/eventos2.php?id_evento_miembros=' + id + '&_=' + new Date()
                .getTime(),
                function(u) {
                    console.log(u);



                    $('#id_miembro_evento').empty()

                    $('#id_miembro_evento').select2({

                        data: reloadMiembrosSelect(id)

                    }).trigger("change");
                    $('#lista_miembros_evento').empty()
                    if (!u || !Array.isArray(u)) {
                        $('#lista_miembros_evento').append(
                            '<li class="list-group-item">Sin miembros asociados</li>');

                    } else {

                        u.forEach(function(miembro) {
                            var estadoIcon = $('<i>')
                                .addClass('ml-0') // ícono info por defecto
                                .css('cursor', 'pointer')
                                .css('font-size', '18px')
                                .attr('title', miembro.estado_miembro).attr(
                                    'data-toggle',
                                    "tooltip").attr('id', 'estado_miembro_' + miembro
                                    .id_miembro).attr('data-original-title', miembro
                                    .estado_miembro).attr('data-placement', "top");

                            // Si el mensaje incluye "✅", lo tomamos como éxito, sino como alerta
                            if (miembro.estado_m == true) {

                                estadoIcon.addClass('text-success');
                                estadoIcon.addClass('fa fa-check-circle')

                            } else {
                                estadoIcon.addClass('text-danger');
                                estadoIcon.addClass('fas fa-exclamation-circle')
                            }
                            var newItem = $('<li>').addClass(
                                    'p-1 li_miembro d-flex justify-content-between').attr(
                                    'data-id',
                                    miembro
                                    .id_miembro)
                                .append($('<div>').addClass('d-flex align-items-center')
                                    .append(
                                        $('<span>').addClass('mb-0 mr-2').text(miembro
                                            .miembro.user_full_name), estadoIcon),
                                    $('<button>').addClass('btn btn-sm btn-danger')
                                    .text('x')
                                    .on('click', function() {
                                        $('#id_evento_miembro_eliminar').val(miembro
                                            .id_miembro_evento);
                                        $('#modalEliminarMiembroEvento').modal("show");

                                    })
                                );




                            $('#lista_miembros_evento').append(newItem);

                        });
                        $('#lista_miembros_evento [data-toggle="tooltip"]').tooltip();
                    }

                });
        }

        $('#btn_eliminar_evento_miembro').click(function() {
            const id = $('#id_evento_miembro_eliminar').val();
            $.ajax({
                type: 'DELETE',
                url: '/api/eventos2.php?id_evento_miembro=' + id,
                success: function() {
                    var id_evento = $('#btn_add_miembros_evento').data("id");
                    reloadMiembros(id_evento)
                    $('#modalEliminarMiembroEvento').modal("hide");
                    if (window.calendar != undefined) {
                        window.calendar.refetchEvents();
                    }
                }
            });
        });
        $(document).on("click", ".btn_personal", function() {
            const id = $(this).data("id");
            $('#btn_add_miembros_evento').data("id", id);
            reloadMiembros(id)
            $('#modalPersonalEvento').modal("show");
        });

        $('#btn_add_miembro_evento').click(function() {
            // Obtener el valor y el texto del extra seleccionado
            var id_miembro = $('#id_miembro_evento').val();
            var id_evento = $('#btn_add_miembros_evento').data("id");


            // Verificar si el extra ya está en la lista
            var isDuplicate = false;
            $('#lista_miembros_evento li').each(function() {

                if ($(this).data('id') == id_miembro) {
                    isDuplicate = true;

                    return false; // Salir del ciclo si se encuentra un duplicado
                }
            });
            if (isDuplicate) {
                $.toast({
                    heading: 'Miembro duplicado.',
                    text: 'Este miembro ya está en el evento.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });
                return;
            }
            // Si el extra es un duplicado, mostrar un mensaje
            $.post('/api/eventos2.php', {
                id_evento_agregar_miembro: id_evento,
                id_miembro_agregar_miembro: id_miembro
            }, function() {

                reloadMiembros(id_evento)
                $.toast({
                    heading: 'Miembro agregado.',
                    text: 'El maiembro se ha agregado correctamente.',
                    position: 'top-right',
                    loaderBg: '#32a852',
                    icon: 'success',
                    hideAfter: 2000,
                    stack: 6
                });
            });



        });
        $('#btn_devoluciones').click(function() {
            const id = $('#btn_devoluciones').data("id");
            const cantidad = $('#btn_devoluciones').data("cantidad");
            var cantidadDevuelta = parseInt($('#devueltos').val());
            if (cantidadDevuelta == "") {
                $.toast({
                    heading: 'Cantidad no válida.',
                    text: 'Ingresa una cantidad.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });

                return;
            }
            if (cantidadDevuelta > cantidad) {
                $.toast({
                    heading: 'Cantidad no válida.',
                    text: 'Ingresa una cantidad menor o igual que el total de unidades.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });

                return;
            }
            $.post('/api/eventos2.php', {
                id_evento_material_devolver: id,
                devueltos: cantidadDevuelta
            }, function() {
                $('#modalDevoluciones').modal("hide");
                reloadEventoMaterialsTable();

            });
        });
        $(document).on("click", "#btn_aceptar_presupuesto_evento2", function(e) {
            var id_presupuesto_aceptar = $(this).data("pre")
            var aceptado = $(this).data("e")


            $.ajax({

                type: 'POST',

                url: './api/presupuestos_material.php',

                cache: false,

                data: {

                    aceptado: aceptado,

                    id_presupuesto_aceptar: id_presupuesto_aceptar

                },

                success: function(result) {

                    console.log(result);

                    $.toast({

                        heading: 'Presupuesto ' + aceptado,

                        text: 'Se ha ' + aceptado +

                            ' el presupuesto correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 4

                    });
                    $("#modalVerPresupuesto").modal("hide");
                    $('#tabla_eventos').DataTable().ajax.reload(null, false);

                }

            });

            return false;

        })
        $(document).on("click", ".btn_presupuesto_evento", function() {

            var id_presupuesto_descargar = $(this).data("id")
            var id_presupuesto = $(this).data("pre")
            $("#btn_aceptar_presupuesto_evento2").data("pre", id_presupuesto)
            var estado = $(this).data("e")


            if (estado == "Aceptado") {
                $("#btn_aceptar_presupuesto_evento2").text("Rechazar")
                $("#btn_aceptar_presupuesto_evento2").data("e", "Rechazado")
            } else {
                $("#btn_aceptar_presupuesto_evento2").data("e", "Aceptado")
                $("#btn_aceptar_presupuesto_evento2").text("Aceptar")
            }
            var url

            var div = document.getElementById("contenedor_presupuesto")

            div.innerHTML = ""

            $.ajax({

                type: 'POST',

                url: './mailer',

                cache: false,

                async: false,

                data: {

                    id_evento_presupuesto_materiales_descargar: id_presupuesto_descargar



                },

                success: function(result2) {



                    url = result2;





                    var iframe = document.createElement('iframe');

                    iframe.setAttribute('id', 'presupuesto_modal');

                    iframe.setAttribute('src', url + '?timestamp=' + new Date()
                        .getTime());

                    iframe.style.width = "100%"

                    iframe.style.height = "70vh"

                    div.appendChild(iframe);
                    $("#btn_editar_presupuesto_evento").attr("href",
                        "./crear_presupuesto_materiales?id=" +
                        id_presupuesto)
                    $("#btn_eliminar_presupuesto_evento2").data("id", id_presupuesto)



                    $("#modalVerPresupuesto").modal("show");

                }

            });









        });

        $(document).on("click", ".btn_factura_evento", function() {

            var id_factura_descargar = $(this).data("id")
            var numero = $(this).data("numero")
            var id_factura = $(this).data("pre")
            $("#btn_aceptar_factura_evento2").data("pre", id_factura)
            var estado = $(this).data("e")


            if (estado == "Aceptado") {
                $("#btn_aceptar_factura_evento2").text("Rechazar")
                $("#btn_aceptar_factura_evento2").data("e", "Rechazado")
            } else {
                $("#btn_aceptar_factura_evento2").data("e", "Aceptado")
                $("#btn_aceptar_factura_evento2").text("Aceptar")
            }
            var url

            var div = document.getElementById("contenedor_factura")

            div.innerHTML = ""

            $.ajax({

                type: 'POST',

                url: './mailer',

                cache: false,

                async: false,

                data: {

                    id_evento_factura_materiales_descargar: id_factura_descargar



                },

                success: function(result2) {



                    url = result2;





                    var iframe = document.createElement('iframe');

                    iframe.setAttribute('id', 'factura_modal');

                    iframe.setAttribute('src', url + '?timestamp=' + new Date()
                        .getTime());

                    iframe.style.width = "100%"

                    iframe.style.height = "70vh"

                    div.appendChild(iframe);
                    $("#btn_editar_factura_evento").attr("href",
                        "./crear_factura_manual_materiales?id_factura=" +
                        id_factura)
                    $("#btn_eliminar_factura_evento2").data("id", id_factura)

                    $("#btn_facturae_factura_evento2").data("id", id_factura)
                    $("#btn_facturae_factura_evento2").data("numero", numero)
                    $("#modalVerFactura").modal("show");

                }

            });









        });
        $(document).on("click", "#btn_facturae_factura_evento2", function() {

            $("#btn_facturae").data("id", $(this).data("id"))
            $("#btn_facturae").data("numero", $(this).data("numero"))
            $("#nombre_facturae").val("Factura-e_" + $(this).data("numero"))

            $("#modalDescargarFacturaeMateriales").modal("show");

        })
        $('#btn_facturae').click(function(event) {

            var id = $(this).data("id")

            var firmado = $('input[name="firmado"]:checked').val();

            var nombre = $("#nombre_facturae").val()

            console.log(firmado);

            $.ajax({

                type: 'GET',

                url: './api/facturae2.php?id=' + id + "&firmado=" + firmado +

                    "&nombre=" +

                    nombre,

                cache: false,

                async: false,

                dataType: "json",

                success: function(result) {

                    console.log(result);

                    if (result.success) {

                        if (result.firmado == '1') {

                            var link = document.createElement('a');

                            link.href = result.url;

                            link.download = nombre + '.xsig';

                            document.body.appendChild(link);

                            link.click();

                            document.body.removeChild(link);

                        } else {

                            var link = document.createElement('a');

                            link.href = result.url;

                            link.download = nombre + '.xml';

                            document.body.appendChild(link);

                            link.click();

                            document.body.removeChild(link);

                        }



                        $('#modalDescargarFacturaeMateriales').modal("hide")

                    } else {

                        $.toast({

                            heading: "Credenciales incorrectas",

                            text: result.error,

                            position: 'top-right',

                            loaderBg: '#ff5c6c',

                            icon: 'error',

                            hideAfter: 5000,

                            stack: 6

                        });

                    }





                }

            });

            return false;

        });
    });

})(jQuery);
</script>