<div class="modal modal-cambiar fade" id="modalVerContrato" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Contrato</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div id="contenido_contrato" class="text-center modal-body pb-0">



            </div>


            <div class="modal-footer text-right">

                <input id="subir_docx" class=" d-none form-control" type="file"
                    accept=".docx, application/vnd.openxmlformats-officedocument.wordprocessingml.document">


                <button id="button_subir_contrato" class="btn btn-success" type="button">

                    Subir contrato</button>
                <a id="button_descargar_contrato" class="btn btn-info" type="button" download="">

                    Descargar contrato base</a>








            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal modal-cambiar fade" id="modalVerHorario" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Horario</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div id="contenido_horario" class="text-center modal-body pb-0">



            </div>


            <div class="modal-footer text-right">




                <input id="subir_file" class="d-none form-control" type="file" data-user="" data-id="" data-evento=""
                    accept=".pdf">


                <button id="button_subir_horario" class="btn btn-success" type="button">

                    Subir horario</button>
                <a id="button_descargar_horario" class="btn btn-info" type="button" download="">

                    Descargar horario base</a>







            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
(function($) {

    'use strict';

    $(function() {
        $("#button_descargar_contrato").click(function(params) {
            var url = "./contratos/" + $("#button_subir_contrato").data("evento") + "/" + $(
                "#button_subir_contrato").data("user") + "/contrato_vacio.pdf"
            var uniqueUrl = url + "?timestamp=" + new Date().getTime();
            $(this).attr('href', uniqueUrl);


        })
        $("#button_descargar_horario").click(function(params) {
            var url = '../horarios/default.pdf'
            var uniqueUrl = url + "?timestamp=" + new Date().getTime();
            $(this).attr('href', uniqueUrl);


        })
        $(document).on("click", ".ver_contrato", function() {


            var url = $(this).data("url")
            $("#button_subir_contrato").data("url", url)
            var user = $(this).data("user")
            $("#button_subir_contrato").data("user", user)
            var evento = $(this).data("evento")
            $("#button_subir_contrato").data("evento", evento)
            var id = $(this).data("id")
            $("#button_subir_contrato").data("id", id)
            if (url != null) {
                document.getElementById("contenido_contrato").innerHTML = ""
                var iframe = document.createElement('iframe');
                iframe.setAttribute('id', 'iframe_contrato');

                iframe.style.height = "400px"
                var uniqueUrl = url + "?timestamp=" + new Date().getTime();
                iframe.setAttribute('src', uniqueUrl);
                document.getElementById("contenido_contrato").appendChild(iframe);
            } else {
                document.getElementById("contenido_contrato").innerHTML = ""

                var pElement = document.createElement('p');

                pElement.textContent = 'Aún no has subido ningún contrato lleno';

                // Crear el elemento lord-icon
                var lordIconElement = document.createElement('lord-icon');
                lordIconElement.setAttribute('id', 'lord_contrato');
                lordIconElement.setAttribute('src', 'https://cdn.lordicon.com/qbtyvmai.json');
                lordIconElement.setAttribute('trigger', 'loop');
                lordIconElement.setAttribute('delay', '2000');
                lordIconElement.setAttribute('colors', 'primary:#000000,secondary:#000000');
                document.getElementById("contenido_contrato").appendChild(pElement);
                document.getElementById("contenido_contrato").appendChild(lordIconElement);
            }

            $("#modalVerContrato").modal("show")



        });


        $(document).on("change", "#subir_docx", function() {
            var id_user_evento = $("#button_subir_horario").data("id")
            var id_evento = $("#button_subir_horario").data("evento")
            var user_id = $("#button_subir_horario").data("user")
            var horario_lleno = this.files[0]
            // $("#file_contrato_" + id_user_evento).val(contrato_lleno.name)
            console.log(horario_lleno);
            CargarHorario(id_evento, user_id, horario_lleno, id_user_evento)

        })

        function CargarHorario(id_evento, user_id, horario_lleno, id_user_evento) {
            $("#button_subir_horario").addClass("btn-loading")
            var formData = new FormData();
            formData.append('id_evento_subir', id_evento);
            formData.append('horario_subir', horario_lleno);
            formData.append('id_user_evento_subir', id_user_evento);
            formData.append('user_id_subir', user_id);
            $.ajax({
                url: "./api/user_evento.php",
                type: 'POST',

                cache: false,
                async: false,

                processData: false, // tell jQuery not to process the data
                contentType: false,
                data: formData,
                success: function(res) {
                    var url = "./horarios/" + id_evento + "/" + user_id + "/horario_lleno.pdf"
                    document.getElementById("contenido_horario").innerHTML = ""
                    var iframe = document.createElement('iframe');
                    iframe.setAttribute('id', 'iframe_horario');

                    iframe.style.height = "400px"
                    var uniqueUrl = url + "?timestamp=" + new Date().getTime();
                    iframe.setAttribute('src', uniqueUrl);
                    document.getElementById("contenido_horario").appendChild(iframe);
                    $('.tabla_eventos').DataTable().ajax.reload(null, false);
                    $("#button_subir_horario").removeClass("btn-loading")
                    $.toast({
                        heading: 'Horario subido.',
                        text: 'Se ha subido el horario correctamente.',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                }
            })

        }
        $(document).on("click", "#button_subir_horario", function() {
            var id_user_evento = $(this).data("id")
            $("#subir_docx").click()



        });

        $(document).on("click", ".ver_horario", function() {


            var url = $(this).data("url")
            $("#button_subir_horario").data("url", url)
            var user = $(this).data("user")
            $("#button_subir_horario").data("user", user)
            var evento = $(this).data("evento")
            $("#button_subir_horario").data("evento", evento)
            var id = $(this).data("id")
            $("#button_subir_horario").data("id", id)
            if (url != null) {
                document.getElementById("contenido_horario").innerHTML = ""
                var iframe = document.createElement('iframe');
                iframe.setAttribute('id', 'iframe_horario');
                var uniqueUrl = url + "?timestamp=" + new Date().getTime();

                iframe.setAttribute('src', uniqueUrl);
                iframe.style.height = "400px"
                document.getElementById("contenido_horario").appendChild(iframe);
            } else {
                document.getElementById("contenido_horario").innerHTML = ""

                var pElement = document.createElement('p');

                pElement.textContent = 'Aún no has subido ningún horario lleno';

                // Crear el elemento lord-icon
                var lordIconElement = document.createElement('lord-icon');
                lordIconElement.setAttribute('id', 'lord_horario');
                lordIconElement.setAttribute('src', 'https://cdn.lordicon.com/qbtyvmai.json');
                lordIconElement.setAttribute('trigger', 'loop');
                lordIconElement.setAttribute('delay', '2000');
                lordIconElement.setAttribute('colors', 'primary:#000000,secondary:#000000');
                document.getElementById("contenido_horario").appendChild(pElement);
                document.getElementById("contenido_horario").appendChild(lordIconElement);
            }

            $("#modalVerHorario").modal("show")



        });
        $(document).on("change", "#subir_file", function() {
            var id_user_evento = $("#button_subir_contrato").data("id")
            var id_evento = $("#button_subir_contrato").data("evento")
            var user_id = $("#button_subir_contrato").data("user")
            var contrato_lleno = this.files[0]
            // $("#file_contrato_" + id_user_evento).val(contrato_lleno.name)
            console.log(contrato_lleno);
            CargarContrato(id_evento, user_id, contrato_lleno, id_user_evento)

        })
        $(document).on("click", "#button_subir_contrato", function() {
            var id_user_evento = $(this).data("id")
            $("#subir_file").click()



        });

        function CargarContrato(id_evento, user_id, contrato_lleno, id_user_evento) {

            var formData = new FormData();
            formData.append('id_evento_subir', id_evento);
            formData.append('contrato_subir', contrato_lleno);
            formData.append('id_user_evento_subir', id_user_evento);
            formData.append('user_id_subir', user_id);
            $.ajax({
                url: "./api/user_evento.php",
                type: 'POST',

                cache: false,
                async: false,

                processData: false, // tell jQuery not to process the data
                contentType: false,
                data: formData,
                success: function(res) {
                    var url = "./contratos/" + id_evento + "/" + user_id + "/contrato_lleno.pdf"
                    document.getElementById("contenido_contrato").innerHTML = ""
                    var iframe = document.createElement('iframe');
                    iframe.setAttribute('id', 'iframe_contrato');

                    iframe.style.height = "400px"
                    var uniqueUrl = url + "?timestamp=" + new Date().getTime();
                    iframe.setAttribute('src', uniqueUrl);
                    document.getElementById("contenido_contrato").appendChild(iframe);
                    $('.tabla_eventos').DataTable().ajax.reload(null, false);
                    $.toast({
                        heading: 'Contrato subido.',
                        text: 'Se ha subido el contrato correctamente.',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                }
            })

        }

    });
})(jQuery);
</script>