<div class="modal fade modal-cambiar" id="modalEliminarEstadoArchivo" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar estado</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el estado definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_estado_archivo_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_estado_archivo">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarEstadoArchivo" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar estado</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Nombre</label>
                                <input class="form-control w-100" id="nombre_estado_archivo" type="text">
                            </div>

                        </div>
                        <div class="col-12">

                            <div class="form-group">

                                <label>Color</label>


                                <input id="color_estado_archivo" type="text" class="colorpicker form-control"
                                    value="#7ab2fa" />
                            </div>



                        </div>



                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_estado_archivo" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<style>
.color_estado {
    width: 20px;
    height: 20px;
}
</style>

<script>
(function($) {
    'use strict';
    $(function() {

        function getData(id_estado_archivo = "No") {

            var r;
            $.ajax({
                url: "./api/estado_archivo.php",
                type: 'GET',
                dataType: 'json',
                cache: false,
                async: false,
                success: function(data) {
                    data = data.map(function(item) {
                        return {
                            id: item.id_estado_archivo,
                            text: item.nombre,
                            selected: (item.id_estado_archivo == id_estado_archivo) ?
                                true : false,
                            color: item.color
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguno',
                        selected: (id_estado_archivo == "No") ? true : false
                    });
                    r = data
                }
            });
            return r;
        }


        $('.select_estado_archivo').select2({
            data: getData(),
            templateResult: function(option) {
                if (!option.color) {
                    return option.text; // Mantener el placeholder sin cambios
                }

                // Crea un elemento span personalizado
                var $span = $('<div class="d-flex justify-content-between">' + option.text +
                    '<span style="background-color:' + option.color +
                    '" class="color_estado"></span></div>');

                return $span;
            }
        }).trigger("change");
        $("#btn_add_estado_archivo").click(function() {

            var color = $('#color_estado_archivo').val()
            var nombre = $("#nombre_estado_archivo").val()



            $.ajax({
                type: 'POST',
                url: './api/estado_archivo.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {

                    color: color,
                    nombre: nombre
                },
                success: function(r) {
                    console.log(r);
                    $('#modalAgregarEstadoArchivo').modal("hide")
                    $('.select_estado_archivo').empty()
                    $('.select_estado_archivo').select2({
                        data: getData(r.id_estado_archivo)
                    }).trigger("change");
                    $.toast({
                        heading: 'Estado agregado.',
                        text: 'Se ha agregado el estado correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    //$('#tabla_estado_archivo').DataTable().ajax.reload(null, false);
                    $("#btn_add_estado_archivo").removeClass('btn-loading');

                }
            });
        })

        $(document).on("click", ".btn_eliminar_estado_archivo", function() {

            var target = $(this).data("target");


            if (typeof target === 'undefined') {
                console.log($(this).data("id"));
                $("#id_estado_archivo_eliminar").val($(this).data("id"))
            } else {
                if ($("#" + target).val() == "No") {
                    return false;
                } else {
                    $("#id_estado_archivo_eliminar").val($("#" + target).val())
                }
            }

            $("#modalEliminarEstadoArchivo").modal("show");
        })

        $('#btn_eliminar_estado_archivo').click(function(event) {
            var id_estado_archivo_eliminar = $("#id_estado_archivo_eliminar").val()
            console.log(id_estado_archivo_eliminar);
            $.ajax({
                type: 'DELETE',
                url: './api/estado_archivo.php?id=' + id_estado_archivo_eliminar,
                cache: false,
                async: false,
                success: function(result) {

                    $('#modalEliminarEstadoArchivo').modal("hide")
                    $.toast({
                        heading: 'Estado eliminado',
                        text: 'Se ha eliminado el estado correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                    $('.select_estado_archivo').empty()
                    $('.select_estado_archivo').select2({
                        data: getData()
                    }).trigger("change");
                    // $('#tabla_estado_archivo').DataTable().ajax.reload(null, false);
                }
            });
            return false;
        });

    });
})(jQuery);
</script>