<div class="modal fade modal-cambiar" id="modalEliminarEmpleados" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar empleado</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar el empleado definitivamente?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>



            <!-- /btn -->



            <div class="modal-footer text-right">





                <input type="hidden" id="id_empleado_eliminar">

                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_empleado">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>

<div class="modal fade" id="modalAgregarEmpleado" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Empleado</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">

                            <div class="form-group">

                                <label for="my-input">Asociar usuario a empleado</label>

                                <div class="input-group" style="width: 100%;">

                                    <select id="id_empleado_add" style="width: 100%;"
                                        class="select_empleados custom-select select2 form-control">

                                        <?php

                                        foreach ($User_List as $User) {

                                        ?>

                                        <option value="<?php echo $User['user_id']; ?>">

                                            <?php echo htmlentities($User['user_full_name'], ENT_QUOTES); ?>

                                        </option>

                                        <?php

                                        }

                                        ?>

                                    </select>

                                </div>

                            </div>

                        </div>

                        <!-- Nombre -->

                        <div class="col-12">

                            <div class="form-group">

                                <label>Nombre</label>

                                <input type="text" class="form-control" id="nombre_empleado" required
                                    data-nombre="nombre">

                            </div>

                        </div>

                        <!-- DNI -->

                        <div class="col-12">

                            <div class="form-group">

                                <label>DNI</label>

                                <input type="text" class="form-control" id="dni_empleado" data-nombre="DNI" required>

                            </div>

                        </div>

                        <!-- Teléfono -->

                        <div class="col-12">

                            <div class="form-group">

                                <label>Teléfono</label>

                                <input id="telefono_empleado" type="text" class="form-control" pattern="[0-9]{10}"
                                    data-nombre="teléfono" required>

                            </div>

                        </div>

                        <!-- Dirección -->

                        <div class="col-12">

                            <div class="form-group">

                                <label>Dirección</label>

                                <input type="text" class="form-control" id="direccion_empleado" data-nombre="dirección"
                                    required>

                            </div>

                        </div>

                        <!-- Precio por Hora -->

                        <div class="col-12">

                            <div class="form-group">

                                <label>Precio por Hora</label>

                                <input id="precio_hora_empleado" type="number" class="form-control" step="any"
                                    data-nombre="precio por hora" required>

                            </div>

                        </div>

                        <!-- Número -->

                        <div class="col-12">

                            <div class="form-group">

                                <label>Número</label>

                                <input type="text" class="form-control" id="numero_empleado" data-nombre="número"
                                    required>

                            </div>

                        </div>

                        <!-- Email -->

                        <div class="col-12">

                            <div class="form-group">

                                <label>Email</label>

                                <input type="email" class="form-control" id="email_empleado" data-nombre="email"
                                    required>

                            </div>

                        </div>

                        <!-- NIF -->

                        <div class="col-12">

                            <div class="form-group">

                                <label>NIF</label>

                                <input type="text" class="form-control" id="nif_empleado" data-nombre="NIF" required>

                            </div>

                        </div>

                        <!-- Precio por Hora Extra -->

                        <div class="col-12">

                            <div class="form-group">

                                <label>Precio por Hora Extra</label>

                                <input id="precio_hora_extra_empleado" type="number" class="form-control" step="any"
                                    data-nombre="precio por hora extra" required>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div class="modal-footer text-right">

                <button id="btn_add_empleado" class="btn btn-success btn-fw" type="button">Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">Cancelar</button>

            </div>

        </div>

    </div>

</div>



<div class="modal fade" id="modalEditarEmpleado" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Editar Empleado</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <!-- Nombre -->

                        <div class="col-12">

                            <div class="form-group">

                                <label>Nombre</label>

                                <input type="text" class="form-control" id="nombre_empleado_editar" required
                                    data-nombre="nombre">

                            </div>

                        </div>

                        <!-- DNI -->

                        <div class="col-12">

                            <div class="form-group">

                                <label>DNI</label>

                                <input type="text" class="form-control" id="dni_empleado_editar" data-nombre="DNI"
                                    required>

                            </div>

                        </div>

                        <!-- Teléfono -->

                        <div class="col-12">

                            <div class="form-group">

                                <label>Teléfono</label>

                                <input id="telefono_empleado_editar" type="text" class="form-control"
                                    pattern="[0-9]{10}" data-nombre="teléfono" required>

                            </div>

                        </div>

                        <!-- Dirección -->

                        <div class="col-12">

                            <div class="form-group">

                                <label>Dirección</label>

                                <input type="text" class="form-control" id="direccion_empleado_editar"
                                    data-nombre="dirección" required>

                            </div>

                        </div>

                        <!-- Precio por Hora -->

                        <div class="col-12">

                            <div class="form-group">

                                <label>Precio por Hora</label>

                                <input id="precio_hora_empleado_editar" type="number" class="form-control" step="any"
                                    data-nombre="precio por hora" required>

                            </div>

                        </div>

                        <!-- Número -->

                        <div class="col-12">

                            <div class="form-group">

                                <label>Número</label>

                                <input type="text" class="form-control" id="numero_empleado_editar" data-nombre="número"
                                    required>

                            </div>

                        </div>

                        <!-- Email -->

                        <div class="col-12">

                            <div class="form-group">

                                <label>Email</label>

                                <input type="email" class="form-control" id="email_empleado_editar" data-nombre="email"
                                    required>

                            </div>

                        </div>

                        <!-- NIF -->

                        <div class="col-12">

                            <div class="form-group">

                                <label>NIF</label>

                                <input type="text" class="form-control" id="nif_empleado_editar" data-nombre="NIF"
                                    required>

                            </div>

                        </div>

                        <!-- Precio por Hora Extra -->

                        <div class="col-12">

                            <div class="form-group">

                                <label>Precio por Hora Extra</label>

                                <input id="precio_hora_extra_empleado_editar" type="number" class="form-control"
                                    step="any" data-nombre="precio por hora extra" required>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div class="modal-footer text-right">

                <button id="btn_edit_empleado" class="btn btn-success btn-fw" type="button">Editar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">Cancelar</button>

            </div>

        </div>

    </div>

</div>



<script>
(function($) {

    'use strict';

    $(function() {







        function getData() {

            var r

            $.ajax({

                url: "./api/empleados.php",

                type: 'GET',

                dataType: 'json', // added data type

                cache: false,

                async: false,

                dataType: "json",

                success: function(data) {

                    data = data.map(function(item) {

                        return {

                            id: item.id_empleado,

                            text: item.nombre,

                            selected: false

                        };

                    })

                    data.push({

                        id: 'No',

                        text: 'Ninguno',

                        selected: true

                    });

                    r = data

                }

            });

            return r

        }


        /*
                    $('.select_empleados').select2({}).trigger("change");

                    // Función para limpiar los campos del modal

                    function limpiarCampos(modal) {

                        $(`#${modal} input`).each(function() {

                            $(this).val("");

                        });

                    }

        */
        $('.select_empleados').select2({

            data: getData()

        }).trigger("change");
        // Agregar Empleado

        $("#btn_add_empleado").click(function() {

            // Obtener valores de los campos

            var id_empleado_add = $("#id_empleado_add").val().trim();

            var nombre_empleado = $("#nombre_empleado").val().trim();

            var dni_empleado = $('#dni_empleado').val().trim();

            var telefono_empleado = $('#telefono_empleado').val().trim();

            var direccion_empleado = $('#direccion_empleado').val().trim();

            var precio_hora_empleado = $('#precio_hora_empleado').val().trim();

            var numero_empleado = $('#numero_empleado').val().trim();

            var email_empleado = $('#email_empleado').val().trim();

            var nif_empleado = $('#nif_empleado').val().trim();

            var precio_hora_extra_empleado = $('#precio_hora_extra_empleado').val().trim();



            // Validación básica (puedes mejorar esto según tus necesidades)

            if (!id_empleado_add || !nombre_empleado || !dni_empleado || !telefono_empleado || !
                direccion_empleado || !

                precio_hora_empleado || !numero_empleado || !email_empleado || !nif_empleado || !

                precio_hora_extra_empleado) {

                $.toast({

                    heading: 'Error',

                    text: 'Por favor, completa todos los campos.',

                    position: 'top-right',

                    loaderBg: '#ff6849',

                    icon: 'error',

                    hideAfter: 3000,

                    stack: 6

                });

                return;

            }



            // Mostrar loader si tienes alguna clase de carga

            $("#btn_add_empleado").addClass('btn-loading');



            // Enviar datos al servidor

            $.ajax({

                type: 'POST',

                url: './api/empleados.php',

                cache: false,

                data: {

                    id_usuario: id_empleado_add,

                    nombre: nombre_empleado,

                    dni: dni_empleado,

                    telefono: telefono_empleado,

                    direccion: direccion_empleado,

                    precio_hora: precio_hora_empleado,

                    numero: numero_empleado,

                    email: email_empleado,

                    nif: nif_empleado,

                    precio_hora_extra: precio_hora_extra_empleado

                },

                success: function(result) {

                    console.log(result);



                    var r = JSON.parse(result);



                    $('#modalAgregarEmpleado').modal("hide");



                    $.toast({

                        heading: 'Empleado agregado.',

                        text: 'Se ha agregado el empleado correctamente.',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    });

                    $(".tabla_empleados").DataTable().ajax.reload(null, false);





                    $('.select_empleados').select2({

                        data: getData()

                    }).trigger("change");



                    $("#btn_add_empleado").removeClass('btn-loading');

                },

                error: function(xhr, status, error) {

                    console.error(error);

                    $.toast({

                        heading: 'Error',

                        text: 'No se pudo conectar al servidor.',

                        position: 'top-right',

                        loaderBg: '#ff6849',

                        icon: 'error',

                        hideAfter: 3000,

                        stack: 6

                    });

                    $("#btn_add_empleado").removeClass('btn-loading');

                }

            });

        });



        $(document).on("click", ".btn_eliminar_empleado", function() {



            var target = $(this).data("target");





            if (typeof target === 'undefined') {

                console.log($(this).data("id"));

                $("#id_empleado_eliminar").val($(this).data("id"))

            } else {

                if ($("#" + target).val() == "No") {

                    return false;

                } else {

                    $("#id_empleado_eliminar").val($("#" + target).val())

                }

            }





            $("#modalEliminarEmpleados").modal("show");

        })

        $('#btn_eliminar_empleado').click(function(event) {

            var id_empleado_eliminar = $("#id_empleado_eliminar").val()

            $.ajax({

                type: 'DELETE',

                url: './api/empleados.php?id=' + id_empleado_eliminar,

                cache: false,

                success: function(result) {

                    $('.select_empleados').empty()

                    $('.select_empleados').select2({

                        data: getData()

                    }).trigger("change");

                    $('#modalEliminarEmpleados').modal("hide")

                    $.toast({

                        heading: 'Empleados eliminado',

                        text: 'Se ha eliminado el empleado correctamente',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    })

                    $(".tabla_empleados").DataTable().ajax.reload(null, false);

                }

            });

            return false;

        });





        $("#btn_edit_empleado").click(function() {

            // Obtener valores de los campos

            var id_empleado = $(this).data("id");

            var nombre_empleado = $("#nombre_empleado_editar").val().trim();

            var dni_empleado = $('#dni_empleado_editar').val().trim();

            var telefono_empleado = $('#telefono_empleado_editar').val().trim();

            var direccion_empleado = $('#direccion_empleado_editar').val().trim();

            var precio_hora_empleado = $('#precio_hora_empleado_editar').val().trim();

            var numero_empleado = $('#numero_empleado_editar').val().trim();

            var email_empleado = $('#email_empleado_editar').val().trim();

            var nif_empleado = $('#nif_empleado_editar').val().trim();

            var precio_hora_extra_empleado = $('#precio_hora_extra_empleado_editar').val().trim();



            // Validación básica

            if (!nombre_empleado || !dni_empleado || !telefono_empleado || !direccion_empleado || !

                precio_hora_empleado || !numero_empleado || !email_empleado || !nif_empleado || !

                precio_hora_extra_empleado) {

                $.toast({

                    heading: 'Error',

                    text: 'Por favor, completa todos los campos.',

                    position: 'top-right',

                    loaderBg: '#ff6849',

                    icon: 'error',

                    hideAfter: 3000,

                    stack: 6

                });

                return;

            }



            // Mostrar loader si tienes alguna clase de carga

            $("#btn_edit_empleado").addClass('btn-loading');



            // Enviar datos al servidor

            $.ajax({

                type: 'POST',

                url: './api/empleados.php',

                cache: false,

                data: {

                    id_empleado: id_empleado,

                    nombre: nombre_empleado,

                    dni: dni_empleado,

                    telefono: telefono_empleado,

                    direccion: direccion_empleado,

                    precio_hora: precio_hora_empleado,

                    numero: numero_empleado,

                    email: email_empleado,

                    nif: nif_empleado,

                    precio_hora_extra: precio_hora_extra_empleado

                },

                success: function(result) {

                    console.log(result);



                    var r = JSON.parse(result);



                    $('#modalEditarEmpleado').modal("hide");

                    $('.select_empleados').empty().select2({

                        data: getData()

                    }).trigger("change");

                    $.toast({

                        heading: 'Empleado editado.',

                        text: 'Se ha editado el empleado correctamente.',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 6

                    });

                    $(".tabla_empleados").DataTable().ajax.reload(null, false);










                    $("#btn_edit_empleado").removeClass('btn-loading');

                },

                error: function(xhr, status, error) {

                    console.error(error);

                    $.toast({

                        heading: 'Error',

                        text: 'No se pudo conectar al servidor.',

                        position: 'top-right',

                        loaderBg: '#ff6849',

                        icon: 'error',

                        hideAfter: 3000,

                        stack: 6

                    });

                    $("#btn_edit_empleado").removeClass('btn-loading');

                }

            });

        });



        // Cargar datos en el modal de edición al hacer clic en el botón de editar

        $(document).on("click", ".btn_editar_empleado", function() {

            var id_empleado = $(this).data("id");

            // Aquí deberías hacer una llamada AJAX para obtener los datos del empleado y rellenar el formulario

            $.ajax({

                type: 'GET',

                url: './api/empleados.php?id=' + id_empleado,

                cache: false,

                success: function(result) {



                    var r = JSON.parse(result);



                    var empleado = r.data;

                    $("#nombre_empleado_editar").val(empleado.nombre);

                    $("#dni_empleado_editar").val(empleado.dni);

                    $("#telefono_empleado_editar").val(empleado.telefono);

                    $("#direccion_empleado_editar").val(empleado.direccion);

                    $("#precio_hora_empleado_editar").val(empleado.precio_hora);

                    $("#numero_empleado_editar").val(empleado.numero);

                    $("#email_empleado_editar").val(empleado.email);

                    $("#nif_empleado_editar").val(empleado.nif);

                    $("#precio_hora_extra_empleado_editar").val(empleado

                        .precio_hora_extra);

                    $("#btn_edit_empleado").data("id", id_empleado);

                    $("#modalEditarEmpleado").modal("show");





                },

                error: function(xhr, status, error) {

                    console.error(error);

                    $.toast({

                        heading: 'Error',

                        text: 'No se pudo conectar al servidor.',

                        position: 'top-right',

                        loaderBg: '#ff6849',

                        icon: 'error',

                        hideAfter: 3000,

                        stack: 6

                    });

                }

            });

        });

    });

})(jQuery);
</script>