<div class="modal fade modal-cambiar" id="modalEliminarEmpleados" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar empleado</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el empleado definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_empleado_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_empleado">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarEmpleado" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Empleado</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Nombre</label>
                                <input type="text" class="form-control requerido" id="nombre_empleado" placeholder=""
                                    required data-nombre="nombre">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Apellidos</label>
                                <input type="text" class="form-control requerido" id="apellidos_empleado" placeholder=""
                                    data-nombre="apellidos">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Número de seguridad social</label>
                                <input type="text" class="form-control requerido" id="numero_seguridad_social_empleado"
                                    placeholder="" data-nombre="número de seguridad social">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>NIF</label>
                                <input type="text" class="form-control requerido" id="nif_empleado" placeholder=""
                                    data-nombre="NIF">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Dirección</label>
                                <input type="text" class="form-control" id="direccion_empleado" placeholder=""
                                    data-nombre="dirección">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Teléfono</label>
                                <input id="telefono_empleado" type="text" class="form-control" pattern="[0-9]{10}"
                                    data-nombre="teléfono">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Email</label>
                                <input type="email" class="form-control" id="email_empleado" placeholder=""
                                    data-nombre="email">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Fecha de Contratación</label>
                                <input type="date" class="form-control" id="fecha_contratacion_empleado"
                                    data-nombre="fecha de contratación">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Fecha de Nacimiento</label>
                                <input type="date" class="form-control requerido" id="fecha_nacimiento_empleado"
                                    data-nombre="fecha de nacimiento">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Estado</label>

                                <select class="form-control" id="estado_empleado" placeholder="" data-nombre="estado">
                                    <option value="Activo">Activo</option>
                                    <option value="Inactivo">Inactivo</option>
                                </select>
                            </div>
                        </div>

                    </div>

                </div>

            </div>

            <div class="modal-footer text-right">
                <button id="btn_add_empleado" class="btn btn-success btn-fw" type="button">
                    Agregar
                </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar
                </button>
            </div>

        </div>

    </div>

</div>

<div class="modal fade" id="modalEditarEmpleado" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Editar empleado</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>

            </div>

            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Nombre</label>
                                <input type="text" class="form-control requerido" id="nombre_empleado_editar"
                                    placeholder="" required data-nombre="nombre">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Apellidos</label>
                                <input type="text" class="form-control requerido" id="apellidos_empleado_editar"
                                    placeholder="" data-nombre="apellidos">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Número de seguridad social</label>
                                <input type="text" class="form-control requerido"
                                    id="numero_seguridad_social_empleado_editar" placeholder=""
                                    data-nombre="número de seguridad social">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>NIF</label>
                                <input type="text" class="form-control requerido" id="nif_empleado_editar"
                                    placeholder="" data-nombre="NIF">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Dirección</label>
                                <input type="text" class="form-control" id="direccion_empleado_editar" placeholder=""
                                    data-nombre="dirección">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Teléfono</label>
                                <input id="telefono_empleado_editar" type="text" class="form-control"
                                    pattern="[0-9]{10}" data-nombre="teléfono">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Email</label>
                                <input type="email" class="form-control" id="email_empleado_editar" placeholder=""
                                    data-nombre="email">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Fecha de Contratación</label>
                                <input type="date" class="form-control" id="fecha_contratacion_empleado_editar"
                                    data-nombre="fecha de contratación">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Fecha de Nacimiento</label>
                                <input type="date" class="form-control requerido" id="fecha_nacimiento_empleado_editar"
                                    data-nombre="fecha de nacimiento">
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Estado</label>

                                <select class="form-control" id="estado_empleado_ditar" placeholder=""
                                    data-nombre="estado">
                                    <option value="Activo">Activo</option>
                                    <option value="Inactivo">Inactivo</option>
                                </select>
                            </div>
                        </div>


                    </div>

                </div>

            </div>

            <div class="modal-footer text-right">
                <button id="btn_edit_empleado" class="btn btn-success btn-fw" type="button">
                    Editar
                </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar
                </button>
            </div>

        </div>

    </div>

</div>


<script>
(function($) {
    'use strict';
    $(function() {



        function getData() {
            var r
            $.ajax({
                url: "./api/empleado.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                dataType: "json",
                success: function(data) {
                    data = data.map(function(item) {
                        return {
                            id: item.id_empleado,
                            text: item.nombre,
                            selected: false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguno',
                        selected: true
                    });
                    r = data
                }
            });
            return r
        }

        $('.select_empleados').select2({
            data: getData()
        }).trigger("change");
        $("#btn_add_empleado").click(function() {
            var nombre_empleado = $("#nombre_empleado").val();
            var apellidos_empleado = $("#apellidos_empleado").val();
            var nif_empleado = $("#nif_empleado").val();
            var direccion_empleado = $('#direccion_empleado').val();
            var telefono_empleado = $('#telefono_empleado').val();
            var email_empleado = $('#email_empleado').val();
            var fecha_contratacion_empleado = $('#fecha_contratacion_empleado').val();
            var fecha_nacimiento_empleado = $('#fecha_nacimiento_empleado').val();
            var estado_empleado = $('#estado_empleado').val();
            var numero_seguridad_social_empleado = $("#numero_seguridad_social_empleado").val();
            var camposValidos = true;
            $("#modalAgregarEmpleado .requerido").each(function() {
                if ($(this).val().trim() === "") {
                    $.toast({
                        heading: 'El campo de ' + $(this).data("nombre") +
                            " es requerido",
                        text: 'Por favor, complete todos los campos obligatorios.',
                        position: 'top-right',
                        loaderBg: '#ff4859',
                        icon: 'error',
                        hideAfter: 3000,
                        stack: 6
                    });
                    $(this).focus()
                    camposValidos = false;
                    return false;
                }
            });

            if (!camposValidos) {

                return; // Salir de la función si hay errores
            }
            $.ajax({
                type: 'POST',
                url: './api/empleado.php',
                cache: false,
                data: {
                    nombre: nombre_empleado,
                    apellidos: apellidos_empleado,
                    nif: nif_empleado,
                    direccion: direccion_empleado,
                    telefono: telefono_empleado,
                    email: email_empleado,
                    fecha_contratacion: fecha_contratacion_empleado,
                    fecha_nacimiento: fecha_nacimiento_empleado,
                    estado: estado_empleado,
                    numero_seguridad_social: numero_seguridad_social_empleado
                },
                success: function(result) {
                    console.log(result);
                    var r = JSON.parse(result);
                    $('#modalAgregarEmpleado').modal("hide");
                    $('.select_empleados').empty();
                    $('.select_empleados').select2({
                        data: getData()
                    }).trigger("change");
                    $.toast({
                        heading: 'Empleado agregado.',
                        text: 'Se ha agregado el empleado correctamente.',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    $(".tabla_empleados").DataTable().ajax.reload(null, false);
                    $("#btn_add_empleado").removeClass('btn-loading');
                    $("#modalAgregarEmpleado input").each(function() {
                        $(this).val("");
                    });
                }
            });
        });

        $(document).on("click", ".btn_eliminar_empleado", function() {

            var target = $(this).data("target");


            if (typeof target === 'undefined') {
                console.log($(this).data("id"));
                $("#id_empleado_eliminar").val($(this).data("id"))
            } else {
                if ($("#" + target).val() == "No") {
                    return false;
                } else {
                    $("#id_empleado_eliminar").val($("#" + target).val())
                }
            }


            $("#modalEliminarEmpleados").modal("show");
        })
        $('#btn_eliminar_empleado').click(function(event) {
            var id_empleado_eliminar = $("#id_empleado_eliminar").val()
            $.ajax({
                type: 'DELETE',
                url: './api/empleado.php?id=' + id_empleado_eliminar,
                cache: false,
                success: function(result) {
                    $('.select_empleados').empty()
                    $('.select_empleados').select2({
                        data: getData()
                    }).trigger("change");
                    $('#modalEliminarEmpleados').modal("hide")
                    $.toast({
                        heading: 'Empleados eliminado',
                        text: 'Se ha eliminado el empleado correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                    $(".tabla_empleados").DataTable().ajax.reload(null, false);
                }
            });
            return false;
        });
        $(document).on("click", ".btn_editar_empleado", function(event) {
            var id = $(this).data("id");
            $("#btn_edit_empleado").data("id", id);

            $.ajax({
                url: './api/empleado.php?id_empleado=' + id,
                type: 'GET',
                cache: false,
                dataType: 'json', // added data type
                success: function(result) {
                    console.log(result);
                    $("#nombre_empleado_editar").val(result.nombre);
                    $("#numero_seguridad_social_empleado_editar").val(result
                        .numero_seguridad_social);
                    $("#apellidos_empleado_editar").val(result.apellidos);
                    $("#nif_empleado_editar").val(result.nif);
                    $("#direccion_empleado_editar").val(result.direccion);
                    $("#telefono_empleado_editar").val(result.telefono);
                    $("#email_empleado_editar").val(result.email);
                    $("#fecha_contratacion_empleado_editar").val(result
                        .fecha_contratacion);
                    $("#fecha_nacimiento_empleado_editar").val(result.fecha_nacimiento);
                    $("#estado_empleado_editar").val(result.estado);

                    $("#modalEditarEmpleado").modal("show");
                }
            });
        });


        $("#btn_edit_empleado").click(function() {
            var id_empleado = $(this).data("id");
            var nombre_empleado = $("#nombre_empleado_editar").val();
            var numero_seguridad_social_empleado = $("#numero_seguridad_social_empleado_editar")
                .val();
            var apellidos_empleado = $("#apellidos_empleado_editar").val();
            var nif_empleado = $("#nif_empleado_editar").val();
            var direccion_empleado = $('#direccion_empleado_editar').val();
            var telefono_empleado = $('#telefono_empleado_editar').val();
            var email_empleado = $('#email_empleado_editar').val();
            var fecha_contratacion_empleado = $('#fecha_contratacion_empleado_editar').val();
            var fecha_nacimiento_empleado = $('#fecha_nacimiento_empleado_editar').val();
            var estado_empleado = $('#estado_empleado_editar').val();
            $("#modalEditarEmpleado .requerido").each(function() {
                if ($(this).val().trim() === "") {
                    $.toast({
                        heading: 'El campo de ' + $(this).data("nombre") +
                            " es requerido",
                        text: 'Por favor, complete todos los campos obligatorios.',
                        position: 'top-right',
                        loaderBg: '#ff4859',
                        icon: 'error',
                        hideAfter: 3000,
                        stack: 6
                    });
                    $(this).focus()
                    camposValidos = false;
                    return
                }
            });

            if (!camposValidos) {

                return; // Salir de la función si hay errores
            }
            $.ajax({
                type: 'POST',
                url: './api/empleado.php',
                cache: false,
                data: {
                    id_empleado: id_empleado,
                    nombre: nombre_empleado,
                    apellidos: apellidos_empleado,
                    nif: nif_empleado,
                    direccion: direccion_empleado,
                    telefono: telefono_empleado,
                    email: email_empleado,
                    fecha_contratacion: fecha_contratacion_empleado,
                    fecha_nacimiento: fecha_nacimiento_empleado,
                    estado: estado_empleado,
                    numero_seguridad_social: numero_seguridad_social_empleado
                },
                success: function(result) {
                    console.log(result);
                    var r = JSON.parse(result);
                    $('#modalEditarEmpleado').modal("hide");
                    $('.select_empleados').empty();
                    $('.select_empleados').select2({
                        data: getData()
                    }).trigger("change");
                    $.toast({
                        heading: 'Empleado editado.',
                        text: 'Se ha editado el empleado correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    $(".tabla_empleados").DataTable().ajax.reload(null, false);
                    $("#btn_edit_empleado").removeClass('btn-loading');
                    $("#modalEditarEmpleado input").each(function() {
                        $(this).val("");
                    });
                }
            });
        });

    });
})(jQuery);
</script>