<div class="modal fade" id="modalAgregarEmail" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Agregar email personalizado</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="container p-0">

                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <h5>Nombre</h5>
                                <input id="nombre_email_custom" class="form-control valor_personalizacion" type="text"
                                    value="">
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <h5>Asunto</h5>
                                <input id="asunto_email_custom" class="form-control valor_personalizacion" type="text"
                                    value="">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <h5 class="mb-2">Tags</h5>
                                <div style="flex-wrap: wrap;"
                                    class="mb-1 d-flex flex-row justify content start align-items-end">
                                    <button class="btn btn-success btn-fw mb-2 mr-2 tag_button" type="button"
                                        data-tag="nombre">
                                        %nombre%</button>

                                    <button class="btn btn-success btn-fw mb-2 mr-2 tag_button" type="button"
                                        data-tag="nombreyapellido">
                                        %nombreyapellido%</button>
                                    <button class="d-none btn btn-success btn-fw mb-2 mr-2" id="tag_boton_baja"
                                        type="button">
                                        %boton_dar_baja%</button>
                                    <button class="btn btn-success btn-fw mb-2 mr-2 tag_button" type="button"
                                        data-tag="fechadehoy">
                                        %fechadehoy%</button>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <h5>Cuerpo</h5>
                                <textarea id="cuerpo_email_custom" class="form-control"></textarea>

                            </div>
                        </div>
                    </div>






                </div>
            </div>
            <div class="modal-footer text-right">
                <button id="btn_add_email_custom" class="btn btn-success btn-fw" type="button">
                    Agregar</button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>
            </div>
            <!-- /modal-body -->
        </div>

    </div>

</div>
<div class="modal fade" id="modalEditarEmail" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Editar email personalizado</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="container p-0">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <h5>Nombre</h5>
                                <input id="nombre_email_custom_editar" class="form-control valor_personalizacion"
                                    type="text" value="">
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <h5>Asunto</h5>
                                <input id="asunto_email_custom_editar" class="form-control valor_personalizacion"
                                    type="text" value="">
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <h5 class="mb-2">Tags</h5>
                                <div style="flex-wrap: wrap;"
                                    class="mb-1 d-flex flex-row justify content start align-items-end">
                                    <button class="btn btn-success btn-fw mb-2 mr-2 tag_button_editar" type="button"
                                        data-tag="nombre">
                                        %nombre%</button>


                                    <button class="btn btn-success btn-fw mb-2 mr-2 tag_button_editar" type="button"
                                        data-tag="nombreyapellido">
                                        %nombreyapellido%</button>
                                    <button class="d-none btn btn-success btn-fw mb-2 mr-2" id="tag_boton_baja"
                                        type="button">
                                        %boton_dar_baja%</button>
                                    <button class="btn btn-success btn-fw mb-2 mr-2 tag_button_editar" type="button"
                                        data-tag="fechadehoy">
                                        %fechadehoy%</button>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <h5>Cuerpo</h5>
                                <textarea id="cuerpo_email_custom_editar" class="form-control"></textarea>

                            </div>
                        </div>
                    </div>


                </div>
            </div>
            <div class="modal-footer text-right">
                <button id="btn_edit_email_custom" class="btn btn-success btn-fw" type="button">
                    Editar</button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>
            </div>
            <!-- /modal-body -->
        </div>

    </div>

</div>

<div class="modal fade modal-cambiar" id="modalEliminarEmail" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar email personalizado</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el email personalizado definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_email_custom_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_email_personalizado">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>

<script>
(function($) {
    'use strict';
    $(function() {

        var changeEnabled = false;

        if ($("#cuerpo_email_custom").length > 0) {
            tinymce.init({
                selector: "textarea#cuerpo_email_custom",
                theme: "modern",
                height: 400,
                plugins: [
                    "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
                    "searchreplace visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                    "save table directionality emoticons template paste textcolor"
                ],
                toolbar: "insertfile undo redo | code | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | print preview media fullpage | forecolor backcolor emoticons",
                language: "es",
                branding: false,
                setup: function(editor) {

                    editor.on('change', function() {
                        if (!changeEnabled) {
                            return;
                        }




                        changeEnabled = false;
                    });
                    editor.on('init', function() {

                        // Crear el botón personalizado
                        var button = document.createElement('button');
                        button.type = 'button';
                        button.innerHTML = 'Guardar';
                        button.className =
                            'btn_guardar_mce m-2 btn btn-success';
                        button.id = 'btn_guardar_mce'
                        // Definir la acción del botón
                        button.onclick = function() {
                            changeEnabled = true;
                            editor.fire('change');
                            changeEnabled = false;
                        };

                        // Agregar el botón al footer del editor
                        var container = editor.getContainer();
                        var footer = container.querySelector(
                            '.mce-statusbar .mce-container-body'
                        );
                        console.log(footer);
                        if (footer) {
                            footer.appendChild(button);
                        }
                    });
                }
            });
        }


        if ($("#cuerpo_email_custom_editar").length > 0) {
            tinymce.init({
                selector: "textarea#cuerpo_email_custom_editar",
                theme: "modern",
                height: 400,
                plugins: [
                    "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
                    "searchreplace visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                    "save table directionality emoticons template paste textcolor"
                ],
                toolbar: "insertfile undo redo | code | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | print preview media fullpage | forecolor backcolor emoticons",
                language: "es",
                branding: false,

                setup: function(editor) {

                    editor.on('change', function() {
                        if (!changeEnabled) {
                            return;
                        }




                        changeEnabled = false;
                    });
                    editor.on('init', function() {

                        // Crear el botón personalizado
                        var button = document.createElement('button');
                        button.type = 'button';
                        button.innerHTML = 'Guardar';
                        button.className =
                            'btn_guardar_mce m-2 btn btn-success';
                        button.id = 'btn_guardar_mce'
                        // Definir la acción del botón
                        button.onclick = function() {
                            changeEnabled = true;
                            editor.fire('change');
                            changeEnabled = false;
                        };

                        // Agregar el botón al footer del editor
                        var container = editor.getContainer();
                        var footer = container.querySelector(
                            '.mce-statusbar .mce-container-body'
                        );
                        console.log(footer);
                        if (footer) {
                            footer.appendChild(button);
                        }
                    });
                }
            });
        }

        function insertCustomText(tag) {
            changeEnabled = true;
            var editor = tinymce.get('cuerpo_email_custom');

            // Obtener el contenido actual del editor
            var content = editor.getContent({
                format: 'html'
            });

            // Obtener la posición del cursor de texto
            var cursorPosition = editor.selection.getBookmark();

            // Insertar el tag en la posición del cursor de texto
            editor.selection.moveToBookmark(cursorPosition);
            editor.selection.setContent('%' + tag + '%');
            changeEnabled = false;
        }

        function insertCustomTextEditar(tag) {
            changeEnabled = true;
            var editor = tinymce.get('cuerpo_email_custom_editar');

            // Obtener el contenido actual del editor
            var content = editor.getContent({
                format: 'html'
            });

            // Obtener la posición del cursor de texto
            var cursorPosition = editor.selection.getBookmark();

            // Insertar el tag en la posición del cursor de texto
            editor.selection.moveToBookmark(cursorPosition);
            editor.selection.setContent('%' + tag + '%');
            changeEnabled = false;
        }

        function insertTextAtCursor(textareaId, text) {
            var textarea = document.getElementById(textareaId);
            var scrollPos = textarea.scrollTop;
            var strPos = 0;
            var br = ((textarea.selectionStart || textarea.selectionStart == '0') ?
                "ff" : (document.selection ? "ie" : false));

            if (br == "ie") {
                textarea.focus();
                var range = document.selection.createRange();
                range.moveStart('character', -textarea.value.length);
                strPos = range.text.length;
            } else if (br == "ff") {
                strPos = textarea.selectionStart;
            }

            var front = (textarea.value).substring(0, strPos);
            var back = (textarea.value).substring(strPos, textarea.value.length);
            textarea.value = front + "%" + text + "%" + back;
            strPos = strPos + text.length;

            if (br == "ie") {
                textarea.focus();
                var ieRange = document.selection.createRange();
                ieRange.moveStart('character', -textarea.value.length);
                ieRange.moveStart('character', strPos);
                ieRange.moveEnd('character', 0);
                ieRange.select();
            } else if (br == "ff") {
                textarea.selectionStart = strPos;
                textarea.selectionEnd = strPos;
                textarea.focus();
            }

            textarea.scrollTop = scrollPos;
        }
        $(document).on("click", ".tag_button", function() {
            var tag = $(this).data("tag")
            insertCustomText(tag)
        });
        $(document).on("click", ".tag_button_editar", function() {
            var tag = $(this).data("tag")
            insertCustomTextEditar(tag)
        });
        $(document).on("click", "#tag_boton_baja", function() {
            changeEnabled = true;
            var editor = tinymce.get('cuerpo_email_custom');


            // Guardar la posición del cursor
            editor.focus(); // Asegura que el editor esté activo
            var cursorPosition = editor.selection.getBookmark();

            // Insertar el contenido en la posición actual
            editor.selection.moveToBookmark(cursorPosition);
            editor.insertContent(
                `<a href="%url%dar_baja?client_id=%client_id%" style=" 
                pointer-events: auto;
               
                
    box-sizing: border-box;
    margin: 0;
    overflow: visible;
    text-transform: none;
    outline: 0;
    outline-offset: 0;
    display: inline-block;
    font-weight: 400;
    text-align: center;
    white-space: nowrap;
    vertical-align: middle;
    user-select: none;
    border: 1px solid rgba(0, 0, 0, 0);
    padding: .56rem 1.375rem;
    border-radius: .1875rem;
    transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
    background-color: <?php echo htmlentities($personalizacion['color_elementos'], ENT_QUOTES); ?>;
    border-color: <?php echo htmlentities($personalizacion['color_elementos'], ENT_QUOTES); ?>;
    box-shadow: none;
    font-size: .875rem;
    line-height: 1;
    font-family: "Muli", sans-serif;
    
    margin-right: .25rem;
    min-width: 120px;
    color: #ffffff;
    cursor: pointer;
    text-decoration: none;">Dar de baja</a>`
            );
        });
        $(document).on("click", "#tag_boton_baja_editar", function() {
            changeEnabled = true;
            var editor = tinymce.get('cuerpo_email_custom_editar');


            // Guardar la posición del cursor
            editor.focus(); // Asegura que el editor esté activo
            var cursorPosition = editor.selection.getBookmark();

            // Insertar el contenido en la posición actual
            editor.selection.moveToBookmark(cursorPosition);
            editor.insertContent(
                `<a href="%url%dar_baja?client_id=%client_id%" style=" 
                pointer-events: auto;
               
                    box-sizing: border-box;
                    margin: 0;
                    overflow: visible;
                    text-transform: none;
                    outline: 0;
                    outline-offset: 0;
                    display: inline-block;
                    font-weight: 400;
                    text-align: center;
                    white-space: nowrap;
                    vertical-align: middle;
                    user-select: none;
                    border: 1px solid rgba(0, 0, 0, 0);
                    padding: .56rem 1.375rem;
                    border-radius: .1875rem;
                    transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
                    background-color: #0cca8e;
                    border-color: #0cca8e;
                    box-shadow: none;
                    font-size: .875rem;
                    line-height: 1;
                    font-family: "Muli", sans-serif;
                    
                    margin-right: .25rem;
                    min-width: 120px;
                    color: #ffffff;
                    cursor: pointer;
                    text-decoration: none;">Dar de baja</a>`
            );
        });

        function getData() {
            var r
            $.ajax({
                url: "./api/email_custom.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                dataType: "json",
                success: function(data) {


                    data = data.map(function(item) {
                        return {
                            id: item.id_email_custom,
                            text: item.nombre,
                            selected: false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguno',
                        selected: true
                    });
                    r = data
                }
            });
            return r
        }

        $('.select_email_custom').select2({
            data: getData()
        }).trigger("change");

        function validarCampos() {

            var asunto_email_custom = $("#asunto_email_custom").val();
            var cuerpo_email_custom = tinymce.get("cuerpo_email_custom").getContent();
            var nombre_email_custom = $("#nombre_email_custom").val();

            var res = true



            if (nombre_email_custom == "") {
                $.toast({
                    heading: 'Campo vacío',
                    text: 'El campo nombre no puede estar vacío.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                res = false
            }
            if (asunto_email_custom == "") {
                $.toast({
                    heading: 'Campo vacío',
                    text: 'El campo asunto no puede estar vacío.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                res = false
            }
            if (cuerpo_email_custom == "") {
                $.toast({
                    heading: 'Campo vacío',
                    text: 'El campo cuerpo no puede estar vacío.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                res = false
            }

            return res

        }

        function validarCamposEditar() {

            var asunto_email_custom = $("#asunto_email_custom_editar").val();
            var cuerpo_email_custom = tinymce.get("cuerpo_email_custom_editar").getContent();
            var nombre_email_custom = $("#nombre_email_custom_editar").val();

            var res = true



            if (nombre_email_custom == "") {
                $.toast({
                    heading: 'Campo vacío',
                    text: 'El campo nombre no puede estar vacío.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                res = false
            }
            if (asunto_email_custom == "") {
                $.toast({
                    heading: 'Campo vacío',
                    text: 'El campo asunto no puede estar vacío.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                res = false
            }
            if (cuerpo_email_custom == "") {
                $.toast({
                    heading: 'Campo vacío',
                    text: 'El campo cuerpo no puede estar vacío.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 5000,
                    stack: 6
                });
                res = false
            }

            return res

        }
        $("#btn_add_email_custom").click(function() {
            $("#btn_add_email_custom").addClass('btn-loading');
            var nombre_email_custom = $('#nombre_email_custom').val()
            var asunto_email_custom = $("#asunto_email_custom").val()
            var cuerpo_email_custom = tinymce.get("cuerpo_email_custom").getContent();

            if (!validarCampos()) {
                $("#btn_add_email_custom").removeClass('btn-loading');
                return false
            }


            $.ajax({
                type: 'POST',
                url: './api/email_custom.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    nombre: nombre_email_custom,
                    asunto: asunto_email_custom,
                    cuerpo: cuerpo_email_custom
                },
                success: function(r) {
                    console.log(r);
                    if (r.success) {
                        $('#modalAgregarEmail').modal("hide")
                        $('.select_email_custom').empty()
                        $('.select_email_custom').select2({
                            data: getData()
                        }).trigger("change");
                        $.toast({
                            heading: r.title,
                            text: r.message,
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });
                        $('#modalAgregarEmail input').each(function() {
                            $(this).val("")
                        })

                    } else {
                        console.log(r);
                        $.toast({
                            heading: r.title,
                            text: r.message,
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 5000,
                            stack: 6
                        });
                    }


                    $("#btn_add_email_custom").removeClass('btn-loading');

                },
                error: function(r) {
                    console.log(r);
                }

            });
        })

        $(document).on("click", ".btn_eliminar_email_custom", function() {

            var target = $(this).data("target");


            if (typeof target === 'undefined') {

                $("#btn_email_custom_eliminar").data("id", $(this).data("id"))
            } else {
                if ($("#" + target).val() == "No") {
                    return false;
                } else {
                    $("#btn_email_custom_eliminar").data("id", $("#" + target).val())
                }
            }

            $("#modalEliminarEmail").modal("show");
        })

        $('#btn_eliminar_email_custom').click(function(event) {
            var id_email_custom_eliminar = $("#btn_email_custom_eliminar").data("id")

            $.ajax({
                type: 'DELETE',
                url: './api/email_custom.php?id=' + id_email_custom_eliminar,
                cache: false,
                success: function(result) {

                    $('#modalEliminarEmail').modal("hide")
                    $.toast({
                        heading: 'Email eliminado',
                        text: 'Se ha eliminado el email correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                    $('.select_email_custom').empty()
                    $('.select_email_custom').select2({
                        data: getData()
                    }).trigger("change");

                }
            });
            return false;
        });
        $("#btn_edit_email_custom").click(function() {
            $("#btn_edit_email_custom").addClass('btn-loading');
            var nombre_email_custom = $('#nombre_email_custom_editar').val()
            var asunto_email_custom = $("#asunto_email_custom_editar").val()
            var cuerpo_email_custom = tinymce.get("cuerpo_email_custom_editar").getContent();
            var id_email_custom = $("#btn_edit_email_custom").data("id")
            if (!validarCamposEditar()) {
                $("#btn_edit_email_custom").removeClass('btn-loading');
                return false
            }
            $.ajax({
                type: 'POST',
                url: './api/email_custom.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    nombre: nombre_email_custom,
                    asunto: asunto_email_custom,
                    cuerpo: cuerpo_email_custom,
                    id_email_custom: id_email_custom
                },
                success: function(r) {

                    if (r.success) {
                        $('#modalEditarEmail').modal("hide")
                        $('.select_email_custom').empty()
                        $('.select_email_custom').select2({
                            data: getData()
                        }).trigger("change");
                        $.toast({
                            heading: "Vehículo editado",
                            text: "Se ha editado el vehículo correctamente.",
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });
                        $('.select_email_custom').empty()
                        $('.select_email_custom').select2({
                            data: getData()
                        }).trigger("change");


                    } else {

                        $.toast({
                            heading: r.title,
                            text: r.message,
                            position: 'top-right',
                            loaderBg: '#ff5c6c',
                            icon: 'error',
                            hideAfter: 5000,
                            stack: 6
                        });
                    }


                    $("#btn_edit_email_custom").removeClass('btn-loading');

                }
            });
        })

        $("#btn_insert_email_custom").click(function() {
            var id_email_custom = $("#id_email_custom").val()
            if (id_email_custom == "No") {
                return false
            }
            $.ajax({
                url: "./api/email_custom.php?id_email_custom=" + id_email_custom,
                type: 'GET',

                cache: false,
                async: false,
                dataType: "json",
                success: function(res) {
                    console.log(res);

                    $("#asunto").val(res.asunto);
                    tinymce.get("mymce").setContent(res.cuerpo);






                }
            });
        })
        $(document).on("click", ".btn_edit_email_custom", function(e) {

            var target = $(this).data("target");

            var id_email_custom
            if (typeof target === 'undefined') {


                id_email_custom = $(this).data("id")
            } else {
                if ($("#" + target).val() == "No") {
                    return false;
                } else {
                    id_email_custom = $("#" + target).val()

                }
            }

            console.log(id_email_custom);

            $("#btn_edit_email_custom").data("id", id_email_custom)



            $.ajax({
                url: "./api/email_custom.php?id_email_custom=" + id_email_custom,
                type: 'GET',

                cache: false,
                async: false,
                dataType: "json",
                success: function(res) {
                    console.log(res);

                    $("#asunto_email_custom_editar").val(res.asunto);
                    tinymce.get("cuerpo_email_custom_editar").setContent(res.cuerpo);
                    $("#nombre_email_custom_editar").val(res.nombre);



                    $("#modalEditarEmail").modal('show');

                }
            });



        })




    });
})(jQuery);
</script>




<script>
(function($) {

    'use strict';

    $(function() {


    });

})(jQuery);
</script>