<div class="modal fade modal-cambiar" id="modalEliminarCurso" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar curso</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el curso definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_curso_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_curso">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarCurso" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Curso</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">


                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Número de plazas</label>
                                <input class="form-control w-100" id="numero_plaza" type="number">
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Numero de grupo </label>
                                <input class="form-control w-100" id="numero_grupo" type="number">
                            </div>

                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Acción</label>
                                <select style="min-width: 200px;" id="select_accion_curso"
                                    class="custom-select select2 form-control">

                                    <?php
                                    foreach ($Acciones as $Accion) {
                                    ?>
                                    <option value="<?php echo $Accion['numero_aaff']; ?>">
                                        <?php echo $Accion['denominacion']; ?>
                                    </option>
                                    <?php
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Plan</label>
                                <select style="min-width: 200px;" id="select_plan_curso"
                                    class="custom-select select2 form-control">
                                    <option selected value="No">
                                        Ninguno
                                    </option>
                                    <?php
                                    foreach ($Planes as $Plan) {
                                    ?>
                                    <option value="<?php echo $Plan['id_plan']; ?>">
                                        <?php echo $Plan['nombre']; ?>
                                    </option>
                                    <?php
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Estado</label>
                                <select id="select_estado_curso" class="form-control select2" type="text" name="">
                                    <option value="No iniciado">No iniciado</option>
                                    <option value="Notificado">Notificado</option>
                                    <option value="En curso">En curso</option>
                                    <option value="Finalizado">Finalizado</option>
                                    <option value="Cerrado">Cerrado</option>
                                </select>
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Horario</label>
                                <div class="input-group">
                                    <input class="form-control w-100" id="horario_1_curso" type="time" value="08:00">
                                    <span class="mb-0 mx-2" style="line-height: 1.9;"> - </span>
                                    <input class="form-control w-100" id="horario_2_curso" type="time" value="16:00">


                                </div>
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Fecha de inicio</label>
                                <input class="form-control w-100" id="fecha_i_curso" type="date">
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Fecha de fin</label>
                                <input class="form-control w-100" id="fecha_f_curso" type="date">
                            </div>

                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Docente</label>
                                <select style="min-width: 200px;" id="select_docente_curso"
                                    class="custom-select select2 form-control">
                                    <option selected value="No">
                                        Ninguno
                                    </option>
                                    <?php
                                    foreach ($Docentes as $Docente) {
                                    ?>
                                    <option value="<?php echo $Docente['id_docente']; ?>">
                                        <?php echo $Docente['nombre']; ?>
                                    </option>
                                    <?php
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Modalidad</label>
                                <select id="modalidad_curso" class="form-control select2" type="text" name="">
                                    <option value="Tele formación">Tele formación</option>
                                    <option value="Presencial">Presencial</option>

                                </select>
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Sede</label>
                                <input class="form-control w-100" id="sede_curso" type="text">
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Instalación</label>
                                <input class="form-control w-100" id="instalacion_curso" type="number">
                            </div>

                        </div>
                        <div class="col-md-6">

                            <div class="form-group">
                                <label for="my-input">Nivel de estudios</label>
                                <select id="nivel_estudios_curso" class="form-control">
                                    <option value="0">Sin titulación</option>
                                    <option value="1">Educación Primaria</option>
                                    <option value="22">Título de Graduado E.S.O./E.G.B.</option>
                                    <option value="23">Certificados de Profesionalidad Nivel 1</option>
                                    <option value="24">Certificados de Profesionalidad Nivel 2</option>
                                    <option value="32">Bachillerato</option>
                                    <option value="33">Enseñanzas de Formación Profesional de Grado Medio</option>
                                    <option value="34">Enseñanzas Profesionales de Música-danza</option>
                                    <option value="38">Formación Profesional Básica</option>
                                    <option value="41">Certificados de Profesionalidad Nivel 3</option>
                                    <option value="51">Enseñanzas de Formación Profesional de Grado Superior
                                    </option>
                                    <option value="61">Grados Universitarios de hasta 240 créditos</option>
                                    <option value="62">Diplomados Universitarios</option>
                                    <option value="71">Grados Universitarios de más 240 créditos</option>
                                    <option value="72">Licenciados o equivalentes</option>
                                    <option value="73">Másteres oficiales Universitarios</option>
                                    <option value="74">Especialidades en CC. Salud (residentes)</option>
                                    <option value="81">Doctorado Universitario</option>
                                    <option value="PR">Carnet profesional /Profesiones Reguladas</option>
                                    <option value="A1">Nivel de idioma A1 del MCER</option>
                                    <option value="A2">Nivel de idioma A2 del MCER</option>
                                    <option value="B1">Nivel de idioma B1 del MCER</option>
                                    <option value="B2">Nivel de idioma B2 del MCER</option>
                                    <option value="C1">Nivel de idioma C1 del MCER</option>
                                    <option value="C2">Nivel de idioma C2 del MCER</option>
                                </select>
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="my-input">Es certificado</label>
                                <select id="certificado_curso" class="form-control select2" type="text" name="">
                                    <option value="Si">Si</option>
                                    <option value="No">No</option>

                                </select>
                            </div>

                        </div>



                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_curso" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
(function($) {
    'use strict';
    $(function() {
        function getData(id_curso) {
            console.log(id_curso);
            var r
            $.ajax({
                url: "./api/cursos.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,

                success: function(data) {

                    data = data.map(function(item) {
                        return {
                            id: item.id_curso,
                            text: item.accion.denominacion,
                            selected: (item.id_curso == id_curso) ? true : false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguna',
                        selected: (id_curso == "No") ? true : false
                    });

                    r = data
                }
            });
            return r
        }
        $('.select_cursos').select2({
            data: getData("No")
        }).trigger("change");




        $("#btn_add_curso").click(function() {






            var numero_plaza = $('#numero_plaza').val()
            var numero_grupo = $('#numero_grupo').val()
            var numero_aaff = $('#select_accion_curso').val()

            var estado = $('#select_estado_curso').val()
            var horario = $("#horario_1_curso").val() + "-" + $("#horario_2_curso").val()
            var fecha_f = (moment($("#fecha_f_curso")
                .val()).format('YYYY-MM-DD') != "Invalid date") ? moment($(
                    "#fecha_f_curso")
                .val()).format('YYYY-MM-DD') : ""
            var fecha_i = (moment($("#fecha_i_curso")
                .val()).format('YYYY-MM-DD') != "Invalid date") ? moment($(
                    "#fecha_i_curso")
                .val()).format('YYYY-MM-DD') : ""
            var id_docente = ($('#select_docente_curso').val() != "No") ? $(
                '#select_docente_curso').val() : ""
            var modalidad = $('#modalidad_curso').val()
            var sede = $('#sede_curso').val()
            var instalacion = $('#instalacion_curso').val()
            var nivel_estudios = $('#nivel_estudios_curso').val()
            var certificado = $('#certificado_curso').val()
            var id_plan = ($('#select_plan_curso').val() != "No") ? $(
                '#select_plan_curso').val() : ""


            $.ajax({
                type: 'POST',
                url: './api/cursos.php',
                cache: false,
                async: false,
                dataType: 'json',
                data: {

                    numero_plaza: numero_plaza,
                    numero_grupo: numero_grupo,
                    numero_aaff: numero_aaff,

                    estado: estado,
                    horario: horario,
                    fecha_f: fecha_f,
                    fecha_i: fecha_i,
                    id_docente: id_docente,
                    modalidad: modalidad,
                    sede: sede,
                    instalacion: instalacion,
                    nivel_estudios: nivel_estudios,
                    certificado: certificado,
                    id_plan: id_plan
                },
                success: function(result) {
                    var r = result
                    console.log(r);
                    $('.select_cursos').empty()
                    $('.select_cursos').select2({
                        data: getData(r.id_curso)
                    }).trigger("change");

                    $('#modalAgregarCurso').modal("hide")

                    $.toast({
                        heading: 'Curso agregado.',
                        text: 'Se ha agregado el curso correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    $("#btn_add_curso").removeClass('btn-loading');

                }
            });
        })
        $(document).on("click", ".btn_eliminar_curso", function() {

            var target = $(this).data("target");
            if ($("#" + target).val() == "No") {
                return false;
            }
            if (target == "table") {

                $("#id_curso_eliminar").val($(this).data("id"))
            } else {
                $("#id_curso_eliminar").val($("#" + target).val())
            }
            $("#modalEliminarCurso").modal("show");
        })
        $('#btn_eliminar_curso').click(function(event) {
            var id_curso_eliminar = $("#id_curso_eliminar").val()
            $.ajax({
                type: 'DELETE',
                url: './api/cursos.php?id=' + id_curso_eliminar,
                cache: false,
                async: false,
                success: function(result) {

                    $('.select_cursos').empty()
                    $('.select_cursos').select2({
                        data: getData("No")
                    }).trigger("change");
                    $('#modalEliminarCurso').modal("hide")
                    $.toast({
                        heading: 'Curso eliminado',
                        text: 'Se ha eliminado el curso correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                }
            });
            return false;
        });
    });
})(jQuery);
</script>