<!-- Modal Eliminar Comercial -->
<div class="modal fade modal-cambiar" id="modalEliminarComercial" role="dialog"
    aria-labelledby="exampleModalCenterTitle">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar comercial</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <p class="">¿Estás seguro de que deseas eliminar el comercial definitivamente?</p>
                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>
            </div>
            <div class="modal-footer text-right">
                <input type="hidden" id="id_comercial_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_comercial">Confirmar y
                    eliminar</button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">Cancelar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Agregar Comercial -->
<div class="modal fade" id="modalAgregarComercial" role="dialog" aria-labelledby="exampleModalCenterTitle">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Agregar comercial</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="container p-0">
                    <div class="row">
                        <div class="col-12 mb-2">
                            <input class="form-control w-100" id="codigo_comercial" type="text"
                                placeholder="Código comercial">
                        </div>
                        <div class="col-12">
                            <div class="form-group">

                                <label>Usuario</label>

                                <select id="user_id_comercial"
                                    class="form-control custom-select text-center select2 select_users">

                                    <?php

                                    foreach ($User_List as $User)

                                        {

                                        ?>

                                    <option type="number"
                                        value=<?php echo htmlentities($User['user_id'], ENT_QUOTES); ?>>

                                        <?php echo htmlentities($User['user_full_name'], ENT_QUOTES); ?>

                                    </option>

                                    <?php } ?>

                                </select>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer text-right">
                <button id="btn_add_comercial" class="btn btn-success btn-fw" type="button">Agregar</button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">Cancelar</button>
            </div>
        </div>
    </div>
</div>

<script>
(function($) {
    'use strict';

    $(function() {

        function getData(id_comercial) {
            var r;
            $.ajax({
                url: "./api/users.php?comerciales",
                type: 'GET',
                dataType: 'json',
                cache: false,
                async: false,
                success: function(data) {
                    data = data.map(function(item) {
                        return {
                            id: item.id_comercial,
                            text: item.user_full_name + " - "  + item.codigo,
                            selected: (item.id_comercial == id_comercial)
                        };
                    });
                    data.push({
                        id: 'No',
                        text: 'Ninguno',
                        selected: (id_comercial == "No")
                    });
                    r = data;
                }
            });
            return r;
        }

        $('.select_comerciales').each(function() {
            var $select = $(this);
            if ($select.closest('.modal').length) {
                var $mod = $select.closest('.modal');
                $mod.on('shown.bs.modal', function() {
                    var pri = ($select.data("pri") === undefined);
                    var edit = ($select.data("edit") === undefined) ? "No" : $select.data(
                        "edit");
                    if (pri) {
                        reload($select, edit, $mod);
                    } else {
                        $mod.off('shown.bs.modal');
                        $select.data("pri", false);
                    }
                });
            } else {
                reload($select);
            }
        });

        function reload($select, $id = "No", $mod = "No") {
            $select.empty();
            var data = getData(($id != "No") ? $id : "No");
            $select.select2({
                data: data,
                dropdownParent: ($mod == "No") ? null : $mod
            }).trigger("change");
        }

        $("#btn_add_comercial").click(function() {
            var codigo = $('#codigo_comercial').val();
            var user_id = $('#user_id_comercial').val();

            $.ajax({
                type: 'POST',
                url: './api/users.php',
                dataType: "json",
                data: {
                    codigo: codigo,
                    user_id: user_id
                },
                success: function(r) {
                    $('#modalAgregarComercial').modal("hide");
                    $('.select_comerciales').each(function() {
                        reload($(this), r.id, "No");
                    });
                    $.toast({
                        heading: 'Comercial agregado.',
                        text: 'Se ha agregado el comercial correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                }
            });
        });

        $(document).on("click", ".btn_eliminar_comercial", function() {
            var target = $(this).data("target");
            if ($("#" + target).val() == "No") return false;
            $("#id_comercial_eliminar").val($("#" + target).val());
            $("#modalEliminarComercial").modal("show");
        });

        $('#btn_eliminar_comercial').click(function() {
            var id = $("#id_comercial_eliminar").val();
            $.ajax({
                type: 'DELETE',
                url: './api/users.php?id_comercial =' + id,
                success: function(result) {
                    $('.select_comerciales').each(function() {
                        reload($(this));
                    });
                    $('#modalEliminarComercial').modal("hide");
                    $.toast({
                        heading: 'Comercial eliminado',
                        text: 'Se ha eliminado el comercial correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                }
            });
        });
    });

})(jQuery);
</script>