<div class="modal fade modal-cambiar" id="modalEliminarCombustible" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar combustible</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el combustible definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_combustible_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_combustible">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarCombustible" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Combustible</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">


                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Nombre</label>
                                <input class="form-control w-100" id="nombre_combustible" type="text">
                            </div>

                        </div>


                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_combustible" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
(function($) {
    'use strict';
    $(function() {

        function getData(id_combustible) {
            var r
            $.ajax({
                url: "./api/combustibles.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,

                success: function(data) {
                    console.log(data);
                    data = data.map(function(item) {
                        return {
                            id: item.id_combustible,
                            text: item.nombre,
                            selected: (item.id_combustible == id_combustible) ? true :
                                false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguno',
                        selected: (id_combustible == "No") ? true : false
                    });

                    r = data
                }
            });
            return r
        }

        $('.select_combustibles').select2({
            data: getData("No")
        }).trigger("change");
        $("#btn_add_combustible").click(function() {
            var nombre_combustible = $('#nombre_combustible').val()





            $.ajax({
                type: 'POST',
                url: './api/combustibles.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    nombre: nombre_combustible

                },
                success: function(r) {

                    $('#modalAgregarCombustible').modal("hide")
                    $('.select_combustibles').empty()
                    $('.select_combustibles').select2({
                        data: getData(r.id)
                    }).trigger("change");
                    $.toast({
                        heading: 'Combustible agregado.',
                        text: 'Se ha agregado el método correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });

                    $("#btn_add_combustible").removeClass('btn-loading');

                }
            });
        })

        $(document).on("click", ".btn_eliminar_combustible", function() {

            var target = $(this).data("target");


            if (typeof target === 'undefined') {
                console.log($(this).data("id"));
                $("#id_combustible_eliminar").val($(this).data("id"))
            } else {
                if ($("#" + target).val() == "No") {
                    return false;
                } else {
                    $("#id_combustible_eliminar").val($("#" + target).val())
                }
            }

            $("#modalEliminarCombustible").modal("show");
        })

        $('#btn_eliminar_combustible').click(function(event) {
            var id_combustible_eliminar = $("#id_combustible_eliminar").val()
            console.log(id_combustible_eliminar);
            $.ajax({
                type: 'DELETE',
                url: './api/combustibles.php?id=' + id_combustible_eliminar,
                cache: false,
                success: function(result) {

                    $('#modalEliminarCombustible').modal("hide")
                    $.toast({
                        heading: 'Combustible eliminado',
                        text: 'Se ha eliminado el combustible correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                    $('.select_combustibles').empty()
                    $('.select_combustibles').select2({
                        data: getData("No")
                    }).trigger("change");

                }
            });
            return false;
        });

    });
})(jQuery);
</script>