<div class="modal fade modal-cambiar" id="modalEliminarColumna" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar columna</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el columna definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_columna_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_columna">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarColumna" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Columna</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">


                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Nombre</label>
                                <input class="form-control w-100" id="nombre_columna" type="text">
                            </div>

                        </div>



                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_columna" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
(function($) {
    'use strict';
    $(function() {

        function getData() {
            var r
            $.ajax({
                url: "./api/columnas.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                dataType: "json",
                success: function(data) {
                    data = data.map(function(item) {
                        return {
                            id: item.id_columna,
                            text: item.nombre,
                            selected: false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguno',
                        selected: true
                    });
                    r = data
                }
            });
            return r
        }

        $('.select_columnas').select2({
            data: getData()
        }).trigger("change");
        $("#btn_add_columna").click(function() {
            var nombre_columna = $('#nombre_columna').val()



            $.ajax({
                type: 'POST',
                url: './api/columnas.php',
                cache: false,
                data: {
                    nombre: nombre_columna

                },
                success: function(result) {
                    var r = JSON.parse(result)
                    $('#modalAgregarColumna').modal("hide")
                    $('.select_columnas').empty()
                    $('.select_columnas').select2({
                        data: getData()
                    }).trigger("change");
                    $.toast({
                        heading: 'Columna agregada.',
                        text: 'Se ha agregado la columna correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    $('#tabla_columnas').DataTable().ajax.reload(null, false);
                    $("#btn_add_columna").removeClass('btn-loading');
                    $('#nombre_columna').val("")
                }
            });
        })

        $(document).on("click", ".btn_eliminar_columna", function() {

            var target = $(this).data("target");


            if (typeof target === 'undefined') {
                console.log($(this).data("id"));
                $("#id_columna_eliminar").val($(this).data("id"))
            } else {
                if ($("#" + target).val() == "No") {
                    return false;
                } else {
                    $("#id_columna_eliminar").val($("#" + target).val())
                }
            }

            $("#modalEliminarColumna").modal("show");
        })

        $('#btn_eliminar_columna').click(function(event) {
            var id_columna_eliminar = $("#id_columna_eliminar").val()
            console.log(id_columna_eliminar);
            $.ajax({
                type: 'DELETE',
                url: './api/columnas.php?id=' + id_columna_eliminar,
                cache: false,
                success: function(result) {

                    $('#modalEliminarColumna').modal("hide")
                    $.toast({
                        heading: 'Columna eliminada',
                        text: 'Se ha eliminado la columna correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                    $('.select_columnas').empty()
                    $('.select_columnas').select2({
                        data: getData()
                    }).trigger("change");
                    $('#tabla_columnas').DataTable().ajax.reload(null, false);
                }
            });
            return false;
        });

    });
})(jQuery);
</script>