<div class="modal fade modal-cambiar" id="modalEliminarCategoria" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar categoria</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el categoria definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_categoria_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_categoria">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarCategoria" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Categoria</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">

                        <div class="col-12">
                            <input class="form-control w-100" id="nombre_categoria" type="text">
                        </div>

                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_categoria" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
    (function ($) {
        'use strict';
        $(function () {
            $("#btn_add_categoria").click(function () {
                var nombre_categoria = $('#nombre_categoria').val()
                $.ajax({
                    type: 'POST',
                    url: './api/categorias.php',
                    cache: false,
                    data: {
                        nombre: nombre_categoria,
                    },
                    success: function (result) {
                        var r = JSON.parse(result)
                        $('#modalAgregarCategoria').modal("hide")
                        $(".select_categorias").each(
                            function () {
                                $(this).append(
                                    '<option value="' +
                                    r.id + '">' +
                                    nombre_categoria +
                                    '</option>'
                                ).val(r.id)
                                    .trigger("change");
                            })
                        $.toast({
                            heading: 'Categoria agregado.',
                            text: 'Se ha agregado la categoria correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        });
                        setTimeout(function () {
                            $("#btn_add_categoria").removeClass('btn-loading');
                        }, 2000);
                    }
                });
            })
            $(document).on("click", ".btn_eliminar_categoria", function () {

                var target = $(this).data("target");

                $("#id_categoria_eliminar").val($("#" + target).val())
                if ($("#id_categoria_eliminar").val() != "No") {
                    $("#modalEliminarCategoria").modal("show");
                }

            })
            $('#btn_eliminar_categoria').click(function (event) {
                var id_categoria_eliminar = $("#id_categoria_eliminar").val()
                $.ajax({
                    type: 'DELETE',
                    url: './api/categorias.php?id=' + id_categoria_eliminar,
                    cache: false,
                    success: function (result) {
                        $(".select_categorias").each(function () {
                            $(this).find("option[value='" +
                                id_categoria_eliminar + "']").remove()
                                .trigger(
                                    "change");
                        })
                        $('#modalEliminarCategoria').modal("hide")
                        $.toast({
                            heading: 'Categoria eliminada',
                            text: 'Se ha eliminado la categoria correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        })
                    }
                });
                return false;
            });
        });
    })(jQuery);
</script>