<!-- Modal Eliminar Camión -->
<div class="modal fade modal-cambiar" id="modalEliminarCamion" role="dialog" aria-labelledby="exampleModalCenterTitle">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar camión</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <p class="">¿Estás seguro de que deseas eliminar el camión definitivamente?</p>
                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>
            </div>
            <div class="modal-footer text-right">
                <input type="hidden" id="id_camion_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_camion">Confirmar y
                    eliminar</button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">Cancelar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal Agregar Camión -->
<div class="modal fade" id="modalAgregarCamion" role="dialog" aria-labelledby="exampleModalCenterTitle">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Agregar camión</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="container p-0">
                    <div class="row mb-2">
                        <div class="col-12">
                            <label for="matricula_camion">Matrícula</label>
                            <input class="form-control" id="matricula_camion" type="text">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <label for="itv_camion">Fecha ITV</label>
                            <input class="form-control" id="itv_camion" type="date">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer text-right">
                <button id="btn_add_camion" class="btn btn-success btn-fw" type="button">Agregar</button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">Cancelar</button>
            </div>
        </div>
    </div>
</div>



<div class="modal fade" id="modalEditarCamion" role="dialog" aria-labelledby="exampleModalCenterTitle">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Editar camión</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="container p-0">
                    <div class="row mb-2">
                        <div class="col-12">
                            <label for="matricula_camion">Matrícula</label>
                            <input class="form-control" id="matricula_camion_editar" type="text">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <label for="itv_camion">Fecha ITV</label>
                            <input class="form-control" id="itv_camion_editar" type="date">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer text-right">
                <button id="btn_edit_camion" class="btn btn-success btn-fw" type="button">Editar</button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">Cancelar</button>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="modalSubirArchivoCamiones" role="dialog">

    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Archivos</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-4">

                <div class="row">

                    <div class="col-12 col-md-6">

                        <div class="form-group">

                            <label for="my-input">Nombre</label>

                            <input id="nombre_archivo_camiones" type="text" class="form-control">

                        </div>

                    </div>

                    <div class="col-12 col-md-6">

                        <div class="form-group">

                            <label for="my-input">Archivo</label>

                            <div class="input-group">

                                <input type="file" class="d-none" id="archivo_file_camiones" accept=".png, .jpg, .pdf">

                                <input disabled id="archivo_archivo_camiones" type="text" class="form-control"
                                    value="Ningún archivo seleccionado.">

                                <div class="input-group-append">

                                    <label for="archivo_file_camiones" class="mb-0 btn btn-success btn-fw"
                                        id="btn_subir_archivo_camiones" type="button">

                                        Seleccionar archivo</label>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="col-12 text-left mb-2">

                        <button class="btn btn-success btn-fw" id="btn_add_archivo_camiones"
                            type="button">Subir</button>

                    </div>

                </div>

                <div class=" container-lg p-0">

                    <div id="lista_archivos_camiones" class="row">

                    </div>

                </div>

            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>



<div class="modal fade modal-cambiar" id="modalVerArchivoCamiones" role="dialog"
    aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div id="contenedor_archivo_camiones" class="modal-body">

                <!-- btn -->

            </div>

            <!-- /btn -->

            <!-- /modal-body -->

        </div>

    </div>

</div>
<style>
.archivo_lista_camiones {

    cursor: pointer;

    transition: all .3s ease;

    position: relative;

    height: 100%;

    width: 100%;

    background: #0000001a;

    box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);

    -webkit-box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);

    -moz-box-shadow: 2px 6px 20px -7px rgba(0, 0, 0, 0.75);

    aspect-ratio: 1/1;

    border-radius: 2% !important;

}

.archivo_lista_camiones img {

    object-fit: cover;

    max-height: 200px;

}

.archivo_lista_camiones:hover {

    opacity: .5;

    background: #000000;

}

.btn_eliminar_archivo_camiones {

    cursor: pointer;

    transition: all .3s ease;

    opacity: 0;

    position: absolute;

    right: 0;

    top: 0;

    border-radius: 10% !important;

}

.archivo_lista_camiones:hover .btn_eliminar_archivo_camiones {

    opacity: 1;

}

.btn_eliminar_archivo_camiones i:before {

    transition: all .3s ease;

    font-size: 1.1rem;

    color: #F1635F;

}

.btn_eliminar_archivo_camiones:hover i:before {

    color: #F1635F;

}

.btn_seleccionar_archivo_camiones {

    cursor: pointer;

    transition: all .3s ease;

    opacity: 0;

    position: absolute;

    left: 0;

    top: 0;

    border-radius: 10% !important;

}

.archivo_lista_camiones:hover .btn_seleccionar_archivo_camiones {

    opacity: 1;

}

.btn_seleccionar_archivo_camiones i:before {

    transition: all .3s ease;

    font-size: 1.1rem;

    color: #0cca8e;

}

.btn_seleccionar_archivo_camiones:hover i:before {

    color: #0cca8e;

}

.nombre_archivo_div_camiones {

    position: absolute;

    font-size: 18px;

    border-radius: 4px;

    transition: all .3s ease;

    opacity: 0;

    color: white;

    background-color: black;

    padding: .5rem;

    cursor: pointer;

}

.col-sm-3:hover .nombre_archivo_div_camiones {

    opacity: 1;

}

#lista_archivos_camiones {

    max-height: 723px;

    overflow-y: scroll;

}

table.dataTable thead>tr>th.sorting {

    padding: 10px !important;

}
</style>
<script>
(function($) {
    'use strict';

    $(function() {

        function getCamiones(id_camion) {
            var result;
            $.ajax({
                url: "./api/camiones.php",
                type: 'GET',
                dataType: 'json',
                cache: false,
                async: false,
                success: function(data) {
                    data = data.map(function(item) {
                        return {
                            id: item.id_camion,
                            text: item.matricula,
                            selected: (item.id_camion == id_camion)
                        };
                    });
                    data.push({
                        id: 'No',
                        text: 'Ninguno',
                        selected: (id_camion == "No")
                    });
                    result = data;
                }
            });
            return result;
        }

        $('.select_camiones').each(function() {
            const $select = $(this);
            const $modal = $select.closest('.modal');

            if ($modal.length) {
                $modal.on('shown.bs.modal', function() {
                    const isPrimary = ($select.data("pri") === undefined);
                    const id = $select.data("edit") ?? "No";

                    if (isPrimary) {
                        reloadSelect($select, id, $modal);
                    } else {
                        $modal.off('shown.bs.modal');
                        $select.data("pri", false);
                    }
                });
            } else {
                reloadSelect($select);
            }
        });

        function reloadSelect($select, id = "No", $modal = "No") {
            $select.empty();
            const config = {
                data: getCamiones(id)
            };
            if ($modal !== "No") config.dropdownParent = $modal;
            $select.select2(config).trigger("change");
        }

        $('#btn_add_camion').click(function() {
            const matricula = $('#matricula_camion').val().trim();
            const itv = $('#itv_camion').val();

            if (!matricula) {
                alert("La matrícula es obligatoria.");
                return;
            }

            $.ajax({
                type: 'POST',
                url: './api/camiones.php',
                dataType: "json",
                cache: false,
                async: false,
                data: {
                    matricula: matricula,
                    itv: itv
                },
                success: function(r) {
                    $('#modalAgregarCamion').modal("hide");
                    $('.select_camiones').each(function() {
                        reloadSelect($(this), r.id_camion, "No");
                    });
                    $('#tabla_camiones').DataTable().ajax.reload(null, false);
                    $.toast({
                        heading: 'Camión agregado',
                        text: 'Se ha agregado el camión correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000
                    });
                }
            });
        });

        $(document).on("click", ".btn_eliminar_camion", function() {
            var target = $(this).data("target");
            var value = $("#" + target).val();
            if (value === "No") return false;
            if (target === undefined) {
                value = $(this).data("id")
            }
            $("#id_camion_eliminar").val(value);
            $("#modalEliminarCamion").modal("show");
        });



        $(document).on("click", ".btn_edit_camion", function() {

            const value = $(this).data("id");

            $("#btn_edit_camion").data("id", value);

            $.ajax({

                url: './api/camiones.php?id_camion=' + $(this).data("id"),

                type: 'GET',

                cache: false,

                dataType: 'json', // added data type

                success: function(result) {

                    console.log(result);


                    $("#matricula_camion_editar").val(result.matricula)
                    $("#itv_camion_editar").val(result.itv)





                    $("#modalEditarCamion").modal("show");




                }

            });

        });
        $('#btn_edit_camion').click(function() {
            const id = $(this).data("id");
            const matricula = $('#matricula_camion_editar').val().trim();
            const itv =
                (moment($("#itv_camion_editar")

                    .val()).format('YYYY-MM-DD') != "Invalid date") ? moment($(

                        "#itv_camion_editar")

                    .val()).format('YYYY-MM-DD') : ""

            if (!matricula) {
                alert("La matrícula es obligatoria.");
                return;
            }

            $.ajax({
                type: 'POST',
                url: './api/camiones.php',
                cache: false,
                dataType: "json",
                data: {
                    id_camion: id,
                    matricula: matricula,
                    itv: itv
                },
                success: function() {
                    $('#modalEditarCamion').modal("hide");

                    $('.select_camiones').each(function() {
                        reloadSelect($(this), id, "No");
                    });
                    $('#tabla_camiones').DataTable().ajax.reload(null, false);
                    $.toast({
                        heading: 'Camión actualizado',
                        text: 'Se han guardado los cambios correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000
                    });
                    if (window.calendar != undefined) {
                        window.calendar.refetchEvents();
                    }
                },
                error: function() {
                    alert("Hubo un error al actualizar el camión.");
                }
            });
        });

        $('#btn_eliminar_camion').click(function() {
            const id = $("#id_camion_eliminar").val();
            $.ajax({
                type: 'DELETE',
                url: './api/camiones.php?id=' + id,
                cache: false,
                async: false,
                success: function() {
                    $('.select_camiones').each(function() {
                        reloadSelect($(this));
                    });
                    $('#modalEliminarCamion').modal("hide");
                    $('#tabla_camiones').DataTable().ajax.reload(null, false);
                    $.toast({
                        heading: 'Camión eliminado',
                        text: 'Se ha eliminado el camión correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000
                    });
                }
            });
        });

    });

})(jQuery);
</script>



<script>
(function($) {
    'use strict';

    $(function() {

        $("#archivo_file_camiones").change(function(e) {

            var archivo = $('#archivo_file_camiones')[0].files[0];

            $("#archivo_archivo_camiones").val(archivo.name)

        });

        $("#btn_add_archivo_camiones").click(function() {

            var archivo = $('#archivo_file_camiones')[0].files[0];

            var id_factura_proveedor = $('#btn_subir_archivo_camiones').data("id")

            var nombre = $("#nombre_archivo_camiones").val();

            if (!archivo) {

                $.toast({

                    heading: 'Ningún archivo seleccionado.',

                    text: 'Por favor, selecciona un archivo para subir.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                return false

            }

            if (nombre == "") {

                $.toast({

                    heading: 'Ningún nombre seleccionado.',

                    text: 'Por favor, agrega un nombre al archivo para subir.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                return false

            }

            var extension = archivo.type.split('/').pop();

            if (extension == "jpeg") {

                extension = "jpg"

            }

            if (archivo.size > 3000000) {

                $.toast({

                    heading: 'Archivo demasiado pesado.',

                    text: 'El archivo debe pesar menos 3 MB.',

                    position: 'top-right',

                    loaderBg: '#ff5c6c',

                    icon: 'error',

                    hideAfter: 5000,

                    stack: 6

                });

                return false

            }

            var fd = new FormData();

            fd.append('archivo', archivo);

            fd.append('extension', extension);

            fd.append('nombre', nombre);

            fd.append('id_camion_archivos', id_factura_proveedor);

            var contenedor = document.getElementById('lista_archivos_camiones');

            var divElement = document.createElement('div');

            divElement.classList.add('col-sm-3', 'p-2', 'd-flex',

                'justify-content-center', 'align-items-center');

            // Crear un elemento div para la clase "archivo_lista"

            var archivoListaDiv = document.createElement('div');

            archivoListaDiv.classList.add('archivo_lista_camiones', 'd-flex',

                'justify-content-center', 'align-items-center');

            var imgElement = document.createElement('img');

            imgElement.classList.add('img-fluid');

            imgElement.setAttribute('alt', '');

            imgElement.setAttribute('src', './assets/images/oval.svg');

            // Agregar elementos al div "archivo_lista"

            archivoListaDiv.appendChild(imgElement);

            divElement.appendChild(archivoListaDiv);

            // Agregar el div "archivo_lista" al div principal

            contenedor.insertAdjacentElement('afterbegin', divElement);

            $.ajax({

                url: './api/camiones.php',

                type: 'POST',

                data: fd,

                async: false,

                cache: false,

                processData: false, // tell jQuery not to process the data

                contentType: false, // tell jQuery not to set contentType

                success: function(result) {

                    console.log(result);

                    if (result == "0") {

                        $.toast({

                            heading: 'Nombre repetido.',

                            text: 'Selecciona otro nombre para el archivo.',

                            position: 'top-right',

                            loaderBg: '#ff5c6c',

                            icon: 'error',

                            hideAfter: 5000,

                            stack: 6

                        });

                        divElement.remove()

                        return false

                    } else {

                        CargarArchivos(id_factura_proveedor)

                        $.toast({

                            heading: 'Nuevo archivo subido.',

                            text: 'Se subido el nuevo archivo correctamente.',

                            position: 'top-right',

                            loaderBg: '#32a852',

                            icon: 'success',

                            hideAfter: 2000,

                            stack: 4

                        })

                    }

                }

            });

        });

        function CargarArchivos(id_factura_proveedor) {

            var contenedor = document.getElementById('lista_archivos_camiones');

            contenedor.innerHTML = ""

            $.ajax({

                url: './api/camiones.php?id_camion_archivos=' +

                    id_factura_proveedor,

                type: 'GET',

                cache: false,

                async: false,

                dataType: 'json', // added data type

                success: function(result) {

                    console.log(result);

                    for (let r of result) {

                        r.url = r.url.slice(1)

                        console.log(r);

                        var divElement = document.createElement('div');

                        divElement.classList.add('col-sm-3', 'p-2', 'd-flex',

                            'justify-content-center', 'align-items-center');

                        // Crear un elemento div para la clase "archivo_lista"

                        var archivoListaDiv = document.createElement('div');

                        archivoListaDiv.classList.add('archivo_lista_camiones', 'd-flex',

                            'justify-content-center', 'align-items-center');

                        if (r.extension != "pdf") {

                            // Crear un elemento img

                            var imgElement = document.createElement('img');

                            imgElement.classList.add('img-fluid');

                            imgElement.setAttribute('alt', '');

                            imgElement.setAttribute('src', r.url);

                        } else {

                            var iframe = document.createElement('iframe');

                            iframe.setAttribute('src', r.url);

                            iframe.style.width = "100%";

                            iframe.style.height = "100%";

                        }

                        // Crear un botón para eliminar

                        var btnEliminar = document.createElement('button');

                        btnEliminar.classList.add('p-1', 'btn_eliminar_archivo_camiones',
                            'btn');

                        btnEliminar.setAttribute('data-url', r.url);

                        btnEliminar.setAttribute('data-id', id_factura_proveedor);

                        btnEliminar.setAttribute('type', 'button');

                        btnEliminar.innerHTML = '<i class="m-0 fas fa-trash"></i>';

                        // Crear un botón para seleccionar

                        var btnSeleccionar = document.createElement('button');

                        btnSeleccionar.classList.add('p-1', 'btn_seleccionar_archivo_camiones',

                            'btn');

                        btnSeleccionar.setAttribute('data-url', r.url);

                        btnSeleccionar.setAttribute('data-extension', r.extension);

                        btnSeleccionar.setAttribute('type', 'button');

                        btnSeleccionar.innerHTML = '<i class="m-0 fa fa-eye"></i>';

                        var nombre = document.createElement('a');

                        nombre.textContent = r.nombre

                        nombre.setAttribute('data-nombre', r.nombre);

                        nombre.setAttribute('data-url', r.url);

                        nombre.setAttribute('data-extension', r.extension);

                        nombre.classList.add("nombre_archivo_div_camiones")

                        nombre.innerHTML += '<i class="ml-2 fa fa-download"></i>';

                        // Agregar elementos al div "archivo_lista"

                        if (r.extension != "pdf") {

                            // Crear un elemento img

                            archivoListaDiv.appendChild(imgElement);

                        } else {

                            archivoListaDiv.appendChild(iframe);

                        }

                        archivoListaDiv.appendChild(btnEliminar);

                        archivoListaDiv.appendChild(btnSeleccionar);

                        // Agregar el div "archivo_lista" al div principal

                        divElement.appendChild(archivoListaDiv);

                        divElement.appendChild(nombre);

                        contenedor.appendChild(divElement);

                    }

                }

            })

        }

        $(document).on("click", ".btn_modal_archivos_camiones", function() {

            $('#btn_subir_archivo_camiones').data("id", $(this).data("id"))

            CargarArchivos($(this).data("id"))

            $("#modalSubirArchivoCamiones").modal("show");

        });

        $(document).on("click", ".btn_seleccionar_archivo_camiones", function() {

            var url = $(this).data("url");

            var extension = $(this).data("extension");

            var div = document.getElementById("contenedor_archivo_camiones")

            div.innerHTML = ""

            if (extension !== "pdf") {

                // Crear un elemento <img>

                var imgElement = document.createElement("img");

                // Establecer los atributos del elemento <img>

                imgElement.id = "archivo_modal_camiones";

                imgElement.className = "w-100 img-fluid";

                imgElement.src = url; // Aquí establece la fuente de la imagen que desees

                imgElement.alt = "";

                // Agregar el elemento <img> al documento

                div.appendChild(imgElement);

            } else {

                var iframe = document.createElement('iframe');

                iframe.setAttribute('id', 'archivo_modal_camiones');

                iframe.setAttribute('src', url);

                iframe.style.width = "100%"

                iframe.style.height = "400px"

                div.appendChild(iframe);

            }

            $("#modalVerArchivoCamiones").modal("show");

        });

        $(document).on("click", ".nombre_archivo_div_camiones", function() {

            var nombre = $(this).data("nombre");

            var url = $(this).data("url");

            var extension = $(this).data("extension");

            $(this).attr("download", nombre + "." + extension)

            $(this).attr("href", url)

        });

        $(document).on("click", ".btn_eliminar_archivo_camiones", function() {

            var id = $(this).data("id");

            var url = $(this).data("url");

            $.ajax({

                type: "DELETE",

                url: "./api/camiones.php?url=" + url,

                cache: false,

                async: false,

                success: function(response) {

                    console.log(response);

                    CargarArchivos(id)

                    $.toast({

                        heading: 'Archivo eliminado.',

                        text: 'Se eliminado el archivo correctamente.',

                        position: 'top-right',

                        loaderBg: '#32a852',

                        icon: 'success',

                        hideAfter: 2000,

                        stack: 4

                    })

                }

            })

        });
    });

})(jQuery);
</script>