<div class="modal fade modal-cambiar" id="modalEliminarBanco" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar banco</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el banco definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_banco_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_banco">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarBanco" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Banco</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">


                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Banco</label>
                                <input class="form-control w-100" id="nombre_banco" type="text">
                            </div>

                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">SWIFT/BIC</label>
                                <input class="form-control w-100" id="swift_banco" type="text">
                            </div>

                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Dirección</label>
                                <input class="form-control w-100" id="direccion_banco" type="text">
                            </div>

                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">IBAN</label>
                                <input class="form-control w-100" id="iban_banco" type="text">
                            </div>

                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Nombre de beneficiario</label>
                                <input class="form-control w-100" id="beneficiario_banco" type="text">
                            </div>

                        </div>
                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Divisa</label>
                                <select id="divisa_banco" class="form-control custom-select text-center">
                                    <option type="text" value="(€) Euro">(€) Euro</option>

                                    <option type="text" value="($) Dolar">($) Dolar</option>
                                    <option type="text" value="(£) Libra">(£) Libra</option>



                                </select>
                            </div>

                        </div>

                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_banco" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
(function($) {
    'use strict';
    $(function() {

        function getData() {
            var r
            $.ajax({
                url: "./api/bancos.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                dataType: "json",
                success: function(data) {
                    data = data.map(function(item) {
                        return {
                            id: item.id_banco,
                            text: item.nombre,
                            selected: false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguno',
                        selected: true
                    });
                    r = data
                }
            });
            return r
        }

        $('.select_bancos').select2({
            data: getData()
        }).trigger("change");
        $("#btn_add_banco").click(function() {
            var nombre_banco = $('#nombre_banco').val()

            var swift_banco = $("#swift_banco").val()
            var direccion_banco = $("#direccion_banco").val()
            var iban_banco = $("#iban_banco").val()
            var beneficiario_banco = $("#beneficiario_banco").val()
            var divisa_banco = $("#divisa_banco").val()



            $.ajax({
                type: 'POST',
                url: './api/bancos.php',
                cache: false,
                data: {
                    nombre: nombre_banco,
                    swift: swift_banco,
                    direccion: direccion_banco,
                    iban: iban_banco,
                    beneficiario: beneficiario_banco,
                    divisa: divisa_banco
                },
                success: function(result) {
                    var r = JSON.parse(result)
                    $('#modalAgregarBanco').modal("hide")
                    $('.select_bancos').empty()
                    $('.select_bancos').select2({
                        data: getData()
                    }).trigger("change");
                    $.toast({
                        heading: 'Banco agregado.',
                        text: 'Se ha agregado el banco correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    $('#tabla_bancos').DataTable().ajax.reload(null, false);
                    $("#btn_add_banco").removeClass('btn-loading');

                }
            });
        })

        $(document).on("click", ".btn_eliminar_banco", function() {

            var target = $(this).data("target");


            if (typeof target === 'undefined') {
                console.log($(this).data("id"));
                $("#id_banco_eliminar").val($(this).data("id"))
            } else {
                if ($("#" + target).val() == "No") {
                    return false;
                } else {
                    $("#id_banco_eliminar").val($("#" + target).val())
                }
            }

            $("#modalEliminarBanco").modal("show");
        })

        $('#btn_eliminar_banco').click(function(event) {
            var id_banco_eliminar = $("#id_banco_eliminar").val()
            console.log(id_banco_eliminar);
            $.ajax({
                type: 'DELETE',
                url: './api/bancos.php?id=' + id_banco_eliminar,
                cache: false,
                success: function(result) {

                    $('#modalEliminarBanco').modal("hide")
                    $.toast({
                        heading: 'Banco eliminado',
                        text: 'Se ha eliminado el banco correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                    $('.select_bancos').empty()
                    $('.select_bancos').select2({
                        data: getData()
                    }).trigger("change");
                    $('#tabla_bancos').DataTable().ajax.reload(null, false);
                }
            });
            return false;
        });
        $("#btn_edit_banco").click(function() {
            var nombre_banco = $('#nombre_banco_editar').val()
            var id_banco = $(this).data("id")
            var swift_banco = $("#swift_banco_editar").val()
            var direccion_banco = $("#direccion_banco_editar").val()
            var iban_banco = $("#iban_banco_editar").val()
            var beneficiario_banco = $("#beneficiario_banco_editar").val()
            var divisa_banco = $("#divisa_banco_editar").val()

            $.ajax({
                type: 'POST',
                url: './api/bancos.php',
                cache: false,
                async: false,
                dataType: "json",
                data: {
                    id_banco: id_banco,
                    nombre: nombre_banco,
                    swift: swift_banco,
                    direccion: direccion_banco,
                    iban: iban_banco,
                    beneficiario: beneficiario_banco,
                    divisa: divisa_banco
                },
                success: function(r) {

                    $('#modalEditarBanco').modal("hide")
                    $('.select_bancos').empty()
                    $('.select_bancos').select2({
                        data: getData()
                    }).trigger("change");
                    $.toast({
                        heading: 'Banco editado.',
                        text: 'Se ha editado el banco correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    $('#tabla_bancos').DataTable().ajax.reload(null, false);
                    $("#btn_edit_banco").removeClass('btn-loading');

                }
            });
        })
    });
})(jQuery);
</script>