<div class="modal fade modal-cambiar" id="modalEliminarBalda" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar balda</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el balda definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_balda_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_balda">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarBalda" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Balda</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">


                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Nombre</label>
                                <input class="form-control w-100" id="nombre_balda" type="text">
                            </div>

                        </div>



                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_balda" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
(function($) {
    'use strict';
    $(function() {

        function getData() {
            var r
            $.ajax({
                url: "./api/baldas.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                dataType: "json",
                success: function(data) {
                    data = data.map(function(item) {
                        return {
                            id: item.id_balda,
                            text: item.nombre,
                            selected: false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguno',
                        selected: true
                    });
                    r = data
                }
            });
            return r
        }

        $('.select_baldas').select2({
            data: getData()
        }).trigger("change");
        $("#btn_add_balda").click(function() {
            var nombre_balda = $('#nombre_balda').val()



            $.ajax({
                type: 'POST',
                url: './api/baldas.php',
                cache: false,
                data: {
                    nombre: nombre_balda

                },
                success: function(result) {
                    var r = JSON.parse(result)
                    $('#modalAgregarBalda').modal("hide")
                    $('.select_baldas').empty()
                    $('.select_baldas').select2({
                        data: getData()
                    }).trigger("change");
                    $.toast({
                        heading: 'Balda agregada.',
                        text: 'Se ha agregado la balda correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    $('#tabla_baldas').DataTable().ajax.reload(null, false);
                    $("#btn_add_balda").removeClass('btn-loading');
                    $('#nombre_balda').val("")
                }
            });
        })

        $(document).on("click", ".btn_eliminar_balda", function() {

            var target = $(this).data("target");


            if (typeof target === 'undefined') {
                console.log($(this).data("id"));
                $("#id_balda_eliminar").val($(this).data("id"))
            } else {
                if ($("#" + target).val() == "No") {
                    return false;
                } else {
                    $("#id_balda_eliminar").val($("#" + target).val())
                }
            }

            $("#modalEliminarBalda").modal("show");
        })

        $('#btn_eliminar_balda').click(function(event) {
            var id_balda_eliminar = $("#id_balda_eliminar").val()
            console.log(id_balda_eliminar);
            $.ajax({
                type: 'DELETE',
                url: './api/baldas.php?id=' + id_balda_eliminar,
                cache: false,
                success: function(result) {

                    $('#modalEliminarBalda').modal("hide")
                    $.toast({
                        heading: 'Balda eliminada',
                        text: 'Se ha eliminado la balda correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                    $('.select_baldas').empty()
                    $('.select_baldas').select2({
                        data: getData()
                    }).trigger("change");
                    $('#tabla_baldas').DataTable().ajax.reload(null, false);
                }
            });
            return false;
        });

    });
})(jQuery);
</script>