<div class="modal fade" id="modalAgregarApartado" role="dialog" aria-labelledby="exampleModalCenterTitle2"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered modal" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0"> Agregar apartado</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>



            <div class="modal-body pb-0">

                <div class="container-fluid p-0">

                    <div class="row">

                        <div class="col-12">

                            <div class="form-group">

                                <label>Nombre</label>

                                <input type="text" class="form-control" id="nombre_apartado" placeholder="">

                            </div>

                        </div>
                    </div>


                </div>



            </div>

            <div class="modal-footer text-right">



                <button class="btn btn-info btn-fw" id="btn_add_apartado" type="button">

                    Añadir</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<div class="modal fade" id="modalEditarApartado" role="dialog" aria-labelledby="exampleModalCenterTitle3"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0"> Editar apartado</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>

            <div class="modal-body pb-0">
                <div class="container-lg p-0">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label>Nombre</label>
                                <input type="text" class="form-control" id="nombre_apartado_editar" placeholder="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal-footer text-right">
                <button class="btn btn-info btn-fw" type="button" id="btn_edit_apartado">
                    Editar</button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>
            </div>
        </div>
    </div>
</div>


<div class="modal modal-cambiar fade" id="modalEliminarApartado" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Eliminar apartado</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>

            <div class="modal-body pb-0">

                <!-- btn -->







                <p class="">¿Estás seguro de que deseas eliminar este apartado?</p>



                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>











            </div>


            <div class="modal-footer text-right">







                <button class="btn btn-danger btn-fw" id="btn_eliminar_apartado" type="button">

                    Confirmar y eliminar </button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>

            <!-- /modal-body -->

        </div>

    </div>

</div>
<?php require_once __VIEWS__ . 'selects/medidas.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/familias.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/ubicaciones.template.php'; ?>
<?php require_once __VIEWS__ . 'selects/igic.template.php'; ?>
<style>
    #apartados {
        max-height: 400px;
        overflow-y: auto;
    }

    .apartados {
        line-height: .9 !important;
    }
</style>

<script>
    (function($) {

        'use strict';

        $(function() {
            $("#btn_edit_apartado").click(function(e) {
                var nombre = $("#nombre_apartado_editar").val();
                var id = $("#btn_edit_apartado").data("id");

                $.ajax({
                    type: 'POST',
                    url: './api/apartados_carpetas.php?id=' + id,
                    data: {
                        nombre: nombre
                    },
                    cache: false,
                    dataType: "json",
                    async: false,
                    success: function(response) {

                        if (response == 0) {
                            $("#btn_edit_apartado").removeClass("btn-loading")

                            $.toast({
                                heading: 'Código repetido.',
                                text: 'Ya existe un apartado con el mismo código.',
                                position: 'top-right',
                                loaderBg: '#ff5c6c',
                                icon: 'error',
                                hideAfter: 3000,
                                stack: 6
                            });

                        } else {
                            $('#modalEditarApartado').modal("hide");

                            $.toast({
                                heading: 'Apartado editado',
                                text: 'Se ha editado el apartado correctamente',
                                position: 'top-right',
                                loaderBg: '#32a852',
                                icon: 'success',
                                hideAfter: 2000,
                                stack: 6
                            });

                            setTimeout(() => {
                                window.location.reload();
                            }, 2000);
                        }
                    }
                })

            })

            $(document).on("click", ".btn_editar_apartado", function(e) {
                $("#btn_edit_apartado").data("id", $(this).data("id"))

                $.ajax({
                    type: 'GET',
                    url: './api/apartados_carpetas.php?id=' + $(this).data("id"),
                    cache: false,
                    async: false,
                    dataType: "json",
                    success: function(r) {
                        $("#nombre_apartado_editar").val(r.nombre);
                        $("#modalEditarApartado").modal('show');
                    }
                });


            })

            $(document).on("click", ".btn_eliminar_apartado", function(e) {
                $("#btn_eliminar_apartado").data("id", $(this).data("id"))
                $("#modalEliminarApartado").modal('show');
            })


            $('#btn_eliminar_apartado').click(function(event) {
                var id_apartado_eliminar = $("#btn_eliminar_apartado").data("id")

                $.ajax({
                    type: 'DELETE',
                    url: './api/apartados_carpetas.php?id=' + id_apartado_eliminar,
                    cache: false,
                    async: false,
                    success: function(result) {

                        $('#modalEliminarApartado').modal('hide');
                        $.toast({
                            heading: 'Apartado eliminado',
                            text: 'Se ha eliminado el apartado correctamente',
                            position: 'top-right',
                            loaderBg: '#32a852',
                            icon: 'success',
                            hideAfter: 2000,
                            stack: 6
                        })

                        setTimeout(() => {
                            window.location.reload();
                        }, 2000);
                    }
                });

                return false;
            });

            $("#btn_add_apartado").click(function(e) {
                $("#btn_add_apartado").addClass('btn-loading');
                var nombre = $("#nombre_apartado").val()
                $.ajax({
                    type: 'POST',
                    url: './api/apartados_carpetas.php',
                    data: {
                        nombre: nombre

                    },
                    cache: false,
                    success: function(response) {
                        if (response == 0) {
                            $("#btn_add_apartado").removeClass("btn-loading")

                            $.toast({
                                heading: 'Código repetido.',
                                text: 'Ya existe un apartado con el mismo código.',
                                position: 'top-right',
                                loaderBg: '#ff5c6c',
                                icon: 'error',
                                hideAfter: 3000,
                                stack: 6
                            });

                        } else {
                            $('#modalAgregarApartado').modal("hide");
                            $.toast({
                                heading: 'Apartado agregado',
                                text: 'Se ha agregado el apartado correctamente',
                                position: 'top-right',
                                loaderBg: '#32a852',
                                icon: 'success',
                                hideAfter: 2000,
                                stack: 6
                            });

                            setTimeout(() => {
                                window.location.reload();
                            }, 2000);
                        }
                    }
                })
            });
        });

    })(jQuery);
</script>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        const precioApartadoInput = document.getElementById("precio_apartado");
        const precioConIgicInput = document.getElementById("precio_con_igic_apartado");
        const selectIgic = document.getElementById("select_igic");

        // Function to get the tax percentage
        function getImpuesto() {
            var selectedOption = $("#select_igic").find(':selected');
            var porcentaje = parseFloat(selectedOption.data('porcentaje'));
            return isNaN(porcentaje) ? 0 : porcentaje / 100;
        }

        precioApartadoInput.addEventListener("input", function() {
            var impuesto = getImpuesto();
            var precioApartado = parseFloat(precioApartadoInput.value);

            if (!isNaN(precioApartado)) {
                var precioConImpuesto = (precioApartado * (1 + impuesto)).toFixed(2);
                console.log(precioApartado);
                console.log(impuesto);
                console.log(precioConImpuesto);
                precioConIgicInput.value = precioConImpuesto;
            }
        });

        precioConIgicInput.addEventListener("input", function() {
            var impuesto = getImpuesto();
            var precioConImpuesto = parseFloat(precioConIgicInput.value);

            if (!isNaN(precioConImpuesto)) {
                var precioApartado = (precioConImpuesto / (1 + impuesto)).toFixed(2);
                console.log(precioConImpuesto);
                console.log(impuesto);
                console.log(precioApartado);
                precioApartadoInput.value = precioApartado;
            }
        });
        // $("#select_igic").val("No").trigger("change")
        //$("#select_igic").val(null).trigger("change")
        $("#select_igic").change(function() {

            // Trigger input event on precioApartadoInput to recalculate values
            precioApartadoInput.dispatchEvent(new Event('input'));
        });
    });
</script>


<script>
    document.addEventListener("DOMContentLoaded", function() {
        const precioApartadoInput = document.getElementById("precio_apartado_editar");
        const precioConIgicInput = document.getElementById("precio_con_igic_apartado_editar");

        const selectIgic = document.getElementById("select_igic_editar");
        // Function to get the tax percentage
        function getImpuesto() {
            var selectedOption = $("#select_igic_editar").find(':selected');
            var porcentaje = parseFloat(selectedOption.data('porcentaje'));
            return isNaN(porcentaje) ? 0 : porcentaje / 100;
        }

        precioApartadoInput.addEventListener("input", function() {
            var impuesto = getImpuesto();
            var precioApartado = parseFloat(precioApartadoInput.value);

            if (!isNaN(precioApartado)) {
                var precioConImpuesto = (precioApartado * (1 + impuesto)).toFixed(2);
                console.log(precioApartado);
                console.log(impuesto);
                console.log(precioConImpuesto);
                precioConIgicInput.value = precioConImpuesto;
            }
        });

        precioConIgicInput.addEventListener("input", function() {
            var impuesto = getImpuesto();
            var precioConImpuesto = parseFloat(precioConIgicInput.value);

            if (!isNaN(precioConImpuesto)) {
                var precioApartado = (precioConImpuesto / (1 + impuesto)).toFixed(2);
                console.log(precioConImpuesto);
                console.log(impuesto);
                console.log(precioApartado);
                precioApartadoInput.value = precioApartado;
            }
        });
        $("#select_igic_editar").change(function() {

            // Trigger input event on precioApartadoInput to recalculate values
            precioApartadoInput.dispatchEvent(new Event('input'));
        });
    });
</script>