<div class="modal fade modal-cambiar" id="modalEliminarAlmacen" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar almacen</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <!-- btn -->



                <p class="">¿Estás seguro de que deseas eliminar el almacen definitivamente?</p>

                <lottie-player autoplay src="assets/lottiefiles/warning.json"
                    style="width: 250px;margin: auto;margin-top: -20px;"></lottie-player>





            </div>

            <!-- /btn -->

            <div class="modal-footer text-right">


                <input type="hidden" id="id_almacen_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_almacen">
                    Confirmar y eliminar </button>
                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">
                    Cancelar </button>


            </div>
            <!-- /modal-body -->
        </div>
    </div>
</div>
<div class="modal fade" id="modalAgregarAlmacen" role="dialog" aria-labelledby="exampleModalCenterTitle"
    aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered" role="document">

        <div class="modal-content">

            <div class="modal-header border-none">

                <h4 class="mb-0">Agregar Almacen</h4>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">

                    <i class="ti-close"></i>

                </button>

            </div>




            <div class="modal-body pb-0">

                <div class="container p-0">

                    <div class="row">


                        <div class="col-12">
                            <div class="form-group">
                                <label for="my-input">Nombre</label>
                                <input class="form-control w-100" id="nombre_almacen" type="text">
                            </div>

                        </div>



                    </div>

                </div>



            </div>

            <div class="modal-footer text-right">



                <button id="btn_add_almacen" class="btn btn-success btn-fw" type="button">

                    Agregar</button>

                <button class="btn btn-confi" data-dismiss="modal" aria-label="Close">

                    Cancelar </button>





            </div>



            <!-- /modal-body -->

        </div>

    </div>

</div>
<script>
(function($) {
    'use strict';
    $(function() {

        function getData() {
            var r
            $.ajax({
                url: "./api/almacenes.php",
                type: 'GET',
                dataType: 'json', // added data type
                cache: false,
                async: false,
                dataType: "json",
                success: function(data) {
                    data = data.map(function(item) {
                        return {
                            id: item.id_almacen,
                            text: item.nombre,
                            selected: false
                        };
                    })
                    data.push({
                        id: 'No',
                        text: 'Ninguno',
                        selected: true
                    });
                    r = data
                }
            });
            return r
        }

        $('.select_almacenes').select2({
            data: getData()
        }).trigger("change");
        $("#btn_add_almacen").click(function() {
            var nombre_almacen = $('#nombre_almacen').val()



            $.ajax({
                type: 'POST',
                url: './api/almacenes.php',
                cache: false,
                data: {
                    nombre: nombre_almacen

                },
                success: function(result) {
                    var r = JSON.parse(result)
                    $('#modalAgregarAlmacen').modal("hide")
                    $('.select_almacenes').empty()
                    $('.select_almacenes').select2({
                        data: getData()
                    }).trigger("change");
                    $.toast({
                        heading: 'Almacen agregado.',
                        text: 'Se ha agregado el almacen correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    });
                    $('#tabla_almacenes').DataTable().ajax.reload(null, false);
                    $("#btn_add_almacen").removeClass('btn-loading');
                    $('#nombre_almacen').val("")
                }
            });
        })

        $(document).on("click", ".btn_eliminar_almacen", function() {

            var target = $(this).data("target");


            if (typeof target === 'undefined') {
                console.log($(this).data("id"));
                $("#id_almacen_eliminar").val($(this).data("id"))
            } else {
                if ($("#" + target).val() == "No") {
                    return false;
                } else {
                    $("#id_almacen_eliminar").val($("#" + target).val())
                }
            }

            $("#modalEliminarAlmacen").modal("show");
        })

        $('#btn_eliminar_almacen').click(function(event) {
            var id_almacen_eliminar = $("#id_almacen_eliminar").val()
            console.log(id_almacen_eliminar);
            $.ajax({
                type: 'DELETE',
                url: './api/almacenes.php?id=' + id_almacen_eliminar,
                cache: false,
                success: function(result) {

                    $('#modalEliminarAlmacen').modal("hide")
                    $.toast({
                        heading: 'Almacen eliminado',
                        text: 'Se ha eliminado el almacen correctamente',
                        position: 'top-right',
                        loaderBg: '#32a852',
                        icon: 'success',
                        hideAfter: 2000,
                        stack: 6
                    })
                    $('.select_almacenes').empty()
                    $('.select_almacenes').select2({
                        data: getData()
                    }).trigger("change");
                    $('#tabla_almacenes').DataTable().ajax.reload(null, false);
                }
            });
            return false;
        });

    });
})(jQuery);
</script>