<div class="content-wrapper">
    <div class="row profile-page ">

        <div class="col-12 mb-3">
            <div class="card satmar-bottom mb-0">
                <div class="sato-border-blue">
                    <div class="text-center soli-ad">
                        <lord-icon src="https://cdn.lordicon.com/belclitb.json" trigger="hover"
                            colors="primary:<?php echo htmlentities($personalizacion['color_iconos_primario'], ENT_QUOTES); ?>,secondary:<?php echo htmlentities($personalizacion['color_iconos_secundario'], ENT_QUOTES); ?>"
                            style="width:80px;height:80px">
                        </lord-icon>
                        <p class="mb-2">Materiales alquilados</p>
                        <span id="user_count" class=""></span>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <div class="row profile-page mb-3">
        <div class="col-12">
            <div class="card">
                <div class="" style="padding-bottom: 0px !important;">
                    <div class="pt-0 ">
                        <div class="row ">
                            <div class="col-md-12">

                                <div class="card card-cuenta">
                                    <div class="card-header">
                                        <div class="row">
                                            <div class="col-12">
                                                <h4 class="mb-0">Listado de materiales alquilados</h4>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body card-table-body p-3">

                                        <div class="col-sm-3 p-0">
                                            <div class="form-group">

                                                <label>Filtrar por cliente</label>

                                                <div class="input-group">

                                                    <span class="input-group-prepend">

                                                        <button
                                                            class="btn_eliminar_cliente file-upload-browse btn btn-danger"
                                                            data-target="filtro_cliente" type="button">-</button>

                                                    </span>

                                                    <select id="filtro_cliente"
                                                        class="select_clientes custom-select select2 form-control">

                                                    </select>

                                                    <span class="input-group-append">

                                                        <button class="file-upload-browse btn btn-info" type="button"
                                                            data-toggle="modal"
                                                            data-target="#modalAgregarCliente">+</button>

                                                    </span>

                                                </div>

                                            </div>
                                        </div>

                                        <table id="tabla_materiales_evento" style="min-height:120px;" cellspacing="0"
                                            class="table display nowrap">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Evento</th>
                                                    <th>Estado</th>
                                                    <th>Material</th>

                                                    <th>Alertas</th>
                                                    <th>Días</th>
                                                    <th>Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody></tbody>

                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
<div class="modal fade modal-cambiar" id="modalEliminarEventoMaterial" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Eliminar alquiler</h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <p>¿Estás seguro de que deseas eliminar el alquiler del material definitivamente?</p>
                <lottie-player autoplay src="assets/lottiefiles/warning.json" style="width: 250px;margin: auto;">
                </lottie-player>
            </div>
            <div class="modal-footer text-right">
                <input type="hidden" id="id_evento_material_eliminar">
                <button class="btn btn-success btn-fw" type="button" id="btn_eliminar_evento_material">Confirmar y
                    eliminar</button>
                <button class="btn btn-confi" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>


<div class="modal fade modal-cambiar" id="modalDevoluciones" role="dialog">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header border-none">
                <h4 class="mb-0">Devolver materiales</h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="ti-close"></i>
                </button>
            </div>
            <div class="modal-body pb-0">
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label for="my-input">Unidades devueltas</label>
                            <input id="devueltos" class="form-control" type="number" name="">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer text-right">

                <button class="btn btn-success btn-fw" type="button" id="btn_devoluciones">Guardar</button>
                <button class="btn btn-confi" data-dismiss="modal">Cancelar</button>
            </div>
        </div>
    </div>
</div>
<!-- MODALS -->



<?php require_once __VIEWS__ . 'selects/clientes.template.php'; ?>
<script>
(function($) {
    'use strict';
    $(function() {

        $("#filtro_cliente").change(function(e) {

            //$('.tabla_clientes').DataTable().ajax.reload(null, false);

            $('#tabla_materiales_evento').DataTable().ajax.reload(null, false);

        });
        var Table = $('#tabla_materiales_evento').DataTable({
            responsive: true,
            dom: 'Blfrtip',
            aLengthMenu: [
                [10, 25, 50, -1],
                [10, 25, 50, "Todos"]
            ],
            iDisplayLength: 10,
            language: {
                search: "Buscar",
                emptyTable: "No hay seguimientos",
                info: "Mostrando _START_ a _END_ de _TOTAL_ seguimientos",
                infoEmpty: "Mostrando 0 a 0 de 0 seguimientos",
                infoFiltered: "(Filtrado de _MAX_ total entradas)",
                lengthMenu: "Mostrar _MENU_ entradas",
                processing: "Cargando...",
                paginate: {
                    first: "Primero",
                    last: "Último",
                    next: "Siguiente",
                    previous: "Anterior"
                }
            },
            stateSave: true,
            stateSaveCallback: function(settings, data) {
                localStorage.setItem('DataTables_' + settings.sInstance, JSON.stringify(data));
            },
            stateLoadCallback: function(settings) {
                return JSON.parse(localStorage.getItem('DataTables_' + settings.sInstance));
            },
            order: [
                [0, "desc"]
            ],
            buttons: [{
                extend: 'colvis',
                text: 'Ocultar Columnas',
                collectionLayout: 'fixed two-column',
                className: "form-control"
            }],
            ajax: {
                url: '/api/eventos2.php',
                method: 'GET',
                data: function(d) {

                    // Agregar parámetros adicionales a la solicitud aquí

                    d.seguimientos = 1;

                    d.client_id = $("#filtro_cliente").val();


                },
                dataSrc: function(json) {
                    console.log(json);

                    $("#user_count").text(json.length);
                    return json;
                }
            },
            columns: [{
                    data: "id_evento_material"
                },
                {
                    data: "evento.nombre"
                },
                {
                    data: null,
                    render: function(data) {
                        const fechas = JSON.parse(data
                            .dias); // arreglo de fechas en formato YYYY-MM-DD
                        const hoy = new Date().toISOString().split('T')[0];
                        const cant = parseInt(data.cantidad);
                        const devueltos = parseInt(data
                            .devueltos); // corregido: estaba como 'devuetos'

                        // Ordenamos por si no vienen ordenadas
                        fechas.sort();

                        if (hoy < fechas[0]) {
                            return "Pendiente de alquiler";
                        }

                        if (hoy > fechas[fechas.length - 1]) {
                            if (cant === devueltos) {
                                return `${devueltos} unidades devueltas`;
                            } else {
                                return `Devueltas ${devueltos} unidades de ${cant}`;
                            }
                        }

                        if (fechas.includes(hoy)) {
                            return "Alquilado";
                        }

                        for (let i = 0; i < fechas.length - 1; i++) {
                            if (hoy > fechas[i] && hoy < fechas[i + 1]) {
                                return "Alquilado";
                            }
                        }

                        return "-"; // Por si no entra en ninguna condición
                    }

                },
                {
                    data: "material.nombre"
                },
                {
                    data: "estado_material"
                },
                {
                    data: "dias",
                    render: function(data) {
                        data = JSON.parse(data);
                        if (!Array.isArray(data) || data.length === 0) return "—";
                        const grupos = agruparFechasConsecutivas(data);
                        return grupos.map(grupo => {
                            const desde = grupo[0];
                            const hasta = grupo[grupo.length - 1];
                            return `${desde} al ${hasta} (${grupo.length} días)`;
                        }).join(", ");
                    }
                },
                {
                    data: null,
                    "render": function(data, type, row) {

                        var td = document.createElement('td');

                        td.className = 'table-dropdown';

                        td.style.textAlign = 'center';

                        var divDropdown = document.createElement('div');

                        divDropdown.className = 'dropdown d-block user-dropdown';

                        var link = document.createElement('a');

                        link.className = 'dropdown-toggle d-flex align-items-center';

                        link.id = 'UserDropdown';

                        link.href = '#';

                        link.setAttribute('data-toggle', 'dropdown');

                        link.setAttribute('aria-expanded', 'false');

                        link.textContent = 'Acciones';

                        var dropdownMenu = document.createElement('div');

                        dropdownMenu.className =

                            'dropdown-menu dropdown-menu-right navbar-dropdown p-0';

                        dropdownMenu.setAttribute('aria-labelledby', 'UserDropdown');

                        var linkVerPerfil = document.createElement('a');

                        linkVerPerfil.className = 'p-1 dropdown-item';

                        linkVerPerfil.href = `./cliente?id=${data.id_evento_material}`;

                        linkVerPerfil.innerHTML = `

            <lord-icon src="./assets/lordicons/eye.json" trigger="hover" colors="primary:#00000,secondary:#000000"
                style="width:30px;height:30px"></lord-icon>

            Ver Perfil

            `;

                        var buttonEditar = document.createElement('button');

                        buttonEditar.className = 'btn_edit_evento p-1 dropdown-item';

                        buttonEditar.setAttribute('type', 'button');

                        buttonEditar.setAttribute('data-id', data.id_evento_material);

                        buttonEditar.innerHTML = `

                        <lord-icon src="./assets/lordicons/edit.json" trigger="hover" colors="primary:#000000,secondary:#000000"
                            style="width:30px;height:30px"></lord-icon>

                        Editar

                        `;


                        var buttonAceptar = document.createElement('button');

                        buttonAceptar.className = 'btn_materiales_evento p-1 dropdown-item';

                        buttonAceptar.setAttribute('type', 'button');

                        buttonAceptar.setAttribute('data-id', data.id_evento_material);

                        buttonAceptar.innerHTML = `

                    <lord-icon src="./assets/lordicons/parlan.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Materiales

                `;

                        var buttonEliminar = document.createElement('button');

                        buttonEliminar.className =
                            'btn_eliminar_evento_material p-1 dropdown-item';

                        buttonEliminar.setAttribute('type', 'button');

                        buttonEliminar.setAttribute('data-id', data.id_evento_material);

                        buttonEliminar.innerHTML = `

                        <lord-icon src="./assets/lordicons/delete.json" trigger="hover" colors="primary:#000000,secondary:#000000"
                            style="width:30px;height:30px"></lord-icon>

                        Eliminar

                        `;
                        var buttonFotos = document.createElement('button');

                        buttonFotos.className =
                            'btn_modal_archivos_eventos p-1 dropdown-item';

                        buttonFotos.setAttribute('type', 'button');

                        buttonFotos.setAttribute('data-id', data.id_evento_material);

                        buttonFotos.innerHTML = `

                    <lord-icon src="./assets/lordicons/file.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Documentos

                `;

                        var buttonEstado = document.createElement('button');

                        buttonEstado.className =
                            'btn_devoluciones p-1 dropdown-item';

                        buttonEstado.setAttribute('type', 'button');

                        buttonEstado.setAttribute('data-id', data.id_evento_material);

                        buttonEstado.innerHTML = `

                    <lord-icon src="./assets/lordicons/security.json" trigger="hover" colors="primary:#000000,secondary:#000000" style="width:30px;height:30px"></lord-icon>

                    Devoluciones

                `;
                        const fechas = JSON.parse(data
                            .dias); // arreglo de fechas en formato YYYY-MM-DD
                        const hoy = new Date().toISOString().split('T')[0];


                        // Ordenamos por si no vienen ordenadas
                        fechas.sort();

                        if (hoy > fechas[fechas.length - 1]) {
                            dropdownMenu.appendChild(buttonEstado);
                        }


                        //dropdownMenu.appendChild(buttonEditar);

                        dropdownMenu.appendChild(buttonEliminar);

                        //     dropdownMenu.appendChild(buttonCambiarEstado);

                        divDropdown.appendChild(link);

                        divDropdown.appendChild(dropdownMenu);

                        td.appendChild(divDropdown);

                        return td.outerHTML;

                    }
                }
            ]
        });

        function agruparFechasConsecutivas(fechas) {
            if (!fechas.length) return [];
            fechas.sort();

            const grupos = [];
            let grupoActual = [fechas[0]];

            for (let i = 1; i < fechas.length; i++) {
                const fechaPrev = new Date(fechas[i - 1]);
                const fechaActual = new Date(fechas[i]);

                if ((fechaActual - fechaPrev) === 86400000) {
                    grupoActual.push(fechas[i]);
                } else {
                    grupos.push(grupoActual);
                    grupoActual = [fechas[i]];
                }
            }
            grupos.push(grupoActual);
            return grupos;
        }

        $(document).on("click", ".btn_eliminar_evento_material", function() {
            const id = $(this).data("id");
            $('#id_evento_material_eliminar').val(id);
            $('#modalEliminarEventoMaterial').modal("show");
        });
        $(document).on("click", ".btn_devoluciones", function() {
            const id = $(this).data("id");
            $.getJSON('/api/eventos2.php?id_evento_material=' + id + '&_=' + new Date()
                .getTime(),
                function(material) {
                    console.log(material);

                    $('#devueltos').val(material.devueltos);
                    $('#btn_devoluciones').data("id", id);
                    $('#btn_devoluciones').data("cantidad", material.cantidad);
                    $('#modalDevoluciones').modal("show");
                });
        });
        $('#btn_devoluciones').click(function() {
            const id = $('#btn_devoluciones').data("id");
            const cantidad = $('#btn_devoluciones').data("cantidad");
            var cantidadDevuelta = parseInt($('#devueltos').val());
            if (cantidadDevuelta == "") {
                $.toast({
                    heading: 'Cantidad no válida.',
                    text: 'Ingresa una cantidad.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });

                return;
            }
            if (cantidadDevuelta > cantidad) {
                $.toast({
                    heading: 'Cantidad no válida.',
                    text: 'Ingresa una cantidad menor o igual que el total de unidades.',
                    position: 'top-right',
                    loaderBg: '#ff5c6c',
                    icon: 'error',
                    hideAfter: 2000,
                    stack: 6
                });

                return;
            }
            $.post('/api/eventos2.php', {
                id_evento_material_devolver: id,
                devueltos: cantidadDevuelta
            }, function() {
                $('#modalDevoluciones').modal("hide");
                reloadEventoMaterialsTable();

            });
        });
        $('#btn_eliminar_evento_material').click(function() {
            const id = $('#id_evento_material_eliminar').val();
            $.ajax({
                type: 'DELETE',
                url: '/api/eventos2.php?id_evento_material=' + id,
                success: function() {
                    $('#modalEliminarEventoMaterial').modal("hide");
                    reloadEventoMaterialsTable();

                }
            });
        });

        function reloadEventoMaterialsTable() {
            $('#tabla_materiales_evento').DataTable().ajax.reload(null, false);
        }
    });
})(jQuery);
</script>